/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.resourceRoots;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.actions.ContentEntryEditingAction;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.module.PyContentEntriesEditor;
import com.jetbrains.python.module.PyRootTypeProvider;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceRootProvider
extends PyRootTypeProvider {
    private final MultiMap<ContentEntry, VirtualFilePointer> myResourceRoots = new MultiMap();

    @Override
    public void reset(@NotNull Disposable disposable, PyContentEntriesEditor editor2, @NotNull Module module) {
        if (disposable == null) {
            ResourceRootProvider.$$$reportNull$$$0(0);
        }
        if (module == null) {
            ResourceRootProvider.$$$reportNull$$$0(1);
        }
        this.myResourceRoots.clear();
        MultiMap<String, String> resourcesRoots = this.getResourceRoots(module);
        if (resourcesRoots == null) {
            return;
        }
        for (String contentEntryUrl : resourcesRoots.keySet()) {
            ContentEntry contentEntry = ResourceRootProvider.findContentEntry(contentEntryUrl, editor2);
            if (contentEntry == null) continue;
            for (String resourceRoot : resourcesRoots.get((Object)contentEntryUrl)) {
                this.myResourceRoots.putValue((Object)contentEntry, (Object)VirtualFilePointerManager.getInstance().create(resourceRoot, disposable, this.DUMMY_LISTENER));
            }
        }
    }

    @Override
    public void apply(Module module) {
        MultiMap<String, String> resourceRoots = this.getCurrentResourceRoots();
        this.setResourceRoots(resourceRoots, module);
    }

    @Override
    @Nullable
    public CustomShortcutSet getShortcut() {
        return new CustomShortcutSet(KeyStroke.getKeyStroke(82, 8));
    }

    @Override
    public boolean isModified(Module module) {
        MultiMap<String, String> roots = this.getResourceRoots(module);
        if (roots != null) {
            MultiMap<String, String> current = this.getCurrentResourceRoots();
            if (!Comparing.haveEqualElements((Collection)roots.keySet(), (Collection)current.keySet())) {
                return true;
            }
            for (String contentEntryUrl : roots.keySet()) {
                if (Comparing.haveEqualElements((Collection)roots.get((Object)contentEntryUrl), (Collection)current.get((Object)contentEntryUrl))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public MultiMap<ContentEntry, VirtualFilePointer> getRoots() {
        return this.myResourceRoots;
    }

    @Override
    public Icon getIcon() {
        return AllIcons.Modules.ResourcesRoot;
    }

    @Override
    public String getName() {
        return "Resource";
    }

    @Override
    public Color getColor() {
        return JBColor.ORANGE;
    }

    @Override
    public ContentEntryEditingAction createRootEntryEditingAction(JTree tree, Disposable disposable, PyContentEntriesEditor editor2, ModifiableRootModel model) {
        return new PyRootTypeProvider.RootEntryEditingAction(tree, disposable, editor2, model);
    }

    private MultiMap<String, String> getCurrentResourceRoots() {
        MultiMap result = new MultiMap();
        for (ContentEntry entry : this.myResourceRoots.keySet()) {
            ArrayList<String> resourcesRoots = new ArrayList<String>();
            for (VirtualFilePointer filePointer : this.myResourceRoots.get((Object)entry)) {
                resourcesRoots.add(filePointer.getUrl());
            }
            result.put((Object)entry.getUrl(), resourcesRoots);
        }
        return result;
    }

    @NotNull
    public static Set<String> getAllResourceRoots(@NotNull Module module) {
        if (module == null) {
            ResourceRootProvider.$$$reportNull$$$0(2);
        }
        HashSet<String> result = new HashSet<String>();
        ImmutableList rootProviders = FluentIterable.from((Object[])PyRootTypeProvider.EP_NAME.getExtensions()).filter(ResourceRootProvider.class).toList();
        for (ResourceRootProvider provider : rootProviders) {
            MultiMap<String, String> roots = provider.getResourceRoots(module);
            if (roots == null) continue;
            result.addAll(roots.values().stream().map(VfsUtilCore::urlToPath).collect(Collectors.toSet()));
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            ResourceRootProvider.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @Nullable
    private static ContentEntry findContentEntry(String url, PyContentEntriesEditor editor2) {
        for (ContentEntry contentEntry : editor2.getContentEntries()) {
            if (!contentEntry.getUrl().equals(url)) continue;
            return contentEntry;
        }
        return null;
    }

    @Nullable
    protected abstract MultiMap<String, String> getResourceRoots(Module var1);

    protected abstract void setResourceRoots(MultiMap<String, String> var1, Module var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/resourceRoots/ResourceRootProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/resourceRoots/ResourceRootProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllResourceRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAllResourceRoots";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

