/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.add;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import com.jetbrains.python.sdk.add.PyAddSdkPanelKt;
import com.jetbrains.python.sdk.add.PySdkPathChoosingComboBox;
import icons.PythonIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B9\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\n\u0010\u001e\u001a\u0004\u0018\u00010\bH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0007H\u0016J\n\u0010!\u001a\u0004\u0018\u00010 H\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/python/sdk/add/PyAddExistingCondaEnvPanel;", "Lcom/jetbrains/python/sdk/add/PyAddSdkPanel;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "newProjectPath", "", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Ljava/util/List;Ljava/lang/String;Lcom/intellij/openapi/util/UserDataHolder;)V", "condaPathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "makeSharedField", "Lcom/intellij/ui/components/JBCheckBox;", "getNewProjectPath", "()Ljava/lang/String;", "setNewProjectPath", "(Ljava/lang/String;)V", "panelName", "getPanelName", "sdkComboBox", "Lcom/jetbrains/python/sdk/add/PySdkPathChoosingComboBox;", "getOrCreateSdk", "validateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "validateAnacondaPath", "intellij.python.community.impl"})
public final class PyAddExistingCondaEnvPanel
extends PyAddSdkPanel {
    @NotNull
    private final Icon icon;
    private final PySdkPathChoosingComboBox sdkComboBox;
    private final TextFieldWithBrowseButton condaPathField;
    private final JBCheckBox makeSharedField;
    private final Project project;
    private final Module module;
    private final List<Sdk> existingSdks;
    @Nullable
    private String newProjectPath;

    @Override
    @NotNull
    public String getPanelName() {
        String string = PyBundle.message("python.add.sdk.panel.name.existing.environment", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PyBundle.message(\"python\u2026me.existing.environment\")");
        return string;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public List<ValidationInfo> validateAll() {
        return CollectionsKt.listOfNotNull((Object[])new ValidationInfo[]{PyAddSdkPanel.Companion.validateSdkComboBox(this.sdkComboBox, this), this.validateAnacondaPath()});
    }

    private final ValidationInfo validateAnacondaPath() {
        String string;
        String string2 = this.condaPathField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"condaPathField.text");
        String text2 = string2;
        File file2 = new File(text2);
        if (StringUtil.isEmptyOrSpaces((String)text2)) {
            string = "Conda executable path is empty";
        } else if (!file2.exists()) {
            string = "Conda executable not found";
        } else if (!file2.isFile() || !file2.canExecute()) {
            string = "Conda executable path is not an executable file";
        } else {
            return null;
        }
        String message = string;
        return new ValidationInfo(message);
    }

    @Override
    @Nullable
    public Sdk getOrCreateSdk() {
        Sdk sdk;
        Sdk sdk2 = this.sdkComboBox.getSelectedSdk();
        PyCondaPackageService.getInstance().PREFERRED_CONDA_PATH = this.condaPathField.getText();
        Sdk sdk3 = sdk2;
        if (sdk3 instanceof PyDetectedSdk) {
            PyDetectedSdk pyDetectedSdk = (PyDetectedSdk)sdk2;
            String string = this.getNewProjectPath();
            if (string == null) {
                Project project = this.project;
                string = project != null ? project.getBasePath() : null;
            }
            Sdk sdk4 = PySdkExtKt.setupAssociated(pyDetectedSdk, this.existingSdks, string);
            if (sdk4 != null) {
                Sdk sdk5 = sdk4;
                boolean bl = false;
                boolean bl2 = false;
                Sdk $this$apply = sdk5;
                boolean bl3 = false;
                if (!this.makeSharedField.isSelected()) {
                    PySdkExtKt.associateWithModule($this$apply, this.module, this.getNewProjectPath());
                }
                sdk = sdk5;
            } else {
                sdk = null;
            }
        } else {
            sdk = sdk2;
        }
        return sdk;
    }

    @Override
    @Nullable
    public String getNewProjectPath() {
        return this.newProjectPath;
    }

    @Override
    public void setNewProjectPath(@Nullable String string) {
        this.newProjectPath = string;
    }

    public PyAddExistingCondaEnvPanel(@Nullable Project project, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks, @Nullable String newProjectPath, final @NotNull UserDataHolder context) {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        String path;
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.project = project;
        this.module = module;
        this.existingSdks = existingSdks;
        this.newProjectPath = newProjectPath;
        Icon icon = PythonIcons.Python.Anaconda;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"PythonIcons.Python.Anaconda");
        this.icon = icon;
        this.sdkComboBox = new PySdkPathChoosingComboBox(null, null, 3, null);
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        PyAddExistingCondaEnvPanel pyAddExistingCondaEnvPanel = this;
        boolean bl = false;
        boolean bl2 = false;
        TextFieldWithBrowseButton $this$apply = textFieldWithBrowseButton2;
        boolean bl3 = false;
        String string = PyCondaPackageService.getInstance().PREFERRED_CONDA_PATH;
        if (string == null) {
            string = path = PyCondaPackageService.getSystemCondaExecutable();
        }
        if (path != null) {
            $this$apply.setText(path);
        }
        $this$apply.addBrowseFolderListener(PyBundle.message("python.sdk.select.conda.path.title", new Object[0]), null, this.project, FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor());
        pyAddExistingCondaEnvPanel.condaPathField = textFieldWithBrowseButton = textFieldWithBrowseButton2;
        this.makeSharedField = new JBCheckBox(PyBundle.message("available.to.all.projects", new Object[0]));
        ((ComboBoxWithWidePopup)this.sdkComboBox.getChildComponent()).addItemListener(new ItemListener(){

            @Override
            public final void itemStateChanged(ItemEvent it) {
                ItemEvent itemEvent = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemEvent, (String)"it");
                if (itemEvent.getStateChange() == 1) {
                    String respectiveCondaExecutable;
                    Sdk sdk = sdkComboBox.getSelectedSdk();
                    String string = respectiveCondaExecutable = PyCondaPackageService.getCondaExecutable(sdk != null ? sdk.getHomePath() : null);
                    TextFieldWithBrowseButton textFieldWithBrowseButton = condaPathField;
                    boolean bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        string2 = "";
                    }
                    String string3 = string2;
                    textFieldWithBrowseButton.setText(string3);
                }
            }
        });
        this.setLayout(new BorderLayout());
        FormBuilder formBuilder = FormBuilder.createFormBuilder().addLabeledComponent(PyBundle.message("interpreter", new Object[0]), (JComponent)((Object)this.sdkComboBox)).addLabeledComponent(PyBundle.message("python.sdk.conda.path", new Object[0]), (JComponent)this.condaPathField).addComponent((JComponent)this.makeSharedField);
        Intrinsics.checkExpressionValueIsNotNull((Object)formBuilder, (String)"FormBuilder.createFormBu\u2026omponent(makeSharedField)");
        JPanel formPanel = formBuilder.getPanel();
        this.add((Component)formPanel, "North");
        PyAddSdkPanelKt.addInterpretersAsync(this.sdkComboBox, (Function0<? extends List<? extends Sdk>>)((Function0)new Function0<List<? extends PyDetectedSdk>>(){

            @NotNull
            public final List<PyDetectedSdk> invoke() {
                return PySdkExtKt.detectCondaEnvs(module, existingSdks, context);
            }
        }));
    }
}

