/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.wsl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSdkPropertiesPaths;
import com.intellij.util.PathMappingSettings;
import com.intellij.wsl.WSLCredentialsHolder;
import com.intellij.wsl.WSLCredentialsType;
import com.jetbrains.extensions.python.ProgressManagerExtKt;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.Result;
import com.jetbrains.python.remote.PyRemoteCommandLinePatcherKt;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.wsl.PyWSLProcessHandler;
import com.jetbrains.python.wsl.PyWSLSocketProvider;
import com.jetbrains.python.wsl.Wsl2IPs;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u001a&\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00030\u00012\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\nH\u0000\u001aL\u0010 \u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00030\r0\u00012\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u00032\b\b\u0002\u0010#\u001a\u00020\bH\u0002\u001a\u001a\u0010$\u001a\u00020\b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\nH\u0000\u001a@\u0010%\u001a\u00020&2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010)\u001a\u00020\b2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010#\u001a\u00020\bH\u0000\u001aH\u0010+\u001a\u00020&2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010'\u001a\u00020(2\u0006\u0010,\u001a\u00020\n2\u0006\u0010)\u001a\u00020\b2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010#\u001a\u00020\b2\u0006\u0010-\u001a\u00020\bH\u0002\u001a\u0018\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001*\u00020\nH\u0000\u001a\u0014\u0010.\u001a\u00020\u0003*\u00020\u00022\u0006\u0010/\u001a\u00020\u0003H\u0000\"&\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0001*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0018\u0010\u0007\u001a\u00020\b*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\"\u0018\u0010\u0007\u001a\u00020\b*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u000b\"0\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00030\r0\u0001*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\"\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00060"}, d2={"distribution", "Lcom/jetbrains/python/Result;", "Lcom/intellij/execution/wsl/WSLDistribution;", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "getDistribution", "(Lcom/intellij/openapi/projectRoots/Sdk;)Lcom/jetbrains/python/Result;", "isWsl", "", "(Lcom/intellij/openapi/projectRoots/Sdk;)Z", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;", "(Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;)Z", "result", "Lkotlin/Pair;", "", "Lcom/intellij/execution/process/ProcessOutput;", "getResult", "(Lcom/intellij/execution/process/ProcessOutput;)Lcom/jetbrains/python/Result;", "rootMappings", "", "Lcom/intellij/util/PathMappingSettings$PathMapping;", "getRootMappings", "(Lcom/intellij/execution/wsl/WSLDistribution;)Ljava/util/List;", "wslCredentials", "Lcom/intellij/wsl/WSLCredentialsHolder;", "getWslCredentials", "(Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;)Lcom/intellij/wsl/WSLCredentialsHolder;", "getWsl2WindowsIp", "Lcom/jetbrains/python/wsl/Wsl2IPs;", "project", "Lcom/intellij/openapi/project/Project;", "sdkAdditionalData", "getWslOutput", "title", "command", "patchExe", "isWsl1", "startWslProcess", "Lcom/jetbrains/python/wsl/PyWSLProcessHandler;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "sudo", "remoteWorkDir", "startWslProcessImpl", "sdkData", "closeStdin", "toRemotePath", "localPath", "intellij.python.wsl"})
public final class PyWSLUtilsKt {
    @Nullable
    public static final Result<WSLDistribution, String> getDistribution(@NotNull Sdk $this$distribution) {
        Intrinsics.checkParameterIsNotNull((Object)$this$distribution, (String)"$this$distribution");
        SdkAdditionalData sdkAdditionalData = $this$distribution.getSdkAdditionalData();
        if (!(sdkAdditionalData instanceof PyRemoteSdkAdditionalDataBase)) {
            sdkAdditionalData = null;
        }
        PyRemoteSdkAdditionalDataBase pyRemoteSdkAdditionalDataBase = (PyRemoteSdkAdditionalDataBase)sdkAdditionalData;
        return pyRemoteSdkAdditionalDataBase != null ? PyWSLUtilsKt.getDistribution(pyRemoteSdkAdditionalDataBase) : null;
    }

    public static final boolean isWsl(@NotNull Sdk $this$isWsl) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isWsl, (String)"$this$isWsl");
        SdkAdditionalData sdkAdditionalData = $this$isWsl.getSdkAdditionalData();
        if (!(sdkAdditionalData instanceof PyRemoteSdkAdditionalDataBase)) {
            sdkAdditionalData = null;
        }
        PyRemoteSdkAdditionalDataBase pyRemoteSdkAdditionalDataBase = (PyRemoteSdkAdditionalDataBase)sdkAdditionalData;
        return pyRemoteSdkAdditionalDataBase != null && PyWSLUtilsKt.isWsl(pyRemoteSdkAdditionalDataBase);
    }

    @Nullable
    public static final WSLCredentialsHolder getWslCredentials(@NotNull PyRemoteSdkAdditionalDataBase $this$wslCredentials) {
        Intrinsics.checkParameterIsNotNull((Object)$this$wslCredentials, (String)"$this$wslCredentials");
        RemoteConnectionCredentialsWrapper remoteConnectionCredentialsWrapper = $this$wslCredentials.connectionCredentials();
        Intrinsics.checkExpressionValueIsNotNull((Object)remoteConnectionCredentialsWrapper, (String)"connectionCredentials()");
        Object object = remoteConnectionCredentialsWrapper.getCredentials();
        if (!(object instanceof WSLCredentialsHolder)) {
            object = null;
        }
        return (WSLCredentialsHolder)object;
    }

    @NotNull
    public static final Result<WSLDistribution, String> getDistribution(@NotNull PyRemoteSdkAdditionalDataBase $this$getDistribution) {
        Result result;
        Intrinsics.checkParameterIsNotNull((Object)$this$getDistribution, (String)"$this$getDistribution");
        WSLCredentialsHolder wSLCredentialsHolder = PyWSLUtilsKt.getWslCredentials($this$getDistribution);
        if (wSLCredentialsHolder != null && (wSLCredentialsHolder = wSLCredentialsHolder.getDistribution()) != null) {
            WSLCredentialsHolder wSLCredentialsHolder2 = wSLCredentialsHolder;
            boolean bl = false;
            boolean bl2 = false;
            WSLCredentialsHolder it = wSLCredentialsHolder2;
            boolean bl3 = false;
            WSLCredentialsHolder wSLCredentialsHolder3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)wSLCredentialsHolder3, (String)"it");
            result = new Result.Success(wSLCredentialsHolder3);
        } else {
            WSLCredentialsHolder wSLCredentialsHolder4 = PyWSLUtilsKt.getWslCredentials($this$getDistribution);
            result = new Result.Failure("Unknown distribution " + (wSLCredentialsHolder4 != null ? wSLCredentialsHolder4.getDistributionId() : null));
        }
        return result;
    }

    @NotNull
    public static final String toRemotePath(@NotNull WSLDistribution $this$toRemotePath, @NotNull String localPath) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toRemotePath, (String)"$this$toRemotePath");
        Intrinsics.checkParameterIsNotNull((Object)localPath, (String)"localPath");
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)localPath, (char[])new char[]{File.pathSeparatorChar}, (boolean)false, (int)0, (int)6, null), (CharSequence)":", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>($this$toRemotePath){
            final /* synthetic */ WSLDistribution $this_toRemotePath;

            @NotNull
            public final CharSequence invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String string = this.$this_toRemotePath.getWslPath(it);
                return string != null ? (CharSequence)string : (CharSequence)it;
            }
            {
                this.$this_toRemotePath = wSLDistribution;
                super(1);
            }
        }), (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PathMappingSettings.PathMapping> getRootMappings(@NotNull WSLDistribution $this$rootMappings) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$rootMappings, (String)"$this$rootMappings");
        File[] fileArray = File.listRoots();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileArray, (String)"File.listRoots()");
        File[] $this$map$iv = fileArray;
        boolean $i$f$map = false;
        File[] fileArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var6_6 = $this$mapTo$iv$iv;
        int n = ((void)var6_6).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = var6_6[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            PathMappingSettings.PathMapping pathMapping = new PathMappingSettings.PathMapping(v1.getPath(), $this$rootMappings.getWslPath(it.getPath()));
            collection.add(pathMapping);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean isWsl(@NotNull PyRemoteSdkAdditionalDataBase $this$isWsl) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isWsl, (String)"$this$isWsl");
        return Intrinsics.areEqual((Object)$this$isWsl.getRemoteConnectionType(), (Object)WSLCredentialsType.getInstance());
    }

    @NotNull
    public static final PyWSLProcessHandler startWslProcess(@Nullable Project project, @NotNull GeneralCommandLine commandLine, @NotNull PyRemoteSdkAdditionalDataBase sdkAdditionalData, boolean sudo, @Nullable String remoteWorkDir, boolean patchExe) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        Intrinsics.checkParameterIsNotNull((Object)sdkAdditionalData, (String)"sdkAdditionalData");
        boolean wsl1 = PyWSLUtilsKt.isWsl1(project, sdkAdditionalData);
        return PyWSLUtilsKt.startWslProcessImpl(project, commandLine, sdkAdditionalData, sudo, remoteWorkDir, patchExe, !wsl1);
    }

    public static /* synthetic */ PyWSLProcessHandler startWslProcess$default(Project project, GeneralCommandLine generalCommandLine, PyRemoteSdkAdditionalDataBase pyRemoteSdkAdditionalDataBase, boolean bl, String string, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            string = null;
        }
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        return PyWSLUtilsKt.startWslProcess(project, generalCommandLine, pyRemoteSdkAdditionalDataBase, bl, string, bl2);
    }

    public static final boolean isWsl1(@Nullable Project project, @NotNull PyRemoteSdkAdditionalDataBase sdkAdditionalData) {
        Intrinsics.checkParameterIsNotNull((Object)sdkAdditionalData, (String)"sdkAdditionalData");
        String string = (String)PyWSLUtilsKt.getWslOutput$default(project, "Obtaining WSL version...", sdkAdditionalData, "uname -v", false, 16, null).getSuccessOrNull();
        return string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Microsoft", (boolean)false, (int)2, null) : true;
    }

    @NotNull
    public static final Result<Wsl2IPs, String> getWsl2WindowsIp(@Nullable Project project, @NotNull PyRemoteSdkAdditionalDataBase sdkAdditionalData) {
        Result result;
        Intrinsics.checkParameterIsNotNull((Object)sdkAdditionalData, (String)"sdkAdditionalData");
        WSLDistribution wSLDistribution = PyWSLUtilsKt.getDistribution(sdkAdditionalData).getSuccessOrNull();
        if (wSLDistribution == null) {
            return new Result.Failure("No distribution");
        }
        WSLDistribution distribution = wSLDistribution;
        String string = distribution.getWslPath(PythonHelpersLocator.getHelperPath("pycharm/_jb_wsl_get_ip.py"));
        if (string == null) {
            return new Result.Failure("Can't find helper");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"distribution.getWslPath(\u2026lure(\"Can't find helper\")");
        String helper = string;
        Result<String, Pair<Integer, String>> output = PyWSLUtilsKt.getWslOutput(project, "Obtaining WSL IP...", sdkAdditionalData, sdkAdditionalData.getInterpreterPath() + " '" + helper + '\'', true);
        if (output instanceof Result.Success) {
            String string2;
            List list = StringsKt.split$default((CharSequence)((CharSequence)((Result.Success)output).getResult()), (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
            boolean bl = false;
            boolean bl2 = false;
            List it = list;
            boolean bl3 = false;
            String string3 = (String)it.get(0);
            boolean bl4 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string5 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            string3 = (String)it.get(1);
            bl4 = false;
            String string6 = string3;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string7 = string2 = ((Object)StringsKt.trim((CharSequence)string6)).toString();
            String string8 = string5;
            Wsl2IPs wsl2IPs = new Wsl2IPs(string8, string7);
            result = new Result.Success(wsl2IPs);
        } else if (output instanceof Result.Failure) {
            result = new Result.Failure("Can't obtain ip: " + (String)((Pair)((Result.Failure)output).getError()).getSecond());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    private static final Result<String, Pair<Integer, String>> getResult(@NotNull ProcessOutput $this$result) {
        Result result;
        switch ($this$result.getExitCode()) {
            case 0: {
                String string = $this$result.getStdout();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"stdout");
                result = new Result.Success(string);
                break;
            }
            default: {
                result = new Result.Failure(new Pair((Object)$this$result.getExitCode(), (Object)$this$result.getStderr()));
            }
        }
        return result;
    }

    private static final Result<String, Pair<Integer, String>> getWslOutput(Project project, String title, PyRemoteSdkAdditionalDataBase sdkAdditionalData, String command, boolean patchExe) {
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
        return (Result)ProgressManagerExtKt.runUnderProgress(progressManager, title, (Function0)new Function0<Result<String, Pair<? extends Integer, ? extends String>>>(project, command, sdkAdditionalData, patchExe){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $command;
            final /* synthetic */ PyRemoteSdkAdditionalDataBase $sdkAdditionalData;
            final /* synthetic */ boolean $patchExe;

            @NotNull
            public final Result<String, Pair<Integer, String>> invoke() {
                boolean bl = false;
                boolean bl2 = this.$patchExe;
                String string = null;
                boolean bl3 = true;
                ProcessOutput processOutput = new CapturingProcessRunner((BaseProcessHandler)PyWSLUtilsKt.startWslProcessImpl$default(this.$project, new GeneralCommandLine(StringsKt.split$default((CharSequence)this.$command, (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null)), this.$sdkAdditionalData, bl, string, bl2, bl3, 16, null)).runProcess();
                Intrinsics.checkExpressionValueIsNotNull((Object)processOutput, (String)"CapturingProcessRunner(\n\u2026do = false)).runProcess()");
                return PyWSLUtilsKt.access$getResult$p(processOutput);
            }
            {
                this.$project = project;
                this.$command = string;
                this.$sdkAdditionalData = pyRemoteSdkAdditionalDataBase;
                this.$patchExe = bl;
                super(0);
            }
        });
    }

    static /* synthetic */ Result getWslOutput$default(Project project, String string, PyRemoteSdkAdditionalDataBase pyRemoteSdkAdditionalDataBase, String string2, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return PyWSLUtilsKt.getWslOutput(project, string, pyRemoteSdkAdditionalDataBase, string2, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final PyWSLProcessHandler startWslProcessImpl(Project project, GeneralCommandLine commandLine, PyRemoteSdkAdditionalDataBase sdkData, boolean sudo, String remoteWorkDir, boolean patchExe, boolean closeStdin) {
        String string;
        String it;
        Result<WSLDistribution, String> result = PyWSLUtilsKt.getDistribution(sdkData);
        boolean bl = false;
        boolean bl2 = false;
        Result<WSLDistribution, String> it2 = result;
        boolean bl32 = false;
        Result<WSLDistribution, String> result2 = it2;
        if (!(result2 instanceof Result.Success)) {
            if (result2 instanceof Result.Failure) {
                throw (Throwable)new ExecutionException((String)((Result.Failure)it2).getError());
            }
            throw new NoWhenBranchMatchedException();
        }
        WSLDistribution distribution = (WSLDistribution)((Result.Success)it2).getResult();
        PyRemotePathMapper pyRemotePathMapper = PyRemotePathMapper.fromSettings(sdkData.getPathMappings(), PyRemotePathMapper.PyPathMappingType.USER_DEFINED);
        Intrinsics.checkExpressionValueIsNotNull((Object)pyRemotePathMapper, (String)"PyRemotePathMapper.fromS\u2026MappingType.USER_DEFINED)");
        PyRemotePathMapper mapper = pyRemotePathMapper;
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
        ProgressManagerExtKt.runUnderProgress(progressManager, "Preparing command to run it on WSL...", (Function0)new Function0<Unit>(commandLine, sdkData, project, mapper){
            final /* synthetic */ GeneralCommandLine $commandLine;
            final /* synthetic */ PyRemoteSdkAdditionalDataBase $sdkData;
            final /* synthetic */ Project $project;
            final /* synthetic */ PyRemotePathMapper $mapper;

            public final void invoke() {
                try {
                    PyRemoteCommandLinePatcherKt.patchRemoteCommandLineIfNeeded(this.$commandLine, (RemoteSdkPropertiesPaths)this.$sdkData, new PyWSLSocketProvider(this.$project, this.$sdkData), this.$mapper);
                }
                catch (RemoteSdkException ex) {
                    Logger.getInstance(PyWSLProcessHandler.class).warn((Throwable)ex);
                }
            }
            {
                this.$commandLine = generalCommandLine;
                this.$sdkData = pyRemoteSdkAdditionalDataBase;
                this.$project = project;
                this.$mapper = pyRemotePathMapper;
                super(0);
            }
        });
        if (patchExe) {
            commandLine.setExePath(sdkData.getInterpreterPath());
        }
        ParametersList parametersList = commandLine.getParametersList();
        Intrinsics.checkExpressionValueIsNotNull((Object)parametersList, (String)"commandLine.parametersList");
        Iterator iterator = parametersList.getParamsGroups().iterator();
        while (iterator.hasNext()) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ParamsGroup group2;
            ParamsGroup paramsGroup = group2 = (ParamsGroup)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)paramsGroup, (String)"group");
            ArrayList params = new ArrayList(paramsGroup.getParameters());
            group2.getParametersList().clearAll();
            Iterable bl32 = params;
            ParametersList parametersList2 = group2.getParametersList();
            boolean $i$f$map = false;
            void var14_28 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                String string3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it");
                String string4 = PyWSLUtilsKt.toRemotePath(distribution, string3);
                collection.add(string4);
            }
            collection = (List)destination$iv$iv;
            parametersList2.addAll((List)collection);
        }
        Map map2 = commandLine.getEnvironment();
        Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"commandLine.environment");
        Object $this$forEach$iv = map2;
        boolean $i$f$forEach2 = false;
        Map map3 = $this$forEach$iv;
        boolean $this$map$iv = false;
        Iterator $i$f$map = map3.entrySet().iterator();
        while ($i$f$map.hasNext()) {
            void k;
            Map.Entry element$iv;
            Map.Entry $dstr$k$v = element$iv = $i$f$map.next();
            boolean bl5 = false;
            Object object = $dstr$k$v;
            boolean bl6 = false;
            it = (String)object.getKey();
            object = $dstr$k$v;
            bl6 = false;
            String v = (String)object.getValue();
            Map map4 = commandLine.getEnvironment();
            Intrinsics.checkExpressionValueIsNotNull((Object)map4, (String)"commandLine.environment");
            String string5 = v;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"v");
            map4.put(k, PyWSLUtilsKt.toRemotePath(distribution, string5));
        }
        File file2 = commandLine.getWorkDirectory();
        if (file2 != null) {
            $this$forEach$iv = file2;
            $i$f$forEach2 = false;
            boolean bl7 = false;
            Object it3 = $this$forEach$iv;
            boolean bl8 = false;
            String string6 = ((File)it3).getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"it.path");
            if (StringsKt.startsWith$default((String)string6, (String)"/", (boolean)false, (int)2, null)) {
                String string7 = distribution.getWindowsPath(((File)it3).getPath());
                if (string7 == null) {
                    string7 = ((File)it3).getPath();
                }
                commandLine.setWorkDirectory(new File(string7));
            }
        }
        if ((string = remoteWorkDir) == null) {
            Object object = commandLine.getWorkDirectory();
            if (object != null && (object = ((File)object).toString()) != null) {
                Object $i$f$forEach2 = object;
                boolean bl9 = false;
                boolean bl10 = false;
                Object it4 = $i$f$forEach2;
                boolean bl11 = false;
                Object object2 = it4;
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"it");
                string = PyWSLUtilsKt.toRemotePath(distribution, (String)object2);
            } else {
                string = null;
            }
        }
        String effectiveRemoteWorkDir = string;
        distribution.patchCommandLine(commandLine, project, effectiveRemoteWorkDir, sudo);
        PathMappingSettings pathMappingSettings = sdkData.getPathMappings();
        Intrinsics.checkExpressionValueIsNotNull((Object)pathMappingSettings, (String)"sdkData.pathMappings");
        PyWSLProcessHandler pyWSLProcessHandler = new PyWSLProcessHandler(commandLine, distribution, pathMappingSettings);
        if (closeStdin) {
            WSLUtil.addInputCloseListener((ProcessHandler)((ProcessHandler)pyWSLProcessHandler));
        }
        ProcessHandler processHandler2 = distribution.patchProcessHandler(commandLine, (ProcessHandler)pyWSLProcessHandler);
        Intrinsics.checkExpressionValueIsNotNull((Object)processHandler2, (String)"distribution.patchProces\u2026ine, pyWSLProcessHandler)");
        return (PyWSLProcessHandler)processHandler2;
    }

    static /* synthetic */ PyWSLProcessHandler startWslProcessImpl$default(Project project, GeneralCommandLine generalCommandLine, PyRemoteSdkAdditionalDataBase pyRemoteSdkAdditionalDataBase, boolean bl, String string, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 0x10) != 0) {
            string = null;
        }
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        return PyWSLUtilsKt.startWslProcessImpl(project, generalCommandLine, pyRemoteSdkAdditionalDataBase, bl, string, bl2, bl3);
    }

    public static final /* synthetic */ Result access$getResult$p(ProcessOutput $this$access_u24result_u24p) {
        return PyWSLUtilsKt.getResult($this$access_u24result_u24p);
    }
}

