/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.connections.configuration;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.BoundConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.CellBuilder;
import com.intellij.ui.layout.CellKt;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.PropertyBinding;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import com.intellij.ui.layout.RowBuilderWithButtonGroupProperty;
import com.intellij.util.ui.StatusText;
import java.awt.Container;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.jupyter.JupyterBundle;
import org.jetbrains.plugins.notebooks.jupyter.connections.ConfiguredServerJupyterModuleConnectionSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterConnectionParameters;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterConnectionParametersSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterModuleConnectionSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.ManagedServerJupyterModuleConnectionSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.configuration.JupyterServerModuleConfigurable$$special$;
import org.jetbrains.plugins.notebooks.jupyter.connections.configuration.ManagedServerSettingsForm;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0006H\u0016J\b\u0010\u0017\u001a\u00020\nH\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/configuration/JupyterServerModuleConfigurable;", "Lcom/intellij/openapi/options/BoundConfigurable;", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/module/Module;)V", "formPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "managedServerSettingsForm", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/configuration/ManagedServerSettingsForm;", "value", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterModuleConnectionSettings;", "savedJupyterConnectionParameters", "getSavedJupyterConnectionParameters", "()Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterModuleConnectionSettings;", "setSavedJupyterConnectionParameters", "(Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterModuleConnectionSettings;)V", "selectedJupyterModuleConnectionSettingsClass", "Ljava/lang/Class;", "url", "", "apply", "", "createPanel", "getConnectionParametersFromUI", "reset", "validateOnApply", "Companion", "intellij.python.jupyter"})
public final class JupyterServerModuleConfigurable
extends BoundConfigurable {
    private final DialogPanel formPanel;
    private final ManagedServerSettingsForm managedServerSettingsForm;
    private String url;
    private Class<? extends JupyterModuleConnectionSettings> selectedJupyterModuleConnectionSettingsClass;
    private final Module module;
    public static final Companion Companion = new Companion(null);

    private final JupyterModuleConnectionSettings getSavedJupyterConnectionParameters() {
        return JupyterConnectionParametersSettings.INSTANCE.getConnectionParametersForModule(this.module);
    }

    private final void setSavedJupyterConnectionParameters(JupyterModuleConnectionSettings value2) {
        JupyterConnectionParametersSettings.INSTANCE.setConnectionParametersForModule(this.module, value2);
    }

    @NotNull
    public DialogPanel createPanel() {
        return this.formPanel;
    }

    public void apply() {
        boolean modified = this.isModified();
        this.validateOnApply();
        super.apply();
        if (modified) {
            JupyterModuleConnectionSettings parameters = this.getConnectionParametersFromUI();
            this.setSavedJupyterConnectionParameters(parameters.copy());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateOnApply() {
        Object v0;
        block3: {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = this.formPanel.getValidateCallbacks();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ValidationInfo validationInfo;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Function0 it = (Function0)element$iv$iv;
                boolean bl2 = false;
                if ((ValidationInfo)it.invoke() == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                ValidationInfo it$iv$iv = validationInfo;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ValidationInfo it = (ValidationInfo)element$iv;
                boolean bl = false;
                if (!(!it.warning)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        ValidationInfo validationInfo = v0;
        if (validationInfo != null) {
            ValidationInfo validationInfo2 = validationInfo;
            boolean bl = false;
            boolean bl6 = false;
            ValidationInfo it = validationInfo2;
            boolean bl7 = false;
            throw (Throwable)new ConfigurationException(it.message);
        }
    }

    public void reset() {
        JupyterModuleConnectionSettings jupyterModuleConnectionSettings = this.getSavedJupyterConnectionParameters();
        boolean bl = false;
        boolean bl2 = false;
        JupyterModuleConnectionSettings it = jupyterModuleConnectionSettings;
        boolean bl3 = false;
        this.selectedJupyterModuleConnectionSettingsClass = this.getSavedJupyterConnectionParameters().getClass();
        JupyterModuleConnectionSettings jupyterModuleConnectionSettings2 = it;
        if (jupyterModuleConnectionSettings2 instanceof ManagedServerJupyterModuleConnectionSettings) {
            this.managedServerSettingsForm.reset((ManagedServerJupyterModuleConnectionSettings)it);
        } else if (jupyterModuleConnectionSettings2 instanceof ConfiguredServerJupyterModuleConnectionSettings) {
            this.url = JupyterServerModuleConfigurable.Companion.persistentConnectionPresentation((ConfiguredServerJupyterModuleConnectionSettings)it);
        }
        super.reset();
    }

    private final JupyterModuleConnectionSettings getConnectionParametersFromUI() {
        JupyterModuleConnectionSettings jupyterModuleConnectionSettings;
        Class<? extends JupyterModuleConnectionSettings> clazz = this.selectedJupyterModuleConnectionSettingsClass;
        if (Intrinsics.areEqual(clazz, ManagedServerJupyterModuleConnectionSettings.class)) {
            jupyterModuleConnectionSettings = this.managedServerSettingsForm.getConnectionSettingsFromUI();
        } else if (Intrinsics.areEqual(clazz, ConfiguredServerJupyterModuleConnectionSettings.class)) {
            ConfiguredServerJupyterModuleConnectionSettings configuredServerJupyterModuleConnectionSettings;
            String text2 = this.url;
            if (StringsKt.isBlank((CharSequence)text2)) {
                throw (Throwable)new RuntimeConfigurationError("Jupyter Server URL required");
            }
            try {
                JupyterConnectionParameters connectionParameters = JupyterConnectionParameters.Companion.fromUrlString(text2, true, false, false);
                configuredServerJupyterModuleConnectionSettings = new ConfiguredServerJupyterModuleConnectionSettings(connectionParameters.getUrlString(), connectionParameters.getToken());
            }
            catch (MalformedURLException e) {
                throw (Throwable)new RuntimeConfigurationError("Jupyter Server URL malformed: " + e.getMessage());
            }
            jupyterModuleConnectionSettings = configuredServerJupyterModuleConnectionSettings;
        } else {
            throw (Throwable)new IllegalStateException("Unexpected class " + this.selectedJupyterModuleConnectionSettingsClass);
        }
        return jupyterModuleConnectionSettings;
    }

    /*
     * WARNING - void declaration
     */
    public JupyterServerModuleConfigurable(@NotNull Module module) {
        DialogPanel dialogPanel;
        void constraints$iv;
        void $this$buttonGroup$iv$iv;
        void getter$iv;
        void $this$buttonGroup$iv;
        LayoutBuilder builder$iv;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        super("", null);
        this.module = module;
        this.managedServerSettingsForm = new ManagedServerSettingsForm();
        this.url = "";
        this.selectedJupyterModuleConnectionSettingsClass = ManagedServerJupyterModuleConnectionSettings.class;
        JBTextField urlTextField = new JBTextField();
        StatusText statusText = urlTextField.getEmptyText();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusText, (String)"urlTextField.emptyText");
        statusText.setText(JupyterBundle.message("jupyter.server.url.prompt", new Object[0]));
        LCFlags[] lCFlagsArray = new LCFlags[]{};
        JupyterServerModuleConfigurable jupyterServerModuleConfigurable = this;
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder();
        boolean bl = false;
        RowBuilder rowBuilder = (RowBuilder)$this$panel;
        Function0 function0 = (Function0)new Function0<Class<? extends JupyterModuleConnectionSettings>>(this, urlTextField){
            final /* synthetic */ JupyterServerModuleConfigurable this$0;
            final /* synthetic */ JBTextField $urlTextField$inlined;
            {
                this.this$0 = jupyterServerModuleConfigurable;
                this.$urlTextField$inlined = jBTextField;
                super(0);
            }

            @NotNull
            public final Class<? extends JupyterModuleConnectionSettings> invoke() {
                return JupyterServerModuleConfigurable.access$getSelectedJupyterModuleConnectionSettingsClass$p(this.this$0);
            }
        };
        Function1 setter$iv = (Function1)new Function1<Class<? extends JupyterModuleConnectionSettings>, Unit>(this, urlTextField){
            final /* synthetic */ JupyterServerModuleConfigurable this$0;
            final /* synthetic */ JBTextField $urlTextField$inlined;
            {
                this.this$0 = jupyterServerModuleConfigurable;
                this.$urlTextField$inlined = jBTextField;
                super(1);
            }

            public final void invoke(@NotNull Class<? extends JupyterModuleConnectionSettings> value2) {
                Intrinsics.checkParameterIsNotNull(value2, (String)"value");
                JupyterServerModuleConfigurable.access$setSelectedJupyterModuleConnectionSettingsClass$p(this.this$0, value2);
            }
        };
        boolean $i$f$buttonGroup = false;
        void var13_14 = $this$buttonGroup$iv;
        PropertyBinding binding$iv$iv = new PropertyBinding((Function0)getter$iv, setter$iv);
        boolean $i$f$buttonGroup2 = false;
        $this$buttonGroup$iv$iv.withButtonGroup(new ButtonGroup(), (Function0)new Function0<Unit>((RowBuilder)$this$buttonGroup$iv$iv, binding$iv$iv, this, urlTextField){
            final /* synthetic */ RowBuilder $this_buttonGroup;
            final /* synthetic */ PropertyBinding $binding;
            final /* synthetic */ JupyterServerModuleConfigurable this$0;
            final /* synthetic */ JBTextField $urlTextField$inlined;
            {
                this.$this_buttonGroup = rowBuilder;
                this.$binding = propertyBinding;
                this.this$0 = jupyterServerModuleConfigurable;
                this.$urlTextField$inlined = jBTextField;
                super(0);
            }

            public final void invoke() {
                RowBuilderWithButtonGroupProperty $this$buttonGroup = new RowBuilderWithButtonGroupProperty(this.$this_buttonGroup, this.$binding);
                boolean bl = false;
                RowBuilder.DefaultImpls.row$default((RowBuilder)$this$buttonGroup, null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>($this$buttonGroup, this){
                    final /* synthetic */ RowBuilderWithButtonGroupProperty $this_buttonGroup;
                    final /* synthetic */ $special$$inlined$panel$lambda$3 this$0;
                    {
                        this.$this_buttonGroup = rowBuilderWithButtonGroupProperty;
                        this.this$0 = var2_2;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                        JBRadioButton radioButton = (JBRadioButton)RowBuilderWithButtonGroupProperty.radioButton$default((RowBuilderWithButtonGroupProperty)this.$this_buttonGroup, (Row)$this$row, (String)JupyterBundle.message("Jupyter.servers.use.managed.server", new Object[0]), ManagedServerJupyterModuleConnectionSettings.class, null, (int)4, null).getComponent();
                        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$row, null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this, radioButton){
                            final /* synthetic */ $special$$inlined$panel$lambda$3$1 this$0;
                            final /* synthetic */ JBRadioButton $radioButton;
                            {
                                this.this$0 = var1_1;
                                this.$radioButton = jBRadioButton;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                                ManagedServerSettingsForm.Companion.managedSettingsPanel($this$row, JupyterServerModuleConfigurable.access$getManagedServerSettingsForm$p(this.this$0.this$0.this$0), JupyterServerModuleConfigurable.access$getModule$p(this.this$0.this$0.this$0), ComponentPredicateKt.getSelected((AbstractButton)((AbstractButton)this.$radioButton)));
                            }
                        }), (int)3, null);
                    }
                }), (int)3, null);
                RowBuilder.DefaultImpls.row$default((RowBuilder)$this$buttonGroup, null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>($this$buttonGroup, this){
                    final /* synthetic */ RowBuilderWithButtonGroupProperty $this_buttonGroup;
                    final /* synthetic */ $special$$inlined$panel$lambda$3 this$0;
                    {
                        this.$this_buttonGroup = rowBuilderWithButtonGroupProperty;
                        this.this$0 = var2_2;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                        JBRadioButton radioButton = (JBRadioButton)RowBuilderWithButtonGroupProperty.radioButton$default((RowBuilderWithButtonGroupProperty)this.$this_buttonGroup, (Row)$this$row, (String)JupyterBundle.message("Jupyter.servers.configured.server", new Object[0]), ConfiguredServerJupyterModuleConnectionSettings.class, null, (int)4, null).getComponent();
                        CellKt.withTextBinding((CellBuilder)Cell.invoke$default((Cell)$this$row, (JComponent)((JComponent)this.this$0.$urlTextField$inlined), (CCFlags[])new CCFlags[]{$this$row.getPushX()}, null, null, (int)6, null), (PropertyBinding)new PropertyBinding((Function0)new Function0<String>(this){
                            final /* synthetic */ $special$$inlined$panel$lambda$3$2 this$0;
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                return JupyterServerModuleConfigurable.access$getUrl$p(this.this$0.this$0.this$0);
                            }
                        }, (Function1)new Function1<String, Unit>(this){
                            final /* synthetic */ $special$$inlined$panel$lambda$3$2 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            public final void invoke(@NotNull String value2) {
                                Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
                                JupyterServerModuleConfigurable.access$setUrl$p(this.this$0.this$0.this$0, value2);
                            }
                        })).enableIf(ComponentPredicateKt.getSelected((AbstractButton)((AbstractButton)radioButton)));
                    }
                }), (int)3, null);
            }
        });
        DialogPanel panel$iv = ComponentsKt.DialogPanel((String)title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, (LCFlags[])constraints$iv);
        LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
        jupyterServerModuleConfigurable.formPanel = dialogPanel = panel$iv;
    }

    public static final /* synthetic */ Class access$getSelectedJupyterModuleConnectionSettingsClass$p(JupyterServerModuleConfigurable $this) {
        return $this.selectedJupyterModuleConnectionSettingsClass;
    }

    public static final /* synthetic */ void access$setSelectedJupyterModuleConnectionSettingsClass$p(JupyterServerModuleConfigurable $this, Class clazz) {
        $this.selectedJupyterModuleConnectionSettingsClass = clazz;
    }

    public static final /* synthetic */ ManagedServerSettingsForm access$getManagedServerSettingsForm$p(JupyterServerModuleConfigurable $this) {
        return $this.managedServerSettingsForm;
    }

    public static final /* synthetic */ Module access$getModule$p(JupyterServerModuleConfigurable $this) {
        return $this.module;
    }

    public static final /* synthetic */ String access$getUrl$p(JupyterServerModuleConfigurable $this) {
        return $this.url;
    }

    public static final /* synthetic */ void access$setUrl$p(JupyterServerModuleConfigurable $this, String string) {
        $this.url = string;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0002\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/configuration/JupyterServerModuleConfigurable$Companion;", "", "()V", "persistentConnectionPresentation", "", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/ConfiguredServerJupyterModuleConnectionSettings;", "intellij.python.jupyter"})
    public static final class Companion {
        private final String persistentConnectionPresentation(@NotNull ConfiguredServerJupyterModuleConnectionSettings $this$persistentConnectionPresentation) {
            String string;
            block3: {
                block2: {
                    string = $this$persistentConnectionPresentation.getToken();
                    if (string == null) break block2;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string2;
                    boolean bl3 = false;
                    string = $this$persistentConnectionPresentation.getUrl() + "?token=" + it;
                    if (string != null) break block3;
                }
                string = $this$persistentConnectionPresentation.getUrl();
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

