/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.connections.execution;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.JupyterProjectUtilKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.ConfiguredServerJupyterModuleConnectionSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterConnectionParameters;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterConnectionParametersSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterModuleConnectionSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterModuleConnectionSettingsKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.ManagedServerJupyterModuleConnectionSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterNotebookOfflineSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterNotebookRuntimeSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterNotebookSessionSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterRuntimeService;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.ManagedJupyterServerNotebookSessionSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterServer;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterServers;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\f\u0010\b\u001a\u00020\u0007*\u00020\tH\u0000\u001a\f\u0010\n\u001a\u00020\u0007*\u00020\u000bH\u0002\u001a\n\u0010\f\u001a\u00020\u0007*\u00020\r\u00a8\u0006\u000e"}, d2={"getJupyterServer", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterServer;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isRemoteJupyterServerSettings", "", "isLocal", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterConnectionParameters;", "isLocalUrlString", "", "isRemote", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterModuleConnectionSettings;", "intellij.python.jupyter"})
public final class JupyterConnectionSettingsUtilKt {
    public static final boolean isRemoteJupyterServerSettings(@NotNull Project project, @Nullable VirtualFile virtualFile2) {
        JupyterNotebookRuntimeSettings notebookSettings;
        JupyterNotebookRuntimeSettings jupyterNotebookRuntimeSettings;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        VirtualFile virtualFile3 = virtualFile2;
        if (virtualFile3 != null) {
            VirtualFile virtualFile4 = virtualFile3;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile4;
            boolean bl3 = false;
            jupyterNotebookRuntimeSettings = JupyterRuntimeService.Companion.getInstance(project).getRuntime(it);
        } else {
            jupyterNotebookRuntimeSettings = notebookSettings = null;
        }
        if (notebookSettings != null) {
            return (Boolean)notebookSettings.accept(new JupyterNotebookRuntimeSettings.Visitor<Boolean>(){

                @NotNull
                public Boolean visit(@NotNull JupyterNotebookOfflineSettings settings) {
                    Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                    return JupyterConnectionSettingsUtilKt.isRemote(settings.getConnectionSettings());
                }

                @NotNull
                public Boolean visit(@NotNull JupyterNotebookSessionSettings settings) {
                    Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                    return !JupyterConnectionSettingsUtilKt.isLocal(settings.getSession().getJupyterServer().getConnectionParameters());
                }

                @NotNull
                public Boolean visit(@NotNull ManagedJupyterServerNotebookSessionSettings settings) {
                    Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                    return false;
                }
            });
        }
        JupyterModuleConnectionSettings guessedConnectionSettings = JupyterConnectionParametersSettings.INSTANCE.guessConnectionSettings(project, virtualFile2);
        return JupyterConnectionSettingsUtilKt.isRemote(guessedConnectionSettings);
    }

    @Nullable
    public static final JupyterServer getJupyterServer(@NotNull Project project, @Nullable VirtualFile virtualFile2) {
        JupyterServer jupyterServer;
        JupyterConnectionParameters effectiveConnectionParameters;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        JupyterModuleConnectionSettings guessedConnectionSettings = JupyterConnectionParametersSettings.INSTANCE.guessConnectionSettings(project, virtualFile2);
        JupyterConnectionParameters jupyterConnectionParameters = effectiveConnectionParameters = JupyterModuleConnectionSettingsKt.getConnectionParameters(guessedConnectionSettings, project, virtualFile2);
        if (jupyterConnectionParameters != null) {
            JupyterConnectionParameters jupyterConnectionParameters2 = jupyterConnectionParameters;
            boolean bl = false;
            boolean bl2 = false;
            JupyterConnectionParameters it = jupyterConnectionParameters2;
            boolean bl3 = false;
            jupyterServer = JupyterServers.Companion.getInstance().getServer(it);
        } else {
            jupyterServer = null;
        }
        return jupyterServer;
    }

    public static final boolean isRemote(@NotNull JupyterModuleConnectionSettings $this$isRemote) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$this$isRemote, (String)"$this$isRemote");
        JupyterModuleConnectionSettings jupyterModuleConnectionSettings = $this$isRemote;
        if (jupyterModuleConnectionSettings instanceof ManagedServerJupyterModuleConnectionSettings) {
            bl = false;
        } else if (jupyterModuleConnectionSettings instanceof ConfiguredServerJupyterModuleConnectionSettings) {
            bl = JupyterProjectUtilKt.isPyCharmDS() ? true : !JupyterConnectionSettingsUtilKt.isLocalUrlString(((ConfiguredServerJupyterModuleConnectionSettings)$this$isRemote).getUrl());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public static final boolean isLocal(@NotNull JupyterConnectionParameters $this$isLocal) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isLocal, (String)"$this$isLocal");
        return JupyterProjectUtilKt.isPyCharmDS() ? $this$isLocal.getManaged() : JupyterConnectionSettingsUtilKt.isLocalUrlString($this$isLocal.getUrlString());
    }

    private static final boolean isLocalUrlString(@NotNull String $this$isLocalUrlString) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = CollectionsKt.listOf((Object[])new String[]{"localhost", "127.0.0.1"});
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String localHostname = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)$this$isLocalUrlString, (CharSequence)localHostname, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

