/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.connections.execution.core;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SmartFMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.JupyterWebFrontEndApi;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterWebSocketClient;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterCellExecutionCallback;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterCellExecutionCallbackAdapter;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterKernelClient$WhenMappings;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterServer;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterCommMessage;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterCommOpenMessageBuilder;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterExecuteRequestMessageBuilder;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterInputRequestMessage;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterMessage;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterMessageBase;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterMessageHeader;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterMessageType;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterProtocolSchema;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterProtocolSchemaFactory;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterStatusMessage;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.WebSocketMessage;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterStreamOutput;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 32\u00020\u0001:\u00013B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u001d\u001a\u00020\u0013J:\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020\u001cH\u0002J\u0006\u0010%\u001a\u00020\u0013J\"\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00052\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011J\u0018\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020+2\u0006\u0010!\u001a\u00020\fH\u0002J\u0010\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020.H\u0002J\u0006\u0010/\u001a\u00020\u0013J\u001a\u00100\u001a\u00020\u00132\u0006\u0010*\u001a\u00020+2\b\u0010!\u001a\u0004\u0018\u00010\fH\u0007J\u000e\u00101\u001a\u00020\u00132\u0006\u00102\u001a\u00020\u0005R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0084\u0001\u0010\r\u001ax\u0012t\u0012r\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00050\u0005\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013 \u0010*\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00110\u0011 \u0010*8\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00050\u0005\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013 \u0010*\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00110\u0011\u0018\u00010\u000f0\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterKernelClient;", "", "jupyterServer", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterServer;", "kernelId", "", "sessionId", "frontEnd", "Lorg/jetbrains/plugins/notebooks/jupyter/JupyterWebFrontEndApi;", "(Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterServer;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/plugins/notebooks/jupyter/JupyterWebFrontEndApi;)V", "callbacks", "", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterCellExecutionCallback;", "commHandlerByCommId", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/util/SmartFMap;", "kotlin.jvm.PlatformType", "Lkotlin/Function1;", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterCommMessage;", "", "<set-?>", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterStatusMessage$JupyterExecutionState;", "executionState", "getExecutionState", "()Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterStatusMessage$JupyterExecutionState;", "lock", "messageToSkipProcessing", "webSocketClient", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterWebSocketClient;", "deleteSession", "execute", "code", "onMessageCreated", "callback", "silent", "", "getOrConnectWebSocketClient", "interrupt", "openComm", "targetName", "handler", "processMessageCallBack", "message", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterMessage;", "processWebSocketRawMessage", "content", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/WebSocketMessage;", "restart", "sendMessage", "stopListeningMessageReply", "messageId", "Companion", "intellij.python.jupyter"})
public final class JupyterKernelClient {
    private final AtomicReference<SmartFMap<String, Function1<JupyterCommMessage, Unit>>> commHandlerByCommId;
    private Object lock;
    private String messageToSkipProcessing;
    private JupyterWebSocketClient webSocketClient;
    private final Map<String, JupyterCellExecutionCallback> callbacks;
    @Nullable
    private volatile JupyterStatusMessage.JupyterExecutionState executionState;
    private final JupyterServer jupyterServer;
    private final String kernelId;
    private final String sessionId;
    private final JupyterWebFrontEndApi frontEnd;
    private static final Logger LOG;
    public static final Companion Companion;

    @Nullable
    public final JupyterStatusMessage.JupyterExecutionState getExecutionState() {
        return this.executionState;
    }

    public final void execute(@NotNull String code, @NotNull String sessionId, @NotNull Function1<? super String, Unit> onMessageCreated, @NotNull JupyterCellExecutionCallback callback2, boolean silent) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
        Intrinsics.checkParameterIsNotNull(onMessageCreated, (String)"onMessageCreated");
        Intrinsics.checkParameterIsNotNull((Object)callback2, (String)"callback");
        JupyterMessage message = new JupyterExecuteRequestMessageBuilder(code, sessionId, null, silent, 4, null).build();
        onMessageCreated.invoke((Object)message.getHeader().getMessageId());
        this.callbacks.put(message.getHeader().getMessageId(), callback2);
        this.getOrConnectWebSocketClient().send(message.serialize());
    }

    public final void stopListeningMessageReply(@NotNull String messageId) {
        Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
        this.callbacks.put(messageId, JupyterCellExecutionCallbackAdapter.Companion.getEMPTY());
    }

    @NotNull
    public final String openComm(@NotNull String targetName, @NotNull Function1<? super JupyterCommMessage, Unit> handler) {
        Intrinsics.checkParameterIsNotNull((Object)targetName, (String)"targetName");
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID().toString()");
        String commId = string;
        this.commHandlerByCommId.updateAndGet((UnaryOperator<SmartFMap<String, Function1<JupyterCommMessage, Unit>>>)new UnaryOperator<SmartFMap<String, Function1<? super JupyterCommMessage, ? extends Unit>>>(commId, handler){
            final /* synthetic */ String $commId;
            final /* synthetic */ Function1 $handler;

            public final SmartFMap<String, Function1<JupyterCommMessage, Unit>> apply(SmartFMap<String, Function1<JupyterCommMessage, Unit>> it) {
                return it.plus((Object)this.$commId, (Object)this.$handler);
            }
            {
                this.$commId = string;
                this.$handler = function1;
            }
        });
        JupyterMessage message = new JupyterCommOpenMessageBuilder(this.sessionId, null, null, targetName, null, commId, null, 86, null).build();
        this.getOrConnectWebSocketClient().send(message.serialize());
        return commId;
    }

    @Deprecated(message="Should be encapsulated")
    public final void sendMessage(@NotNull JupyterMessage message, @Nullable JupyterCellExecutionCallback callback2) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        JupyterCellExecutionCallback jupyterCellExecutionCallback = callback2;
        if (jupyterCellExecutionCallback != null) {
            JupyterCellExecutionCallback jupyterCellExecutionCallback2 = jupyterCellExecutionCallback;
            boolean bl = false;
            boolean bl2 = false;
            JupyterCellExecutionCallback it = jupyterCellExecutionCallback2;
            boolean bl3 = false;
            this.callbacks.put(message.getHeader().getMessageId(), it);
        }
        this.getOrConnectWebSocketClient().send(message.serialize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JupyterWebSocketClient getOrConnectWebSocketClient() {
        JupyterWebSocketClient jupyterWebSocketClient;
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            JupyterWebSocketClient jupyterWebSocketClient2 = this.webSocketClient;
            if (jupyterWebSocketClient2 == null) {
                JupyterWebSocketClient jupyterWebSocketClient3 = this.jupyterServer.getClient().createWebSocketClientForKernel(this.kernelId, (Function1<? super WebSocketMessage, Unit>)((Function1)new Function1<WebSocketMessage, Unit>(this){
                    final /* synthetic */ JupyterKernelClient this$0;
                    {
                        this.this$0 = jupyterKernelClient;
                        super(1);
                    }

                    public final void invoke(@NotNull WebSocketMessage content2) {
                        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
                        JupyterKernelClient.access$processWebSocketRawMessage(this.this$0, content2);
                    }
                }));
                boolean bl4 = false;
                boolean bl5 = false;
                JupyterWebSocketClient it = jupyterWebSocketClient3;
                boolean bl6 = false;
                this.webSocketClient = it;
                jupyterWebSocketClient2 = jupyterWebSocketClient3;
            }
            jupyterWebSocketClient = jupyterWebSocketClient2;
        }
        return jupyterWebSocketClient;
    }

    private final void processWebSocketRawMessage(WebSocketMessage content2) {
        String parentMessageId;
        JupyterProtocolSchema protocolSchema = JupyterProtocolSchemaFactory.createSchema$default(JupyterProtocolSchemaFactory.INSTANCE, null, 1, null);
        JupyterMessage message = JupyterMessageBase.Companion.parse(content2, protocolSchema);
        JupyterMessageHeader jupyterMessageHeader = message.getParentHeader();
        String string = parentMessageId = jupyterMessageHeader != null ? jupyterMessageHeader.getMessageId() : null;
        if (message.getHeader().getMessageType() == JupyterMessageType.COMM_MSG) {
            JupyterCommMessage jupyterCommMessage = new JupyterCommMessage(message);
            Function1 function1 = (Function1)this.commHandlerByCommId.get().get((Object)jupyterCommMessage.getCommId());
            if (function1 != null) {
                Function1 function12 = function1;
                boolean bl = false;
                boolean bl2 = false;
                Function1 it = function12;
                boolean bl3 = false;
                it.invoke((Object)jupyterCommMessage);
                return;
            }
            String string2 = jupyterCommMessage.getMsgId();
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl4 = false;
                String msgId = string3;
                boolean bl5 = false;
                this.messageToSkipProcessing = msgId;
            }
        }
        if (parentMessageId == null) {
            LOG.info("Jupyter message arrived, but not processed because parent message id is absent: " + message);
        } else {
            JupyterCellExecutionCallback callback2 = this.callbacks.get(parentMessageId);
            if (Intrinsics.areEqual((Object)parentMessageId, (Object)this.messageToSkipProcessing) ^ true && callback2 != null) {
                this.processMessageCallBack(message, callback2);
            }
        }
        this.frontEnd.sendMessageToFrontEnd(message);
    }

    private final void processMessageCallBack(JupyterMessage message, JupyterCellExecutionCallback callback2) {
        switch (JupyterKernelClient$WhenMappings.$EnumSwitchMapping$0[message.getHeader().getMessageType().ordinal()]) {
            case 1: {
                JupyterStatusMessage statusMessage = new JupyterStatusMessage(message);
                this.executionState = statusMessage.getExecutionState();
                callback2.onStatus(statusMessage);
                break;
            }
            case 2: {
                callback2.onExecuteInput(message);
                break;
            }
            case 3: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CollectionsKt.joinToString$default((Iterable)JupyterStreamOutput.Companion.fromMessage(message).getText(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                }
                callback2.onUpdateOutput(message);
                break;
            }
            case 4: {
                callback2.onUpdateOutput(message);
                break;
            }
            case 5: {
                callback2.onExecuteReply(message);
                break;
            }
            case 6: {
                callback2.onDisplayData(message);
                break;
            }
            case 7: {
                callback2.onInputRequest(new JupyterInputRequestMessage(message));
                break;
            }
            case 8: {
                callback2.onUpdateOutput(message);
                break;
            }
            case 9: {
                callback2.onClearOutput(message);
                break;
            }
            case 10: {
                callback2.onInspectReply(message);
                break;
            }
            case 11: {
                callback2.onCompleteReply(message);
                break;
            }
            default: {
                LOG.info("Jupyter message arrived, but not processed: " + message);
            }
        }
    }

    public final void interrupt() {
        this.jupyterServer.getClient().interrupt(this.kernelId);
    }

    public final void restart() {
        this.jupyterServer.getClient().restart(this.kernelId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteSession() {
        block8: {
            JupyterWebSocketClient jupyterWebSocketClient;
            this.callbacks.clear();
            Object object = this.lock;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                JupyterWebSocketClient jupyterWebSocketClient2 = this.webSocketClient;
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                jupyterWebSocketClient = jupyterWebSocketClient2;
            }
            if (jupyterWebSocketClient != null) {
                jupyterWebSocketClient.close();
            }
            try {
                this.jupyterServer.getClient().deleteSession(this.sessionId);
            }
            catch (Exception e) {
                boolean bl4;
                Logger $this$debugOrInfoIfTestMode$iv = LOG;
                boolean $i$f$debugOrInfoIfTestMode = false;
                Application application = ApplicationManager.getApplication();
                if (application != null) {
                    if (application.isUnitTestMode()) {
                        Logger logger = $this$debugOrInfoIfTestMode$iv;
                        bl4 = false;
                        String string = "Error occurred on deleting Jupyter session " + this.sessionId;
                        logger.info(string);
                    }
                }
                Logger $this$debug$iv$iv = $this$debugOrInfoIfTestMode$iv;
                boolean $i$f$debug = false;
                if (!$this$debug$iv$iv.isDebugEnabled()) break block8;
                Logger logger = $this$debug$iv$iv;
                bl4 = false;
                String string = "Error occurred on deleting Jupyter session " + this.sessionId;
                logger.debug(string, (Throwable)e);
            }
        }
    }

    public JupyterKernelClient(@NotNull JupyterServer jupyterServer, @NotNull String kernelId, @NotNull String sessionId, @NotNull JupyterWebFrontEndApi frontEnd) {
        Intrinsics.checkParameterIsNotNull((Object)jupyterServer, (String)"jupyterServer");
        Intrinsics.checkParameterIsNotNull((Object)kernelId, (String)"kernelId");
        Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
        Intrinsics.checkParameterIsNotNull((Object)frontEnd, (String)"frontEnd");
        this.jupyterServer = jupyterServer;
        this.kernelId = kernelId;
        this.sessionId = sessionId;
        this.frontEnd = frontEnd;
        this.commHandlerByCommId = new AtomicReference<SmartFMap>(SmartFMap.emptyMap());
        this.lock = new Object();
        this.messageToSkipProcessing = "";
        this.callbacks = new ConcurrentHashMap();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(JupyterKernelClient.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Jupyt\u2026KernelClient::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$processWebSocketRawMessage(JupyterKernelClient $this, WebSocketMessage content2) {
        $this.processWebSocketRawMessage(content2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterKernelClient$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.python.jupyter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

