/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.editor;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.core.impl.file.NotebookVirtualFile;
import org.jetbrains.plugins.notebooks.jupyter.debugger.CellSourcePosition;
import org.jetbrains.plugins.notebooks.jupyter.editor.IndexedCell;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterCellUtilKt$getCellIndex$;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterTextEditorWithPreview;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterCellType;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterCell;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterFile;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterSource;
import org.jetbrains.plugins.notebooks.jupyter.settings.JupyterSettings;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0084\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u001e\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0010H\u0002\u001a\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0013H\u0000\u001a\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001b\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\u0010\u001c\u001a\u001e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!\u001a\"\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\"\u001a\u0004\u0018\u00010\tH\u0000\u001a\u0016\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010#\u001a\u00020$\u001a\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u0018H\u0000\u001a \u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u0010\u001a$\u0010*\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010'\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u0010H\u0000\u001a\u0012\u0010+\u001a\u0004\u0018\u00010\u00022\u0006\u0010'\u001a\u00020\u0018H\u0000\u001a\u001a\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u0018H\u0000\u001a\u0012\u0010.\u001a\u0004\u0018\u00010\t2\u0006\u0010'\u001a\u00020\u0018H\u0000\u001a\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0000\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0013\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0004\u00a8\u00063"}, d2={"JUPYTER_EDITOR_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/editor/Editor;", "getJUPYTER_EDITOR_KEY", "()Lcom/intellij/openapi/util/Key;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "NOTEBOOK_VIRTUAL_FILE_KEY", "Lorg/jetbrains/plugins/notebooks/core/impl/file/NotebookVirtualFile;", "getNOTEBOOK_VIRTUAL_FILE_KEY", "addExtraLines", "", "source", "", "getCellIndex", "", "psiCells", "", "Lorg/jetbrains/plugins/notebooks/jupyter/psi/JupyterCell;", "offset", "getCellPositionForJupyterCell", "Lorg/jetbrains/plugins/notebooks/jupyter/debugger/CellSourcePosition;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "cell", "getCellSelectionOffset", "psiCell", "(Lorg/jetbrains/plugins/notebooks/jupyter/psi/JupyterCell;)Ljava/lang/Integer;", "getCells", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "notebookVirtualFile", "psiFile", "Lcom/intellij/psi/PsiFile;", "getDocumentByOriginalVirtualFile", "Lcom/intellij/openapi/editor/Document;", "virtualFile", "getIndexedJupyterCellByOffset", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/IndexedCell;", "getJupyterCellByOffset", "getJupyterEditorByOriginalVirtualFile", "getJupyterFileEditorByOriginalVirtualFile", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterTextEditorWithPreview;", "getJupyterVirtualFileByOriginalVirtualFile", "shouldHaveExtraLines", "", "cellType", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterCellType;", "intellij.python.jupyter"})
public final class JupyterCellUtilKt {
    @NotNull
    private static final Key<Editor> JUPYTER_EDITOR_KEY;
    @NotNull
    private static final Key<NotebookVirtualFile> NOTEBOOK_VIRTUAL_FILE_KEY;
    private static final Logger LOG;

    @NotNull
    public static final Key<Editor> getJUPYTER_EDITOR_KEY() {
        return JUPYTER_EDITOR_KEY;
    }

    @NotNull
    public static final Key<NotebookVirtualFile> getNOTEBOOK_VIRTUAL_FILE_KEY() {
        return NOTEBOOK_VIRTUAL_FILE_KEY;
    }

    @Nullable
    public static final List<JupyterCell> getCells(@NotNull PsiFile psiFile) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
        PsiFile psiFile2 = psiFile;
        boolean bl = false;
        boolean bl2 = false;
        PsiFile it = psiFile2;
        boolean bl3 = false;
        Object object = it instanceof JupyterFile ? psiFile2 : null;
        if (object != null) {
            psiFile2 = object;
            bl = false;
            bl2 = false;
            PsiFile $this$run = psiFile2;
            boolean bl4 = false;
            list = (List)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)psiFile), (CachedValueProvider)new CachedValueProvider<T>($this$run, psiFile){
                final /* synthetic */ PsiFile $this_run;
                final /* synthetic */ PsiFile $psiFile$inlined;
                {
                    this.$this_run = psiFile;
                    this.$psiFile$inlined = psiFile2;
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final CachedValueProvider.Result<List<JupyterCell>> compute() {
                    void $this$filterIsInstanceTo$iv$iv;
                    PsiElement psiElement = this.$this_run.getFirstChild();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"firstChild");
                    PsiElement[] psiElementArray = psiElement.getChildren();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElementArray, (String)"firstChild.children");
                    PsiElement[] $this$filterIsInstance$iv = psiElementArray;
                    boolean $i$f$filterIsInstance = false;
                    PsiElement[] psiElementArray2 = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof JupyterCell)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List list = (List)destination$iv$iv;
                    Object[] objectArray = new Object[]{this.$psiFile$inlined};
                    List list2 = list;
                    return new CachedValueProvider.Result((Object)list2, objectArray);
                }
            });
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public static final List<JupyterCell> getCells(@NotNull Project project, @Nullable NotebookVirtualFile notebookVirtualFile) {
        List<JupyterCell> list;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        NotebookVirtualFile notebookVirtualFile2 = notebookVirtualFile;
        if (notebookVirtualFile2 != null) {
            NotebookVirtualFile notebookVirtualFile3 = notebookVirtualFile2;
            boolean bl = false;
            boolean bl2 = false;
            NotebookVirtualFile it = notebookVirtualFile3;
            boolean bl3 = false;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile((VirtualFile)it);
            if (psiFile == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.notebooks.jupyter.psi.JupyterFile");
            }
            list = JupyterCellUtilKt.getCells((PsiFile)((JupyterFile)psiFile));
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public static final List<JupyterCell> getCells(@NotNull Project project, @NotNull TextEditor editor2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        VirtualFile virtualFile2 = editor2.getFile();
        if (virtualFile2 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"editor.file ?: return null");
        VirtualFile virtualFile3 = virtualFile2;
        VirtualFile virtualFile4 = virtualFile3;
        if (!(virtualFile4 instanceof NotebookVirtualFile)) {
            virtualFile4 = null;
        }
        return JupyterCellUtilKt.getCells(project, (NotebookVirtualFile)virtualFile4);
    }

    @Nullable
    public static final CellSourcePosition getCellPositionForJupyterCell(@NotNull VirtualFile file2, @NotNull JupyterCell cell) {
        Editor editor2;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)cell, (String)"cell");
                Editor editor3 = JupyterCellUtilKt.getJupyterEditorByOriginalVirtualFile(file2);
                editor2 = editor3;
                if (editor2 == null) break block2;
                TextRange textRange = cell.getTextRange();
                Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"cell.textRange");
                if ((editor2 = editor2.offsetToLogicalPosition(textRange.getStartOffset())) != null) break block3;
            }
            return null;
        }
        int line2 = editor2.line;
        XSourcePosition startSourcePosition = XDebuggerUtil.getInstance().createPosition(file2, line2);
        return startSourcePosition != null ? new CellSourcePosition(startSourcePosition) : null;
    }

    @Nullable
    public static final IndexedCell getIndexedJupyterCellByOffset(@NotNull Project project, @NotNull TextEditor editor2, int offset) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        List<JupyterCell> list = JupyterCellUtilKt.getCells(project, editor2);
        if (list == null) {
            return null;
        }
        List<JupyterCell> psiCells = list;
        int activeCellIndex = JupyterCellUtilKt.getCellIndex(psiCells, offset);
        return activeCellIndex < 0 ? null : new IndexedCell(activeCellIndex, psiCells.get(activeCellIndex), activeCellIndex == psiCells.size() - 1);
    }

    @Nullable
    public static final JupyterCell getJupyterCellByOffset(@NotNull Project project, @Nullable NotebookVirtualFile virtualFile2, int offset) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        List<JupyterCell> list = JupyterCellUtilKt.getCells(project, virtualFile2);
        if (list == null) {
            return null;
        }
        List<JupyterCell> psiCells = list;
        int activeCellIndex = JupyterCellUtilKt.getCellIndex(psiCells, offset);
        return activeCellIndex < 0 ? null : psiCells.get(activeCellIndex);
    }

    private static final int getCellIndex(List<? extends JupyterCell> psiCells, int offset) {
        return SequencesKt.lastIndexOf((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)psiCells), (Function1)((Function1)new Function1<JupyterCell, Boolean>(offset){
            final /* synthetic */ int $offset;

            public final boolean invoke(@NotNull JupyterCell it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.getTextOffset() <= this.$offset;
            }
            {
                this.$offset = n;
                super(1);
            }
        })), (Object)true);
    }

    @Nullable
    public static final Editor getJupyterEditorByOriginalVirtualFile(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile2, (String)"virtualFile");
        if (virtualFile2 instanceof NotebookVirtualFile) {
            LOG.error("Original notebook file is expected, but NotebookVirtualFile provided");
        }
        return (Editor)virtualFile2.getUserData(JUPYTER_EDITOR_KEY);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final JupyterTextEditorWithPreview getJupyterFileEditorByOriginalVirtualFile(@NotNull Project project, @NotNull VirtualFile virtualFile2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)virtualFile2, (String)"virtualFile");
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)project).getAllEditors(virtualFile2);
        Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorArray, (String)"FileEditorManager.getIns\u2026etAllEditors(virtualFile)");
        FileEditor[] $this$mapNotNull$iv = fileEditorArray;
        boolean $i$f$mapNotNull = false;
        FileEditor[] fileEditorArray2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var9_9 = $this$forEach$iv$iv$iv;
        int n = ((void)var9_9).length;
        for (int i = 0; i < n; ++i) {
            JupyterTextEditorWithPreview jupyterTextEditorWithPreview;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var9_9[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            Object v1 = it;
            if (!(v1 instanceof JupyterTextEditorWithPreview)) {
                v1 = null;
            }
            if ((JupyterTextEditorWithPreview)v1 == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            JupyterTextEditorWithPreview it$iv$iv = jupyterTextEditorWithPreview;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (JupyterTextEditorWithPreview)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    @Nullable
    public static final Document getDocumentByOriginalVirtualFile(@NotNull VirtualFile virtualFile2) {
        Editor editor2;
        Intrinsics.checkParameterIsNotNull((Object)virtualFile2, (String)"virtualFile");
        Editor editor3 = editor2 = JupyterCellUtilKt.getJupyterEditorByOriginalVirtualFile(virtualFile2);
        return editor3 != null ? editor3.getDocument() : null;
    }

    @Nullable
    public static final NotebookVirtualFile getJupyterVirtualFileByOriginalVirtualFile(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile2, (String)"virtualFile");
        return (NotebookVirtualFile)((Object)virtualFile2.getUserData(NOTEBOOK_VIRTUAL_FILE_KEY));
    }

    public static final boolean shouldHaveExtraLines(@NotNull JupyterCellType cellType2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)cellType2), (String)"cellType");
        return cellType2 != JupyterCellType.RAW && JupyterSettings.Companion.getInstance().getSourceCodeLineSpan() > 0;
    }

    @NotNull
    public static final String addExtraLines(@NotNull CharSequence source2) {
        Intrinsics.checkParameterIsNotNull((Object)source2, (String)"source");
        String span = StringsKt.repeat((CharSequence)"\n", (int)JupyterSettings.Companion.getInstance().getSourceCodeLineSpan());
        return span + source2 + span;
    }

    @Nullable
    public static final Integer getCellSelectionOffset(@NotNull JupyterCell psiCell) {
        Integer n;
        Intrinsics.checkParameterIsNotNull((Object)psiCell, (String)"psiCell");
        JupyterSource jupyterSource = (JupyterSource)PsiTreeUtil.getChildOfType((PsiElement)psiCell, JupyterSource.class);
        if (jupyterSource != null) {
            JupyterSource jupyterSource2 = jupyterSource;
            boolean bl = false;
            boolean bl2 = false;
            JupyterSource it = jupyterSource2;
            boolean bl3 = false;
            JupyterSource jupyterSource3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jupyterSource3, (String)"it");
            int n2 = it.getTextLength();
            int n3 = JupyterSettings.Companion.getInstance().getSourceCodeLineSpan();
            int n4 = jupyterSource3.getTextOffset();
            boolean bl4 = false;
            int n5 = Math.min(n2, n3);
            n = n4 + n5;
        } else {
            n = null;
        }
        return n;
    }

    public static final int getCellIndex(@NotNull JupyterCell $this$getCellIndex) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getCellIndex, (String)"$this$getCellIndex");
        PsiElement psiElement = $this$getCellIndex.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"parent");
        Object[] objectArray = psiElement.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"parent.children");
        Sequence $this$filterIsInstance$iv = ArraysKt.asSequence((Object[])objectArray);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getCellIndex$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        return SequencesKt.indexOf((Sequence)sequence, (Object)$this$getCellIndex);
    }

    static {
        Key key = Key.create((String)"JUPYTER_EDITOR_KEY");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create(\"JUPYTER_EDITOR_KEY\")");
        JUPYTER_EDITOR_KEY = key;
        Key key2 = Key.create((String)"NOTEBOOK_VIRTUAL_FILE_KEY");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create(\"NOTEBOOK_VIRTUAL_FILE_KEY\")");
        NOTEBOOK_VIRTUAL_FILE_KEY = key2;
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Metho\u2026s.lookup().lookupClass())");
        LOG = logger;
    }
}

