/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.editor;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.core.impl.file.NotebookVirtualFile;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterFileEditorProvider;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterSourceEditor;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterTextEditorWithPreview;
import org.jetbrains.plugins.notebooks.jupyter.editor.preview.JupyterPreviewFileEditor;
import org.jetbrains.plugins.notebooks.jupyter.editor.preview.JupyterPreviewHtmlPanel;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterSplitFileEditorProvider;", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterFileEditorProvider;", "()V", "createJupyterFileEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lorg/jetbrains/plugins/notebooks/core/impl/file/NotebookVirtualFile;", "intellij.python.jupyter.pro"})
public final class JupyterSplitFileEditorProvider
extends JupyterFileEditorProvider {
    public static final JupyterSplitFileEditorProvider INSTANCE;

    @Override
    @NotNull
    public TextEditor createJupyterFileEditor(@NotNull Project project, @NotNull NotebookVirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)file2), (String)"file");
        FileEditor fileEditor = TextEditorProvider.getInstance().createEditor(project, (VirtualFile)file2);
        if (fileEditor == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
        }
        JupyterSourceEditor editor2 = new JupyterSourceEditor((TextEditor)fileEditor);
        String string = file2.getOriginFile().getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.originFile.path");
        String path = string;
        JupyterPreviewFileEditor preview = new JupyterPreviewFileEditor(new JupyterPreviewHtmlPanel(project, editor2, file2));
        return new JupyterTextEditorWithPreview(project, path, editor2, preview, "Jupyter Notebook Editor");
    }

    private JupyterSplitFileEditorProvider() {
    }

    static {
        JupyterSplitFileEditorProvider jupyterSplitFileEditorProvider;
        INSTANCE = jupyterSplitFileEditorProvider = new JupyterSplitFileEditorProvider();
    }
}

