/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.variables;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterExecutionException;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterCell;
import org.jetbrains.plugins.notebooks.jupyter.variables.JupyterVarsResultWaiter;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/variables/JupyterVarsCommandExecutor;", "Lcom/intellij/openapi/Disposable;", "()V", "executorService", "Ljava/util/concurrent/ExecutorService;", "dispose", "", "executeCommands", "", "project", "Lcom/intellij/openapi/project/Project;", "commands", "", "cell", "Lorg/jetbrains/plugins/notebooks/jupyter/psi/JupyterCell;", "Companion", "intellij.python.jupyter"})
public final class JupyterVarsCommandExecutor
implements Disposable {
    private final ExecutorService executorService;
    @NotNull
    private static final Logger LOG;
    public static final long TIMEOUT = 60L;
    public static final Companion Companion;

    @NotNull
    public final synchronized String executeCommands(@NotNull Project project, @NotNull List<String> commands, @NotNull JupyterCell cell) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(commands, (String)"commands");
        Intrinsics.checkParameterIsNotNull((Object)cell, (String)"cell");
        try {
            if (commands.isEmpty()) {
                return "";
            }
            StringBuilder result = new StringBuilder();
            for (IndexedValue command : CollectionsKt.withIndex((Iterable)commands)) {
                Future future2 = this.executorService.submit((Callable)new Callable<String>(project, cell, command){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ JupyterCell $cell;
                    final /* synthetic */ IndexedValue $command;

                    @NotNull
                    public final String call() {
                        return JupyterVarsResultWaiter.executeAndGetOutput$default(new JupyterVarsResultWaiter(this.$project, this.$cell, (String)this.$command.getValue()), false, false, false, 5, null);
                    }
                    {
                        this.$project = project;
                        this.$cell = jupyterCell;
                        this.$command = indexedValue;
                    }
                });
                result.append((String)future2.get(60L, TimeUnit.SECONDS));
            }
            String string = result.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
            return string;
        }
        catch (JupyterExecutionException e) {
            LOG.warn((Throwable)e);
        }
        catch (TimeoutException e) {
            LOG.error("Variables View timeout error for commands: " + commands);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return "";
    }

    public void dispose() {
        this.executorService.shutdown();
    }

    public JupyterVarsCommandExecutor() {
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newFixedThreadPool(2)");
        this.executorService = executorService;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Metho\u2026s.lookup().lookupClass())");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/variables/JupyterVarsCommandExecutor$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "TIMEOUT", "", "getInstance", "Lorg/jetbrains/plugins/notebooks/jupyter/variables/JupyterVarsCommandExecutor;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.python.jupyter"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final JupyterVarsCommandExecutor getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, JupyterVarsCommandExecutor.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026mandExecutor::class.java)");
            return (JupyterVarsCommandExecutor)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

