/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.project.actions;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.uml.project.ModuleItem;
import com.intellij.uml.project.actions.ModuleNodeIntentionActionBase;
import com.intellij.uml.utils.DiagramJavaBundle;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ShowModuleCyclesAction
extends ModuleNodeIntentionActionBase {
    public ShowModuleCyclesAction() {
        super("Show Module Cyclic Dependencies", null, null);
    }

    public void perform(final DiagramNode<ModuleItem> node, final DiagramBuilder builder) {
        final Project project = builder.getProject();
        final Module module = ((ModuleItem)node.getIdentifyingElement()).getModule();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, DiagramJavaBundle.message("task.title.calculating.module.cyclic.dependencies", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                Graph<Module> graph = ModuleNodeIntentionActionBase.buildModulesGraph(builder, project);
                Set cycles = GraphAlgorithms.getInstance().findCycles(graph, (Object)module);
                if (cycles.isEmpty()) {
                    ApplicationManager.getApplication().invokeLater(() -> DiagramAction.showNotification((String)DiagramJavaBundle.message("notification.message.no.cyclic.dependencies", module.getName()), (DiagramNode)node, (DiagramBuilder)builder));
                } else {
                    ShowModuleCyclesAction.this.showPaths(builder, cycles);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/uml/project/actions/ShowModuleCyclesAction$1", "run"));
            }
        });
    }
}

