/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.remote.RemoteCancelledException;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ssh.ForceDisconnectListener;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.transport.SshConnectionManager;
import com.jetbrains.plugins.remotesdk.transport.SshRemoteSession;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class SdkSessionManager {
    public static SshRemoteSession checkConnectionAndGetSession(final @Nullable Project project, final @NotNull RemoteSdkCredentials data) throws RemoteSdkException {
        if (data == null) {
            SdkSessionManager.$$$reportNull$$$0(0);
        }
        final Checker checker = new Checker();
        Task.Modal task = new Task.Modal(project, "Connecting to " + data.getHost(), true){

            public void run(@NotNull ProgressIndicator pi) {
                if (pi == null) {
                    1.$$$reportNull$$$0(0);
                }
                checker.work(pi, data, project);
            }

            public void onCancel() {
                checker.setError(new RemoteCancelledException("Connection was canceled."));
            }

            public void onThrowable(@NotNull Throwable error) {
                if (error == null) {
                    1.$$$reportNull$$$0(1);
                }
                checker.setError(error);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pi";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "error";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/SdkSessionManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onThrowable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (!ProgressManager.getInstance().hasProgressIndicator()) {
            ApplicationManager.getApplication().invokeAndWait(() -> ProgressManager.getInstance().run((Task)task));
        } else {
            task.run(ProgressManager.getInstance().getProgressIndicator());
        }
        return SdkSessionManager.processResult(data, checker);
    }

    public static SshRemoteSession checkConnectionAndGetSessionInBackground(@Nullable Project project, @NotNull RemoteSdkCredentials data) throws RemoteSdkException {
        if (data == null) {
            SdkSessionManager.$$$reportNull$$$0(1);
        }
        Checker checker = new Checker();
        checker.work(ProgressManager.getInstance().getProgressIndicator(), data, project);
        return SdkSessionManager.processResult(data, checker);
    }

    @NotNull
    private static SshRemoteSession processResult(@NotNull RemoteSdkCredentials data, Checker checker) throws RemoteSdkException {
        Throwable error;
        if (data == null) {
            SdkSessionManager.$$$reportNull$$$0(2);
        }
        if ((error = checker.getException()) != null) {
            throw new RemoteSdkException("Error connecting to remote host:" + data.getHost(), error);
        }
        SshRemoteSession session = checker.getSession();
        if (session == null) {
            throw new RemoteSdkException("Couldn't create remote session for " + data.getHost());
        }
        SshRemoteSession sshRemoteSession = session;
        if (sshRemoteSession == null) {
            SdkSessionManager.$$$reportNull$$$0(3);
        }
        return sshRemoteSession;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/SdkSessionManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/SdkSessionManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "processResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkConnectionAndGetSession";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkConnectionAndGetSessionInBackground";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processResult";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Checker {
        private final AtomicReference<Throwable> myException = new AtomicReference();
        private final AtomicReference<Boolean> myResult = new AtomicReference<Boolean>(false);
        private final AtomicReference<SshRemoteSession> mySession = new AtomicReference();

        private Checker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void work(@Nullable ProgressIndicator pi, @NotNull RemoteSdkCredentials data, @Nullable Project project) {
            if (data == null) {
                Checker.$$$reportNull$$$0(0);
            }
            Semaphore done = new Semaphore();
            done.down();
            EventDispatcher forceDisconnectDispatcher = EventDispatcher.create(ForceDisconnectListener.class);
            SshConnectionManager connectionManager = SshConnectionManager.getInstance();
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                Ref error = new Ref();
                Ref result = new Ref();
                Ref session = new Ref();
                try {
                    SshRemoteSession s;
                    if (pi != null) {
                        pi.setText("Connecting to " + data.getHost() + "...");
                    }
                    if (RemoteSdkUtil.checkInterpreterAndCreateHelpersDir(data, (Ref<? super Exception>)error, (Ref<? super Boolean>)result, null, s = connectionManager.getSession(project, (RemoteCredentials)data))) {
                        session.set((Object)s);
                    }
                }
                catch (Exception e) {
                    error.set((Object)new CustomFileSystemException(e.getMessage(), (Throwable)e));
                }
                finally {
                    this.myException.set((Throwable)error.get());
                    this.myResult.set((Boolean)result.get());
                    this.mySession.set((SshRemoteSession)session.get());
                    done.up();
                }
            });
            try {
                ProgressIndicatorUtils.awaitWithCheckCanceled((Semaphore)done, (ProgressIndicator)pi);
            }
            finally {
                ((ForceDisconnectListener)forceDisconnectDispatcher.getMulticaster()).forceDisconnect();
            }
        }

        public void setError(Throwable e) {
            this.myException.compareAndSet(null, e);
        }

        public Throwable getException() {
            return this.myException.get();
        }

        public Boolean getResult() {
            return this.myResult.get();
        }

        public SshRemoteSession getSession() {
            return this.mySession.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/SdkSessionManager$Checker", "work"));
        }
    }
}

