/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerKt;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.uploader.EventLogUploadException;
import com.intellij.internal.statistic.service.fus.EventLogWhitelistUpdateError;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogSystemLogger {
    private static final String GROUP = "event.log";

    public static void logWhitelistLoad(@NotNull String recorderId, @Nullable String version) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(0);
        }
        FeatureUsageData data = new FeatureUsageData().addVersionByString(version);
        EventLogSystemLogger.logEvent(recorderId, "whitelist.loaded", data);
    }

    public static void logWhitelistUpdated(@NotNull String recorderId, @Nullable String version) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(1);
        }
        FeatureUsageData data = new FeatureUsageData().addVersionByString(version);
        EventLogSystemLogger.logEvent(recorderId, "whitelist.updated", data);
    }

    public static void logWhitelistErrorOnLoad(@NotNull String recorderId, @NotNull EventLogWhitelistUpdateError error) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(2);
        }
        if (error == null) {
            EventLogSystemLogger.$$$reportNull$$$0(3);
        }
        EventLogSystemLogger.logWhitelistError(recorderId, "whitelist.load.failed", error);
    }

    public static void logWhitelistErrorOnUpdate(@NotNull String recorderId, @NotNull EventLogWhitelistUpdateError error) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(4);
        }
        if (error == null) {
            EventLogSystemLogger.$$$reportNull$$$0(5);
        }
        EventLogSystemLogger.logWhitelistError(recorderId, "whitelist.update.failed", error);
    }

    private static void logWhitelistError(@NotNull String recorderId, @NotNull String eventId, @NotNull EventLogWhitelistUpdateError error) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(6);
        }
        if (eventId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(7);
        }
        if (error == null) {
            EventLogSystemLogger.$$$reportNull$$$0(8);
        }
        FeatureUsageData data = new FeatureUsageData().addData("stage", error.getUpdateStage().name()).addData("error", error.getErrorType());
        int code = error.getErrorCode();
        if (code != -1) {
            data.addData("code", code);
        }
        EventLogSystemLogger.logEvent(recorderId, eventId, data);
    }

    public static void logFilesSend(@NotNull String recorderId, int total, int succeed, int failed, boolean external) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(9);
        }
        FeatureUsageData data = new FeatureUsageData().addData("total", total).addData("send", succeed + failed).addData("failed", failed).addData("external", external);
        EventLogSystemLogger.logEvent(recorderId, "logs.send", data);
    }

    public static void logStartingExternalSend(@NotNull String recorderId, long time) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(10);
        }
        FeatureUsageData data = new FeatureUsageData().addData("send_ts", time);
        EventLogSystemLogger.logEvent(recorderId, "external.send.started", data);
    }

    public static void logFinishedExternalSend(@NotNull String recorderId, @Nullable String error, long time) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(11);
        }
        boolean succeed = StringUtil.isEmpty((String)error);
        FeatureUsageData data = new FeatureUsageData().addData("succeed", succeed).addData("send_ts", time);
        if (!succeed) {
            data.addData("error", error);
        }
        EventLogSystemLogger.logEvent(recorderId, "external.send.finished", data);
    }

    public static void logCreatingExternalSendCommand(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(12);
        }
        EventLogSystemLogger.logEvent(recorderId, "external.send.command.creation.started");
    }

    public static void logFinishedCreatingExternalSendCommand(@NotNull String recorderId, @Nullable EventLogUploadException.EventLogUploadErrorType errorType) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(13);
        }
        boolean succeed = errorType == null;
        FeatureUsageData data = new FeatureUsageData().addData("succeed", succeed);
        if (!succeed) {
            data.addData("error", errorType.name());
        }
        EventLogSystemLogger.logEvent(recorderId, "external.send.command.creation.finished", data);
    }

    public static void logSystemError(@NotNull String recorderId, @NotNull String eventId, @NotNull String errorClass, long time) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(14);
        }
        if (eventId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(15);
        }
        if (errorClass == null) {
            EventLogSystemLogger.$$$reportNull$$$0(16);
        }
        FeatureUsageData data = new FeatureUsageData().addData("error", errorClass);
        if (time != -1L) {
            data.addData("error_ts", time);
        }
        EventLogSystemLogger.logEvent(recorderId, eventId, data);
    }

    private static void logEvent(@NotNull String recorderId, @NotNull String eventId, @NotNull FeatureUsageData data) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(17);
        }
        if (eventId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(18);
        }
        if (data == null) {
            EventLogSystemLogger.$$$reportNull$$$0(19);
        }
        StatisticsEventLoggerProvider provider = StatisticsEventLoggerKt.getEventLogProvider(recorderId);
        provider.getLogger().log(new EventLogGroup(GROUP, provider.getVersion()), eventId, data.build(), false);
    }

    private static void logEvent(@NotNull String recorderId, @NotNull String eventId) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(20);
        }
        if (eventId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(21);
        }
        StatisticsEventLoggerProvider provider = StatisticsEventLoggerKt.getEventLogProvider(recorderId);
        provider.getLogger().log(new EventLogGroup(GROUP, provider.getVersion()), eventId, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 7: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventId";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorClass";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/eventLog/EventLogSystemLogger";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "logWhitelistLoad";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "logWhitelistUpdated";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "logWhitelistErrorOnLoad";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "logWhitelistErrorOnUpdate";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "logWhitelistError";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "logFilesSend";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "logStartingExternalSend";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "logFinishedExternalSend";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "logCreatingExternalSendCommand";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "logFinishedCreatingExternalSendCommand";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "logSystemError";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "logEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

