/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.internal.statistic.eventLog.StatisticsEventEscaper;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRegexpAwareRule;
import com.intellij.internal.statistic.eventLog.validator.rules.PerformanceCareRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RegexpWhiteListRule;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumWhiteListRule
extends PerformanceCareRule
implements FUSRegexpAwareRule {
    private final Collection<String> myEnumValues;

    public EnumWhiteListRule(@Nullable Collection<String> strings) {
        this.myEnumValues = strings == null ? Collections.emptySet() : ContainerUtil.unmodifiableOrEmptyCollection(strings);
    }

    @Override
    @NotNull
    public ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
        if (data == null) {
            EnumWhiteListRule.$$$reportNull$$$0(0);
        }
        if (context == null) {
            EnumWhiteListRule.$$$reportNull$$$0(1);
        }
        if (this.myEnumValues.isEmpty()) {
            ValidationResultType validationResultType = ValidationResultType.INCORRECT_RULE;
            if (validationResultType == null) {
                EnumWhiteListRule.$$$reportNull$$$0(2);
            }
            return validationResultType;
        }
        ValidationResultType validationResultType = this.myEnumValues.contains(StatisticsEventEscaper.escape((String)data)) ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
        if (validationResultType == null) {
            EnumWhiteListRule.$$$reportNull$$$0(3);
        }
        return validationResultType;
    }

    @Override
    @NotNull
    public String asRegexp() {
        String string = StringUtil.join((Collection)ContainerUtil.map(this.myEnumValues, s -> RegexpWhiteListRule.escapeText(s)), (String)"|");
        if (string == null) {
            EnumWhiteListRule.$$$reportNull$$$0(4);
        }
        return string;
    }

    public String toString() {
        return "EnumWhiteListRule: myEnumValues=" + this.asRegexp();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/rules/impl/EnumWhiteListRule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/rules/impl/EnumWhiteListRule";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "asRegexp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doValidate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

