/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionResult {
    private final LookupElement myLookupElement;
    private final PrefixMatcher myMatcher;
    private final CompletionSorter mySorter;

    protected CompletionResult(LookupElement lookupElement, PrefixMatcher matcher, CompletionSorter sorter) {
        this.myLookupElement = lookupElement;
        this.myMatcher = matcher;
        this.mySorter = sorter;
    }

    @Nullable
    public static CompletionResult wrap(LookupElement lookupElement, PrefixMatcher matcher, CompletionSorter sorter) {
        if (matcher.prefixMatches(lookupElement)) {
            return new CompletionResult(lookupElement, matcher, sorter);
        }
        return null;
    }

    public PrefixMatcher getPrefixMatcher() {
        return this.myMatcher;
    }

    public CompletionSorter getSorter() {
        return this.mySorter;
    }

    public LookupElement getLookupElement() {
        return this.myLookupElement;
    }

    @NotNull
    public CompletionResult withLookupElement(@NotNull LookupElement element) {
        if (element == null) {
            CompletionResult.$$$reportNull$$$0(0);
        }
        if (!this.myMatcher.prefixMatches(element)) {
            throw new AssertionError((Object)"The new element doesn't match the prefix");
        }
        return new CompletionResult(element, this.myMatcher, this.mySorter);
    }

    public boolean isStartMatch() {
        return this.myMatcher.isStartMatch(this.myLookupElement);
    }

    public String toString() {
        return this.myLookupElement.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/CompletionResult", "withLookupElement"));
    }
}

