/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroupKt;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.ui.MessageType;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 #2\u00020\u0001:\u0001#B;\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0003\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0007J\u0018\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001cJ0\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u001d\u001a\u00020\u00032\b\b\u0001\u0010\u001b\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fJB\u0010\u0017\u001a\u00020\u00182\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u00032\n\b\u0001\u0010 \u001a\u0004\u0018\u00010\u00032\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0012R\"\u0010\u0014\u001a\u0004\u0018\u00010\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\r\u00a8\u0006$"}, d2={"Lcom/intellij/notification/NotificationGroup;", "", "displayId", "", "displayType", "Lcom/intellij/notification/NotificationDisplayType;", "isLogByDefault", "", "toolWindowId", "icon", "Ljavax/swing/Icon;", "(Ljava/lang/String;Lcom/intellij/notification/NotificationDisplayType;ZLjava/lang/String;Ljavax/swing/Icon;)V", "getDisplayId", "()Ljava/lang/String;", "getDisplayType", "()Lcom/intellij/notification/NotificationDisplayType;", "getIcon", "()Ljavax/swing/Icon;", "()Z", "<set-?>", "parentId", "getParentId", "getToolWindowId", "createNotification", "Lcom/intellij/notification/Notification;", "type", "Lcom/intellij/notification/NotificationType;", "content", "Lcom/intellij/openapi/ui/MessageType;", "title", "listener", "Lcom/intellij/notification/NotificationListener;", "subtitle", "setParentId", "value", "Companion", "intellij.platform.ide"})
public final class NotificationGroup {
    @Nullable
    private String parentId;
    @NotNull
    private final String displayId;
    @NotNull
    private final NotificationDisplayType displayType;
    private final boolean isLogByDefault;
    @Nullable
    private final String toolWindowId;
    @Nullable
    private final Icon icon;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String getParentId() {
        return this.parentId;
    }

    @NotNull
    public final Notification createNotification(@Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String content, @NotNull MessageType type) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        NotificationType notificationType = type.toNotificationType();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)notificationType), (String)"type.toNotificationType()");
        return this.createNotification(content, notificationType);
    }

    @NotNull
    public final Notification createNotification(@Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String content, @NotNull NotificationType type) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        return NotificationGroup.createNotification$default(this, "", content, type, null, 8, null);
    }

    @NotNull
    public final Notification createNotification(@Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String title, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String content, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        return new Notification(this.displayId, title, content, type, listener2);
    }

    public static /* synthetic */ Notification createNotification$default(NotificationGroup notificationGroup, String string, String string2, NotificationType notificationType, NotificationListener notificationListener, int n, Object object) {
        if ((n & 4) != 0) {
            notificationType = NotificationType.INFORMATION;
        }
        if ((n & 8) != 0) {
            notificationListener = null;
        }
        return notificationGroup.createNotification(string, string2, notificationType, notificationListener);
    }

    @JvmOverloads
    @NotNull
    public final Notification createNotification(@NotNull NotificationType type) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        return NotificationGroup.createNotification$default(this, null, null, null, type, null, 16, null);
    }

    public static /* synthetic */ Notification createNotification$default(NotificationGroup notificationGroup, NotificationType notificationType, int n, Object object) {
        if ((n & 1) != 0) {
            notificationType = NotificationType.INFORMATION;
        }
        return notificationGroup.createNotification(notificationType);
    }

    @JvmOverloads
    @NotNull
    public final Notification createNotification() {
        return NotificationGroup.createNotification$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final Notification createNotification(@Nls(capitalization=Nls.Capitalization.Sentence) @Nullable String title, @Nls(capitalization=Nls.Capitalization.Sentence) @Nullable String subtitle, @Nls(capitalization=Nls.Capitalization.Sentence) @Nullable String content, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        return new Notification(this.displayId, this.icon, title, subtitle, content, type, listener2);
    }

    public static /* synthetic */ Notification createNotification$default(NotificationGroup notificationGroup, String string, String string2, String string3, NotificationType notificationType, NotificationListener notificationListener, int n, Object object) {
        if ((n & 8) != 0) {
            notificationType = NotificationType.INFORMATION;
        }
        if ((n & 0x10) != 0) {
            notificationListener = null;
        }
        return notificationGroup.createNotification(string, string2, string3, notificationType, notificationListener);
    }

    @JvmOverloads
    @NotNull
    public final Notification createNotification(@Nls(capitalization=Nls.Capitalization.Sentence) @Nullable String title, @Nls(capitalization=Nls.Capitalization.Sentence) @Nullable String subtitle, @Nls(capitalization=Nls.Capitalization.Sentence) @Nullable String content, @NotNull NotificationType type) {
        return NotificationGroup.createNotification$default(this, title, subtitle, content, type, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final Notification createNotification(@Nls(capitalization=Nls.Capitalization.Sentence) @Nullable String title, @Nls(capitalization=Nls.Capitalization.Sentence) @Nullable String subtitle, @Nls(capitalization=Nls.Capitalization.Sentence) @Nullable String content) {
        return NotificationGroup.createNotification$default(this, title, subtitle, content, null, null, 24, null);
    }

    @NotNull
    public final NotificationGroup setParentId(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.parentId = value;
        return this;
    }

    @NotNull
    public final String getDisplayId() {
        return this.displayId;
    }

    @NotNull
    public final NotificationDisplayType getDisplayType() {
        return this.displayType;
    }

    public final boolean isLogByDefault() {
        return this.isLogByDefault;
    }

    @Nullable
    public final String getToolWindowId() {
        return this.toolWindowId;
    }

    @Nullable
    public final Icon getIcon() {
        return this.icon;
    }

    @JvmOverloads
    public NotificationGroup(@NonNls @NotNull String displayId, @NotNull NotificationDisplayType displayType, boolean isLogByDefault, @NonNls @Nullable String toolWindowId, @Nullable Icon icon) {
        Intrinsics.checkParameterIsNotNull((Object)displayId, (String)"displayId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)displayType), (String)"displayType");
        this.displayId = displayId;
        this.displayType = displayType;
        this.isLogByDefault = isLogByDefault;
        this.toolWindowId = toolWindowId;
        this.icon = icon;
        if (NotificationGroupKt.access$getRegisteredGroups$p().containsKey(this.displayId)) {
            NotificationGroupKt.access$getLOG$p().info("Notification group " + this.displayId + " is already registered", new Throwable());
        }
        NotificationGroupKt.access$getRegisteredGroups$p().put(this.displayId, this);
    }

    public /* synthetic */ NotificationGroup(String string, NotificationDisplayType notificationDisplayType, boolean bl, String string2, Icon icon, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            icon = null;
        }
        this(string, notificationDisplayType, bl, string2, icon);
    }

    @JvmOverloads
    public NotificationGroup(@NonNls @NotNull String displayId, @NotNull NotificationDisplayType displayType, boolean isLogByDefault, @NonNls @Nullable String toolWindowId) {
        this(displayId, displayType, isLogByDefault, toolWindowId, null, 16, null);
    }

    @JvmOverloads
    public NotificationGroup(@NonNls @NotNull String displayId, @NotNull NotificationDisplayType displayType, boolean isLogByDefault) {
        this(displayId, displayType, isLogByDefault, null, null, 24, null);
    }

    @JvmOverloads
    public NotificationGroup(@NonNls @NotNull String displayId, @NotNull NotificationDisplayType displayType) {
        this(displayId, displayType, false, null, null, 28, null);
    }

    @JvmStatic
    @NotNull
    public static final NotificationGroup balloonGroup(@NonNls @NotNull String displayId) {
        return Companion.balloonGroup(displayId);
    }

    @JvmStatic
    @NotNull
    public static final NotificationGroup logOnlyGroup(@NonNls @NotNull String displayId) {
        return Companion.logOnlyGroup(displayId);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final NotificationGroup toolWindowGroup(@NonNls @NotNull String displayId, @NonNls @NotNull String toolWindowId, boolean logByDefault) {
        return Companion.toolWindowGroup(displayId, toolWindowId, logByDefault);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final NotificationGroup toolWindowGroup(@NonNls @NotNull String displayId, @NonNls @NotNull String toolWindowId) {
        return com.intellij.notification.NotificationGroup$Companion.toolWindowGroup$default(Companion, displayId, toolWindowId, false, 4, null);
    }

    @JvmStatic
    @Nullable
    public static final NotificationGroup findRegisteredGroup(@NotNull String displayId) {
        return Companion.findRegisteredGroup(displayId);
    }

    @NotNull
    public static final Iterable<NotificationGroup> getAllRegisteredGroups() {
        return Companion.getAllRegisteredGroups();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u00020\u00052\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\r\u001a\u00020\u00052\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007J&\u0010\u000e\u001a\u00020\u00052\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u000f\u001a\u00020\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/notification/NotificationGroup$Companion;", "", "()V", "allRegisteredGroups", "", "Lcom/intellij/notification/NotificationGroup;", "allRegisteredGroups$annotations", "getAllRegisteredGroups", "()Ljava/lang/Iterable;", "balloonGroup", "displayId", "", "findRegisteredGroup", "logOnlyGroup", "toolWindowGroup", "toolWindowId", "logByDefault", "", "intellij.platform.ide"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final NotificationGroup balloonGroup(@NonNls @NotNull String displayId) {
            Intrinsics.checkParameterIsNotNull((Object)displayId, (String)"displayId");
            return new NotificationGroup(displayId, NotificationDisplayType.BALLOON, false, null, null, 28, null);
        }

        @JvmStatic
        @NotNull
        public final NotificationGroup logOnlyGroup(@NonNls @NotNull String displayId) {
            Intrinsics.checkParameterIsNotNull((Object)displayId, (String)"displayId");
            return new NotificationGroup(displayId, NotificationDisplayType.NONE, false, null, null, 28, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final NotificationGroup toolWindowGroup(@NonNls @NotNull String displayId, @NonNls @NotNull String toolWindowId, boolean logByDefault) {
            Intrinsics.checkParameterIsNotNull((Object)displayId, (String)"displayId");
            Intrinsics.checkParameterIsNotNull((Object)toolWindowId, (String)"toolWindowId");
            return new NotificationGroup(displayId, NotificationDisplayType.TOOL_WINDOW, logByDefault, toolWindowId, null, 16, null);
        }

        public static /* synthetic */ NotificationGroup toolWindowGroup$default(Companion companion, String string, String string2, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.toolWindowGroup(string, string2, bl);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final NotificationGroup toolWindowGroup(@NonNls @NotNull String displayId, @NonNls @NotNull String toolWindowId) {
            return com.intellij.notification.NotificationGroup$Companion.toolWindowGroup$default(this, displayId, toolWindowId, false, 4, null);
        }

        @JvmStatic
        @Nullable
        public final NotificationGroup findRegisteredGroup(@NotNull String displayId) {
            Intrinsics.checkParameterIsNotNull((Object)displayId, (String)"displayId");
            return (NotificationGroup)NotificationGroupKt.access$getRegisteredGroups$p().get(displayId);
        }

        @JvmStatic
        public static /* synthetic */ void allRegisteredGroups$annotations() {
        }

        @NotNull
        public final Iterable<NotificationGroup> getAllRegisteredGroups() {
            return NotificationGroupKt.access$getRegisteredGroups$p().values();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

