/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.actionSystem.ActionStubBase;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartFMap;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionStub
extends AnAction
implements ActionStubBase {
    private static final Logger LOG = Logger.getInstance(ActionStub.class);
    private final String myClassName;
    private final String myProjectType;
    private final Supplier<Presentation> myTemplatePresentation;
    private final String myId;
    private final IdeaPluginDescriptor myPlugin;
    private final String myIconPath;
    private SmartFMap<String, String> myActionTextOverrides;

    public ActionStub(@NotNull String actionClass, @NotNull String id, @NotNull IdeaPluginDescriptor plugin, @Nullable String iconPath, @Nullable String projectType, @NotNull Supplier<Presentation> templatePresentation) {
        if (actionClass == null) {
            ActionStub.$$$reportNull$$$0(0);
        }
        if (id == null) {
            ActionStub.$$$reportNull$$$0(1);
        }
        if (plugin == null) {
            ActionStub.$$$reportNull$$$0(2);
        }
        if (templatePresentation == null) {
            ActionStub.$$$reportNull$$$0(3);
        }
        this.myActionTextOverrides = SmartFMap.emptyMap();
        this.myPlugin = plugin;
        this.myClassName = actionClass;
        this.myProjectType = projectType;
        this.myTemplatePresentation = templatePresentation;
        LOG.assertTrue(!id.isEmpty());
        this.myId = id;
        this.myIconPath = iconPath;
    }

    public void addActionTextOverride(@NotNull String place, @NotNull String text) {
        if (place == null) {
            ActionStub.$$$reportNull$$$0(4);
        }
        if (text == null) {
            ActionStub.$$$reportNull$$$0(5);
        }
        this.myActionTextOverrides = this.myActionTextOverrides.plus((Object)place, (Object)text);
    }

    public void copyActionTextOverride(@NotNull String fromPlace, @NotNull String toPlace) {
        if (fromPlace == null) {
            ActionStub.$$$reportNull$$$0(6);
        }
        if (toPlace == null) {
            ActionStub.$$$reportNull$$$0(7);
        }
        this.myActionTextOverrides = this.myActionTextOverrides.plus((Object)toPlace, this.myActionTextOverrides.get((Object)fromPlace));
    }

    @Override
    @NotNull
    public IdeaPluginDescriptor getPlugin() {
        IdeaPluginDescriptor ideaPluginDescriptor = this.myPlugin;
        if (ideaPluginDescriptor == null) {
            ActionStub.$$$reportNull$$$0(8);
        }
        return ideaPluginDescriptor;
    }

    @Override
    @NotNull
    Presentation createTemplatePresentation() {
        Presentation presentation = this.myTemplatePresentation.get();
        if (presentation == null) {
            ActionStub.$$$reportNull$$$0(9);
        }
        return presentation;
    }

    @NotNull
    public String getClassName() {
        String string = this.myClassName;
        if (string == null) {
            ActionStub.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            ActionStub.$$$reportNull$$$0(11);
        }
        return string;
    }

    public ClassLoader getLoader() {
        return this.myPlugin.getPluginClassLoader();
    }

    @Override
    public PluginId getPluginId() {
        return this.myPlugin.getPluginId();
    }

    @Override
    public String getIconPath() {
        return this.myIconPath;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ActionStub.$$$reportNull$$$0(12);
        }
        throw new UnsupportedOperationException();
    }

    @ApiStatus.Internal
    public final void initAction(@NotNull AnAction targetAction) {
        if (targetAction == null) {
            ActionStub.$$$reportNull$$$0(13);
        }
        ActionStub.copyTemplatePresentation(this.getTemplatePresentation(), targetAction.getTemplatePresentation());
        targetAction.setShortcutSet(this.getShortcutSet());
        for (String place : this.myActionTextOverrides.keySet()) {
            targetAction.addTextOverride(place, (String)Objects.requireNonNull(this.myActionTextOverrides.get((Object)place)));
        }
    }

    public static void copyTemplatePresentation(Presentation sourcePresentation, Presentation targetPresentation) {
        if (targetPresentation.getIcon() == null && sourcePresentation.getIcon() != null) {
            targetPresentation.setIcon(sourcePresentation.getIcon());
        }
        if (StringUtil.isEmpty((String)targetPresentation.getText()) && sourcePresentation.getText() != null) {
            targetPresentation.setTextWithMnemonic(sourcePresentation.getTextWithPossibleMnemonic());
        }
        if (targetPresentation.getDescription() == null && sourcePresentation.getDescription() != null) {
            targetPresentation.setDescription(sourcePresentation.getDescription());
        }
    }

    public String getProjectType() {
        return this.myProjectType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templatePresentation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromPlace";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toPlace";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/ActionStub";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/ActionStub";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugin";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplatePresentation";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addActionTextOverride";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyActionTextOverride";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "initAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

