/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.tree;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Range;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.IndexTreePathState;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class TreeUtil {
    public static final TreePath[] EMPTY_TREE_PATH = new TreePath[0];
    private static final Logger LOG = Logger.getInstance(TreeUtil.class);
    private static final String TREE_UTIL_SCROLL_TIME_STAMP = "TreeUtil.scrollTimeStamp";
    private static final JBIterable<Integer> NUMBERS = JBIterable.generate((Object)0, i -> i + 1);

    private TreeUtil() {
    }

    @NotNull
    public static JBTreeTraverser<Object> treeTraverser(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(0);
        }
        TreeModel model = tree.getModel();
        Object root = model.getRoot();
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)JBTreeTraverser.from(node -> TreeUtil.nodeChildren(node, model)).withRoot(root);
        if (jBTreeTraverser == null) {
            TreeUtil.$$$reportNull$$$0(1);
        }
        return jBTreeTraverser;
    }

    @NotNull
    public static JBTreeTraverser<TreePath> treePathTraverser(@NotNull JTree tree) {
        TreeModel model;
        Object root;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(2);
        }
        TreePath rootPath = (root = (model = tree.getModel()).getRoot()) == null ? null : new TreePath(root);
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)JBTreeTraverser.from(path2 -> TreeUtil.nodeChildren(path2.getLastPathComponent(), model).map(o -> path2.pathByAddingChild(o))).withRoot((Object)rootPath);
        if (jBTreeTraverser == null) {
            TreeUtil.$$$reportNull$$$0(3);
        }
        return jBTreeTraverser;
    }

    @NotNull
    public static JBIterable<Object> nodeChildren(@Nullable Object node, @NotNull TreeModel model) {
        int count;
        if (model == null) {
            TreeUtil.$$$reportNull$$$0(4);
        }
        JBIterable jBIterable = (count = model.getChildCount(node)) == 0 ? JBIterable.empty() : NUMBERS.take(count).map(index -> model.getChild(node, (int)index));
        if (jBIterable == null) {
            TreeUtil.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    @NotNull
    public static JBTreeTraverser<TreeNode> treeNodeTraverser(@Nullable TreeNode treeNode) {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)JBTreeTraverser.from(node -> TreeUtil.nodeChildren(node)).withRoot((Object)treeNode);
        if (jBTreeTraverser == null) {
            TreeUtil.$$$reportNull$$$0(6);
        }
        return jBTreeTraverser;
    }

    @NotNull
    public static JBIterable<TreeNode> nodeChildren(@Nullable TreeNode treeNode) {
        int count = treeNode == null ? 0 : treeNode.getChildCount();
        JBIterable jBIterable = count == 0 ? JBIterable.empty() : NUMBERS.take(count).map(index -> treeNode.getChildAt((int)index));
        if (jBIterable == null) {
            TreeUtil.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @NotNull
    public static List<TreePath> collectExpandedPaths(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(8);
        }
        return TreeUtil.collectExpandedObjects(tree, Function.identity());
    }

    @NotNull
    public static List<Object> collectExpandedUserObjects(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(9);
        }
        return TreeUtil.collectExpandedObjects(tree, TreeUtil::getLastUserObject);
    }

    @NotNull
    public static <T> List<T> collectExpandedObjects(@NotNull JTree tree, @NotNull Function<? super TreePath, ? extends T> mapper) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(10);
        }
        if (mapper == null) {
            TreeUtil.$$$reportNull$$$0(11);
        }
        return TreeUtil.collectVisibleRows(tree, tree::isExpanded, mapper);
    }

    @Nullable
    public static <T> T findObjectInPath(@Nullable TreePath path2, @NotNull Class<T> clazz) {
        if (clazz == null) {
            TreeUtil.$$$reportNull$$$0(12);
        }
        while (path2 != null) {
            T object = TreeUtil.getLastUserObject(clazz, path2);
            if (object != null) {
                return object;
            }
            path2 = path2.getParentPath();
        }
        return null;
    }

    @NotNull
    public static <T> List<T> collectSelectedObjectsOfType(@NotNull JTree tree, @NotNull Class<? extends T> type) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(13);
        }
        if (type == null) {
            TreeUtil.$$$reportNull$$$0(14);
        }
        return TreeUtil.collectSelectedObjects(tree, path2 -> TreeUtil.getLastUserObject(type, path2));
    }

    @NotNull
    public static List<TreePath> collectExpandedPaths(@NotNull JTree tree, @NotNull TreePath root) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(15);
        }
        if (root == null) {
            TreeUtil.$$$reportNull$$$0(16);
        }
        return TreeUtil.collectExpandedObjects(tree, root, Function.identity());
    }

    @NotNull
    public static List<Object> collectExpandedUserObjects(@NotNull JTree tree, @NotNull TreePath root) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(17);
        }
        if (root == null) {
            TreeUtil.$$$reportNull$$$0(18);
        }
        return TreeUtil.collectExpandedObjects(tree, root, TreeUtil::getLastUserObject);
    }

    @NotNull
    public static <T> List<T> collectExpandedObjects(@NotNull JTree tree, @NotNull TreePath root, @NotNull Function<? super TreePath, ? extends T> mapper) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(19);
        }
        if (root == null) {
            TreeUtil.$$$reportNull$$$0(20);
        }
        if (mapper == null) {
            TreeUtil.$$$reportNull$$$0(21);
        }
        if (!tree.isVisible(root)) {
            List list = Collections.emptyList();
            if (list == null) {
                TreeUtil.$$$reportNull$$$0(22);
            }
            return list;
        }
        return TreeUtil.collectVisibleRows(tree, path2 -> tree.isExpanded((TreePath)path2) && root.isDescendant((TreePath)path2), mapper);
    }

    public static void restoreExpandedPaths(@NotNull JTree tree, @NotNull List<? extends TreePath> paths) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(23);
        }
        if (paths == null) {
            TreeUtil.$$$reportNull$$$0(24);
        }
        for (int i = paths.size() - 1; i >= 0; --i) {
            tree.expandPath(paths.get(i));
        }
    }

    @NotNull
    public static TreePath getPath(@NotNull TreeNode aRootNode, @NotNull TreeNode aNode) {
        if (aRootNode == null) {
            TreeUtil.$$$reportNull$$$0(25);
        }
        if (aNode == null) {
            TreeUtil.$$$reportNull$$$0(26);
        }
        Object[] nodes = TreeUtil.getPathFromRootTo(aRootNode, aNode, true);
        return new TreePath(nodes);
    }

    public static boolean isAncestor(@NotNull TreeNode ancestor, @NotNull TreeNode node) {
        if (ancestor == null) {
            TreeUtil.$$$reportNull$$$0(27);
        }
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(28);
        }
        for (TreeNode parent = node; parent != null; parent = parent.getParent()) {
            if (parent != ancestor) continue;
            return true;
        }
        return false;
    }

    private static boolean isAncestor(@NotNull TreePath ancestor, @NotNull TreePath path2) {
        if (ancestor == null) {
            TreeUtil.$$$reportNull$$$0(29);
        }
        if (path2 == null) {
            TreeUtil.$$$reportNull$$$0(30);
        }
        if (path2.getPathCount() < ancestor.getPathCount()) {
            return false;
        }
        for (int i = 0; i < ancestor.getPathCount(); ++i) {
            if (path2.getPathComponent(i).equals(ancestor.getPathComponent(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isDescendants(@NotNull TreePath path2, TreePath @NotNull [] paths) {
        if (path2 == null) {
            TreeUtil.$$$reportNull$$$0(31);
        }
        if (paths == null) {
            TreeUtil.$$$reportNull$$$0(32);
        }
        for (TreePath ancestor : paths) {
            if (!TreeUtil.isAncestor(ancestor, path2)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static TreePath getPathFromRoot(@NotNull TreeNode node) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(33);
        }
        Object[] path2 = TreeUtil.getPathFromRootTo(null, node, false);
        return new TreePath(path2);
    }

    private static TreeNode @NotNull [] getPathFromRootTo(@Nullable TreeNode root, @NotNull TreeNode node, boolean includeRoot) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(34);
        }
        int height = 0;
        for (TreeNode n = node; n != root; n = n.getParent()) {
            ++height;
        }
        TreeNode[] path2 = new TreeNode[includeRoot ? height + 1 : height];
        int i = path2.length - 1;
        TreeNode n = node;
        while (i >= 0) {
            path2[i--] = n;
            n = n.getParent();
        }
        if (path2 == null) {
            TreeUtil.$$$reportNull$$$0(35);
        }
        return path2;
    }

    @Nullable
    public static TreeNode findNodeWithObject(Object object, @NotNull TreeModel model, Object parent) {
        if (model == null) {
            TreeUtil.$$$reportNull$$$0(36);
        }
        for (int i = 0; i < model.getChildCount(parent); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)model.getChild(parent, i);
            if (!childNode.getUserObject().equals(object)) continue;
            return childNode;
        }
        return null;
    }

    public static void removeSelected(@NotNull JTree tree) {
        TreePath[] paths;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(37);
        }
        if ((paths = tree.getSelectionPaths()) == null) {
            return;
        }
        for (TreePath path2 : paths) {
            TreeUtil.removeLastPathComponent((DefaultTreeModel)tree.getModel(), path2).restoreSelection(tree);
        }
    }

    public static void removeLastPathComponent(@NotNull JTree tree, @NotNull TreePath pathToBeRemoved) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(38);
        }
        if (pathToBeRemoved == null) {
            TreeUtil.$$$reportNull$$$0(39);
        }
        TreeUtil.removeLastPathComponent((DefaultTreeModel)tree.getModel(), pathToBeRemoved).restoreSelection(tree);
    }

    @Nullable
    public static DefaultMutableTreeNode findNodeWithObject(@NotNull DefaultMutableTreeNode aRoot, Object aObject) {
        if (aRoot == null) {
            TreeUtil.$$$reportNull$$$0(40);
        }
        return TreeUtil.findNode(aRoot, (Condition<? super DefaultMutableTreeNode>)((Condition)node -> Comparing.equal((Object)node.getUserObject(), (Object)aObject)));
    }

    @Nullable
    public static DefaultMutableTreeNode findNode(@NotNull DefaultMutableTreeNode aRoot, @NotNull Condition<? super DefaultMutableTreeNode> condition) {
        if (aRoot == null) {
            TreeUtil.$$$reportNull$$$0(41);
        }
        if (condition == null) {
            TreeUtil.$$$reportNull$$$0(42);
        }
        if (condition.value((Object)aRoot)) {
            return aRoot;
        }
        for (int i = 0; i < aRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode candidate = TreeUtil.findNode((DefaultMutableTreeNode)aRoot.getChildAt(i), condition);
            if (null == candidate) continue;
            return candidate;
        }
        return null;
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    public static TreePath findCommonPath(TreePath @NotNull [] treePaths) {
        if (treePaths == null) {
            TreeUtil.$$$reportNull$$$0(43);
        }
        LOG.assertTrue(TreeUtil.areComponentsEqual(treePaths, 0));
        TreePath result = new TreePath(treePaths[0].getPathComponent(0));
        int pathIndex = 1;
        while (TreeUtil.areComponentsEqual(treePaths, pathIndex)) {
            result = result.pathByAddingChild(treePaths[0].getPathComponent(pathIndex));
            ++pathIndex;
        }
        TreePath treePath = result;
        if (treePath == null) {
            TreeUtil.$$$reportNull$$$0(44);
        }
        return treePath;
    }

    @NotNull
    public static ActionCallback selectFirstNode(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(45);
        }
        ActionCallback actionCallback = Promises.toActionCallback(TreeUtil.promiseSelectFirst(tree));
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(46);
        }
        return actionCallback;
    }

    @NotNull
    public static TreePath getFirstNodePath(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(47);
        }
        TreeModel model = tree.getModel();
        Object root = model.getRoot();
        TreePath selectionPath = new TreePath(root);
        if (!tree.isRootVisible() && model.getChildCount(root) > 0) {
            selectionPath = selectionPath.pathByAddingChild(model.getChild(root, 0));
        }
        TreePath treePath = selectionPath;
        if (treePath == null) {
            TreeUtil.$$$reportNull$$$0(48);
        }
        return treePath;
    }

    @Deprecated
    @NotNull
    public static TreePath getFirstLeafNodePath(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(49);
        }
        TreeModel model = tree.getModel();
        Object root = model.getRoot();
        TreePath selectionPath = new TreePath(root);
        while (model.getChildCount(root) > 0) {
            Object child = model.getChild(root, 0);
            selectionPath = selectionPath.pathByAddingChild(child);
            root = child;
        }
        TreePath treePath = selectionPath;
        if (treePath == null) {
            TreeUtil.$$$reportNull$$$0(50);
        }
        return treePath;
    }

    @NotNull
    private static IndexTreePathState removeLastPathComponent(@NotNull DefaultTreeModel model, @NotNull TreePath pathToBeRemoved) {
        if (model == null) {
            TreeUtil.$$$reportNull$$$0(51);
        }
        if (pathToBeRemoved == null) {
            TreeUtil.$$$reportNull$$$0(52);
        }
        IndexTreePathState selectionState = new IndexTreePathState(pathToBeRemoved);
        if (((MutableTreeNode)pathToBeRemoved.getLastPathComponent()).getParent() == null) {
            IndexTreePathState indexTreePathState = selectionState;
            if (indexTreePathState == null) {
                TreeUtil.$$$reportNull$$$0(53);
            }
            return indexTreePathState;
        }
        model.removeNodeFromParent((MutableTreeNode)pathToBeRemoved.getLastPathComponent());
        IndexTreePathState indexTreePathState = selectionState;
        if (indexTreePathState == null) {
            TreeUtil.$$$reportNull$$$0(54);
        }
        return indexTreePathState;
    }

    private static boolean areComponentsEqual(TreePath @NotNull [] paths, int componentIndex) {
        if (paths == null) {
            TreeUtil.$$$reportNull$$$0(55);
        }
        if (paths[0].getPathCount() <= componentIndex) {
            return false;
        }
        Object pathComponent = paths[0].getPathComponent(componentIndex);
        for (TreePath treePath : paths) {
            if (treePath.getPathCount() <= componentIndex) {
                return false;
            }
            if (pathComponent.equals(treePath.getPathComponent(componentIndex))) continue;
            return false;
        }
        return true;
    }

    private static TreePath @NotNull [] removeDuplicates(TreePath @NotNull [] paths) {
        if (paths == null) {
            TreeUtil.$$$reportNull$$$0(56);
        }
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        for (TreePath path2 : paths) {
            if (result.contains(path2)) continue;
            result.add(path2);
        }
        TreePath[] treePathArray = result.toArray(EMPTY_TREE_PATH);
        if (treePathArray == null) {
            TreeUtil.$$$reportNull$$$0(57);
        }
        return treePathArray;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    public static TreePath @NotNull [] selectMaximals(TreePath @Nullable [] paths) {
        if (paths == null) {
            if (EMPTY_TREE_PATH == null) {
                TreeUtil.$$$reportNull$$$0(58);
            }
            return EMPTY_TREE_PATH;
        }
        TreePath[] noDuplicates = TreeUtil.removeDuplicates(paths);
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        for (TreePath path2 : noDuplicates) {
            ArrayList<TreePath> otherPaths = new ArrayList<TreePath>(Arrays.asList(noDuplicates));
            otherPaths.remove(path2);
            if (TreeUtil.isDescendants(path2, otherPaths.toArray(EMPTY_TREE_PATH))) continue;
            result.add(path2);
        }
        TreePath[] treePathArray = result.toArray(EMPTY_TREE_PATH);
        if (treePathArray == null) {
            TreeUtil.$$$reportNull$$$0(59);
        }
        return treePathArray;
    }

    public static void sort(@NotNull DefaultTreeModel model, @Nullable Comparator comparator) {
        if (model == null) {
            TreeUtil.$$$reportNull$$$0(60);
        }
        TreeUtil.sort((DefaultMutableTreeNode)model.getRoot(), comparator);
    }

    public static void sort(@NotNull DefaultMutableTreeNode node, @Nullable Comparator comparator) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(61);
        }
        TreeUtil.sortRecursively(node, comparator);
    }

    public static <T extends MutableTreeNode> void sortRecursively(@NotNull T node, @Nullable Comparator<? super T> comparator) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(62);
        }
        TreeUtil.sortChildren(node, comparator);
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeUtil.sortRecursively((MutableTreeNode)node.getChildAt(i), comparator);
        }
    }

    public static <T extends MutableTreeNode> void sortChildren(@NotNull T node, @Nullable Comparator<? super T> comparator) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(63);
        }
        List<TreeNode> children = TreeUtil.listChildren(node);
        Collections.sort(children, comparator);
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            node.remove(i);
        }
        TreeUtil.addChildrenTo(node, children);
    }

    public static void addChildrenTo(@NotNull MutableTreeNode node, @NotNull List<? extends TreeNode> children) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(64);
        }
        if (children == null) {
            TreeUtil.$$$reportNull$$$0(65);
        }
        for (TreeNode treeNode : children) {
            MutableTreeNode child = (MutableTreeNode)treeNode;
            node.insert(child, node.getChildCount());
        }
    }

    @Deprecated
    public static boolean traverse(@NotNull TreeNode node, @NotNull Traverse traverse) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(66);
        }
        if (traverse == null) {
            TreeUtil.$$$reportNull$$$0(67);
        }
        return TreeUtil.treeNodeTraverser(node).traverse(TreeTraversal.POST_ORDER_DFS).processEach(traverse::accept);
    }

    @Deprecated
    public static boolean traverseDepth(@NotNull TreeNode node, @NotNull Traverse traverse) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(68);
        }
        if (traverse == null) {
            TreeUtil.$$$reportNull$$$0(69);
        }
        return TreeUtil.treeNodeTraverser(node).traverse(TreeTraversal.PRE_ORDER_DFS).processEach(traverse::accept);
    }

    @ApiStatus.Internal
    public static void selectPaths(@NotNull JTree tree, @NotNull Collection<? extends TreePath> paths) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(70);
        }
        if (paths == null) {
            TreeUtil.$$$reportNull$$$0(71);
        }
        if (paths.isEmpty()) {
            return;
        }
        paths.forEach(tree::makeVisible);
        TreeUtil.internalSelect(tree, paths);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    public static void selectPaths(@NotNull JTree tree, TreePath ... paths) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(72);
        }
        if (paths == null) {
            TreeUtil.$$$reportNull$$$0(73);
        }
        if (paths.length == 0) {
            return;
        }
        for (TreePath path2 : paths) {
            tree.makeVisible(path2);
        }
        tree.setSelectionPaths(paths);
        tree.scrollPathToVisible(paths[0]);
    }

    @NotNull
    public static ActionCallback selectPath(@NotNull JTree tree, TreePath path2) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(74);
        }
        return TreeUtil.selectPath(tree, path2, true);
    }

    @NotNull
    public static ActionCallback selectPath(@NotNull JTree tree, TreePath path2, boolean center) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(75);
        }
        tree.makeVisible(path2);
        Rectangle bounds = tree.getPathBounds(path2);
        if (bounds == null) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(76);
            }
            return actionCallback;
        }
        if (center) {
            Rectangle visible = tree.getVisibleRect();
            if (visible.y < bounds.y + bounds.height && bounds.y < visible.y + visible.height) {
                center = false;
            }
        }
        if (center) {
            return TreeUtil.showRowCentred(tree, tree.getRowForPath(path2));
        }
        int row = tree.getRowForPath(path2);
        return TreeUtil.showAndSelect(tree, row - 2, row + 2, row, -1);
    }

    @NotNull
    public static ActionCallback moveDown(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(77);
        }
        int size = tree.getRowCount();
        int row = tree.getLeadSelectionRow();
        if (row < size - 1) {
            return TreeUtil.showAndSelect(tree, ++row, row + 2, row, TreeUtil.getSelectedRow(tree), false, true, true);
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(78);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback moveUp(@NotNull JTree tree) {
        int row;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(79);
        }
        if ((row = tree.getLeadSelectionRow()) > 0) {
            return TreeUtil.showAndSelect(tree, --row - 2, row, row, TreeUtil.getSelectedRow(tree), false, true, true);
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(80);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback movePageUp(@NotNull JTree tree) {
        int visible;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(81);
        }
        if ((visible = TreeUtil.getVisibleRowCount(tree)) <= 0) {
            return TreeUtil.moveHome(tree);
        }
        int decrement = visible - 1;
        int row = Math.max(TreeUtil.getSelectedRow(tree) - decrement, 0);
        int top = TreeUtil.getFirstVisibleRow(tree) - decrement;
        int bottom = top + visible - 1;
        return TreeUtil.showAndSelect(tree, top, bottom, row, TreeUtil.getSelectedRow(tree));
    }

    @NotNull
    public static ActionCallback movePageDown(@NotNull JTree tree) {
        int visible;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(82);
        }
        if ((visible = TreeUtil.getVisibleRowCount(tree)) <= 0) {
            return TreeUtil.moveEnd(tree);
        }
        int size = tree.getRowCount();
        int increment = visible - 1;
        int index = Math.min(TreeUtil.getSelectedRow(tree) + increment, size - 1);
        int top = TreeUtil.getFirstVisibleRow(tree) + increment;
        int bottom = top + visible - 1;
        return TreeUtil.showAndSelect(tree, top, bottom, index, TreeUtil.getSelectedRow(tree));
    }

    @NotNull
    private static ActionCallback moveHome(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(83);
        }
        return TreeUtil.showRowCentred(tree, 0);
    }

    @NotNull
    private static ActionCallback moveEnd(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(84);
        }
        return TreeUtil.showRowCentred(tree, tree.getRowCount() - 1);
    }

    @NotNull
    private static ActionCallback showRowCentred(@NotNull JTree tree, int row) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(85);
        }
        return TreeUtil.showRowCentered(tree, row, true);
    }

    @NotNull
    public static ActionCallback showRowCentered(@NotNull JTree tree, int row, boolean centerHorizontally) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(86);
        }
        return TreeUtil.showRowCentered(tree, row, centerHorizontally, true);
    }

    @NotNull
    public static ActionCallback showRowCentered(@NotNull JTree tree, int row, boolean centerHorizontally, boolean scroll) {
        int visible;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(87);
        }
        int top = (visible = TreeUtil.getVisibleRowCount(tree)) > 0 ? row - (visible - 1) / 2 : row;
        int bottom = visible > 0 ? top + visible - 1 : row;
        return TreeUtil.showAndSelect(tree, top, bottom, row, -1, false, scroll, false);
    }

    @NotNull
    public static ActionCallback showAndSelect(@NotNull JTree tree, int top, int bottom, int row, int previous) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(88);
        }
        return TreeUtil.showAndSelect(tree, top, bottom, row, previous, false);
    }

    @NotNull
    public static ActionCallback showAndSelect(@NotNull JTree tree, int top, int bottom, int row, int previous, boolean addToSelection) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(89);
        }
        return TreeUtil.showAndSelect(tree, top, bottom, row, previous, addToSelection, true, false);
    }

    @NotNull
    public static ActionCallback showAndSelect(@NotNull JTree tree, int top, int bottom, int row, int previous, boolean addToSelection, boolean scroll) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(90);
        }
        return TreeUtil.showAndSelect(tree, top, bottom, row, previous, addToSelection, scroll, false);
    }

    @NotNull
    public static ActionCallback showAndSelect(@NotNull JTree tree, int top, int bottom, int row, int previous, boolean addToSelection, boolean scroll, boolean resetSelection) {
        Rectangle bottomBounds;
        TreePath path2;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(91);
        }
        if ((path2 = tree.getPathForRow(row)) == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(92);
            }
            return actionCallback;
        }
        int size = tree.getRowCount();
        if (size == 0) {
            tree.clearSelection();
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(93);
            }
            return actionCallback;
        }
        if (top < 0) {
            top = 0;
        }
        if (bottom >= size) {
            bottom = size - 1;
        }
        if (row >= tree.getRowCount()) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(94);
            }
            return actionCallback;
        }
        boolean okToScroll = true;
        if (tree.isShowing()) {
            if (!tree.isValid()) {
                tree.validate();
            }
        } else {
            Application app = ApplicationManager.getApplication();
            if (app != null && app.isUnitTestMode()) {
                okToScroll = false;
            }
        }
        Runnable selectRunnable = () -> {
            if (!tree.isRowSelected(row)) {
                if (addToSelection) {
                    tree.getSelectionModel().addSelectionPath(tree.getPathForRow(row));
                } else {
                    tree.setSelectionRow(row);
                }
            } else if (resetSelection && !addToSelection) {
                tree.setSelectionRow(row);
            }
        };
        if (!okToScroll || !scroll) {
            selectRunnable.run();
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(95);
            }
            return actionCallback;
        }
        Rectangle rowBounds = tree.getRowBounds(row);
        if (rowBounds == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(96);
            }
            return actionCallback;
        }
        Rectangle topBounds = tree.getRowBounds(top);
        if (topBounds == null) {
            topBounds = rowBounds;
        }
        if ((bottomBounds = tree.getRowBounds(bottom)) == null) {
            bottomBounds = rowBounds;
        }
        Rectangle bounds = topBounds.union(bottomBounds);
        bounds.x = rowBounds.x;
        bounds.width = rowBounds.width;
        Rectangle visible = tree.getVisibleRect();
        if (visible.contains(bounds)) {
            selectRunnable.run();
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(97);
            }
            return actionCallback;
        }
        Component comp = tree.getCellRenderer().getTreeCellRendererComponent(tree, path2.getLastPathComponent(), true, true, false, row, false);
        if (comp instanceof SimpleColoredComponent) {
            SimpleColoredComponent renderer = (SimpleColoredComponent)comp;
            Dimension scrollableSize = renderer.computePreferredSize(true);
            bounds.width = scrollableSize.width;
        }
        ActionCallback callback = new ActionCallback();
        selectRunnable.run();
        Range<Integer> range = TreeUtil.getExpandControlRange(tree, path2);
        if (range != null) {
            int delta = bounds.x - (Integer)range.getFrom();
            bounds.x -= delta;
            bounds.width -= delta;
        }
        if (visible.width < bounds.width) {
            bounds.width = visible.width;
        }
        if (tree instanceof Tree && !((Tree)tree).isHorizontalAutoScrollingEnabled()) {
            bounds.x = tree.getVisibleRect().x;
        }
        LOG.debug("tree scroll: ", new Object[]{path2});
        tree.scrollRectToVisible(bounds);
        Object property = tree.getClientProperty(TREE_UTIL_SCROLL_TIME_STAMP);
        long stamp = property instanceof Long ? (Long)property + 1L : Long.MIN_VALUE;
        tree.putClientProperty(TREE_UTIL_SCROLL_TIME_STAMP, stamp);
        int offset = rowBounds.y - bounds.y;
        AbstractTreeBuilder builder = AbstractTreeBuilder.getBuilderFor(tree);
        TreeUtil.scrollToVisible(tree, path2, bounds, offset, stamp, callback::setDone, builder, 3);
        ActionCallback actionCallback = callback;
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(98);
        }
        return actionCallback;
    }

    private static void scrollToVisible(JTree tree, TreePath path2, Rectangle bounds, int offset, long expected, Runnable done, AbstractTreeBuilder builder, int attempt) {
        Runnable scroll = () -> {
            Rectangle pathBounds;
            Rectangle rectangle = pathBounds = attempt <= 0 ? null : tree.getPathBounds(path2);
            if (pathBounds != null) {
                Object property = tree.getClientProperty(TREE_UTIL_SCROLL_TIME_STAMP);
                long stamp = property instanceof Long ? (Long)property : Long.MAX_VALUE;
                LOG.debug("tree scroll ", new Object[]{attempt, stamp == expected ? ": try again: " : ": ignore: ", path2});
                if (stamp == expected) {
                    bounds.y = pathBounds.y - offset;
                    Rectangle visible = tree.getVisibleRect();
                    if (bounds.y < visible.y || bounds.y > visible.y + Math.max(0, visible.height - bounds.height)) {
                        tree.scrollRectToVisible(bounds);
                        TreeUtil.scrollToVisible(tree, path2, bounds, offset, expected, done, builder, attempt - 1);
                        return;
                    }
                }
            }
            done.run();
        };
        SwingUtilities.invokeLater(builder == null ? scroll : () -> builder.getReady(TreeUtil.class).doWhenDone(scroll));
    }

    private static int getSelectedRow(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(99);
        }
        return tree.getRowForPath(tree.getSelectionPath());
    }

    private static int getFirstVisibleRow(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(100);
        }
        Rectangle visible = tree.getVisibleRect();
        int row = -1;
        for (int i = 0; i < tree.getRowCount(); ++i) {
            Rectangle bounds = tree.getRowBounds(i);
            if (visible.y > bounds.y || visible.y + visible.height < bounds.y + bounds.height) continue;
            row = i;
            break;
        }
        return row;
    }

    public static int getVisibleRowCount(@NotNull JTree tree) {
        int lastRow;
        int firstRow;
        Rectangle visible;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(101);
        }
        if ((visible = tree.getVisibleRect()) == null) {
            return 0;
        }
        int rowCount = tree.getRowCount();
        if (rowCount <= 0) {
            return 0;
        }
        int rowHeight = tree.getRowHeight();
        if (rowHeight > 0) {
            Insets insets = tree.getInsets();
            int top = visible.y - insets.top;
            int bottom = visible.y + visible.height - insets.top;
            firstRow = Math.max(0, Math.min(top / rowHeight, rowCount - 1));
            lastRow = Math.max(0, Math.min(bottom / rowHeight, rowCount - 1));
        } else {
            firstRow = tree.getClosestRowForLocation(visible.x, visible.y);
            lastRow = tree.getClosestRowForLocation(visible.x, visible.y + visible.height);
        }
        return lastRow - firstRow + 1;
    }

    public static void installActions(final @NotNull JTree tree) {
        TreeUI ui;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(102);
        }
        if ((ui = tree.getUI()) != null && ui.getClass().getName().equals("com.intellij.ui.tree.ui.DefaultTreeUI")) {
            return;
        }
        tree.getActionMap().put("scrollUpChangeSelection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeUtil.movePageUp(tree);
            }
        });
        tree.getActionMap().put("scrollDownChangeSelection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeUtil.movePageDown(tree);
            }
        });
        tree.getActionMap().put("selectPrevious", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeUtil.moveUp(tree);
            }
        });
        tree.getActionMap().put("selectNext", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeUtil.moveDown(tree);
            }
        });
        TreeUtil.copyAction(tree, "selectLast", "selectLastChangeLead");
        TreeUtil.copyAction(tree, "selectFirst", "selectFirstChangeLead");
        InputMap inputMap = tree.getInputMap(0);
        UIUtil.maybeInstall((InputMap)inputMap, (String)"scrollUpChangeSelection", (KeyStroke)KeyStroke.getKeyStroke(33, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"scrollDownChangeSelection", (KeyStroke)KeyStroke.getKeyStroke(34, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"selectNext", (KeyStroke)KeyStroke.getKeyStroke(40, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"selectPrevious", (KeyStroke)KeyStroke.getKeyStroke(38, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"selectLast", (KeyStroke)KeyStroke.getKeyStroke(35, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"selectFirst", (KeyStroke)KeyStroke.getKeyStroke(36, 0));
    }

    private static void copyAction(@NotNull JTree tree, String original, String copyTo) {
        Action action;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(103);
        }
        if ((action = tree.getActionMap().get(original)) != null) {
            tree.getActionMap().put(copyTo, action);
        }
    }

    public static void collapseAll(@NotNull JTree tree, int keepSelectionLevel) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(104);
        }
        TreeUtil.collapseAll(tree, false, keepSelectionLevel);
    }

    public static void collapseAll(@NotNull JTree tree, boolean strict, int keepSelectionLevel) {
        TreePath prohibited;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(105);
        }
        assert (EventQueue.isDispatchThread());
        int row = tree.getRowCount();
        if (row <= 1) {
            return;
        }
        TreePath leadSelectionPath = tree.getLeadSelectionPath();
        int minCount = 1;
        if (!tree.isRootVisible()) {
            ++minCount;
        }
        if (!tree.getShowsRootHandles()) {
            ++minCount;
            strict = true;
        }
        TreePath treePath = prohibited = leadSelectionPath == null ? null : TreeUtil.normalize(leadSelectionPath, minCount, keepSelectionLevel).getParentPath();
        while (0 < row-- && (strict || row != 0)) {
            TreePath path2 = tree.getPathForRow(row);
            assert (path2 != null) : "path is not found at row " + row;
            int pathCount = path2.getPathCount();
            if (pathCount < minCount) continue;
            if (pathCount == minCount && row > 0) {
                strict = true;
            }
            if (TreeUtil.isAlwaysExpand(path2) || path2.isDescendant(prohibited)) continue;
            tree.collapsePath(path2);
        }
        if (leadSelectionPath == null) {
            return;
        }
        if (!strict) {
            ++minCount;
        }
        TreeUtil.internalSelect(tree, TreeUtil.normalize(leadSelectionPath, minCount, keepSelectionLevel));
    }

    @NotNull
    private static TreePath normalize(@NotNull TreePath path2, int minCount, int keepSelectionLevel) {
        if (path2 == null) {
            TreeUtil.$$$reportNull$$$0(106);
        }
        if (keepSelectionLevel < 0) {
            TreePath treePath = path2;
            if (treePath == null) {
                TreeUtil.$$$reportNull$$$0(107);
            }
            return treePath;
        }
        if (keepSelectionLevel > minCount) {
            minCount = keepSelectionLevel;
        }
        int pathCount = path2.getPathCount();
        while (minCount < pathCount--) {
            path2 = path2.getParentPath();
        }
        assert (path2 != null) : "unexpected minCount: " + minCount;
        TreePath treePath = path2;
        if (treePath == null) {
            TreeUtil.$$$reportNull$$$0(108);
        }
        return treePath;
    }

    private static boolean isAlwaysExpand(@NotNull TreePath path2) {
        AbstractTreeNode node;
        if (path2 == null) {
            TreeUtil.$$$reportNull$$$0(109);
        }
        return (node = TreeUtil.getLastUserObject(AbstractTreeNode.class, path2)) != null && node.isAlwaysExpand();
    }

    public static void selectNode(@NotNull JTree tree, TreeNode node) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(110);
        }
        TreeUtil.selectPath(tree, TreeUtil.getPathFromRoot(node));
    }

    public static void moveSelectedRow(@NotNull JTree tree, int direction) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(111);
        }
        TreePath selectionPath = tree.getSelectionPath();
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)treeNode.getParent();
        int idx = parent.getIndex(treeNode);
        ((DefaultTreeModel)tree.getModel()).removeNodeFromParent(treeNode);
        ((DefaultTreeModel)tree.getModel()).insertNodeInto(treeNode, parent, idx + direction);
        TreeUtil.selectNode(tree, treeNode);
    }

    @NotNull
    public static List<TreeNode> listChildren(@NotNull TreeNode node) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(112);
        }
        int size = node.getChildCount();
        ArrayList<TreeNode> result = new ArrayList<TreeNode>(size);
        for (int i = 0; i < size; ++i) {
            TreeNode child = node.getChildAt(i);
            LOG.assertTrue(child != null);
            result.add(child);
        }
        ArrayList<TreeNode> arrayList = result;
        if (arrayList == null) {
            TreeUtil.$$$reportNull$$$0(113);
        }
        return arrayList;
    }

    public static void expandRootChildIfOnlyOne(@Nullable JTree tree) {
        if (tree == null) {
            return;
        }
        Runnable runnable = () -> {
            TreeModel model = tree.getModel();
            Object root = model.getRoot();
            if (root == null) {
                return;
            }
            TreePath rootPath = new TreePath(root);
            tree.expandPath(rootPath);
            if (model.getChildCount(root) == 1) {
                Object firstChild = model.getChild(root, 0);
                tree.expandPath(rootPath.pathByAddingChild(firstChild));
            }
        };
        UIUtil.invokeLaterIfNeeded((Runnable)runnable);
    }

    public static void expandAll(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(114);
        }
        TreeUtil.promiseExpandAll(tree);
    }

    public static void expandAll(@NotNull JTree tree, @NotNull Runnable onDone) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(115);
        }
        if (onDone == null) {
            TreeUtil.$$$reportNull$$$0(116);
        }
        TreeUtil.promiseExpandAll(tree).onSuccess(result -> UIUtil.invokeLaterIfNeeded((Runnable)onDone));
    }

    @NotNull
    public static Promise<?> promiseExpandAll(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(117);
        }
        return TreeUtil.promiseExpand(tree, Integer.MAX_VALUE);
    }

    public static void expand(@NotNull JTree tree, int levels) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(118);
        }
        TreeUtil.promiseExpand(tree, levels);
    }

    public static void expand(@NotNull JTree tree, int depth, @NotNull Runnable onDone) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(119);
        }
        if (onDone == null) {
            TreeUtil.$$$reportNull$$$0(120);
        }
        TreeUtil.promiseExpand(tree, depth).onSuccess(result -> UIUtil.invokeLaterIfNeeded((Runnable)onDone));
    }

    @NotNull
    public static Promise<?> promiseExpand(@NotNull JTree tree, int depth) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(121);
        }
        AsyncPromise promise2 = new AsyncPromise();
        TreeUtil.promiseMakeVisible(tree, path2 -> depth < path2.getPathCount() ? TreeVisitor.Action.SKIP_SIBLINGS : TreeVisitor.Action.CONTINUE, promise2).onError(arg_0 -> ((AsyncPromise)promise2).setError(arg_0)).onSuccess(path2 -> {
            if (promise2.isCancelled()) {
                return;
            }
            promise2.setResult(null);
        });
        AsyncPromise asyncPromise = promise2;
        if (asyncPromise == null) {
            TreeUtil.$$$reportNull$$$0(122);
        }
        return asyncPromise;
    }

    @NotNull
    public static ActionCallback selectInTree(DefaultMutableTreeNode node, boolean requestFocus, @NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(123);
        }
        return TreeUtil.selectInTree(node, requestFocus, tree, true);
    }

    @NotNull
    public static ActionCallback selectInTree(@Nullable DefaultMutableTreeNode node, boolean requestFocus, @NotNull JTree tree, boolean center) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(124);
        }
        if (node == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(125);
            }
            return actionCallback;
        }
        TreePath treePath = new TreePath(node.getPath());
        tree.expandPath(treePath);
        if (requestFocus) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(tree, true));
        }
        return TreeUtil.selectPath(tree, treePath, center);
    }

    @NotNull
    public static ActionCallback selectInTree(Project project, @Nullable DefaultMutableTreeNode node, boolean requestFocus, @NotNull JTree tree, boolean center) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(126);
        }
        if (node == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(127);
            }
            return actionCallback;
        }
        TreePath treePath = new TreePath(node.getPath());
        tree.expandPath(treePath);
        if (requestFocus) {
            ActionCallback result = new ActionCallback(2);
            IdeFocusManager.getInstance(project).requestFocus(tree, true).notifyWhenDone(result);
            TreeUtil.selectPath(tree, treePath, center).notifyWhenDone(result);
            ActionCallback actionCallback = result;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(128);
            }
            return actionCallback;
        }
        return TreeUtil.selectPath(tree, treePath, center);
    }

    private static boolean isViewable(@NotNull JTree tree, @NotNull TreePath path2) {
        TreePath parent;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(129);
        }
        if (path2 == null) {
            TreeUtil.$$$reportNull$$$0(130);
        }
        return (parent = path2.getParentPath()) != null ? tree.isExpanded(parent) : tree.isRootVisible();
    }

    @NotNull
    public static List<TreePath> collectSelectedPaths(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(131);
        }
        return TreeUtil.collectSelectedObjects(tree, Function.identity());
    }

    @NotNull
    public static List<Object> collectSelectedUserObjects(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(132);
        }
        return TreeUtil.collectSelectedObjects(tree, TreeUtil::getLastUserObject);
    }

    @NotNull
    public static <T> List<T> collectSelectedObjects(@NotNull JTree tree, @NotNull Function<? super TreePath, ? extends T> mapper) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(133);
        }
        if (mapper == null) {
            TreeUtil.$$$reportNull$$$0(134);
        }
        return TreeUtil.getSelection(tree, path2 -> TreeUtil.isViewable(tree, path2), mapper);
    }

    @NotNull
    public static List<TreePath> collectSelectedPaths(@NotNull JTree tree, @NotNull TreePath root) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(135);
        }
        if (root == null) {
            TreeUtil.$$$reportNull$$$0(136);
        }
        return TreeUtil.collectSelectedObjects(tree, root, Function.identity());
    }

    @NotNull
    public static List<Object> collectSelectedUserObjects(@NotNull JTree tree, @NotNull TreePath root) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(137);
        }
        if (root == null) {
            TreeUtil.$$$reportNull$$$0(138);
        }
        return TreeUtil.collectSelectedObjects(tree, root, TreeUtil::getLastUserObject);
    }

    @NotNull
    public static <T> List<T> collectSelectedObjects(@NotNull JTree tree, @NotNull TreePath root, @NotNull Function<? super TreePath, ? extends T> mapper) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(139);
        }
        if (root == null) {
            TreeUtil.$$$reportNull$$$0(140);
        }
        if (mapper == null) {
            TreeUtil.$$$reportNull$$$0(141);
        }
        if (!tree.isVisible(root)) {
            List list = Collections.emptyList();
            if (list == null) {
                TreeUtil.$$$reportNull$$$0(142);
            }
            return list;
        }
        return TreeUtil.getSelection(tree, path2 -> TreeUtil.isViewable(tree, path2) && root.isDescendant((TreePath)path2), mapper);
    }

    @NotNull
    private static <T> List<T> getSelection(@NotNull JTree tree, @NotNull Predicate<? super TreePath> filter, @NotNull Function<? super TreePath, ? extends T> mapper) {
        TreePath[] paths;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(143);
        }
        if (filter == null) {
            TreeUtil.$$$reportNull$$$0(144);
        }
        if (mapper == null) {
            TreeUtil.$$$reportNull$$$0(145);
        }
        if ((paths = tree.getSelectionPaths()) == null || paths.length == 0) {
            List list = Collections.emptyList();
            if (list == null) {
                TreeUtil.$$$reportNull$$$0(146);
            }
            return list;
        }
        List list = Stream.of(paths).filter(filter).map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            TreeUtil.$$$reportNull$$$0(147);
        }
        return list;
    }

    public static void unselectPath(@NotNull JTree tree, @Nullable TreePath path2) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(148);
        }
        if (path2 == null) {
            return;
        }
        TreePath[] selectionPaths = tree.getSelectionPaths();
        if (selectionPaths == null) {
            return;
        }
        for (TreePath selectionPath : selectionPaths) {
            if (selectionPath.getPathCount() <= path2.getPathCount() || !path2.isDescendant(selectionPath)) continue;
            tree.removeSelectionPath(selectionPath);
        }
    }

    @Nullable
    public static Range<Integer> getExpandControlRange(@NotNull JTree aTree, @Nullable TreePath path2) {
        if (aTree == null) {
            TreeUtil.$$$reportNull$$$0(149);
        }
        TreeModel treeModel = aTree.getModel();
        BasicTreeUI basicTreeUI = (BasicTreeUI)aTree.getUI();
        Icon expandedIcon = basicTreeUI.getExpandedIcon();
        Range box = null;
        if (path2 != null && !treeModel.isLeaf(path2.getLastPathComponent())) {
            Insets i = aTree.getInsets();
            int boxWidth = expandedIcon != null ? expandedIcon.getIconWidth() : 8;
            int boxLeftX = i != null ? i.left : 0;
            boolean leftToRight = aTree.getComponentOrientation().isLeftToRight();
            int depthOffset = TreeUtil.getDepthOffset(aTree);
            int totalChildIndent = basicTreeUI.getLeftChildIndent() + basicTreeUI.getRightChildIndent();
            if (leftToRight) {
                boxLeftX += (path2.getPathCount() + depthOffset - 2) * totalChildIndent + basicTreeUI.getLeftChildIndent() - boxWidth / 2;
            }
            int boxRightX = boxLeftX + boxWidth;
            box = new Range((Comparable)Integer.valueOf(boxLeftX), (Comparable)Integer.valueOf(boxRightX));
        }
        return box;
    }

    public static int getDepthOffset(@NotNull JTree aTree) {
        if (aTree == null) {
            TreeUtil.$$$reportNull$$$0(150);
        }
        if (aTree.isRootVisible()) {
            return aTree.getShowsRootHandles() ? 1 : 0;
        }
        return aTree.getShowsRootHandles() ? 0 : -1;
    }

    public static int getNodeDepth(@NotNull JTree tree, @NotNull TreePath path2) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(151);
        }
        if (path2 == null) {
            TreeUtil.$$$reportNull$$$0(152);
        }
        int depth = path2.getPathCount();
        if (!tree.isRootVisible()) {
            --depth;
        }
        if (!tree.getShowsRootHandles()) {
            --depth;
        }
        return depth;
    }

    @ApiStatus.Experimental
    public static int getNodeRowX(@NotNull JTree tree, int row) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(153);
        }
        if (LazyRowX.METHOD == null) {
            return -1;
        }
        TreePath path2 = tree.getPathForRow(row);
        if (path2 == null) {
            return -1;
        }
        int depth = TreeUtil.getNodeDepth(tree, path2);
        if (depth < 0) {
            return -1;
        }
        try {
            return (Integer)LazyRowX.METHOD.invoke((Object)tree.getUI(), row, depth);
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
            return -1;
        }
    }

    @ApiStatus.Experimental
    public static boolean isLocationInExpandControl(@NotNull JTree tree, int x, int y) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(154);
        }
        if (LazyLocationInExpandControl.METHOD == null) {
            return false;
        }
        return TreeUtil.isLocationInExpandControl(tree, tree.getClosestPathForLocation(x, y), x, y);
    }

    @ApiStatus.Experimental
    public static boolean isLocationInExpandControl(@NotNull JTree tree, @Nullable TreePath path2, int x, int y) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(155);
        }
        if (LazyLocationInExpandControl.METHOD == null || path2 == null) {
            return false;
        }
        try {
            return (Boolean)LazyLocationInExpandControl.METHOD.invoke((Object)tree.getUI(), path2, x, y);
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
            return false;
        }
    }

    @ApiStatus.Experimental
    public static void invalidateCacheAndRepaint(@Nullable TreeUI ui) {
        if (ui instanceof BasicTreeUI) {
            BasicTreeUI basic = (BasicTreeUI)ui;
            if (null == ReflectionUtil.getField(BasicTreeUI.class, (Object)ui, JTree.class, (String)"tree")) {
                LOG.warn((Throwable)new IllegalStateException("tree is not properly initialized yet"));
                return;
            }
            UIUtil.invokeLaterIfNeeded(() -> basic.setLeftChildIndent(basic.getLeftChildIndent()));
        }
    }

    @NotNull
    public static RelativePoint getPointForSelection(@NotNull JTree aTree) {
        int[] rows;
        if (aTree == null) {
            TreeUtil.$$$reportNull$$$0(156);
        }
        if ((rows = aTree.getSelectionRows()) == null || rows.length == 0) {
            RelativePoint relativePoint = RelativePoint.getCenterOf((JComponent)aTree);
            if (relativePoint == null) {
                TreeUtil.$$$reportNull$$$0(157);
            }
            return relativePoint;
        }
        return TreeUtil.getPointForRow(aTree, rows[rows.length - 1]);
    }

    @NotNull
    public static RelativePoint getPointForRow(@NotNull JTree aTree, int aRow) {
        if (aTree == null) {
            TreeUtil.$$$reportNull$$$0(158);
        }
        return TreeUtil.getPointForPath(aTree, aTree.getPathForRow(aRow));
    }

    @NotNull
    public static RelativePoint getPointForPath(@NotNull JTree aTree, TreePath path2) {
        if (aTree == null) {
            TreeUtil.$$$reportNull$$$0(159);
        }
        Rectangle rowBounds = aTree.getPathBounds(path2);
        rowBounds.x += 20;
        return TreeUtil.getPointForBounds(aTree, rowBounds);
    }

    @NotNull
    public static RelativePoint getPointForBounds(JComponent aComponent, @NotNull Rectangle aBounds) {
        if (aBounds == null) {
            TreeUtil.$$$reportNull$$$0(160);
        }
        return new RelativePoint((Component)aComponent, new Point(aBounds.x, (int)aBounds.getMaxY()));
    }

    public static boolean isOverSelection(@NotNull JTree tree, @NotNull Point point) {
        TreePath path2;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(161);
        }
        if (point == null) {
            TreeUtil.$$$reportNull$$$0(162);
        }
        return (path2 = tree.getPathForLocation(point.x, point.y)) != null && tree.getSelectionModel().isPathSelected(path2);
    }

    public static void dropSelectionButUnderPoint(@NotNull JTree tree, @NotNull Point treePoint) {
        TreePath toRetain;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(163);
        }
        if (treePoint == null) {
            TreeUtil.$$$reportNull$$$0(164);
        }
        if ((toRetain = tree.getPathForLocation(treePoint.x, treePoint.y)) == null) {
            return;
        }
        TreePath[] selection = tree.getSelectionModel().getSelectionPaths();
        for (TreePath each : selection = selection == null ? EMPTY_TREE_PATH : selection) {
            if (toRetain.equals(each)) continue;
            tree.getSelectionModel().removeSelectionPath(each);
        }
    }

    @Nullable
    public static Object getUserObject(@Nullable Object node) {
        return node instanceof DefaultMutableTreeNode ? ((DefaultMutableTreeNode)node).getUserObject() : node;
    }

    @Nullable
    public static <T> T getUserObject(@NotNull Class<T> type, @Nullable Object node) {
        if (type == null) {
            TreeUtil.$$$reportNull$$$0(165);
        }
        return type.isInstance(node = TreeUtil.getUserObject(node)) ? (T)type.cast(node) : null;
    }

    @Nullable
    public static Object getLastUserObject(@Nullable TreePath path2) {
        return path2 == null ? null : TreeUtil.getUserObject(path2.getLastPathComponent());
    }

    @Nullable
    public static <T> T getLastUserObject(@NotNull Class<T> type, @Nullable TreePath path2) {
        if (type == null) {
            TreeUtil.$$$reportNull$$$0(166);
        }
        return path2 == null ? null : (T)TreeUtil.getUserObject(type, path2.getLastPathComponent());
    }

    @Nullable
    public static TreePath getSelectedPathIfOne(@NotNull JTree tree) {
        TreePath[] paths;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(167);
        }
        return (paths = tree.getSelectionPaths()) != null && paths.length == 1 ? paths[0] : null;
    }

    public static void ensureSelection(@NotNull JTree tree) {
        TreePath[] paths;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(168);
        }
        if ((paths = tree.getSelectionPaths()) != null) {
            for (TreePath each : paths) {
                if (tree.getRowForPath(each) < 0 || !tree.isVisible(each)) continue;
                return;
            }
        }
        for (int eachRow = 0; eachRow < tree.getRowCount(); ++eachRow) {
            TreePath eachPath = tree.getPathForRow(eachRow);
            if (eachPath == null || !tree.isVisible(eachPath)) continue;
            tree.setSelectionPath(eachPath);
            break;
        }
    }

    public static <T extends MutableTreeNode> void insertNode(@NotNull T child, @NotNull T parent, @Nullable DefaultTreeModel model, @NotNull Comparator<? super T> comparator) {
        if (child == null) {
            TreeUtil.$$$reportNull$$$0(169);
        }
        if (parent == null) {
            TreeUtil.$$$reportNull$$$0(170);
        }
        if (comparator == null) {
            TreeUtil.$$$reportNull$$$0(171);
        }
        TreeUtil.insertNode(child, parent, model, false, comparator);
    }

    public static <T extends MutableTreeNode> void insertNode(@NotNull T child, @NotNull T parent, @Nullable DefaultTreeModel model, boolean allowDuplication, @NotNull Comparator<? super T> comparator) {
        int insertionPoint;
        int index;
        if (child == null) {
            TreeUtil.$$$reportNull$$$0(172);
        }
        if (parent == null) {
            TreeUtil.$$$reportNull$$$0(173);
        }
        if (comparator == null) {
            TreeUtil.$$$reportNull$$$0(174);
        }
        if ((index = TreeUtil.indexedBinarySearch(parent, child, comparator)) >= 0 && !allowDuplication) {
            LOG.error("Node " + child + " is already added to " + parent);
            return;
        }
        int n = insertionPoint = index >= 0 ? index : -(index + 1);
        if (model != null) {
            model.insertNodeInto(child, parent, insertionPoint);
        } else {
            parent.insert(child, insertionPoint);
        }
    }

    public static <T extends TreeNode> int indexedBinarySearch(@NotNull T parent, @NotNull T key, @NotNull Comparator<? super T> comparator) {
        if (parent == null) {
            TreeUtil.$$$reportNull$$$0(175);
        }
        if (key == null) {
            TreeUtil.$$$reportNull$$$0(176);
        }
        if (comparator == null) {
            TreeUtil.$$$reportNull$$$0(177);
        }
        return ObjectUtils.binarySearch((int)0, (int)parent.getChildCount(), mid -> comparator.compare(parent.getChildAt(mid), key));
    }

    @NotNull
    public static Comparator<TreePath> getDisplayOrderComparator(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(178);
        }
        Comparator<TreePath> comparator = Comparator.comparingInt(tree::getRowForPath);
        if (comparator == null) {
            TreeUtil.$$$reportNull$$$0(179);
        }
        return comparator;
    }

    private static void expandPathWithDebug(@NotNull JTree tree, @NotNull TreePath path2) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(180);
        }
        if (path2 == null) {
            TreeUtil.$$$reportNull$$$0(181);
        }
        LOG.debug("tree expand path: ", new Object[]{path2});
        tree.expandPath(path2);
    }

    public static void expand(@NotNull JTree tree, @NotNull TreeVisitor visitor, @NotNull Consumer<? super TreePath> consumer) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(182);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(183);
        }
        if (consumer == null) {
            TreeUtil.$$$reportNull$$$0(184);
        }
        TreeUtil.promiseMakeVisibleOne(tree, visitor, path2 -> {
            TreeUtil.expandPathWithDebug(tree, path2);
            consumer.accept((TreePath)path2);
        });
    }

    @NotNull
    public static Promise<TreePath> promiseExpand(@NotNull JTree tree, @NotNull TreeVisitor visitor) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(185);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(186);
        }
        return TreeUtil.promiseMakeVisibleOne(tree, visitor, path2 -> TreeUtil.expandPathWithDebug(tree, path2));
    }

    @NotNull
    public static Promise<List<TreePath>> promiseExpand(@NotNull JTree tree, @NotNull Stream<? extends TreeVisitor> visitors) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(187);
        }
        if (visitors == null) {
            TreeUtil.$$$reportNull$$$0(188);
        }
        Promise<List<TreePath>> promise2 = TreeUtil.promiseMakeVisibleAll(tree, visitors, paths -> paths.forEach(path2 -> TreeUtil.expandPathWithDebug(tree, path2)));
        if (promise2 == null) {
            TreeUtil.$$$reportNull$$$0(189);
        }
        return promise2;
    }

    public static void makeVisible(@NotNull JTree tree, @NotNull TreeVisitor visitor, @NotNull Consumer<? super TreePath> consumer) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(190);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(191);
        }
        if (consumer == null) {
            TreeUtil.$$$reportNull$$$0(192);
        }
        TreeUtil.promiseMakeVisibleOne(tree, visitor, consumer);
    }

    @NotNull
    public static Promise<TreePath> promiseMakeVisible(@NotNull JTree tree, @NotNull TreeVisitor visitor) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(193);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(194);
        }
        return TreeUtil.promiseMakeVisibleOne(tree, visitor, null);
    }

    @NotNull
    private static Promise<TreePath> promiseMakeVisibleOne(@NotNull JTree tree, @NotNull TreeVisitor visitor, @Nullable Consumer<? super TreePath> consumer) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(195);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(196);
        }
        AsyncPromise promise2 = new AsyncPromise();
        TreeUtil.promiseMakeVisible(tree, visitor, promise2).onError(arg_0 -> ((AsyncPromise)promise2).setError(arg_0)).onSuccess(path2 -> {
            if (promise2.isCancelled()) {
                return;
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (promise2.isCancelled()) {
                    return;
                }
                if (tree.isVisible((TreePath)path2)) {
                    if (consumer != null) {
                        consumer.accept((TreePath)path2);
                    }
                    promise2.setResult(path2);
                } else {
                    promise2.cancel();
                }
            });
        });
        AsyncPromise asyncPromise = promise2;
        if (asyncPromise == null) {
            TreeUtil.$$$reportNull$$$0(197);
        }
        return asyncPromise;
    }

    @NotNull
    public static Promise<List<TreePath>> promiseMakeVisible(@NotNull JTree tree, @NotNull Stream<? extends TreeVisitor> visitors) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(198);
        }
        if (visitors == null) {
            TreeUtil.$$$reportNull$$$0(199);
        }
        Promise<List<TreePath>> promise2 = TreeUtil.promiseMakeVisibleAll(tree, visitors, null);
        if (promise2 == null) {
            TreeUtil.$$$reportNull$$$0(200);
        }
        return promise2;
    }

    private static Promise<List<TreePath>> promiseMakeVisibleAll(@NotNull JTree tree, @NotNull Stream<? extends TreeVisitor> visitors, @Nullable Consumer<? super List<TreePath>> consumer) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(201);
        }
        if (visitors == null) {
            TreeUtil.$$$reportNull$$$0(202);
        }
        AsyncPromise promise2 = new AsyncPromise();
        List promises = visitors.filter(Objects::nonNull).map(visitor -> TreeUtil.promiseMakeVisible(tree, visitor, promise2)).collect(Collectors.toList());
        Promises.collectResults(promises, (boolean)true).onError(arg_0 -> ((AsyncPromise)promise2).setError(arg_0)).onSuccess(paths -> {
            if (promise2.isCancelled()) {
                return;
            }
            if (!ContainerUtil.isEmpty((Collection)paths)) {
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (promise2.isCancelled()) {
                        return;
                    }
                    List visible = ContainerUtil.filter((Collection)paths, tree::isVisible);
                    if (!ContainerUtil.isEmpty((Collection)visible)) {
                        if (consumer != null) {
                            consumer.accept(visible);
                        }
                        promise2.setResult((Object)visible);
                    } else {
                        promise2.cancel();
                    }
                });
            } else {
                promise2.cancel();
            }
        });
        return promise2;
    }

    @NotNull
    private static Promise<TreePath> promiseMakeVisible(@NotNull JTree tree, @NotNull TreeVisitor visitor, @NotNull AsyncPromise<?> promise2) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(203);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(204);
        }
        if (promise2 == null) {
            TreeUtil.$$$reportNull$$$0(205);
        }
        return TreeUtil.promiseVisit(tree, path2 -> {
            if (promise2.isCancelled()) {
                return TreeVisitor.Action.SKIP_SIBLINGS;
            }
            TreeVisitor.Action action = visitor.visit(path2);
            if (action == TreeVisitor.Action.CONTINUE || action == TreeVisitor.Action.INTERRUPT) {
                if (!tree.isVisible(path2)) {
                    if (!promise2.isCancelled()) {
                        LOG.debug("tree expand canceled");
                        promise2.cancel();
                    }
                    return TreeVisitor.Action.SKIP_SIBLINGS;
                }
                if (action == TreeVisitor.Action.CONTINUE) {
                    TreeUtil.expandPathWithDebug(tree, path2);
                }
            }
            return action;
        });
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static void select(@NotNull JTree tree, @NotNull TreeVisitor visitor, @NotNull Consumer<? super TreePath> consumer) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(206);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(207);
        }
        if (consumer == null) {
            TreeUtil.$$$reportNull$$$0(208);
        }
        TreeUtil.promiseMakeVisibleOne(tree, visitor, path2 -> {
            TreeUtil.internalSelect(tree, path2);
            consumer.accept((TreePath)path2);
        });
    }

    @NotNull
    public static Promise<TreePath> promiseSelect(@NotNull JTree tree, @NotNull TreeVisitor visitor) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(209);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(210);
        }
        return TreeUtil.promiseMakeVisibleOne(tree, visitor, path2 -> TreeUtil.internalSelect(tree, path2));
    }

    @NotNull
    public static Promise<List<TreePath>> promiseSelect(@NotNull JTree tree, @NotNull Stream<? extends TreeVisitor> visitors) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(211);
        }
        if (visitors == null) {
            TreeUtil.$$$reportNull$$$0(212);
        }
        Promise<List<TreePath>> promise2 = TreeUtil.promiseMakeVisibleAll(tree, visitors, paths -> TreeUtil.internalSelect(tree, paths));
        if (promise2 == null) {
            TreeUtil.$$$reportNull$$$0(213);
        }
        return promise2;
    }

    private static void internalSelect(@NotNull JTree tree, @NotNull Collection<? extends TreePath> paths) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(214);
        }
        if (paths == null) {
            TreeUtil.$$$reportNull$$$0(215);
        }
        assert (EventQueue.isDispatchThread());
        if (paths.isEmpty()) {
            return;
        }
        TreeUtil.internalSelect(tree, paths.toArray(EMPTY_TREE_PATH));
    }

    private static void internalSelect(@NotNull JTree tree, TreePath ... paths) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(216);
        }
        if (paths == null) {
            TreeUtil.$$$reportNull$$$0(217);
        }
        assert (EventQueue.isDispatchThread());
        if (paths.length == 0) {
            return;
        }
        tree.setSelectionPaths(paths);
        for (TreePath path2 : paths) {
            if (TreeUtil.scrollToVisible(tree, path2, true)) break;
        }
    }

    public static boolean scrollToVisible(@NotNull JTree tree, @NotNull TreePath path2, boolean centered) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(218);
        }
        if (path2 == null) {
            TreeUtil.$$$reportNull$$$0(219);
        }
        assert (EventQueue.isDispatchThread());
        Rectangle bounds = tree.getPathBounds(path2);
        if (bounds == null) {
            LOG.debug("cannot scroll to: ", new Object[]{path2});
            return false;
        }
        Container parent = tree.getParent();
        if (parent instanceof JViewport) {
            if (centered) {
                Rectangle visible = tree.getVisibleRect();
                centered = bounds.y < visible.y || bounds.y > visible.y + visible.height - bounds.height;
            }
            int width = parent.getWidth();
            if (!centered && tree instanceof Tree && !((Tree)tree).isHorizontalAutoScrollingEnabled()) {
                bounds.x = -tree.getX();
                bounds.width = width;
            } else {
                bounds.width = Math.min(bounds.width, width / 2);
                bounds.x -= JBUIScale.scale((int)20);
                if (bounds.x < 0) {
                    bounds.width += bounds.x;
                    bounds.x = 0;
                }
            }
            int height = parent.getHeight();
            if (height > bounds.height && height < tree.getHeight()) {
                int y;
                if (centered || height < bounds.height * 5) {
                    bounds.y -= (height - bounds.height) / 2;
                    bounds.height = height;
                } else {
                    bounds.y -= bounds.height * 2;
                    bounds.height *= 5;
                }
                if (bounds.y < 0) {
                    bounds.height += bounds.y;
                    bounds.y = 0;
                }
                if ((y = bounds.y + bounds.height - tree.getHeight()) > 0) {
                    bounds.height -= y;
                }
            }
        }
        TreeUtil.scrollToVisibleWithAccessibility(tree, bounds);
        return true;
    }

    private static void scrollToVisibleWithAccessibility(@NotNull JTree tree, @NotNull Rectangle bounds) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(220);
        }
        if (bounds == null) {
            TreeUtil.$$$reportNull$$$0(221);
        }
        tree.scrollRectToVisible(bounds);
        AccessibleContext context = tree.getAccessibleContext();
        if (context != null) {
            context.firePropertyChange("AccessibleVisibleData", false, true);
        }
    }

    @NotNull
    public static Promise<TreePath> promiseSelectFirst(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(222);
        }
        return TreeUtil.promiseSelect(tree, (TreePath path2) -> TreeUtil.isHiddenRoot(tree, path2) ? TreeVisitor.Action.CONTINUE : TreeVisitor.Action.INTERRUPT);
    }

    private static boolean isHiddenRoot(@NotNull JTree tree, @NotNull TreePath path2) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(223);
        }
        if (path2 == null) {
            TreeUtil.$$$reportNull$$$0(224);
        }
        return !tree.isRootVisible() && path2.getParentPath() == null;
    }

    @NotNull
    public static Promise<TreePath> promiseSelectFirstLeaf(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(225);
        }
        AtomicReference reference = new AtomicReference();
        AsyncPromise promise2 = new AsyncPromise();
        TreeUtil.promiseMakeVisible(tree, path2 -> {
            TreePath parent = reference.getAndSet(path2);
            if (TreeUtil.getPathCount(parent) == TreeUtil.getPathCount(path2.getParentPath())) {
                return TreeVisitor.Action.CONTINUE;
            }
            TreeUtil.internalSelect(tree, parent);
            promise2.setResult((Object)parent);
            return TreeVisitor.Action.INTERRUPT;
        }, promise2).onError(arg_0 -> ((AsyncPromise)promise2).setError(arg_0)).onSuccess(path2 -> {
            if (!promise2.isDone()) {
                TreePath tail = (TreePath)reference.get();
                if (tail == null || TreeUtil.isHiddenRoot(tree, tail)) {
                    promise2.cancel();
                } else {
                    TreeUtil.internalSelect(tree, tail);
                    promise2.setResult((Object)tail);
                }
            }
        });
        AsyncPromise asyncPromise = promise2;
        if (asyncPromise == null) {
            TreeUtil.$$$reportNull$$$0(226);
        }
        return asyncPromise;
    }

    private static int getPathCount(@Nullable TreePath path2) {
        return path2 == null ? 0 : path2.getPathCount();
    }

    public static void visit(@NotNull JTree tree, @NotNull TreeVisitor visitor, @NotNull Consumer<? super TreePath> consumer) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(227);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(228);
        }
        if (consumer == null) {
            TreeUtil.$$$reportNull$$$0(229);
        }
        TreeUtil.promiseVisit(tree, visitor).onSuccess(path2 -> UIUtil.invokeLaterIfNeeded(() -> consumer.accept((TreePath)path2)));
    }

    @NotNull
    public static Promise<TreePath> promiseVisit(@NotNull JTree tree, @NotNull TreeVisitor visitor) {
        TreeModel model;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(230);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(231);
        }
        if ((model = tree.getModel()) instanceof TreeVisitor.Acceptor) {
            TreeVisitor.Acceptor acceptor = (TreeVisitor.Acceptor)((Object)model);
            Promise<TreePath> promise2 = acceptor.accept(visitor);
            if (promise2 == null) {
                TreeUtil.$$$reportNull$$$0(232);
            }
            return promise2;
        }
        if (model == null) {
            Promise promise3 = Promises.rejectedPromise((String)"tree model is not set");
            if (promise3 == null) {
                TreeUtil.$$$reportNull$$$0(233);
            }
            return promise3;
        }
        AsyncPromise promise4 = new AsyncPromise();
        UIUtil.invokeLaterIfNeeded(() -> promise4.setResult((Object)TreeUtil.visitModel(model, visitor)));
        AsyncPromise asyncPromise = promise4;
        if (asyncPromise == null) {
            TreeUtil.$$$reportNull$$$0(234);
        }
        return asyncPromise;
    }

    private static TreePath visitModel(@NotNull TreeModel model, @NotNull TreeVisitor visitor) {
        Object root;
        if (model == null) {
            TreeUtil.$$$reportNull$$$0(235);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(236);
        }
        if ((root = model.getRoot()) == null) {
            return null;
        }
        TreePath path2 = new TreePath(root);
        switch (visitor.visit(path2)) {
            case INTERRUPT: {
                return path2;
            }
            case CONTINUE: {
                break;
            }
            default: {
                return null;
            }
        }
        ArrayDeque<Deque<TreePath>> stack = new ArrayDeque<Deque<TreePath>>();
        stack.push(TreeUtil.children(model, path2));
        while (path2 != null) {
            Deque siblings = (Deque)stack.peek();
            if (siblings == null) {
                return null;
            }
            TreePath next = (TreePath)siblings.poll();
            if (next == null) {
                LOG.assertTrue(siblings == stack.poll());
                path2 = path2.getParentPath();
                continue;
            }
            switch (visitor.visit(next)) {
                case INTERRUPT: {
                    return next;
                }
                case CONTINUE: {
                    path2 = next;
                    stack.push(TreeUtil.children(model, path2));
                    break;
                }
                case SKIP_SIBLINGS: {
                    siblings.clear();
                    break;
                }
            }
        }
        LOG.assertTrue(stack.isEmpty());
        return null;
    }

    @NotNull
    private static Deque<TreePath> children(@NotNull TreeModel model, @NotNull TreePath path2) {
        if (model == null) {
            TreeUtil.$$$reportNull$$$0(237);
        }
        if (path2 == null) {
            TreeUtil.$$$reportNull$$$0(238);
        }
        Object object = path2.getLastPathComponent();
        int count = model.getChildCount(object);
        ArrayDeque<TreePath> deque = new ArrayDeque<TreePath>(count);
        for (int i = 0; i < count; ++i) {
            deque.add(path2.pathByAddingChild(model.getChild(object, i)));
        }
        ArrayDeque<TreePath> arrayDeque = deque;
        if (arrayDeque == null) {
            TreeUtil.$$$reportNull$$$0(239);
        }
        return arrayDeque;
    }

    public static TreePath visitVisibleRows(@NotNull JTree tree, @NotNull TreeVisitor visitor) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(240);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(241);
        }
        TreePath parent = null;
        int count = tree.getRowCount();
        block6: for (int row = 0; row < count; ++row) {
            if (count != tree.getRowCount()) {
                throw new ConcurrentModificationException("tree is modified");
            }
            TreePath path2 = tree.getPathForRow(row);
            if (path2 == null) {
                throw new NullPointerException("path is not found at row " + row);
            }
            if (parent != null && parent.isDescendant(path2)) continue;
            switch (visitor.visit(path2)) {
                case INTERRUPT: {
                    return path2;
                }
                case CONTINUE: {
                    parent = null;
                    continue block6;
                }
                case SKIP_CHILDREN: {
                    parent = path2;
                    continue block6;
                }
                case SKIP_SIBLINGS: {
                    parent = path2.getParentPath();
                    if (parent != null) continue block6;
                    return null;
                }
            }
        }
        return null;
    }

    public static <T> void visitVisibleRows(@NotNull JTree tree, @NotNull Function<? super TreePath, ? extends T> mapper, @NotNull Consumer<? super T> consumer) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(242);
        }
        if (mapper == null) {
            TreeUtil.$$$reportNull$$$0(243);
        }
        if (consumer == null) {
            TreeUtil.$$$reportNull$$$0(244);
        }
        TreeUtil.visitVisibleRows(tree, path2 -> {
            Object object = mapper.apply(path2);
            if (object != null) {
                consumer.accept((Object)object);
            }
            return TreeVisitor.Action.CONTINUE;
        });
    }

    @NotNull
    private static <T> List<T> collectVisibleRows(@NotNull JTree tree, @NotNull Predicate<? super TreePath> filter, @NotNull Function<? super TreePath, ? extends T> mapper) {
        int count;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(245);
        }
        if (filter == null) {
            TreeUtil.$$$reportNull$$$0(246);
        }
        if (mapper == null) {
            TreeUtil.$$$reportNull$$$0(247);
        }
        if ((count = tree.getRowCount()) == 0) {
            List list = Collections.emptyList();
            if (list == null) {
                TreeUtil.$$$reportNull$$$0(248);
            }
            return list;
        }
        ArrayList list = new ArrayList(count);
        TreeUtil.visitVisibleRows(tree, path2 -> filter.test((TreePath)path2) ? mapper.apply((TreePath)path2) : null, list::add);
        ArrayList arrayList = list;
        if (arrayList == null) {
            TreeUtil.$$$reportNull$$$0(249);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 22: 
            case 35: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 59: 
            case 76: 
            case 78: 
            case 80: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 107: 
            case 108: 
            case 113: 
            case 122: 
            case 125: 
            case 127: 
            case 128: 
            case 142: 
            case 146: 
            case 147: 
            case 157: 
            case 179: 
            case 189: 
            case 197: 
            case 200: 
            case 213: 
            case 226: 
            case 232: 
            case 233: 
            case 234: 
            case 239: 
            case 248: 
            case 249: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 22: 
            case 35: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 59: 
            case 76: 
            case 78: 
            case 80: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 107: 
            case 108: 
            case 113: 
            case 122: 
            case 125: 
            case 127: 
            case 128: 
            case 142: 
            case 146: 
            case 147: 
            case 157: 
            case 179: 
            case 189: 
            case 197: 
            case 200: 
            case 213: 
            case 226: 
            case 232: 
            case 233: 
            case 234: 
            case 239: 
            case 248: 
            case 249: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 22: 
            case 35: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 59: 
            case 76: 
            case 78: 
            case 80: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 107: 
            case 108: 
            case 113: 
            case 122: 
            case 125: 
            case 127: 
            case 128: 
            case 142: 
            case 146: 
            case 147: 
            case 157: 
            case 179: 
            case 189: 
            case 197: 
            case 200: 
            case 213: 
            case 226: 
            case 232: 
            case 233: 
            case 234: 
            case 239: 
            case 248: 
            case 249: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/tree/TreeUtil";
                break;
            }
            case 4: 
            case 36: 
            case 51: 
            case 60: 
            case 235: 
            case 237: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 11: 
            case 21: 
            case 134: 
            case 141: 
            case 145: 
            case 243: 
            case 247: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 14: 
            case 165: 
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 136: 
            case 138: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 24: 
            case 32: 
            case 55: 
            case 56: 
            case 71: 
            case 73: 
            case 215: 
            case 217: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aRootNode";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aNode";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 28: 
            case 33: 
            case 34: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 68: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 30: 
            case 31: 
            case 106: 
            case 109: 
            case 130: 
            case 152: 
            case 181: 
            case 219: 
            case 224: 
            case 238: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 39: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToBeRemoved";
                break;
            }
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aRoot";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treePaths";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 67: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traverse";
                break;
            }
            case 116: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onDone";
                break;
            }
            case 144: 
            case 246: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 149: 
            case 150: 
            case 156: 
            case 158: 
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aTree";
                break;
            }
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aBounds";
                break;
            }
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treePoint";
                break;
            }
            case 169: 
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 170: 
            case 173: 
            case 175: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 171: 
            case 174: 
            case 177: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 176: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 183: 
            case 186: 
            case 191: 
            case 194: 
            case 196: 
            case 204: 
            case 207: 
            case 210: 
            case 228: 
            case 231: 
            case 236: 
            case 241: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 184: 
            case 192: 
            case 208: 
            case 229: 
            case 244: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 188: 
            case 199: 
            case 202: 
            case 212: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitors";
                break;
            }
            case 205: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
            case 221: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/tree/TreeUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "treeTraverser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "treePathTraverser";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "nodeChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "treeNodeTraverser";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExpandedObjects";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathFromRootTo";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "findCommonPath";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "selectFirstNode";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstNodePath";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstLeafNodePath";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "removeLastPathComponent";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicates";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "selectMaximals";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "selectPath";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "moveDown";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "moveUp";
                break;
            }
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "showAndSelect";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "listChildren";
                break;
            }
            case 122: 
            case 189: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseExpand";
                break;
            }
            case 125: 
            case 127: 
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "selectInTree";
                break;
            }
            case 142: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSelectedObjects";
                break;
            }
            case 146: 
            case 147: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
            case 157: {
                objectArray = objectArray2;
                objectArray2[1] = "getPointForSelection";
                break;
            }
            case 179: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayOrderComparator";
                break;
            }
            case 197: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseMakeVisibleOne";
                break;
            }
            case 200: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseMakeVisible";
                break;
            }
            case 213: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseSelect";
                break;
            }
            case 226: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseSelectFirstLeaf";
                break;
            }
            case 232: 
            case 233: 
            case 234: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseVisit";
                break;
            }
            case 239: {
                objectArray = objectArray2;
                objectArray2[1] = "children";
                break;
            }
            case 248: 
            case 249: {
                objectArray = objectArray2;
                objectArray2[1] = "collectVisibleRows";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "treeTraverser";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 22: 
            case 35: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 59: 
            case 76: 
            case 78: 
            case 80: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 107: 
            case 108: 
            case 113: 
            case 122: 
            case 125: 
            case 127: 
            case 128: 
            case 142: 
            case 146: 
            case 147: 
            case 157: 
            case 179: 
            case 189: 
            case 197: 
            case 200: 
            case 213: 
            case 226: 
            case 232: 
            case 233: 
            case 234: 
            case 239: 
            case 248: 
            case 249: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "treePathTraverser";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "nodeChildren";
                break;
            }
            case 8: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectExpandedPaths";
                break;
            }
            case 9: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectExpandedUserObjects";
                break;
            }
            case 10: 
            case 11: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "collectExpandedObjects";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findObjectInPath";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectSelectedObjectsOfType";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "restoreExpandedPaths";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isDescendants";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getPathFromRoot";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getPathFromRootTo";
                break;
            }
            case 36: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findNodeWithObject";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "removeSelected";
                break;
            }
            case 38: 
            case 39: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "removeLastPathComponent";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findNode";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findCommonPath";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "selectFirstNode";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getFirstNodePath";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getFirstLeafNodePath";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "areComponentsEqual";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "sortRecursively";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "sortChildren";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "addChildrenTo";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "traverse";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "traverseDepth";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "selectPaths";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "selectPath";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "moveDown";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "moveUp";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "movePageUp";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "movePageDown";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "moveHome";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "moveEnd";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "showRowCentred";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "showRowCentered";
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "showAndSelect";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedRow";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "getFirstVisibleRow";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleRowCount";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "installActions";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "copyAction";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "collapseAll";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "isAlwaysExpand";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "selectNode";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "moveSelectedRow";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "listChildren";
                break;
            }
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "expandAll";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "promiseExpandAll";
                break;
            }
            case 118: 
            case 119: 
            case 120: 
            case 182: 
            case 183: 
            case 184: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 121: 
            case 185: 
            case 186: 
            case 187: 
            case 188: {
                objectArray = objectArray;
                objectArray[2] = "promiseExpand";
                break;
            }
            case 123: 
            case 124: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "selectInTree";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "isViewable";
                break;
            }
            case 131: 
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "collectSelectedPaths";
                break;
            }
            case 132: 
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "collectSelectedUserObjects";
                break;
            }
            case 133: 
            case 134: 
            case 139: 
            case 140: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "collectSelectedObjects";
                break;
            }
            case 143: 
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "getSelection";
                break;
            }
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "unselectPath";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "getExpandControlRange";
                break;
            }
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "getDepthOffset";
                break;
            }
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "getNodeDepth";
                break;
            }
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "getNodeRowX";
                break;
            }
            case 154: 
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "isLocationInExpandControl";
                break;
            }
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "getPointForSelection";
                break;
            }
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "getPointForRow";
                break;
            }
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "getPointForPath";
                break;
            }
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "getPointForBounds";
                break;
            }
            case 161: 
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "isOverSelection";
                break;
            }
            case 163: 
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "dropSelectionButUnderPoint";
                break;
            }
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "getUserObject";
                break;
            }
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "getLastUserObject";
                break;
            }
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedPathIfOne";
                break;
            }
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "ensureSelection";
                break;
            }
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "insertNode";
                break;
            }
            case 175: 
            case 176: 
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "indexedBinarySearch";
                break;
            }
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayOrderComparator";
                break;
            }
            case 180: 
            case 181: {
                objectArray = objectArray;
                objectArray[2] = "expandPathWithDebug";
                break;
            }
            case 190: 
            case 191: 
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "makeVisible";
                break;
            }
            case 193: 
            case 194: 
            case 198: 
            case 199: 
            case 203: 
            case 204: 
            case 205: {
                objectArray = objectArray;
                objectArray[2] = "promiseMakeVisible";
                break;
            }
            case 195: 
            case 196: {
                objectArray = objectArray;
                objectArray[2] = "promiseMakeVisibleOne";
                break;
            }
            case 201: 
            case 202: {
                objectArray = objectArray;
                objectArray[2] = "promiseMakeVisibleAll";
                break;
            }
            case 206: 
            case 207: 
            case 208: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 209: 
            case 210: 
            case 211: 
            case 212: {
                objectArray = objectArray;
                objectArray[2] = "promiseSelect";
                break;
            }
            case 214: 
            case 215: 
            case 216: 
            case 217: {
                objectArray = objectArray;
                objectArray[2] = "internalSelect";
                break;
            }
            case 218: 
            case 219: {
                objectArray = objectArray;
                objectArray[2] = "scrollToVisible";
                break;
            }
            case 220: 
            case 221: {
                objectArray = objectArray;
                objectArray[2] = "scrollToVisibleWithAccessibility";
                break;
            }
            case 222: {
                objectArray = objectArray;
                objectArray[2] = "promiseSelectFirst";
                break;
            }
            case 223: 
            case 224: {
                objectArray = objectArray;
                objectArray[2] = "isHiddenRoot";
                break;
            }
            case 225: {
                objectArray = objectArray;
                objectArray[2] = "promiseSelectFirstLeaf";
                break;
            }
            case 227: 
            case 228: 
            case 229: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 230: 
            case 231: {
                objectArray = objectArray;
                objectArray[2] = "promiseVisit";
                break;
            }
            case 235: 
            case 236: {
                objectArray = objectArray;
                objectArray[2] = "visitModel";
                break;
            }
            case 237: 
            case 238: {
                objectArray = objectArray;
                objectArray[2] = "children";
                break;
            }
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: {
                objectArray = objectArray;
                objectArray[2] = "visitVisibleRows";
                break;
            }
            case 245: 
            case 246: 
            case 247: {
                objectArray = objectArray;
                objectArray[2] = "collectVisibleRows";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 22: 
            case 35: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 59: 
            case 76: 
            case 78: 
            case 80: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 107: 
            case 108: 
            case 113: 
            case 122: 
            case 125: 
            case 127: 
            case 128: 
            case 142: 
            case 146: 
            case 147: 
            case 157: 
            case 179: 
            case 189: 
            case 197: 
            case 200: 
            case 213: 
            case 226: 
            case 232: 
            case 233: 
            case 234: 
            case 239: 
            case 248: 
            case 249: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Deprecated
    @FunctionalInterface
    public static interface Traverse {
        public boolean accept(Object var1);
    }

    private static final class LazyLocationInExpandControl {
        static final Method METHOD = ReflectionUtil.getDeclaredMethod(BasicTreeUI.class, (String)"isLocationInExpandControl", (Class[])new Class[]{TreePath.class, Integer.TYPE, Integer.TYPE});

        private LazyLocationInExpandControl() {
        }
    }

    private static final class LazyRowX {
        static final Method METHOD = ReflectionUtil.getDeclaredMethod(BasicTreeUI.class, (String)"getRowX", (Class[])new Class[]{Integer.TYPE, Integer.TYPE});

        private LazyRowX() {
        }
    }
}

