/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.util;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpsPathUtil {
    public static final String UNNAMED_PROJECT = "<unnamed>";

    public static boolean isUnder(Set<File> ancestors, File file) {
        if (ancestors.isEmpty()) {
            return false;
        }
        File current = file;
        while (current != null) {
            if (ancestors.contains(current)) {
                return true;
            }
            current = FileUtilRt.getParentFile((File)current);
        }
        return false;
    }

    public static File urlToFile(String url) {
        return new File(JpsPathUtil.urlToOsPath(url));
    }

    @NotNull
    public static String urlToOsPath(@NotNull String url) {
        if (url == null) {
            JpsPathUtil.$$$reportNull$$$0(0);
        }
        String string = FileUtilRt.toSystemDependentName((String)JpsPathUtil.urlToPath(url));
        if (string == null) {
            JpsPathUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Contract(value="null -> null; !null -> !null")
    public static String urlToPath(@Nullable String url) {
        if (url == null) {
            return null;
        }
        if (url.startsWith("file://")) {
            return url.substring("file://".length());
        }
        if (url.startsWith("jar://")) {
            url = url.substring("jar://".length());
            url = StringUtil.trimEnd((String)url, (String)"!/");
        }
        return url;
    }

    @NotNull
    public static String fixURLforIDEA(@NotNull String url) {
        int idx;
        if (url == null) {
            JpsPathUtil.$$$reportNull$$$0(2);
        }
        if ((idx = url.indexOf(":/")) >= 0 && idx + 2 < url.length() && url.charAt(idx + 2) != '/') {
            String prefix = url.substring(0, idx);
            String suffix = url.substring(idx + 2);
            url = SystemInfo.isWindows ? prefix + "://" + suffix : prefix + ":///" + suffix;
        }
        String string = url;
        if (string == null) {
            JpsPathUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static String pathToUrl(String path2) {
        return "file://" + path2;
    }

    public static String getLibraryRootUrl(File file) {
        String path2 = FileUtilRt.toSystemIndependentName((String)file.getAbsolutePath());
        return file.isDirectory() ? "file://" + path2 : "jar://" + path2 + "!/";
    }

    public static boolean isJrtUrl(@NotNull String url) {
        if (url == null) {
            JpsPathUtil.$$$reportNull$$$0(4);
        }
        return url.startsWith("jrt://");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String readProjectName(@NotNull Path projectDir) {
        if (projectDir == null) {
            JpsPathUtil.$$$reportNull$$$0(5);
        }
        try (Stream<String> stream = Files.lines(projectDir.resolve(".name"));){
            String string = stream.findFirst().map(String::trim).orElse(null);
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    public static String getDefaultProjectName(@NotNull Path projectDir) {
        Path parent;
        if (projectDir == null) {
            JpsPathUtil.$$$reportNull$$$0(6);
        }
        if ((parent = projectDir.getParent()) != null) {
            Path name = parent.getFileName();
            String string = name != null ? name.toString() : parent.toString();
            if (string == null) {
                JpsPathUtil.$$$reportNull$$$0(7);
            }
            return string;
        }
        return UNNAMED_PROJECT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/util/JpsPathUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/util/JpsPathUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "urlToOsPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fixURLforIDEA";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProjectName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "urlToOsPath";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fixURLforIDEA";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isJrtUrl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readProjectName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultProjectName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

