/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class InspectionCommand
extends AbstractCommand {
    public static final String PREFIX = "%inspectCode";
    private final Project myProject;

    public InspectionCommand(@NotNull String text, int line, @NotNull Project project) {
        if (text == null) {
            InspectionCommand.$$$reportNull$$$0(0);
        }
        if (project == null) {
            InspectionCommand.$$$reportNull$$$0(1);
        }
        super(text, line);
        this.myProject = project;
    }

    @NotNull
    protected Promise<Object> _execute(final @NotNull PlaybackContext context) {
        AnalysisScope scope;
        if (context == null) {
            InspectionCommand.$$$reportNull$$$0(2);
        }
        final ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String extension = this.getText().substring(PREFIX.length()).trim();
        InspectionManagerEx inspectionManagerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)this.myProject);
        GlobalInspectionContextImpl inspectionContext = new GlobalInspectionContextImpl(this.myProject, inspectionManagerEx.getContentManager()){

            protected void notifyInspectionsFinished(@NotNull AnalysisScope scope) {
                if (scope == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.notifyInspectionsFinished(scope);
                context.message(PerformanceTestingBundle.message("command.inspection.finish", new Object[0]), InspectionCommand.this.getLine());
                actionCallback.setDone();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/performancePlugin/commands/InspectionCommand$1", "notifyInspectionsFinished"));
            }
        };
        if (extension.isEmpty()) {
            scope = new AnalysisScope(this.myProject);
        } else {
            Collection<VirtualFile> files = this.getFiles(extension);
            if (files.isEmpty()) {
                context.message(PerformanceTestingBundle.message("command.inspection.extension", new Object[0]) + " " + extension, this.getLine());
            }
            scope = new AnalysisScope(this.myProject, this.getFiles(extension));
        }
        inspectionContext.doInspections(scope);
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            InspectionCommand.$$$reportNull$$$0(3);
        }
        return promise;
    }

    @NotNull
    private Collection<VirtualFile> getFiles(@NotNull String extension) {
        if (extension == null) {
            InspectionCommand.$$$reportNull$$$0(4);
        }
        HashSet<VirtualFile> files = new HashSet<VirtualFile>(100);
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        index.iterateContent(fileOrDir -> {
            if (StringUtil.equals((CharSequence)fileOrDir.getExtension(), (CharSequence)extension)) {
                files.add(fileOrDir);
            }
            return true;
        });
        HashSet<VirtualFile> hashSet = files;
        if (hashSet == null) {
            InspectionCommand.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/InspectionCommand";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/InspectionCommand";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

