/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class StoreIndices
extends AbstractCommand {
    public static final String PREFIX = "%storeIndices";
    public static Path storedIndex;

    public StoreIndices(String text, int line) {
        super(text, line);
    }

    public static Path getStoredIndex() throws IOException {
        if (storedIndex == null) {
            storedIndex = System.getProperty("performance.out.folder") != null ? Paths.get(System.getProperty("performance.out.folder"), new String[0]) : FileUtil.createTempDirectory((String)"stored_index", null).toPath();
        }
        return storedIndex;
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        ((FileBasedIndexImpl)FileBasedIndex.getInstance()).flushIndexes();
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        File indexDir = IndexInfrastructure.getIndexRootDir((ID)ID.findByName((String)"Stubs")).getParentFile();
        try {
            FileUtil.delete((Path)StoreIndices.getStoredIndex());
            FileUtil.copyDir((File)indexDir, (File)StoreIndices.getStoredIndex().toFile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        actionCallback.setDone();
        return Promises.toPromise((ActionCallback)actionCallback);
    }
}

