/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.tracing.actions;

import com.intellij.ide.actions.EditCustomSettingsAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessExtension;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.performancePlugin.tracing.MethodTracing;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureMethodTracingAction
extends EditCustomSettingsAction {
    public ConfigureMethodTracingAction() {
        this.getTemplatePresentation().setEnabledAndVisible(ApplicationManager.getApplication().isInternal());
    }

    @Nullable
    protected File file() {
        return MethodTracing.configFile();
    }

    @NotNull
    protected String template() {
        return "# Only classes from platform or plugin classloaders will be instrumented.\n# Instrumentation may be applied several times in the same run, but to revert it restart or hot-swap is required.\n#\n# To apply instrumentation on application loading set system property\n# internal.method.tracing.on.load=true\n#\n# Method and class name should be separated by '#' or '.'.\n# Pattern may contain asterisks to match arbitrary prefix or suffix of a class or method name.\n#\n# Note that broad patterns may freeze IDE during instrumentation.\n# Very generic patterns may cause JVM crash by hitting limits of native memory.\n#\n# Examples of patterns:\n#\n# com.intellij.psi.impl.source.*.getText\n# com.intellij.psi.impl.PsiImplUtil#*";
    }

    private static class AccessExtension
    implements NonProjectFileWritingAccessExtension {
        private AccessExtension() {
        }

        public boolean isWritable(@NotNull VirtualFile file) {
            if (file == null) {
                AccessExtension.$$$reportNull$$$0(0);
            }
            return FileUtil.pathsEqual((String)file.getPath(), (String)MethodTracing.configFile().getPath());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/performancePlugin/tracing/actions/ConfigureMethodTracingAction$AccessExtension", "isWritable"));
        }
    }
}

