/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.lang.IJPerfFileType;
import com.jetbrains.performancePlugin.profilers.AsyncProfilerHandler;
import com.jetbrains.performancePlugin.profilers.ProfilersController;
import com.jetbrains.performancePlugin.profilers.YourKitProfilerHandler;
import com.jetbrains.performancePlugin.utils.ScriptRunner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecuteScriptDialog
extends DialogWrapper {
    private final Project project;
    private EditorTextField scriptText;
    private JPanel myMainPanel;
    private JBRadioButton myChooseAsyncProfilerButton;
    private JBRadioButton myChooseYourKitProfilerButton;
    private HyperlinkLabel warningLabel;
    private ComboBox<Scenario> scenarioComboBox;
    private static String lastUsedText = null;
    private final ScriptRunner myScriptRunner;
    private final Action execute;

    public ExecuteScriptDialog(final @NotNull Project project) {
        if (project == null) {
            ExecuteScriptDialog.$$$reportNull$$$0(0);
        }
        super(project);
        this.project = project;
        this.$$$setupUI$$$();
        this.myScriptRunner = new ScriptRunner();
        this.execute = this.createExecuteAction();
        this.setTitle(PerformanceTestingBundle.message("executor.title", new Object[0]));
        this.scenarioComboBox.addItem((Object)new Scenario(PerformanceTestingBundle.message("typing.scenario", new Object[0]), ExecuteScriptDialog.generateTestScript(PerformanceScriptType.TYPING)));
        this.scenarioComboBox.addItem((Object)new Scenario(PerformanceTestingBundle.message("formatting.scenario", new Object[0]), ExecuteScriptDialog.generateTestScript(PerformanceScriptType.FORMATTING)));
        this.scenarioComboBox.addItem((Object)new Scenario(PerformanceTestingBundle.message("local.inspection.scenario", new Object[0]), ExecuteScriptDialog.generateTestScript(PerformanceScriptType.INSPECTION)));
        ButtonGroup profilerSelectors = new ButtonGroup();
        profilerSelectors.add((AbstractButton)this.myChooseYourKitProfilerButton);
        profilerSelectors.add((AbstractButton)this.myChooseAsyncProfilerButton);
        ProfilerItemListener profilerItemListener = new ProfilerItemListener();
        this.myChooseYourKitProfilerButton.addItemListener((ItemListener)profilerItemListener);
        this.myChooseAsyncProfilerButton.addItemListener((ItemListener)profilerItemListener);
        this.scenarioComboBox.setEditable(false);
        this.scenarioComboBox.setSelectedIndex(0);
        this.scenarioComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Scenario item = (Scenario)e.getItem();
                ExecuteScriptDialog.this.updateWarningLabel();
                ExecuteScriptDialog.this.scriptText.setText(ExecuteScriptDialog.getCurrentFileCommand(project) + item.getScript());
                ExecuteScriptDialog.this.updateExecuteButtonState();
            }
        });
        if (SystemInfo.isWindows) {
            this.myChooseAsyncProfilerButton.setEnabled(false);
        }
        if (!YourKitProfilerHandler.hasValidController() && !YourKitProfilerHandler.canProfilerBeAttached()) {
            this.myChooseYourKitProfilerButton.setEnabled(false);
            this.myChooseAsyncProfilerButton.setSelected(true);
        } else {
            this.myChooseYourKitProfilerButton.setSelected(true);
        }
        this.setSelectedProfiler();
        this.updateExecuteButtonState();
        this.init();
    }

    private void updateExecuteButtonState() {
        this.execute.setEnabled(!this.scriptText.getText().contains("%startProfile") || !ProfilersController.getInstance().isProfilingStarted());
    }

    private void setSelectedProfiler() {
        if (this.myChooseAsyncProfilerButton.isSelected()) {
            ProfilersController.getInstance().setCurrentProfiler(AsyncProfilerHandler.getInstance());
        } else {
            ProfilersController.getInstance().setCurrentProfiler(YourKitProfilerHandler.getInstance());
        }
    }

    private void createUIComponents() {
        this.scriptText = new EditorTextField(this.project, (FileType)IJPerfFileType.INSTANCE);
        this.scriptText.setOneLineMode(false);
        this.scriptText.setText(lastUsedText != null ? lastUsedText : ExecuteScriptDialog.getCurrentFileCommand(this.project) + ExecuteScriptDialog.generateTestScript(PerformanceScriptType.TYPING));
        this.scriptText.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                ExecuteScriptDialog.this.updateWarningLabel();
                ExecuteScriptDialog.this.updateExecuteButtonState();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/performancePlugin/ui/ExecuteScriptDialog$2", "documentChanged"));
            }
        });
    }

    private static String getCurrentFileCommand(Project project) {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        String openFileCommand = "";
        VirtualFile[] openFiles = fileEditorManager.getSelectedFiles();
        if (openFiles.length != 0) {
            openFileCommand = "%openFile " + openFiles[0].getCanonicalPath() + '\n';
        }
        return openFileCommand;
    }

    @NotNull
    @Contract(pure=true)
    private static String generateTestScript(@NotNull PerformanceScriptType scriptType) {
        String scriptText;
        if (scriptType == null) {
            ExecuteScriptDialog.$$$reportNull$$$0(1);
        }
        String startProfileCommand = "%startProfile " + scriptType.name();
        String stopProfileCommand = "%stopProfile";
        switch (scriptType) {
            case TYPING: {
                scriptText = "%delayType 150|Sample text for typing scenario\n%pressKey ENTER\n%delayType 150|Sample text for typing scenario\n%pressKey ENTER\n%delayType 150|Sample text for typing scenario";
                break;
            }
            case FORMATTING: {
                scriptText = "%reformat";
                break;
            }
            case INSPECTION: {
                scriptText = "%doLocalInspection\n%doLocalInspection\n%doLocalInspection";
                break;
            }
            default: {
                scriptText = "";
            }
        }
        String string = startProfileCommand + "\n" + scriptText + "\n" + stopProfileCommand;
        if (string == null) {
            ExecuteScriptDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    private void updateWarningLabel() {
        this.scriptText.setEnabled(true);
        this.warningLabel.setVisible(false);
        if (ProfilersController.getInstance().isProfilingStarted() && this.scriptText.getText().contains("%startProfile")) {
            this.warningLabel.setText(PerformanceTestingBundle.message("executor.started", new Object[0]));
            this.warningLabel.setVisible(true);
        }
        this.myMainPanel.repaint();
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.execute, this.getCancelAction()};
        if (actionArray == null) {
            ExecuteScriptDialog.$$$reportNull$$$0(3);
        }
        return actionArray;
    }

    private Action createExecuteAction() {
        return new DialogWrapper.DialogWrapperAction(PerformanceTestingBundle.message("execute.script.button", new Object[0])){

            protected void doAction(ActionEvent e) {
                lastUsedText = ExecuteScriptDialog.this.scriptText.getText();
                ProfilersController.getInstance().setStoppedByScript(false);
                ExecuteScriptDialog.this.doOKAction();
                ExecuteScriptDialog.this.myScriptRunner.doRunScript(ExecuteScriptDialog.this.project, ExecuteScriptDialog.this.scriptText.getText(), null);
            }
        };
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.scriptText;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        ComboBox comboBox;
        HyperlinkLabel hyperlinkLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.warningLabel = hyperlinkLabel = new HyperlinkLabel();
        hyperlinkLabel.setEnabled(true);
        hyperlinkLabel.setForeground(new Color(-4521981));
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.scenarioComboBox = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PerformanceTestingBundle", ExecuteScriptDialog.class).getString("select.scenario"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myChooseYourKitProfilerButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setLabel(ResourceBundle.getBundle("messages/PerformanceTestingBundle").getString("yourkit.profiler.radio.button.label"));
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton2, DynamicBundle.getBundle((String)"messages/PerformanceTestingBundle", ExecuteScriptDialog.class).getString("yourkit.profiler.radio.button.label"));
        jBRadioButton2.setToolTipText(ResourceBundle.getBundle("messages/PerformanceTestingBundle").getString("yourkit.profiler.radio.button.label"));
        jPanel.add((Component)jBRadioButton2, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        EditorTextField editorTextField = this.scriptText;
        jBScrollPane.setViewportView((Component)editorTextField);
        this.myChooseAsyncProfilerButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setLabel(ResourceBundle.getBundle("messages/PerformanceTestingBundle").getString("async.profiler.radio.button.label"));
        jBRadioButton.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, DynamicBundle.getBundle((String)"messages/PerformanceTestingBundle", ExecuteScriptDialog.class).getString("async.profiler.radio.button.label"));
        jBRadioButton.setToolTipText(ResourceBundle.getBundle("messages/PerformanceTestingBundle").getString("async.profiler.radio.button.label"));
        jPanel.add((Component)jBRadioButton, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(164, 19), null));
        jBLabel.setLabelFor((Component)comboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/ui/ExecuteScriptDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/ui/ExecuteScriptDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateTestScript";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "generateTestScript";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ProfilerItemListener
    implements ItemListener {
        private ProfilerItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ExecuteScriptDialog.this.setSelectedProfiler();
                ExecuteScriptDialog.this.updateWarningLabel();
            }
        }
    }

    static class Scenario {
        private final String myName;
        private final String myScript;

        Scenario(String name, String script) {
            this.myName = name;
            this.myScript = script;
        }

        public String toString() {
            return this.myName;
        }

        public String getScript() {
            return this.myScript;
        }
    }

    private static enum PerformanceScriptType {
        TYPING,
        FORMATTING,
        INSPECTION;

    }
}

