/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.jdbc.dialects;

import com.intellij.database.remote.jdba.Rdbms;
import com.intellij.database.remote.jdba.core.ConnectionInfo;
import com.intellij.database.remote.jdba.intermediate.DBExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateSession;
import com.intellij.database.remote.jdba.jdbc.dialects.ClickHouse;
import com.intellij.database.remote.jdba.util.Version;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CHouseIntermediateFacade
extends JdbcIntermediateFacade {
    private static final Pattern CHOUSE_VERSION_PATTERN = Pattern.compile("(\\d{1,2}(\\.\\d{1,10}){1,5})");
    private static final String CONNECTION_INFO_QUERY = "select currentDatabase(), version()";

    public CHouseIntermediateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, @NotNull Driver driver, int connectionsLimit, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        if (connectionString == null) {
            CHouseIntermediateFacade.$$$reportNull$$$0(0);
        }
        if (driver == null) {
            CHouseIntermediateFacade.$$$reportNull$$$0(1);
        }
        if (exceptionRecognizer == null) {
            CHouseIntermediateFacade.$$$reportNull$$$0(2);
        }
        super(connectionString, connectionProperties, driver, connectionsLimit, exceptionRecognizer);
    }

    public CHouseIntermediateFacade(@NotNull DataSource dataSource, int connectionsLimit, boolean ownConnections, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        if (dataSource == null) {
            CHouseIntermediateFacade.$$$reportNull$$$0(3);
        }
        if (exceptionRecognizer == null) {
            CHouseIntermediateFacade.$$$reportNull$$$0(4);
        }
        super(dataSource, connectionsLimit, ownConnections, exceptionRecognizer);
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        Rdbms rdbms = ClickHouse.RDBMS;
        if (rdbms == null) {
            CHouseIntermediateFacade.$$$reportNull$$$0(5);
        }
        return rdbms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionInfo obtainConnectionInfoNatively() {
        String driverVersionStr;
        String rdbmsName;
        String[] env;
        JdbcIntermediateSession session = this.openSession();
        try {
            env = session.queryOneRow(CONNECTION_INFO_QUERY, 2, String.class);
            try {
                DatabaseMetaData md = session.getConnection().getMetaData();
                rdbmsName = md.getDatabaseProductName();
                if (rdbmsName == null) {
                    rdbmsName = session.getConnection().getClass().getName();
                }
                driverVersionStr = md.getDriverVersion();
            }
            catch (SQLException sqle) {
                throw this.getExceptionRecognizer().recognizeException(sqle, "getting versions using JDBC metadata");
            }
        }
        finally {
            session.close();
        }
        Version driverVersion = CHouseIntermediateFacade.extractVersion(driverVersionStr, CHOUSE_VERSION_PATTERN, 1);
        if (env != null) {
            assert (env.length == 2);
            String serverVersionStr = env[1];
            Version serverVersion = CHouseIntermediateFacade.extractVersion(serverVersionStr, CHOUSE_VERSION_PATTERN, 1);
            return new ConnectionInfo(rdbmsName, null, env[0], null, serverVersion, driverVersion);
        }
        return new ConnectionInfo(rdbmsName, null, null, null, Version.ZERO, driverVersion);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionRecognizer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdba/jdbc/dialects/CHouseIntermediateFacade";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdba/jdbc/dialects/CHouseIntermediateFacade";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "rdbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

