/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.Rdbms;
import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.FileBlob;
import com.intellij.database.remote.jdbc.impl.FileClob;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HiveJdbcHelper
extends JdbcHelperImpl {
    private static final Set<String> typesWithScale = new HashSet<String>(Arrays.asList("decimal", "varchar", "char", "numeric"));

    public HiveJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super(Rdbms.of("HIVE"), version, connection);
    }

    public HiveJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return HiveJdbcHelper.extractVersion(version);
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public boolean supportsEscape() {
        return false;
    }

    @Override
    @Nullable
    public final JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer) {
        if (!JdbcNativeUtil.detectString(product, "Hive")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return HiveJdbcHelper.create(delegate, productVer);
    }

    @NotNull
    private static JdbcHelperImpl create(@Nullable Connection delegate, @Nullable String productVer) {
        JdbcNativeUtil.logInfo("release_version: " + productVer);
        return new HiveJdbcHelper(HiveJdbcHelper.extractVersion(productVer), delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    public boolean supportsCalendarInPreparedStatement() {
        return false;
    }

    @Override
    @NotNull
    public String getDbmsName() {
        return "HIVE";
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            HiveJdbcHelper.$$$reportNull$$$0(0);
        }
        e.typeName = e.typeName.toLowerCase(Locale.ENGLISH);
        if (!typesWithScale.contains(e.typeName)) {
            e.scale = -1;
            e.length = -1;
        }
    }

    @Override
    public String fixColumnLabel(String columnLabel) {
        int dotPos = columnLabel.indexOf(46);
        if (dotPos == -1) {
            return columnLabel;
        }
        return columnLabel.substring(dotPos + 1);
    }

    @Override
    protected void setTimestamp(@NotNull RemotePreparedStatement statement, int idx, Timestamp timestamp) throws Exception {
        if (statement == null) {
            HiveJdbcHelper.$$$reportNull$$$0(1);
        }
        statement.setTimestamp(idx, timestamp);
    }

    @Override
    public void setStatementParameter(@NotNull RemotePreparedStatement statement, @Nullable Object value, @NotNull ColumnInfo columnInfo, boolean needsEscaping, int idx) throws Exception {
        if (statement == null) {
            HiveJdbcHelper.$$$reportNull$$$0(2);
        }
        if (columnInfo == null) {
            HiveJdbcHelper.$$$reportNull$$$0(3);
        }
        int type = columnInfo.getType();
        if (value == null) {
            statement.setNull(idx, type);
        } else if (value instanceof LobInfo.FileBlobInfo) {
            LobInfo.FileBlobInfo info = (LobInfo.FileBlobInfo)value;
            statement.setObject(idx, new FileBlob(info.file));
        } else if (value instanceof LobInfo.FileClobInfo) {
            LobInfo.FileClobInfo info = (LobInfo.FileClobInfo)value;
            statement.setObject(idx, new FileClob(info.file, info.charset));
        } else if (value instanceof LobInfo.BlobInfo) {
            statement.setObject(idx, ((LobInfo.BlobInfo)value).data);
        } else if (value instanceof byte[]) {
            statement.setBinaryStream(idx, new ByteArrayInputStream((byte[])value));
        } else if (type == -5 && value instanceof BigInteger) {
            statement.setObject(idx, value);
        } else {
            super.setStatementParameter(statement, value, columnInfo, needsEscaping, idx);
        }
    }

    @Override
    public int getType(@NotNull ResultSet delegate) {
        if (delegate == null) {
            HiveJdbcHelper.$$$reportNull$$$0(4);
        }
        return 1003;
    }

    @Override
    public char getEscapeChar() {
        return '\\';
    }

    @Override
    @NotNull
    protected String getCharsToEscape() {
        return "%_\\";
    }

    @Override
    public int fixUpdateCount(int update) {
        if (update == 0) {
            return -2;
        }
        return update;
    }

    @Override
    protected Object fixRowObject(Object object, ResultSetMetaData metaData, int i) throws SQLException {
        if (metaData.getColumnType(i) == 6 && object instanceof Double) {
            return Float.valueOf(((Double)object).floatValue());
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/HiveJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setTimestamp";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setStatementParameter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

