/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.remote.jdbc.helpers.MysqlBaseJdbcHelper;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.util.ArrayUtilRt;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MariaJdbcHelper
extends MysqlBaseJdbcHelper {
    private static final Pattern MYSQL_PREFIXED_VERSION_PATTERN = Pattern.compile("(?:\\d+(?:\\.\\d+)+)-(\\d+(?:\\.\\d+)+)");

    public MariaJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("MariaDB", version, connection);
    }

    public MariaJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return MariaJdbcHelper.extractVersion(version);
    }

    @Override
    public int getRow(@NotNull ResultSet rs) throws SQLException {
        Object pointer;
        if (rs == null) {
            MariaJdbcHelper.$$$reportNull$$$0(0);
        }
        if ((pointer = ReflectionHelper.tryInvokeMethod(rs, "getRowPointer", ArrayUtilRt.EMPTY_CLASS_ARRAY, ArrayUtilRt.EMPTY_OBJECT_ARRAY)) instanceof Integer) {
            return (Integer)pointer + 1;
        }
        return super.getRow(rs);
    }

    @Override
    protected void enableSsl(@NotNull Driver driver, @NotNull Properties properties, @NotNull JdbcSettings.SslMode sslMode) {
        if (driver == null) {
            MariaJdbcHelper.$$$reportNull$$$0(1);
        }
        if (properties == null) {
            MariaJdbcHelper.$$$reportNull$$$0(2);
        }
        if (sslMode == null) {
            MariaJdbcHelper.$$$reportNull$$$0(3);
        }
        MariaJdbcHelper.setIfEmpty(properties, "useSsl", "true");
        if (sslMode == JdbcSettings.SslMode.VERIFY_FULL) {
            MariaJdbcHelper.setIfEmpty(properties, "disableSslHostnameVerification", "false");
            MariaJdbcHelper.setIfEmpty(properties, "trustServerCertificate", "false");
        } else if (sslMode == JdbcSettings.SslMode.VERIFY_CA) {
            MariaJdbcHelper.setIfEmpty(properties, "disableSslHostnameVerification", "true");
            MariaJdbcHelper.setIfEmpty(properties, "trustServerCertificate", "false");
        } else {
            MariaJdbcHelper.setIfEmpty(properties, "disableSslHostnameVerification", "true");
            MariaJdbcHelper.setIfEmpty(properties, "trustServerCertificate", "true");
        }
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            MariaJdbcHelper.$$$reportNull$$$0(4);
        }
        return MariaJdbcHelper.classNameContains(driver, "maria");
    }

    @NotNull
    protected static MariaJdbcHelper create(@Nullable Connection delegate, @Nullable String versionStr) {
        String version = MariaJdbcHelper.extractVersion(versionStr);
        return new MariaJdbcHelper(version, delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        String res = JdbcNativeUtil.findVersion(str, MYSQL_PREFIXED_VERSION_PATTERN);
        if (res == null) {
            res = JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
        }
        return res;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rs";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sslMode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/MariaJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getRow";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "enableSsl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "detect";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

