/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.Rdbms;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MongoJdbcHelper
extends JdbcHelperImpl {
    public static final String DOUBLE_TYPE = "double";
    public static final String STRING_TYPE = "string";
    public static final String OBJECT_TYPE = "object";
    public static final String ARRAY_TYPE = "array";
    public static final String BINARY_DATA_TYPE = "binData";
    public static final String UNDEFINED_TYPE = "undefined";
    public static final String OBJECT_ID_TYPE = "objectId";
    public static final String BOOLEAN_TYPE = "bool";
    public static final String DATE_TYPE = "date";
    public static final String NULL_TYPE = "null";
    public static final String REGEX_TYPE = "regex";
    public static final String DB_POINTER_TYPE = "dbPointer";
    public static final String JS_TYPE = "javascript";
    public static final String SYMBOL_TYPE = "symbol";
    public static final String JS_WITH_SCOPE = "javascriptWithScope";
    public static final String INT_TYPE = "int";
    public static final String TIMESTAMP_TYPE = "timestamp";
    public static final String LONG_TYPE = "long";
    public static final String DECIMAL_TYPE = "decimal";
    public static final String MIN_KEY_TYPE = "minKey";
    public static final String MAX_KEY_TYPE = "maxKey";
    public static final String UNKNOWN_TYPE = "unknown";

    public MongoJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super(Rdbms.of("MONGO"), version, connection);
    }

    public MongoJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return MongoJdbcHelper.extractVersion(version);
    }

    @Override
    @Nullable
    public final JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer) throws Exception {
        if (!JdbcNativeUtil.detectString(product, "Mongo DB")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return MongoJdbcHelper.create(delegate, productVer);
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            MongoJdbcHelper.$$$reportNull$$$0(0);
        }
        return MongoJdbcHelper.classNameContains(driver, "Mongo");
    }

    @NotNull
    private static JdbcHelperImpl create(@Nullable Connection delegate, @Nullable String productVer) throws Exception {
        String versionStr = delegate == null ? productVer : JdbcNativeUtil.getString(delegate, "db.version()");
        JdbcNativeUtil.logInfo("release_version: " + productVer);
        return new MongoJdbcHelper(MongoJdbcHelper.extractVersion(versionStr), delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    protected void enableSsl(@NotNull Driver driver, @NotNull Properties properties, @NotNull JdbcSettings.SslMode sslMode) {
        if (driver == null) {
            MongoJdbcHelper.$$$reportNull$$$0(1);
        }
        if (properties == null) {
            MongoJdbcHelper.$$$reportNull$$$0(2);
        }
        if (sslMode == null) {
            MongoJdbcHelper.$$$reportNull$$$0(3);
        }
        properties.setProperty("ssl", "true");
    }

    @Override
    public Object wrapIfNeeded(@NotNull JdbcRemoteObject exporter, Object o) throws RemoteException, SQLException {
        if (exporter == null) {
            MongoJdbcHelper.$$$reportNull$$$0(4);
        }
        if (o == null) {
            return null;
        }
        String className = o.getClass().getName();
        if (className.equals(MongoObjectIdValue.CLASS_NAME)) {
            return new MongoObjectIdValue(o.toString());
        }
        if (className.equals(MongoDecimalValue.CLASS_NAME)) {
            return new MongoDecimalValue(o.toString());
        }
        if (className.equals(MongoMaxKeyValue.CLASS_NAME)) {
            return new MongoMaxKeyValue();
        }
        if (className.equals(MongoMinKeyValue.CLASS_NAME)) {
            return new MongoMinKeyValue();
        }
        if (className.equals(MongoTimestampValue.CLASS_NAME)) {
            return new MongoTimestampValue(o);
        }
        if (className.equals(MongoRegexpValue.CLASS_NAME)) {
            return new MongoRegexpValue(o);
        }
        return super.wrapIfNeeded(exporter, o);
    }

    @NotNull
    public static String getTypeName(@Nullable Object o) {
        if (o instanceof MongoValue) {
            String string = ((MongoValue)o).typeName();
            if (string == null) {
                MongoJdbcHelper.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (o instanceof Date) {
            return DATE_TYPE;
        }
        if (o instanceof String) {
            return STRING_TYPE;
        }
        if (o instanceof List) {
            return ARRAY_TYPE;
        }
        if (o instanceof Map) {
            return OBJECT_TYPE;
        }
        if (o instanceof Double) {
            return DOUBLE_TYPE;
        }
        if (o instanceof Integer) {
            return INT_TYPE;
        }
        if (o instanceof Long) {
            return LONG_TYPE;
        }
        if (o instanceof Boolean) {
            return BOOLEAN_TYPE;
        }
        if (o == null) {
            return NULL_TYPE;
        }
        return UNKNOWN_TYPE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sslMode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exporter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/MongoJdbcHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/MongoJdbcHelper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "enableSsl";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "wrapIfNeeded";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MongoRegexpValue
    implements MongoValue {
        static String CLASS_NAME = "org.bson.BsonRegularExpression";
        private static Method myGetPattern;
        private static Method myGetOptions;
        public final String pattern;
        public final String options;
        private final Map<String, String> map;

        public MongoRegexpValue(String pattern, String options) {
            this.map = new HashMap<String, String>();
            this.pattern = pattern;
            this.options = options;
            this.map.put("pattern", this.pattern);
            this.map.put("options", this.options);
        }

        MongoRegexpValue(@NotNull Object o) {
            if (o == null) {
                MongoRegexpValue.$$$reportNull$$$0(0);
            }
            this.map = new HashMap<String, String>();
            if (myGetPattern == null) {
                try {
                    Class<?> aClass = Class.forName(CLASS_NAME);
                    myGetPattern = aClass.getMethod("getPattern", new Class[0]);
                    myGetOptions = aClass.getMethod("getOptions", new Class[0]);
                }
                catch (ClassNotFoundException aClass) {
                }
                catch (NoSuchMethodException aClass) {
                    // empty catch block
                }
            }
            String pattern = "";
            String options = "";
            if (myGetPattern != null && myGetOptions != null) {
                try {
                    Object optionsObject;
                    Object patternObject = myGetPattern.invoke(o, new Object[0]);
                    if (patternObject instanceof String) {
                        pattern = (String)patternObject;
                    }
                    if ((optionsObject = myGetOptions.invoke(o, new Object[0])) instanceof String) {
                        options = (String)optionsObject;
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            this.pattern = pattern;
            this.options = options;
            this.map.put("pattern", this.pattern);
            this.map.put("options", this.options);
        }

        @Override
        public String typeName() {
            return MongoJdbcHelper.REGEX_TYPE;
        }

        @Override
        @Nullable
        public Object unwrap() {
            return this.map;
        }

        @Override
        public String jsonTypeName() {
            return "regularExpression";
        }

        @Override
        @NotNull
        public String className() {
            String string = CLASS_NAME;
            if (string == null) {
                MongoRegexpValue.$$$reportNull$$$0(1);
            }
            return string;
        }

        public String toString() {
            return "{\"pattern\": \"" + this.pattern + "\", \"options\": \"" + this.options + "\"";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/MongoJdbcHelper$MongoRegexpValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/MongoJdbcHelper$MongoRegexpValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "className";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class MongoTimestampValue
    implements MongoValue {
        static String CLASS_NAME = "org.bson.BsonTimestamp";
        private static Method myGetTime;
        private static Method myGetInc;
        public final int time;
        public final int inc;
        private final Map<String, Integer> map;

        public MongoTimestampValue(int time, int inc) {
            this.map = new HashMap<String, Integer>();
            this.time = time;
            this.inc = inc;
            this.map.put("t", this.time);
            this.map.put("i", this.inc);
        }

        MongoTimestampValue(@NotNull Object o) {
            if (o == null) {
                MongoTimestampValue.$$$reportNull$$$0(0);
            }
            this.map = new HashMap<String, Integer>();
            if (myGetTime == null) {
                try {
                    Class<?> aClass = Class.forName(CLASS_NAME);
                    myGetTime = aClass.getMethod("getTime", new Class[0]);
                    myGetInc = aClass.getMethod("getInc", new Class[0]);
                }
                catch (ClassNotFoundException aClass) {
                }
                catch (NoSuchMethodException aClass) {
                    // empty catch block
                }
            }
            int time = 0;
            int inc = 0;
            if (myGetTime != null && myGetInc != null) {
                try {
                    Object incObject;
                    Object timeObject = myGetTime.invoke(o, new Object[0]);
                    if (timeObject instanceof Integer) {
                        time = (Integer)timeObject;
                    }
                    if ((incObject = myGetInc.invoke(o, new Object[0])) instanceof Integer) {
                        inc = (Integer)incObject;
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            this.time = time;
            this.inc = inc;
            this.map.put("t", this.time);
            this.map.put("i", this.inc);
        }

        @Override
        public String typeName() {
            return MongoJdbcHelper.TIMESTAMP_TYPE;
        }

        @Override
        @Nullable
        public Object unwrap() {
            return this.map;
        }

        @Override
        public String jsonTypeName() {
            return MongoJdbcHelper.TIMESTAMP_TYPE;
        }

        @Override
        @NotNull
        public String className() {
            String string = CLASS_NAME;
            if (string == null) {
                MongoTimestampValue.$$$reportNull$$$0(1);
            }
            return string;
        }

        public String toString() {
            return "{\"t\": " + this.time + ", \"inc\": " + this.inc;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/MongoJdbcHelper$MongoTimestampValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/MongoJdbcHelper$MongoTimestampValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "className";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class MongoMinKeyValue
    implements MongoValue {
        static String CLASS_NAME = "org.bson.types.MinKey";

        @Override
        public String typeName() {
            return MongoJdbcHelper.MIN_KEY_TYPE;
        }

        @Override
        @Nullable
        public Integer unwrap() {
            return 1;
        }

        @Override
        public String jsonTypeName() {
            return MongoJdbcHelper.MIN_KEY_TYPE;
        }

        @Override
        @NotNull
        public String className() {
            String string = CLASS_NAME;
            if (string == null) {
                MongoMinKeyValue.$$$reportNull$$$0(0);
            }
            return string;
        }

        public String toString() {
            return MongoJdbcHelper.MIN_KEY_TYPE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/jdbc/helpers/MongoJdbcHelper$MongoMinKeyValue", "className"));
        }
    }

    public static class MongoMaxKeyValue
    implements MongoValue {
        static String CLASS_NAME = "org.bson.types.MaxKey";

        @Override
        public String typeName() {
            return MongoJdbcHelper.MAX_KEY_TYPE;
        }

        @Override
        @Nullable
        public Integer unwrap() {
            return 1;
        }

        @Override
        public String jsonTypeName() {
            return MongoJdbcHelper.MAX_KEY_TYPE;
        }

        @Override
        @NotNull
        public String className() {
            String string = CLASS_NAME;
            if (string == null) {
                MongoMaxKeyValue.$$$reportNull$$$0(0);
            }
            return string;
        }

        public String toString() {
            return MongoJdbcHelper.MAX_KEY_TYPE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/jdbc/helpers/MongoJdbcHelper$MongoMaxKeyValue", "className"));
        }
    }

    public static class MongoDecimalValue
    implements MongoValue {
        static String CLASS_NAME = "org.bson.types.Decimal128";
        final String myValue;

        public MongoDecimalValue(String value) {
            this.myValue = value;
        }

        @Override
        public String typeName() {
            return MongoJdbcHelper.DECIMAL_TYPE;
        }

        @Override
        public String jsonTypeName() {
            return "numberDecimal";
        }

        @Override
        @Nullable
        public Object unwrap() {
            return this.myValue;
        }

        @Override
        @NotNull
        public String className() {
            String string = CLASS_NAME;
            if (string == null) {
                MongoDecimalValue.$$$reportNull$$$0(0);
            }
            return string;
        }

        public String toString() {
            return this.myValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/jdbc/helpers/MongoJdbcHelper$MongoDecimalValue", "className"));
        }
    }

    public static class MongoObjectIdValue
    implements MongoValue {
        static String CLASS_NAME = "org.bson.types.ObjectId";
        final String myValue;

        public MongoObjectIdValue(String value) {
            this.myValue = value;
        }

        @Override
        public String typeName() {
            return MongoJdbcHelper.OBJECT_ID_TYPE;
        }

        @Override
        public String jsonTypeName() {
            return "oid";
        }

        @Override
        @Nullable
        public Object unwrap() {
            return this.myValue;
        }

        @Override
        @NotNull
        public String className() {
            String string = CLASS_NAME;
            if (string == null) {
                MongoObjectIdValue.$$$reportNull$$$0(0);
            }
            return string;
        }

        public String toString() {
            return this.myValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/jdbc/helpers/MongoJdbcHelper$MongoObjectIdValue", "className"));
        }
    }

    public static interface MongoValue
    extends Serializable {
        public String typeName();

        public String jsonTypeName();

        @Nullable
        public Object unwrap();

        @NotNull
        public String className();
    }
}

