/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.MysqlBaseJdbcHelper;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysqlJdbcHelper
extends MysqlBaseJdbcHelper {
    private final boolean mySupportsDatesAsStrings;

    public MysqlJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("MySQL", version, connection);
        this.mySupportsDatesAsStrings = MysqlJdbcHelper.isSupportsDatesAsStrings(connection);
    }

    public MysqlJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return MysqlJdbcHelper.extractVersion(version);
    }

    @NotNull
    protected static MysqlJdbcHelper create(@Nullable Connection delegate, @Nullable String versionStr) {
        String version = MysqlJdbcHelper.extractVersion(versionStr);
        return new MysqlJdbcHelper(version, delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    @Nullable
    protected JdbcHelperImpl.TemporalGetter getTemporalGetter(int type) {
        return this.isPossiblyIncorrectTime(type) ? MysqlTemporalGetter.INSTANCE : super.getTemporalGetter(type);
    }

    private boolean isPossiblyIncorrectTime(int type) {
        return this.mySupportsDatesAsStrings && (type == 92 || type == 91 || type == 93);
    }

    private static boolean isSupportsDatesAsStrings(@Nullable Connection connection) {
        if (connection == null) {
            return false;
        }
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            int version = metaData.getDriverMajorVersion();
            return version >= 8;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static class MysqlTemporalGetter
    implements JdbcHelperImpl.TemporalGetter {
        private static final JdbcHelperImpl.TemporalGetter INSTANCE = new MysqlTemporalGetter();

        private MysqlTemporalGetter() {
        }

        @Override
        public Object get(@NotNull ResultSet set, @NotNull RemoteResultSet.DataRetrievingOptions options, int idx) throws SQLException {
            if (set == null) {
                MysqlTemporalGetter.$$$reportNull$$$0(0);
            }
            if (options == null) {
                MysqlTemporalGetter.$$$reportNull$$$0(1);
            }
            return set.getString(idx);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "set";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "options";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/remote/jdbc/helpers/MysqlJdbcHelper$MysqlTemporalGetter";
            objectArray[2] = "get";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

