/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.intellij.internal.statistic.StatisticsEventLogUtil;
import com.intellij.internal.statistic.eventLog.EventLogBuildNumber;
import com.intellij.internal.statistic.eventLog.EventLogUploadSettingsService;
import com.intellij.internal.statistic.service.fus.EventLogWhitelistLoadException;
import com.intellij.internal.statistic.service.fus.EventLogWhitelistParseException;
import com.intellij.internal.statistic.service.fus.FUSWhitelist;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.client.utils.DateUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FUStatisticsWhiteListGroupsService {
    @NotNull
    public static FUSWhitelist getApprovedGroups(@NotNull String userAgent, @NotNull String serviceUrl) {
        if (userAgent == null) {
            FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(0);
        }
        if (serviceUrl == null) {
            FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(1);
        }
        try {
            String content = FUStatisticsWhiteListGroupsService.getFUSWhiteListContent(userAgent, serviceUrl);
            return FUStatisticsWhiteListGroupsService.parseApprovedGroups(content);
        }
        catch (EventLogWhitelistLoadException | EventLogWhitelistParseException e) {
            FUSWhitelist fUSWhitelist = FUSWhitelist.empty();
            if (fUSWhitelist == null) {
                FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(2);
            }
            return fUSWhitelist;
        }
    }

    @NotNull
    public static String loadWhiteListFromServer(@NotNull EventLogUploadSettingsService settingsService) throws EventLogWhitelistLoadException {
        if (settingsService == null) {
            FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(3);
        }
        String userAgent = settingsService.getApplicationInfo().getUserAgent();
        return FUStatisticsWhiteListGroupsService.getFUSWhiteListContent(userAgent, settingsService.getWhiteListProductUrl());
    }

    public static long lastModifiedWhitelist(@NotNull EventLogUploadSettingsService settingsService) {
        if (settingsService == null) {
            FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(4);
        }
        String userAgent = settingsService.getApplicationInfo().getUserAgent();
        return FUStatisticsWhiteListGroupsService.lastModifiedWhitelist(userAgent, settingsService.getWhiteListProductUrl());
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private static String getFUSWhiteListContent(@NotNull String userAgent, @Nullable String serviceUrl) throws EventLogWhitelistLoadException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static long lastModifiedWhitelist(@NotNull String userAgent, @Nullable String serviceUrl) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    public static WLGroups parseWhiteListContent(@Nullable String content) throws EventLogWhitelistParseException {
        block6: {
            if (StatisticsEventLogUtil.isEmptyOrSpaces(content)) {
                throw new EventLogWhitelistParseException(EventLogWhitelistParseException.EventLogWhitelistParseErrorType.EMPTY_CONTENT);
            }
            WLGroups groups = (WLGroups)new GsonBuilder().create().fromJson(content, WLGroups.class);
            if (groups == null) break block6;
            WLGroups wLGroups = groups;
            if (wLGroups == null) {
                FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(8);
            }
            return wLGroups;
        }
        try {
            throw new EventLogWhitelistParseException(EventLogWhitelistParseException.EventLogWhitelistParseErrorType.INVALID_JSON);
        }
        catch (JsonSyntaxException e) {
            throw new EventLogWhitelistParseException(EventLogWhitelistParseException.EventLogWhitelistParseErrorType.INVALID_JSON, (Throwable)e);
        }
        catch (Exception e) {
            throw new EventLogWhitelistParseException(EventLogWhitelistParseException.EventLogWhitelistParseErrorType.UNKNOWN, (Throwable)e);
        }
    }

    @NotNull
    public static FUSWhitelist parseApprovedGroups(@Nullable String content) throws EventLogWhitelistParseException {
        WLGroups groups = FUStatisticsWhiteListGroupsService.parseWhiteListContent(content);
        HashMap<String, FUSWhitelist.GroupFilterCondition> groupToCondition = new HashMap<String, FUSWhitelist.GroupFilterCondition>();
        for (WLGroup group : groups.groups) {
            if (!group.isValid()) continue;
            groupToCondition.put(group.id, FUStatisticsWhiteListGroupsService.toCondition(group.builds, group.versions));
        }
        FUSWhitelist fUSWhitelist = FUSWhitelist.create(groupToCondition);
        if (fUSWhitelist == null) {
            FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(9);
        }
        return fUSWhitelist;
    }

    @NotNull
    private static FUSWhitelist.GroupFilterCondition toCondition(@Nullable List<WLBuild> builds, @Nullable List<WLVersion> versions) {
        List<FUSWhitelist.BuildRange> buildRanges = builds != null && !builds.isEmpty() ? FUStatisticsWhiteListGroupsService.toBuildRanges(builds) : Collections.emptyList();
        List<FUSWhitelist.VersionRange> versionRanges = versions != null && !versions.isEmpty() ? FUStatisticsWhiteListGroupsService.toVersionRanges(versions) : Collections.emptyList();
        return new FUSWhitelist.GroupFilterCondition(buildRanges, versionRanges);
    }

    private static List<FUSWhitelist.BuildRange> toBuildRanges(@NotNull List<WLBuild> builds) {
        if (builds == null) {
            FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(10);
        }
        ArrayList<FUSWhitelist.BuildRange> result = new ArrayList<FUSWhitelist.BuildRange>();
        for (WLBuild build : builds) {
            result.add(FUSWhitelist.BuildRange.create(build.from, build.to));
        }
        return result;
    }

    private static List<FUSWhitelist.VersionRange> toVersionRanges(@NotNull List<WLVersion> versions) {
        if (versions == null) {
            FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(11);
        }
        ArrayList<FUSWhitelist.VersionRange> result = new ArrayList<FUSWhitelist.VersionRange>();
        for (WLVersion version : versions) {
            result.add(FUSWhitelist.VersionRange.create(version.from, version.to));
        }
        return result;
    }

    private static /* synthetic */ Long lambda$lastModifiedWhitelist$1(String value) {
        return DateUtils.parseDate((String)value).getTime();
    }

    private static /* synthetic */ String lambda$lastModifiedWhitelist$0(Header header) {
        return header.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userAgent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceUrl";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/service/fus/FUStatisticsWhiteListGroupsService";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsService";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builds";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/service/fus/FUStatisticsWhiteListGroupsService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getApprovedGroups";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFUSWhiteListContent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseWhiteListContent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseApprovedGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getApprovedGroups";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadWhiteListFromServer";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lastModifiedWhitelist";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFUSWhiteListContent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "toBuildRanges";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "toVersionRanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class WLBuild {
        public String from;
        public String to;

        private WLBuild() {
        }

        public boolean contains(EventLogBuildNumber build) {
            return !(!StatisticsEventLogUtil.isEmpty(this.to) && EventLogBuildNumber.fromString(this.to).compareTo(build) <= 0 || !StatisticsEventLogUtil.isEmpty(this.from) && EventLogBuildNumber.fromString(this.from).compareTo(build) > 0);
        }
    }

    public static class WLRule {
        @Nullable
        public Set<String> event_id;
        @Nullable
        public Map<String, Set<String>> event_data;
        @Nullable
        public Map<String, Set<String>> enums;
        @Nullable
        public Map<String, String> regexps;
    }

    public static class WLVersion {
        public final String from;
        public final String to;

        public WLVersion(String from, String to) {
            this.from = from;
            this.to = to;
        }
    }

    public static class WLGroup {
        @Nullable
        public String id;
        @Nullable
        public final ArrayList<WLBuild> builds = new ArrayList();
        @Nullable
        public final ArrayList<WLVersion> versions = new ArrayList();
        @Nullable
        public WLRule rules;

        public boolean accepts(EventLogBuildNumber current) {
            if (!this.isValid()) {
                return false;
            }
            boolean hasBuilds = this.builds != null && !this.builds.isEmpty();
            return !hasBuilds || this.builds.stream().anyMatch(build -> build.contains(current));
        }

        private boolean isValid() {
            boolean hasBuilds = this.builds != null && !this.builds.isEmpty();
            boolean hasVersions = this.versions != null && !this.versions.isEmpty();
            return StatisticsEventLogUtil.isNotEmpty(this.id) && (hasBuilds || hasVersions);
        }
    }

    public static class WLGroups {
        @NotNull
        public final ArrayList<WLGroup> groups = new ArrayList();
        @Nullable
        public Map<String, Set<String>> globalEnums;
        @Nullable
        public WLRule rules;
        @Nullable
        public String version;
    }
}

