/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.dialects.base.SqlObjectBuilderImplKt;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicColumniation;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModCheck;
import com.intellij.database.model.basic.BasicModColumniation;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.basic.BasicModTypedElement;
import com.intellij.database.model.basic.BasicModView;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.database.SqlObjectBuilder;
import com.intellij.sql.psi.SqlColumnAliasDefinition;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlCommentStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateTypeStatementImpl;
import com.intellij.sql.psi.impl.SqlForeignKeyDefinitionImpl;
import com.intellij.sql.psi.impl.SqlReferenceExpressionImpl;
import com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\fH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0015\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\"\u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010#\u001a\n %*\u0004\u0018\u00010$0$2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010&\u001a\n %*\u0004\u0018\u00010$0$2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010*\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020+2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010,\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020-2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u001b\u0010.\u001a\r\u0012\t\u0012\u00070\u001b\u00a2\u0006\u0002\b\u00120/2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u00100\u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u00101\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u0002022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u00103\u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u00104\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0007\u001a\u0004\u0018\u000105H\u0002J\u0014\u00106\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0007\u001a\u0004\u0018\u000107H\u0002J \u00108\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u00109\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020:2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010;\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020<2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0015\u0010=\u001a\u00070>\u00a2\u0006\u0002\b\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010?\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020@2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010A\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020B2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0017\u0010C\u001a\t\u0018\u00010\u001b\u00a2\u0006\u0002\bD2\u0006\u0010\u0007\u001a\u00020\bH\u0002J<\u0010E\u001a.\u0012\f\u0012\n %*\u0004\u0018\u00010G0G %*\u0015\u0012\f\u0012\n %*\u0004\u0018\u00010G0G0/\u00a2\u0006\u0002\b\u00120F\u00a2\u0006\u0002\b\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0017\u0010H\u001a\t\u0018\u00010I\u00a2\u0006\u0002\bD2\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010J\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020K2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0017\u0010L\u001a\t\u0018\u00010\u001b\u00a2\u0006\u0002\bD2\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010M\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020K2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010N\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020K2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010O\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020P2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010Q\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020R2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010S\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020P2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u001e\u0010T\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001f2\u000e\u0010U\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0VH\u0004J\u0010\u0010W\u001a\u00020X2\u0006\u0010\u0007\u001a\u00020\bH\u0004J\u0010\u0010Y\u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010Z\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0016J\u0010\u0010Z\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\rH\u0016J\u0010\u0010[\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020+H\u0014J\"\u0010\\\u001a\u0004\u0018\u0001H]\"\u0006\b\u0000\u0010]\u0018\u00012\b\u0010^\u001a\u0004\u0018\u000105H\u0084\b\u00a2\u0006\u0002\u0010_J)\u0010\\\u001a\u0004\u0018\u0001052\b\u0010^\u001a\u0004\u0018\u0001052\u0012\u0010`\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020!0aH\u0084\bJ\u001c\u0010\\\u001a\u0004\u0018\u0001052\b\u0010b\u001a\u0004\u0018\u0001052\u0006\u0010c\u001a\u00020dH\u0004J\u0019\u0010e\u001a\u0004\u0018\u00010f2\b\u0010\u0007\u001a\u0004\u0018\u000105H\u0004\u00a2\u0006\u0002\u0010gJ)\u0010h\u001a\u0004\u0018\u0001052\b\u0010i\u001a\u0004\u0018\u0001052\u0012\u0010`\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020!0aH\u0084\bJ\u001c\u0010h\u001a\u0004\u0018\u0001052\b\u0010i\u001a\u0004\u0018\u0001052\u0006\u0010c\u001a\u00020dH\u0004J\u0014\u0010j\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0007\u001a\u0004\u0018\u000105H\u0004J'\u0010k\u001a\u00020\u00042\b\u0010^\u001a\u0004\u0018\u0001052\u0012\u0010`\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020\u00040aH\u0084\bJ'\u0010l\u001a\u00020\u00042\b\u0010m\u001a\u0004\u0018\u0001052\u0012\u0010`\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020\u00040aH\u0084\bJ\u001a\u0010n\u001a\u0004\u0018\u00010o2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010p\u001a\u00020qH\u0004J\u0016\u0010r\u001a\u00020o*\u00020\u001b2\b\b\u0002\u0010p\u001a\u00020qH\u0004J\u000e\u0010s\u001a\u0004\u0018\u00010\u001b*\u000205H\u0004\u00a8\u0006t"}, d2={"Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "Lcom/intellij/sql/database/SqlObjectBuilder;", "()V", "assignName", "", "obj", "Lcom/intellij/database/model/basic/BasicModNamedElement;", "source", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/sql/database/SqlObjectBuilder$Context;", "build", "Lcom/intellij/sql/psi/SqlElement;", "Lcom/intellij/database/model/basic/BasicModElement;", "buildArgument", "Lcom/intellij/database/model/basic/BasicModArgument;", "buildArgumentDir", "Lcom/intellij/database/model/ArgumentDirection;", "Lorg/jetbrains/annotations/NotNull;", "buildArranged", "Lcom/intellij/database/model/basic/BasicModArrangedElement;", "buildArrangedPos", "", "buildBasicElement", "buildCheck", "Lcom/intellij/database/model/basic/BasicModCheck;", "buildCheckPredicate", "", "buildColumniation", "Lcom/intellij/database/model/basic/BasicModColumniation;", "buildColumniationRefs", "", "buildFkIsDeferrable", "", "buildFkIsDeferred", "buildFkOnDelete", "Lcom/intellij/database/model/properties/CascadeRule;", "kotlin.jvm.PlatformType", "buildFkOnUpdate", "buildFkRefColumns", "buildFkRefSchemaName", "buildFkRefTableName", "buildForeignKey", "Lcom/intellij/database/model/basic/BasicModForeignKey;", "buildIndex", "Lcom/intellij/database/model/basic/BasicModIndex;", "buildIndexReverseColumns", "", "buildIndexUnique", "buildKey", "Lcom/intellij/database/model/basic/BasicModKey;", "buildKeyIsPrimary", "buildNameFromPsiElement", "Lcom/intellij/psi/PsiElement;", "buildNameFromRef", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "buildNamedElement", "buildNamespace", "Lcom/intellij/database/model/basic/BasicModNamespace;", "buildRoutine", "Lcom/intellij/database/model/basic/BasicModRoutine;", "buildRoutineKind", "Lcom/intellij/database/model/DasRoutine$Kind;", "buildRoutineSources", "Lcom/intellij/database/model/basic/BasicModSourceAware;", "buildTrigger", "Lcom/intellij/database/model/basic/BasicModTrigger;", "buildTriggerCondition", "Lorg/jetbrains/annotations/Nullable;", "buildTriggerEvents", "", "Lcom/intellij/database/model/TrigEvent;", "buildTriggerTurn", "Lcom/intellij/database/model/TrigTurn;", "buildTyped", "Lcom/intellij/database/model/basic/BasicModTypedElement;", "buildTypedDef", "buildTypedNotNull", "buildTypedType", "buildView", "Lcom/intellij/database/model/basic/BasicModView;", "buildViewColumn", "Lcom/intellij/database/model/basic/BasicModTableOrViewColumn;", "buildViewSource", "collectNames", "ref", "Lcom/intellij/database/model/MultiRef;", "extractType", "Lcom/intellij/database/model/DataType;", "extractTypedNotNull", "finalize", "finalizeForeignKey", "findChild", "T", "el", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Object;", "action", "Lkotlin/Function1;", "parent", "type", "Lcom/intellij/psi/tree/IElementType;", "findInt", "", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Integer;", "findSibling", "element", "findString", "forEachChild", "forEachSibling", "first", "getViewQuery", "Lcom/intellij/database/script/SimpleCompositeText;", "kind", "Lcom/intellij/database/script/CompositeText$Kind;", "asComposite", "extractName", "intellij.database.dialects.base"})
public abstract class SqlObjectBuilderImpl
implements SqlObjectBuilder {
    public void build(@NotNull DasObject obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (source instanceof DbElement || source instanceof BasicElement) {
            SqlObjectBuilderImplKt.getLog().error("Unexpected source: " + source.getClass().getSimpleName());
        }
        this.build((BasicModElement)obj2, source, context);
    }

    public void build(@NotNull DasObject obj2, @NotNull SqlElement source) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)source), SqlCommentStatementImpl.class) != null) {
            String comment;
            SqlElement sqlElement = source;
            if (!(sqlElement instanceof SqlStringLiteralExpressionImpl)) {
                sqlElement = null;
            }
            SqlStringLiteralExpressionImpl sqlStringLiteralExpressionImpl = (SqlStringLiteralExpressionImpl)sqlElement;
            String string = comment = sqlStringLiteralExpressionImpl != null ? sqlStringLiteralExpressionImpl.getValue() : null;
            if (obj2 instanceof BasicModNamedElement) {
                ((BasicModNamedElement)obj2).setComment(comment);
            }
        }
    }

    public void finalize(@NotNull DasObject obj2) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        this.finalize((BasicModElement)obj2);
    }

    public void finalize(@NotNull BasicModElement obj2) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        if (obj2 instanceof BasicModForeignKey) {
            this.finalizeForeignKey((BasicModForeignKey)obj2);
        }
    }

    protected void finalizeForeignKey(@NotNull BasicModForeignKey obj2) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        BasicTableOrView basicTableOrView = obj2.getRefTable();
        if (basicTableOrView == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)basicTableOrView, (String)"obj.refTable ?: return");
        BasicTableOrView refTable = basicTableOrView;
        List list = obj2.getRefColNames();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"obj.refColNames");
        List refCols = list;
        if (refCols.isEmpty()) {
            BasicKey key2;
            BasicKey basicKey = key2 = refTable.getPrimaryKey();
            obj2.setRefKeyName(basicKey != null ? basicKey.getName() : null);
            if (key2 != null) {
                obj2.setRefColNames(key2.getColNames());
            }
        } else {
            BasicKey key3;
            BasicKey basicKey = key3 = (BasicKey)refTable.getKeys().find((Predicate)new Predicate<BasicKey>(refCols){
                final /* synthetic */ List $refCols;

                public final boolean test(BasicKey k) {
                    return BasicColumniation.areColNames((BasicColumniation)((BasicColumniation)k), (List)this.$refCols);
                }
                {
                    this.$refCols = list;
                }
            });
            obj2.setRefKeyName(basicKey != null ? basicKey.getName() : null);
        }
    }

    public void build(@NotNull BasicModElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BasicModElement basicModElement = obj2;
        if (basicModElement instanceof BasicModNamespace) {
            this.buildNamespace((BasicModNamespace)obj2, source, context);
        } else if (basicModElement instanceof BasicModArgument) {
            this.buildArgument((BasicModArgument)obj2, source, context);
        } else if (basicModElement instanceof BasicModForeignKey) {
            this.buildForeignKey((BasicModForeignKey)obj2, source, context);
        } else if (basicModElement instanceof BasicModIndex) {
            this.buildIndex((BasicModIndex)obj2, source, context);
        } else if (basicModElement instanceof BasicModKey) {
            this.buildKey((BasicModKey)obj2, source, context);
        } else if (basicModElement instanceof BasicModRoutine) {
            this.buildRoutine((BasicModRoutine)obj2, source, context);
        } else if (basicModElement instanceof BasicModTrigger) {
            this.buildTrigger((BasicModTrigger)obj2, source, context);
        } else if (basicModElement instanceof BasicModCheck) {
            this.buildCheck((BasicModCheck)obj2, source, context);
        } else if (basicModElement instanceof BasicModView) {
            this.buildView((BasicModView)obj2, source, context);
        } else if (basicModElement instanceof BasicModTableOrViewColumn) {
            if (((BasicModTableOrViewColumn)obj2).getParent() instanceof BasicView) {
                this.buildViewColumn((BasicModTableOrViewColumn)obj2, source, context);
            } else {
                this.buildBasicElement(obj2, source, context);
            }
        } else {
            this.buildBasicElement(obj2, source, context);
        }
    }

    private final void buildViewColumn(BasicModTableOrViewColumn obj2, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement((BasicModElement)obj2, source, context);
        obj2.setNameSurrogate(!(source instanceof PsiColumn) || !(((PsiColumn)source).getNavigationElement() instanceof SqlColumnAliasDefinition));
    }

    protected void buildBasicElement(@NotNull BasicModElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (obj2 instanceof BasicModNamedElement) {
            this.buildNamedElement((BasicModNamedElement)obj2, source, context);
        }
        if (obj2 instanceof BasicModArrangedElement) {
            this.buildArranged((BasicModArrangedElement)obj2, source, context);
        }
        if (obj2 instanceof BasicModTypedElement) {
            this.buildTyped((BasicModTypedElement)obj2, source, context);
        }
        if (obj2 instanceof BasicModColumniation) {
            this.buildColumniation((BasicModColumniation)obj2, source, context);
        }
    }

    protected void buildView(@NotNull BasicModView obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.buildBasicElement((BasicModElement)obj2, source, context);
        this.buildViewSource(obj2, source, context);
    }

    protected void buildViewSource(@NotNull BasicModView obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ((BasicModModel)obj2.getModel()).writeSources(new Runnable(this, obj2, source){
            final /* synthetic */ SqlObjectBuilderImpl this$0;
            final /* synthetic */ BasicModView $obj;
            final /* synthetic */ DasObject $source;

            public final void run() {
                this.$obj.setSourceText((CompositeText)this.this$0.getViewQuery(this.$source, CompositeText.Kind.ORIGINAL_TEXT));
            }
            {
                this.this$0 = sqlObjectBuilderImpl;
                this.$obj = basicModView;
                this.$source = dasObject;
            }
        });
    }

    @Nullable
    protected final SimpleCompositeText getViewQuery(@NotNull DasObject source, @NotNull CompositeText.Kind kind) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        DasObject dasObject = source;
        if (!(dasObject instanceof SqlCreateViewStatement)) {
            dasObject = null;
        }
        return (object = (SqlCreateViewStatement)dasObject) != null && (object = object.getQueryExpression()) != null && (object = object.getText()) != null ? this.asComposite((String)object, kind) : null;
    }

    protected void buildForeignKey(@NotNull BasicModForeignKey obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.buildBasicElement((BasicModElement)obj2, source, context);
        obj2.setDeferrable(this.buildFkIsDeferrable(source));
        obj2.setInitiallyDeferred(this.buildFkIsDeferred(source));
        obj2.setOnDelete(this.buildFkOnDelete(source));
        obj2.setOnUpdate(this.buildFkOnUpdate(source));
        if (!context.isStubBuilder) {
            String schemaName;
            obj2.setRefColNames(this.buildFkRefColumns(source));
            obj2.setRefTableName(this.buildFkRefTableName(source));
            String string = schemaName = this.buildFkRefSchemaName(source);
            BasicModForeignKey basicModForeignKey = obj2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            BasicSchema basicSchema = obj2.getSchema();
            String string2 = Intrinsics.areEqual((Object)schemaName, (Object)(basicSchema != null ? basicSchema.getName() : null)) ^ true ? string : null;
            basicModForeignKey.setRefSchemaName(string2);
        }
    }

    private final String buildFkRefSchemaName(DasObject source) {
        String string;
        DasObject dasObject = source;
        if (dasObject instanceof SqlForeignKeyDefinitionImpl) {
            SqlReferenceExpression sqlReferenceExpression = ((SqlForeignKeyDefinitionImpl)source).getRefTableReference();
            Object object = sqlReferenceExpression != null ? sqlReferenceExpression.getParent() : null;
            if (!(object instanceof SqlReferenceExpression)) {
                object = null;
            }
            string = this.buildNameFromRef((SqlReferenceExpression)object);
        } else {
            string = dasObject instanceof DasForeignKey ? StringUtil.nullize((String)((DasForeignKey)source).getRefTableSchema(), (boolean)true) : null;
        }
        return string;
    }

    private final String buildFkRefTableName(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof SqlForeignKeyDefinitionImpl ? this.buildNameFromRef(((SqlForeignKeyDefinitionImpl)source).getRefTableReference()) : (dasObject instanceof DasForeignKey ? ((DasForeignKey)source).getRefTableName() : null);
    }

    private final List<String> buildFkRefColumns(DasObject source) {
        List<String> list;
        DasObject dasObject = source;
        if (dasObject instanceof DasForeignKey) {
            MultiRef multiRef = ((DasForeignKey)source).getRefColumns();
            Intrinsics.checkExpressionValueIsNotNull((Object)multiRef, (String)"source.refColumns");
            list = this.collectNames((MultiRef<? extends DasObject>)multiRef);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final String buildNameFromRef(SqlReferenceExpression source) {
        if (source == null) {
            return null;
        }
        String string = this.buildNameFromPsiElement(source.resolve());
        if (string == null) {
            string = source.getName();
        }
        return string;
    }

    private final String buildNameFromPsiElement(PsiElement source) {
        PsiElement psiElement = source;
        return psiElement instanceof DasObject ? ((DasObject)source).getName() : (psiElement instanceof SqlNameElement ? ((SqlNameElement)source).getName() : null);
    }

    @NotNull
    protected final List<String> collectNames(@NotNull MultiRef<? extends DasObject> ref) {
        Intrinsics.checkParameterIsNotNull(ref, (String)"ref");
        boolean bl = false;
        List res2 = new ArrayList();
        MultiRef.It it = ref.iterate();
        while (it.hasNext()) {
            String name2 = (String)it.next();
            DasObject obj2 = (DasObject)it.resolve();
            Object object = obj2;
            if (object == null || (object = object.getName()) == null) {
                String string = name2;
                object = string;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
            }
            res2.add(object);
        }
        return res2;
    }

    private final CascadeRule buildFkOnDelete(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasForeignKey ? DbImplUtil.asCascadeRule((DasForeignKey.RuleAction)((DasForeignKey)source).getDeleteRule()) : CascadeRule.no_action;
    }

    private final CascadeRule buildFkOnUpdate(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasForeignKey ? DbImplUtil.asCascadeRule((DasForeignKey.RuleAction)((DasForeignKey)source).getUpdateRule()) : CascadeRule.no_action;
    }

    private final boolean buildFkIsDeferred(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasForeignKey ? ((DasForeignKey)source).getDeferrability() == DasForeignKey.Deferrability.INITIALLY_DEFERRED : false;
    }

    private final boolean buildFkIsDeferrable(DasObject source) {
        DasForeignKey.Deferrability deferrability;
        DasObject dasObject = source;
        return dasObject instanceof DasForeignKey ? (deferrability = ((DasForeignKey)source).getDeferrability()) != null && deferrability != DasForeignKey.Deferrability.NOT_DEFERRABLE : false;
    }

    protected void buildRoutine(@NotNull BasicModRoutine obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.buildBasicElement((BasicModElement)obj2, source, context);
        obj2.setRoutineKind(this.buildRoutineKind(source));
        if (obj2 instanceof BasicModSourceAware) {
            this.buildRoutineSources((BasicModSourceAware)obj2, source, context);
        }
    }

    protected void buildRoutineSources(@NotNull BasicModSourceAware obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ((BasicModModel)obj2.getModel()).writeSources(new Runnable(this, obj2, source){
            final /* synthetic */ SqlObjectBuilderImpl this$0;
            final /* synthetic */ BasicModSourceAware $obj;
            final /* synthetic */ DasObject $source;

            public final void run() {
                Object object;
                DasObject dasObject = this.$source;
                if (!(dasObject instanceof SqlElement)) {
                    dasObject = null;
                }
                this.$obj.setSourceText((CompositeText)((object = (SqlElement)dasObject) != null && (object = object.getText()) != null ? SqlObjectBuilderImpl.asComposite$default(this.this$0, (String)object, null, 1, null) : null));
            }
            {
                this.this$0 = sqlObjectBuilderImpl;
                this.$obj = basicModSourceAware;
                this.$source = dasObject;
            }
        });
    }

    private final DasRoutine.Kind buildRoutineKind(DasObject source) {
        DasObject dasObject = source;
        DasRoutine.Kind kind = dasObject instanceof DasRoutine ? ((DasRoutine)source).getRoutineKind() : DasRoutine.Kind.NONE;
        Intrinsics.checkExpressionValueIsNotNull((Object)kind, (String)"when (source) {\n    is D\u2026 DasRoutine.Kind.NONE\n  }");
        return kind;
    }

    protected void buildCheck(@NotNull BasicModCheck obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.buildBasicElement((BasicModElement)obj2, source, context);
        obj2.setPredicate(this.buildCheckPredicate(source));
    }

    private final String buildCheckPredicate(DasObject source) {
        String string;
        DasObject dasObject = source;
        if (dasObject instanceof SqlConstraintDefinition) {
            SqlExpression sqlExpression = (SqlExpression)((SqlConstraintDefinition)source).getConstraintParameter(SqlConstraintDefinition.EXPRESSION);
            string = sqlExpression != null ? sqlExpression.getText() : null;
        } else {
            string = null;
        }
        return string;
    }

    protected void buildTrigger(@NotNull BasicModTrigger obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.buildBasicElement((BasicModElement)obj2, source, context);
        obj2.setEvents(this.buildTriggerEvents(source));
        obj2.setTurn(this.buildTriggerTurn(source));
        obj2.setCondition(this.buildTriggerCondition(source));
    }

    private final Set<TrigEvent> buildTriggerEvents(DasObject source) {
        DasObject dasObject = source;
        Set set = dasObject instanceof DasTrigger ? ((DasTrigger)source).getEvents() : SetsKt.emptySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"when (source) {\n    is D\u2026   else -> emptySet()\n  }");
        return set;
    }

    private final TrigTurn buildTriggerTurn(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasTrigger ? ((DasTrigger)source).getTurn() : null;
    }

    private final String buildTriggerCondition(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasTrigger ? ((DasTrigger)source).getCondition() : null;
    }

    protected void buildIndex(@NotNull BasicModIndex obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.buildBasicElement((BasicModElement)obj2, source, context);
        obj2.setUnique(this.buildIndexUnique(source));
        if (!context.isStubBuilder) {
            obj2.setReverseColNames(this.buildIndexReverseColumns(source));
        }
    }

    private final boolean buildIndexUnique(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasIndex ? ((DasIndex)source).isUnique() : false;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> buildIndexReverseColumns(DasObject source) {
        Set set;
        DasObject dasObject = source;
        if (dasObject instanceof DasIndex) {
            void $this$mapTo$iv$iv;
            DasTypedObject it;
            Iterable $this$filterTo$iv$iv;
            Iterable iterable = ((DasIndex)source).getColumnsRef().resolveObjects();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"source.columnsRef.resolveObjects()");
            Iterable $this$filter$iv = iterable;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (DasTypedObject)element$iv$iv;
                boolean bl = false;
                if (!(((DasIndex)source).getColumnSorting(it) == DasIndex.Sorting.DESCENDING)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (DasTypedObject)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                DasTypedObject dasTypedObject = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)dasTypedObject, (String)"it");
                String string = dasTypedObject.getName();
                collection.add(string);
            }
            set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    protected void buildKey(@NotNull BasicModKey obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.buildBasicElement((BasicModElement)obj2, source, context);
        if (!context.isStubBuilder) {
            obj2.setPrimary(this.buildKeyIsPrimary(source));
        }
    }

    private final boolean buildKeyIsPrimary(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasTableKey ? ((DasTableKey)source).isPrimary() : false;
    }

    protected void buildArgument(@NotNull BasicModArgument obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.buildBasicElement((BasicModElement)obj2, source, context);
        obj2.setArgumentDirection(this.buildArgumentDir(source));
    }

    private final ArgumentDirection buildArgumentDir(DasObject source) {
        DasObject dasObject = source;
        ArgumentDirection argumentDirection = dasObject instanceof DasArgument ? ((DasArgument)source).getArgumentDirection() : ArgumentDirection.IN;
        Intrinsics.checkExpressionValueIsNotNull((Object)argumentDirection, (String)"when (source) {\n    is D\u2026 ArgumentDirection.IN\n  }");
        return argumentDirection;
    }

    protected void buildColumniation(@NotNull BasicModColumniation obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (context.isStubBuilder) {
            return;
        }
        obj2.setColNames(this.buildColumniationRefs(source));
    }

    private final List<String> buildColumniationRefs(DasObject source) {
        List<String> list;
        DasObject dasObject = source;
        if (dasObject instanceof DasConstraint) {
            MultiRef multiRef = ((DasConstraint)source).getColumnsRef();
            Intrinsics.checkExpressionValueIsNotNull((Object)multiRef, (String)"source.columnsRef");
            list = this.collectNames((MultiRef<? extends DasObject>)multiRef);
        } else if (dasObject instanceof DasIndex) {
            MultiRef multiRef = ((DasIndex)source).getColumnsRef();
            Intrinsics.checkExpressionValueIsNotNull((Object)multiRef, (String)"source.columnsRef");
            list = this.collectNames((MultiRef<? extends DasObject>)multiRef);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    protected void buildArranged(@NotNull BasicModArrangedElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        DasObject dasObject = source;
        if (!(dasObject instanceof DasPositioned)) {
            dasObject = null;
        }
        DasPositioned dasPositioned = (DasPositioned)dasObject;
        obj2.setPosition(dasPositioned != null ? dasPositioned.getPosition() : (short)0);
    }

    private final short buildArrangedPos(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasPositioned ? ((DasPositioned)source).getPosition() : (short)0;
    }

    protected void buildTyped(@NotNull BasicModTypedElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.buildTypedType(obj2, source, context);
        obj2.setDefaultExpression(this.buildTypedDef(source));
        this.buildTypedNotNull(obj2, source, context);
    }

    protected void buildTypedNotNull(@NotNull BasicModTypedElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        obj2.setNotNull(this.extractTypedNotNull(source));
    }

    protected void buildTypedType(@NotNull BasicModTypedElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        obj2.setDataType(this.extractType(source));
    }

    @NotNull
    protected final DataType extractType(@NotNull DasObject source) {
        DataType dataType;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        DasObject dasObject = source;
        if (dasObject instanceof DasTypedObject) {
            DataType dataType2 = ((DasTypedObject)source).getDataType();
            dataType = dataType2;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType2, (String)"source.dataType");
        } else if (dasObject instanceof SqlCreateTypeStatementImpl) {
            dataType = ((SqlCreateTypeStatementImpl)source).getAliasedType();
            if (dataType == null || (dataType = dataType.getDataType()) == null) {
                DataType dataType3 = DataType.UNKNOWN;
                dataType = dataType3;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType3, (String)"DataType.UNKNOWN");
            }
        } else {
            DataType dataType4 = DataType.UNKNOWN;
            dataType = dataType4;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType4, (String)"DataType.UNKNOWN");
        }
        return dataType;
    }

    private final String buildTypedDef(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasTypedObject ? ((DasTypedObject)source).getDefault() : null;
    }

    private final boolean extractTypedNotNull(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasTypedObject ? ((DasTypedObject)source).isNotNull() : false;
    }

    protected void buildNamedElement(@NotNull BasicModNamedElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (context.isStubBuilder) {
            return;
        }
        this.assignName(obj2, source, context);
        obj2.setComment(source.getComment());
        obj2.setNameQuoted(DbSqlUtil.isQuoted((DasObject)source));
        obj2.setNameScripted(DbSqlUtil.isSqlObject((DasObject)source));
    }

    protected void assignName(@NotNull BasicModNamedElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        obj2.setName(source.getName());
    }

    protected void buildNamespace(@NotNull BasicModNamespace obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.buildBasicElement((BasicModElement)obj2, source, context);
    }

    protected final void forEachChild(@Nullable PsiElement el, @NotNull Function1<? super PsiElement, Unit> action) {
        int $i$f$forEachChild = 0;
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        PsiElement psiElement = el;
        PsiElement first$iv = psiElement != null ? psiElement.getFirstChild() : null;
        boolean $i$f$forEachSibling = false;
        for (PsiElement tmp$iv = first$iv; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
            action.invoke((Object)tmp$iv);
        }
    }

    protected final void forEachSibling(@Nullable PsiElement first2, @NotNull Function1<? super PsiElement, Unit> action) {
        int $i$f$forEachSibling = 0;
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        for (PsiElement tmp = first2; tmp != null; tmp = tmp.getNextSibling()) {
            action.invoke((Object)tmp);
        }
    }

    @Nullable
    protected final PsiElement findChild(@Nullable PsiElement parent, @NotNull IElementType type) {
        PsiElement psiElement;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            SqlObjectBuilderImpl this_$iv = this;
            boolean $i$f$findChild = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv;
            PsiElement psiElement2 = parent;
            PsiElement element$iv$iv = psiElement2 != null ? psiElement2.getFirstChild() : null;
            boolean $i$f$findSibling = false;
            for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)type)) continue;
                psiElement = tmp$iv$iv;
                break block1;
            }
            psiElement = null;
        }
        return psiElement;
    }

    @Nullable
    protected final /* synthetic */ <T> T findChild(@Nullable PsiElement el) {
        PsiElement psiElement;
        block1: {
            int $i$f$findChild = 0;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
            PsiElement psiElement2 = el;
            PsiElement element$iv = psiElement2 != null ? psiElement2.getFirstChild() : null;
            boolean $i$f$findSibling = false;
            for (PsiElement tmp$iv = element$iv; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                PsiElement it = tmp$iv;
                boolean bl = false;
                Intrinsics.reifiedOperationMarker((int)3, (String)"T");
                if (!(it instanceof Object)) continue;
                psiElement = tmp$iv;
                break block1;
            }
            psiElement = null;
        }
        Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
        return (T)psiElement;
    }

    @Nullable
    protected final PsiElement findChild(@Nullable PsiElement el, @NotNull Function1<? super PsiElement, Boolean> action) {
        PsiElement psiElement;
        block1: {
            int $i$f$findChild = 0;
            Intrinsics.checkParameterIsNotNull(action, (String)"action");
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
            PsiElement psiElement2 = el;
            PsiElement element$iv = psiElement2 != null ? psiElement2.getFirstChild() : null;
            boolean $i$f$findSibling = false;
            for (PsiElement tmp$iv = element$iv; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                if (!((Boolean)action.invoke((Object)tmp$iv)).booleanValue()) continue;
                psiElement = tmp$iv;
                break block1;
            }
            psiElement = null;
        }
        return psiElement;
    }

    @Nullable
    protected final PsiElement findSibling(@Nullable PsiElement element, @NotNull IElementType type) {
        PsiElement psiElement;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            SqlObjectBuilderImpl this_$iv = this;
            boolean $i$f$findSibling = false;
            for (PsiElement tmp$iv = element; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                PsiElement it = tmp$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)type)) continue;
                psiElement = tmp$iv;
                break block1;
            }
            psiElement = null;
        }
        return psiElement;
    }

    @Nullable
    protected final PsiElement findSibling(@Nullable PsiElement element, @NotNull Function1<? super PsiElement, Boolean> action) {
        int $i$f$findSibling = 0;
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        for (PsiElement tmp = element; tmp != null; tmp = tmp.getNextSibling()) {
            if (!((Boolean)action.invoke((Object)tmp)).booleanValue()) continue;
            return tmp;
        }
        return null;
    }

    @Nullable
    protected final String findString(@Nullable PsiElement source) {
        SqlCompositeElementType sqlCompositeElementType = SqlElementTypes.SQL_STRING_LITERAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlElementTypes.SQL_STRING_LITERAL");
        PsiElement psiElement = this.findSibling(source, (IElementType)sqlCompositeElementType);
        if (!(psiElement instanceof SqlStringLiteralExpressionImpl)) {
            psiElement = null;
        }
        SqlStringLiteralExpressionImpl sqlStringLiteralExpressionImpl = (SqlStringLiteralExpressionImpl)psiElement;
        return sqlStringLiteralExpressionImpl != null ? sqlStringLiteralExpressionImpl.getValue() : null;
    }

    @Nullable
    protected final Integer findInt(@Nullable PsiElement source) {
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_NUMERIC_LITERAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes.SQL_NUMERIC_LITERAL");
        PsiElement num = this.findChild(source, (IElementType)sqlCompositeElementType);
        Object object = num;
        return object != null && (object = object.getText()) != null ? StringsKt.toIntOrNull((String)object) : null;
    }

    @Nullable
    protected final String extractName(@NotNull PsiElement $this$extractName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$extractName, (String)"$this$extractName");
        PsiElement psiElement = $this$extractName;
        return psiElement instanceof SqlReferenceExpressionImpl ? ((SqlReferenceExpressionImpl)$this$extractName).getName() : (psiElement instanceof SqlStringLiteralExpressionImpl ? ((SqlStringLiteralExpressionImpl)$this$extractName).getValue() : (PsiTreeUtilKt.getElementType((PsiElement)$this$extractName) instanceof SqlKeywordTokenType || Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)$this$extractName), (Object)SqlTokens.SQL_IDENT) ? $this$extractName.getText() : null));
    }

    @NotNull
    protected final SimpleCompositeText asComposite(@NotNull String $this$asComposite, @NotNull CompositeText.Kind kind) {
        Intrinsics.checkParameterIsNotNull((Object)$this$asComposite, (String)"$this$asComposite");
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        return new SimpleCompositeText((CharSequence)$this$asComposite, kind);
    }

    public static /* synthetic */ SimpleCompositeText asComposite$default(SqlObjectBuilderImpl sqlObjectBuilderImpl, String string, CompositeText.Kind kind, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: asComposite");
        }
        if ((n & 1) != 0) {
            kind = CompositeText.Kind.ORIGINAL_TEXT;
        }
        return sqlObjectBuilderImpl.asComposite(string, kind);
    }

    public static final /* synthetic */ void access$forEachSibling(SqlObjectBuilderImpl $this, PsiElement first2, Function1 action) {
        $this.forEachSibling(first2, (Function1<? super PsiElement, Unit>)action);
    }

    public static final /* synthetic */ PsiElement access$findSibling(SqlObjectBuilderImpl $this, PsiElement element, Function1 action) {
        return $this.findSibling(element, (Function1<? super PsiElement, Boolean>)action);
    }
}

