/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.generic;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericDialect
extends AbstractDatabaseDialect {
    private final Dbms myDbms;

    public GenericDialect(@NotNull Dbms dbms) {
        if (dbms == null) {
            GenericDialect.$$$reportNull$$$0(0);
        }
        super(new TypeHelper(){

            @Override
            public String getTypeName(int code, int length, int precision, int scale) {
                return null;
            }
        }, Casing.create((Case)Case.MIXED, (Case)Case.MIXED));
        this.myDbms = dbms;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.myDbms;
        if (dbms == null) {
            GenericDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            GenericDialect.$$$reportNull$$$0(2);
        }
        String string = dataType.jdbcType == 0 ? dataType.getSpecification() : JdbcUtil.getJdbcTypeName((DataType)dataType);
        if (string == null) {
            GenericDialect.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public ObjectKind getSearchPathObjectKind() {
        return null;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection) {
        if (system == null) {
            GenericDialect.$$$reportNull$$$0(4);
        }
        if (connection == null) {
            GenericDialect.$$$reportNull$$$0(5);
        }
        RemoteConnection remoteConnection = connection.getRemoteConnection();
        String catalog = (String)JdbcNativeUtil.computeSafe(() -> ((RemoteConnection)remoteConnection).getCatalog());
        String schema = (String)JdbcNativeUtil.computeSafe(() -> ((RemoteConnection)remoteConnection).getSchema());
        if (schema == null && catalog == null) {
            return null;
        }
        ObjectPath dbPath = ObjectPath.create((String)StringUtil.notNullize((String)catalog), (ObjectKind)ObjectKind.DATABASE);
        if (schema == null) {
            return SearchPath.of((ObjectPath)dbPath);
        }
        return SearchPath.of((ObjectPath)dbPath.append(schema, ObjectKind.SCHEMA));
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    @NotNull
    public String getDisplayName() {
        return "Generic SQL";
    }

    @Override
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition) {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(6);
        }
        if (view == null) {
            GenericDialect.$$$reportNull$$$0(7);
        }
        if (definition == null) {
            GenericDialect.$$$reportNull$$$0(8);
        }
        throw new UnsupportedOperationException(DatabaseBundle.message((String)"ddl.error.create.view", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(9);
        }
        if (view == null) {
            GenericDialect.$$$reportNull$$$0(10);
        }
        throw new UnsupportedOperationException(DatabaseBundle.message((String)"ddl.error.drop.view", (Object[])new Object[]{this.getDisplayName()}));
    }

    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(11);
        }
        if (sequence == null) {
            GenericDialect.$$$reportNull$$$0(12);
        }
        throw new UnsupportedOperationException(DatabaseBundle.message((String)"ddl.error.drop.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsViewDefinition() {
        return false;
    }

    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            GenericDialect.$$$reportNull$$$0(13);
        }
        throw new UnsupportedOperationException(DatabaseBundle.message((String)"ddl.error.view.definition", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsProcedureDefinition() {
        return false;
    }

    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            GenericDialect.$$$reportNull$$$0(14);
        }
        throw new UnsupportedOperationException(DatabaseBundle.message((String)"ddl.error.procedure.definition", (Object[])new Object[]{this.getDisplayName()}));
    }

    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            GenericDialect.$$$reportNull$$$0(15);
        }
        if (qualifier == null) {
            GenericDialect.$$$reportNull$$$0(16);
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), null, null, null, null);
        if (ddlBuilder == null) {
            GenericDialect.$$$reportNull$$$0(17);
        }
        return ddlBuilder;
    }

    public boolean supportsCommonTableExpression() {
        return false;
    }

    @Override
    public boolean similarTo(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            GenericDialect.$$$reportNull$$$0(18);
        }
        return dialect instanceof GenericDialect;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 3: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/generic/GenericDialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/generic/GenericDialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 17: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "similarTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

