/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.h2.model;

import com.intellij.database.dialects.h2.model.H2Schema;
import com.intellij.database.dialects.h2.model.H2SourceAware;
import com.intellij.database.dialects.h2.model.H2Table;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.PropertyConverter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface H2Trigger
extends BasicModIdentifiedElement,
BasicModTrigger,
H2SourceAware {
    public static final BasicMetaProperty<TrigTurn> TURN = BasicMetaProperty.create((String)"Turn", (BasicMetaType)BasicMetaType.Types.TRIG_TURN, null, H2Trigger.class, (boolean)false);
    public static final BasicMetaProperty<Set<TrigEvent>> EVENTS = BasicMetaProperty.create((String)"Events", (BasicMetaType)BasicMetaType.Types.SET_OF_TRIG_EVENT, Collections.emptySet(), H2Trigger.class, (boolean)false);
    public static final BasicMetaProperty<String> SCHEMA_NAME = BasicMetaProperty.create((String)"SchemaName", (BasicMetaType)BasicMetaType.Types.STRING, null, H2Trigger.class, (boolean)false);

    @Nullable
    default public H2Table getTable() {
        return this.getParent();
    }

    @Nullable
    public H2Table getParent();

    @Nullable
    default public H2Table getMajorObject() {
        return this.getTable();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends H2Trigger> getParentFamily() {
        return null;
    }

    @Nullable
    public H2Schema getSchema();

    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.emptyList();
        if (list == null) {
            H2Trigger.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            H2Trigger.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public String getComment();

    @NotNull
    public Set<TrigEvent> getEvents();

    @Nullable
    public String getSchemaName();

    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        String schemaName;
        Set<TrigEvent> events;
        TrigTurn turn;
        int sourceTextLength;
        boolean outdated;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name2;
        long objectId;
        if (consumer == null) {
            H2Trigger.$$$reportNull$$$0(2);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer.accept("ObjectId", (Object)PropertyConverter.export((long)objectId));
        }
        if ((name2 = this.getName()) != null && name2 != ModelConsts.NO_NAME) {
            consumer.accept("Name", (Object)PropertyConverter.export((String)name2));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", (Object)PropertyConverter.export((boolean)nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", (Object)PropertyConverter.export((boolean)nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", (Object)PropertyConverter.export((boolean)nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", (Object)PropertyConverter.export((String)comment));
        }
        if (outdated = this.isOutdated()) {
            consumer.accept("Outdated", (Object)PropertyConverter.export((boolean)outdated));
        }
        if ((sourceTextLength = this.getSourceTextLength()) != 0) {
            consumer.accept("SourceTextLength", (Object)PropertyConverter.export((int)sourceTextLength));
        }
        if ((turn = this.getTurn()) != null) {
            consumer.accept("Turn", (Object)PropertyConverter.export((Enum)turn));
        }
        if (!(events = this.getEvents()).isEmpty()) {
            consumer.accept("Events", (Object)PropertyConverter.exportSetOfTrigEvent(events));
        }
        if ((schemaName = this.getSchemaName()) != null) {
            consumer.accept("SchemaName", (Object)PropertyConverter.export((String)schemaName));
        }
    }

    public void setEvents(@NotNull Set<TrigEvent> var1);

    public void setSchemaName(@Nullable String var1);

    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            H2Trigger.$$$reportNull$$$0(3);
        }
        String objectId = _properties.get("ObjectId");
        String name2 = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String comment = _properties.get("Comment");
        String outdated = _properties.get("Outdated");
        String sourceTextLength = _properties.get("SourceTextLength");
        String turn = _properties.get("Turn");
        String events = _properties.get("Events");
        String schemaName = _properties.get("SchemaName");
        this.setObjectId(objectId != null ? PropertyConverter.importLong((String)objectId) : Long.MIN_VALUE);
        this.setName(name2 != null ? PropertyConverter.importString((String)name2) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean((String)nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean((String)nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean((String)nameQuoted) : false);
        this.setComment(comment != null ? PropertyConverter.importString((String)comment) : null);
        this.setOutdated(outdated != null ? PropertyConverter.importBoolean((String)outdated) : false);
        this.setSourceTextLength(sourceTextLength != null ? PropertyConverter.importInt((String)sourceTextLength) : 0);
        this.setTurn(turn != null ? PropertyConverter.importTrigTurn((String)turn) : null);
        this.setEvents(events != null ? PropertyConverter.importSetOfTrigEvent((String)events) : Collections.emptySet());
        this.setSchemaName(schemaName != null ? PropertyConverter.importString((String)schemaName) : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/h2/model/H2Trigger";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/h2/model/H2Trigger";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

