/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dialects.oracle.model.OraMixinObjectType;
import com.intellij.database.dialects.oracle.model.OraModule;
import com.intellij.database.dialects.oracle.model.OraObjectTypeAttribute;
import com.intellij.database.dialects.oracle.model.OraObjectTypeBody;
import com.intellij.database.dialects.oracle.model.OraObjectTypeRoutine;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.SourceError;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraObjectType
extends OraMixinObjectType,
OraModule {
    public static final BasicMetaProperty<String> SUPER_SCHEMA_NAME = BasicMetaProperty.create((String)"SuperSchemaName", (BasicMetaType)BasicMetaType.Types.STRING, null, OraObjectType.class, (boolean)false);
    public static final BasicMetaProperty<String> SUPER_OBJECT_NAME = BasicMetaProperty.create((String)"SuperObjectName", (BasicMetaType)BasicMetaType.Types.STRING, null, OraObjectType.class, (boolean)false);
    public static final BasicMetaProperty<Boolean> INCOMPLETE = BasicMetaProperty.create((String)"Incomplete", (BasicMetaType)BasicMetaType.Types.BOOLEAN, (Object)false, OraObjectType.class, (boolean)false);
    public static final BasicMetaProperty<Boolean> FINAL = BasicMetaProperty.create((String)"Final", (BasicMetaType)BasicMetaType.Types.BOOLEAN, (Object)false, OraObjectType.class, (boolean)false);
    public static final BasicMetaProperty<Boolean> INSTANTIABLE = BasicMetaProperty.create((String)"Instantiable", (BasicMetaType)BasicMetaType.Types.BOOLEAN, (Object)false, OraObjectType.class, (boolean)false);

    @Nullable
    default public OraSchema getSchema() {
        return this.getParent();
    }

    @Nullable
    public OraSchema getParent();

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends OraObjectType> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull ModSingletonFamily<@NotNull ? extends OraObjectTypeBody> getBodies();

    @NotNull
    public @NotNull ModPositioningNamingFamily<@NotNull ? extends OraObjectTypeAttribute> getAttributes();

    @NotNull
    public @NotNull ModNamingFamily<@NotNull ? extends OraObjectTypeRoutine> getRoutines();

    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.BODY, ObjectKind.OBJECT_ATTRIBUTE, ObjectKind.ROUTINE);
        if (list == null) {
            OraObjectType.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getBodies(), this.getAttributes(), this.getRoutines());
        if (list == null) {
            OraObjectType.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public List<SourceError> getErrors();

    @Override
    @NotNull
    public Set<Long> getDependsOnIds();

    @Nullable
    public String getSuperSchemaName();

    @Nullable
    public String getSuperObjectName();

    public boolean isIncomplete();

    public boolean isFinal();

    public boolean isInstantiable();

    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        boolean instantiable;
        boolean finnal;
        boolean incomplete;
        String superObjectName;
        String superSchemaName;
        Date modifiedTimestamp;
        Date createdTimestamp;
        Set<Long> dependsOnIds;
        boolean withDebugInfo;
        boolean obfuscated;
        boolean invalid;
        List<SourceError> errors;
        int sourceTextLength;
        boolean outdated;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name2;
        long objectId;
        if (consumer == null) {
            OraObjectType.$$$reportNull$$$0(2);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer.accept("ObjectId", (Object)PropertyConverter.export((long)objectId));
        }
        if ((name2 = this.getName()) != null && name2 != ModelConsts.NO_NAME) {
            consumer.accept("Name", (Object)PropertyConverter.export((String)name2));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", (Object)PropertyConverter.export((boolean)nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", (Object)PropertyConverter.export((boolean)nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", (Object)PropertyConverter.export((boolean)nameQuoted));
        }
        if (outdated = this.isOutdated()) {
            consumer.accept("Outdated", (Object)PropertyConverter.export((boolean)outdated));
        }
        if ((sourceTextLength = this.getSourceTextLength()) != 0) {
            consumer.accept("SourceTextLength", (Object)PropertyConverter.export((int)sourceTextLength));
        }
        if (!(errors = this.getErrors()).isEmpty()) {
            consumer.accept("Errors", (Object)PropertyConverter.exportListOfSourceError(errors));
        }
        if (invalid = this.isInvalid()) {
            consumer.accept("Invalid", (Object)PropertyConverter.export((boolean)invalid));
        }
        if (obfuscated = this.isObfuscated()) {
            consumer.accept("Obfuscated", (Object)PropertyConverter.export((boolean)obfuscated));
        }
        if (withDebugInfo = this.isWithDebugInfo()) {
            consumer.accept("WithDebugInfo", (Object)PropertyConverter.export((boolean)withDebugInfo));
        }
        if (!(dependsOnIds = this.getDependsOnIds()).isEmpty()) {
            consumer.accept("DependsOnIds", (Object)PropertyConverter.exportSetOfLong(dependsOnIds));
        }
        if ((createdTimestamp = this.getCreatedTimestamp()) != null) {
            consumer.accept("CreatedTimestamp", (Object)PropertyConverter.export((Date)createdTimestamp));
        }
        if ((modifiedTimestamp = this.getModifiedTimestamp()) != null) {
            consumer.accept("ModifiedTimestamp", (Object)PropertyConverter.export((Date)modifiedTimestamp));
        }
        if ((superSchemaName = this.getSuperSchemaName()) != null) {
            consumer.accept("SuperSchemaName", (Object)PropertyConverter.export((String)superSchemaName));
        }
        if ((superObjectName = this.getSuperObjectName()) != null) {
            consumer.accept("SuperObjectName", (Object)PropertyConverter.export((String)superObjectName));
        }
        if (incomplete = this.isIncomplete()) {
            consumer.accept("Incomplete", (Object)PropertyConverter.export((boolean)incomplete));
        }
        if (finnal = this.isFinal()) {
            consumer.accept("Final", (Object)PropertyConverter.export((boolean)finnal));
        }
        if (instantiable = this.isInstantiable()) {
            consumer.accept("Instantiable", (Object)PropertyConverter.export((boolean)instantiable));
        }
    }

    @Override
    public void setErrors(@NotNull List<SourceError> var1);

    @Override
    default public void setErrors(SourceError ... errors) {
        this.setErrors(Arrays.asList(errors));
    }

    @Override
    public void setDependsOnIds(@NotNull Set<Long> var1);

    public void setSuperSchemaName(@Nullable String var1);

    public void setSuperObjectName(@Nullable String var1);

    public void setIncomplete(boolean var1);

    public void setFinal(boolean var1);

    public void setInstantiable(boolean var1);

    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            OraObjectType.$$$reportNull$$$0(3);
        }
        String objectId = _properties.get("ObjectId");
        String name2 = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String outdated = _properties.get("Outdated");
        String sourceTextLength = _properties.get("SourceTextLength");
        String errors = _properties.get("Errors");
        String invalid = _properties.get("Invalid");
        String obfuscated = _properties.get("Obfuscated");
        String withDebugInfo = _properties.get("WithDebugInfo");
        String dependsOnIds = _properties.get("DependsOnIds");
        String createdTimestamp = _properties.get("CreatedTimestamp");
        String modifiedTimestamp = _properties.get("ModifiedTimestamp");
        String superSchemaName = _properties.get("SuperSchemaName");
        String superObjectName = _properties.get("SuperObjectName");
        String incomplete = _properties.get("Incomplete");
        String finnal = _properties.get("Final");
        String instantiable = _properties.get("Instantiable");
        this.setObjectId(objectId != null ? PropertyConverter.importLong((String)objectId) : Long.MIN_VALUE);
        this.setName(name2 != null ? PropertyConverter.importString((String)name2) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean((String)nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean((String)nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean((String)nameQuoted) : false);
        this.setOutdated(outdated != null ? PropertyConverter.importBoolean((String)outdated) : false);
        this.setSourceTextLength(sourceTextLength != null ? PropertyConverter.importInt((String)sourceTextLength) : 0);
        this.setErrors(errors != null ? PropertyConverter.importListOfSourceError((String)errors) : Collections.emptyList());
        this.setInvalid(invalid != null ? PropertyConverter.importBoolean((String)invalid) : false);
        this.setObfuscated(obfuscated != null ? PropertyConverter.importBoolean((String)obfuscated) : false);
        this.setWithDebugInfo(withDebugInfo != null ? PropertyConverter.importBoolean((String)withDebugInfo) : false);
        this.setDependsOnIds(dependsOnIds != null ? PropertyConverter.importSetOfLong((String)dependsOnIds) : Collections.emptySet());
        this.setCreatedTimestamp(createdTimestamp != null ? PropertyConverter.importDate((String)createdTimestamp) : null);
        this.setModifiedTimestamp(modifiedTimestamp != null ? PropertyConverter.importDate((String)modifiedTimestamp) : null);
        this.setSuperSchemaName(superSchemaName != null ? PropertyConverter.importString((String)superSchemaName) : null);
        this.setSuperObjectName(superObjectName != null ? PropertyConverter.importString((String)superObjectName) : null);
        this.setIncomplete(incomplete != null ? PropertyConverter.importBoolean((String)incomplete) : false);
        this.setFinal(finnal != null ? PropertyConverter.importBoolean((String)finnal) : false);
        this.setInstantiable(instantiable != null ? PropertyConverter.importBoolean((String)instantiable) : false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/model/OraObjectType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/model/OraObjectType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

