/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres.model;

import com.intellij.database.dialects.postgres.model.PgLikeStoredTable;
import com.intellij.database.dialects.postgres.model.PgRule;
import com.intellij.database.dialects.postgres.model.PgSchema;
import com.intellij.database.dialects.postgres.model.PgTrigger;
import com.intellij.database.dialects.postgres.model.PgViewColumn;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseView;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.PgCheckOption;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.SourceError;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PgView
extends PgGPlumBaseView,
PgLikeStoredTable {
    public static final BasicMetaProperty<PgCheckOption> CHECK_OPTION = BasicMetaProperty.create((String)"CheckOption", (BasicMetaType)BasicMetaType.Types.PG_CHECK_OPTION, (Object)PgCheckOption.NONE, PgView.class, (boolean)false);

    @Override
    @Nullable
    default public PgSchema getSchema() {
        return this.getParent();
    }

    @Override
    @Nullable
    public PgSchema getParent();

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends PgView> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull ModPositioningNamingFamily<@NotNull ? extends PgViewColumn> getColumns();

    @Override
    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends PgRule> getRules();

    @Override
    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends PgTrigger> getTriggers();

    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.COLUMN, ObjectKind.RULE, ObjectKind.TRIGGER);
        if (list == null) {
            PgView.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getColumns(), this.getRules(), this.getTriggers());
        if (list == null) {
            PgView.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public List<SourceError> getErrors();

    @NotNull
    public PgCheckOption getCheckOption();

    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        PgCheckOption checkOption;
        boolean invalid;
        List<SourceError> errors;
        int sourceTextLength;
        long stateNumber;
        boolean system;
        boolean faceless;
        String owner;
        boolean outdated;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name2;
        long objectId;
        if (consumer == null) {
            PgView.$$$reportNull$$$0(2);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer.accept("ObjectId", (Object)PropertyConverter.export((long)objectId));
        }
        if ((name2 = this.getName()) != null && name2 != ModelConsts.NO_NAME) {
            consumer.accept("Name", (Object)PropertyConverter.export((String)name2));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", (Object)PropertyConverter.export((boolean)nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", (Object)PropertyConverter.export((boolean)nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", (Object)PropertyConverter.export((boolean)nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", (Object)PropertyConverter.export((String)comment));
        }
        if (outdated = this.isOutdated()) {
            consumer.accept("Outdated", (Object)PropertyConverter.export((boolean)outdated));
        }
        if ((owner = this.getOwner()) != null) {
            consumer.accept("Owner", (Object)PropertyConverter.export((String)owner));
        }
        if (faceless = this.isFaceless()) {
            consumer.accept("Faceless", (Object)PropertyConverter.export((boolean)faceless));
        }
        if (system = this.isSystem()) {
            consumer.accept("System", (Object)PropertyConverter.export((boolean)system));
        }
        if ((stateNumber = this.getStateNumber()) != 0L) {
            consumer.accept("StateNumber", (Object)PropertyConverter.export((long)stateNumber));
        }
        if ((sourceTextLength = this.getSourceTextLength()) != 0) {
            consumer.accept("SourceTextLength", (Object)PropertyConverter.export((int)sourceTextLength));
        }
        if (!(errors = this.getErrors()).isEmpty()) {
            consumer.accept("Errors", (Object)PropertyConverter.exportListOfSourceError(errors));
        }
        if (invalid = this.isInvalid()) {
            consumer.accept("Invalid", (Object)PropertyConverter.export((boolean)invalid));
        }
        if ((checkOption = this.getCheckOption()) != null && checkOption != PgCheckOption.NONE) {
            consumer.accept("CheckOption", (Object)PropertyConverter.export((Enum)checkOption));
        }
    }

    @Override
    public void setErrors(@NotNull List<SourceError> var1);

    @Override
    default public void setErrors(SourceError ... errors) {
        this.setErrors(Arrays.asList(errors));
    }

    public void setCheckOption(@NotNull PgCheckOption var1);

    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            PgView.$$$reportNull$$$0(3);
        }
        String objectId = _properties.get("ObjectId");
        String name2 = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String comment = _properties.get("Comment");
        String outdated = _properties.get("Outdated");
        String owner = _properties.get("Owner");
        String faceless = _properties.get("Faceless");
        String system = _properties.get("System");
        String stateNumber = _properties.get("StateNumber");
        String sourceTextLength = _properties.get("SourceTextLength");
        String errors = _properties.get("Errors");
        String invalid = _properties.get("Invalid");
        String checkOption = _properties.get("CheckOption");
        this.setObjectId(objectId != null ? PropertyConverter.importLong((String)objectId) : Long.MIN_VALUE);
        this.setName(name2 != null ? PropertyConverter.importString((String)name2) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean((String)nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean((String)nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean((String)nameQuoted) : false);
        this.setComment(comment != null ? PropertyConverter.importString((String)comment) : null);
        this.setOutdated(outdated != null ? PropertyConverter.importBoolean((String)outdated) : false);
        this.setOwner(owner != null ? PropertyConverter.importString((String)owner) : null);
        this.setFaceless(faceless != null ? PropertyConverter.importBoolean((String)faceless) : false);
        this.setSystem(system != null ? PropertyConverter.importBoolean((String)system) : false);
        this.setStateNumber(stateNumber != null ? PropertyConverter.importLong((String)stateNumber) : 0L);
        this.setSourceTextLength(sourceTextLength != null ? PropertyConverter.importInt((String)sourceTextLength) : 0);
        this.setErrors(errors != null ? PropertyConverter.importListOfSourceError((String)errors) : Collections.emptyList());
        this.setInvalid(invalid != null ? PropertyConverter.importBoolean((String)invalid) : false);
        this.setCheckOption(checkOption != null ? PropertyConverter.importPgCheckOption((String)checkOption) : PgCheckOption.NONE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgres/model/PgView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgres/model/PgView";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

