/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresgreenplumbase.model;

import com.intellij.database.dialects.postgresbase.model.PgBaseModelHelper;
import com.intellij.database.dialects.postgresbase.model.PgBaseSchema;
import com.intellij.database.dialects.postgresbase.model.PgBaseTable;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDefType;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDefTypeAttribute;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRole;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseSchema;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseSequence;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseTable;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumObjectEditorFactory;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.PgDataTypeSubKind;
import com.intellij.database.schemaEditor.DbObjectEditorFactory;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\nH\u0016J\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0011J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00162\u0006\u0010\u0012\u001a\u00020\u0011J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModelHelper;", "()V", "fillPropertiesWithExamples", "", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "variant", "", "vars", "", "generationVariants", "Lcom/intellij/util/containers/JBIterable;", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "getAncestors", "", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseTable;", "table", "getObjectEditorFactory", "Lcom/intellij/database/schemaEditor/DbObjectEditorFactory;", "getSuccessors", "", "hasDefaultType", "", "sequence", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseSequence;", "intellij.database.dialects.postgresgreenplumbase"})
public abstract class PgGPlumBaseModelHelper
extends PgBaseModelHelper {
    public boolean hasDefaultType(@NotNull PgGPlumBaseSequence sequence) {
        Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
        DataType dataType = sequence.getDataType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"sequence.dataType");
        DataType dataType2 = dataType;
        return Intrinsics.areEqual((Object)dataType2, (Object)DataType.UNKNOWN) || StringsKt.equals((String)dataType2.typeName, (String)"bigint", (boolean)true);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PgGPlumBaseTable> getAncestors(@NotNull PgGPlumBaseTable table) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        List<Long> list = table.getAncestorIds();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"table.ancestorIds");
        List<Long> ancestorIds = list;
        if (ancestorIds.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        PgGPlumBaseSchema pgGPlumBaseSchema = table.getSchema();
        if (pgGPlumBaseSchema == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)pgGPlumBaseSchema, (String)"table.schema ?: return emptyList()");
        PgGPlumBaseSchema schema = pgGPlumBaseSchema;
        Iterable $this$map$iv = ancestorIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void id;
            Long l = (Long)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PgBaseSchema pgBaseSchema = schema;
            void v3 = id;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"id");
            PgBaseTable pgBaseTable = this.findTableByObjectId(pgBaseSchema, v3.longValue());
            collection.add(pgBaseTable);
        }
        Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PgGPlumBaseTable)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<PgGPlumBaseTable> getSuccessors(@NotNull PgGPlumBaseTable table) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        Set<Long> set = table.getSuccessorIds();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"table.successorIds");
        Set<Long> successorIds = set;
        if (successorIds.isEmpty()) {
            return SetsKt.emptySet();
        }
        PgGPlumBaseSchema pgGPlumBaseSchema = table.getSchema();
        if (pgGPlumBaseSchema == null) {
            return SetsKt.emptySet();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)pgGPlumBaseSchema, (String)"table.schema ?: return emptySet()");
        PgGPlumBaseSchema schema = pgGPlumBaseSchema;
        Iterable $this$map$iv = successorIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void id;
            Long l = (Long)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PgBaseSchema pgBaseSchema = schema;
            void v3 = id;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"id");
            PgBaseTable pgBaseTable = this.findTableByObjectId(pgBaseSchema, v3.longValue());
            collection.add(pgBaseTable);
        }
        Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PgGPlumBaseTable)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Override
    @NotNull
    public DbObjectEditorFactory getObjectEditorFactory() {
        return PgGPlumObjectEditorFactory.INSTANCE;
    }

    @NotNull
    public JBIterable<String> generationVariants(@NotNull BasicMetaObject<?> meta) {
        JBIterable jBIterable;
        Intrinsics.checkParameterIsNotNull(meta, (String)"meta");
        ObjectKind objectKind = meta.kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROLE)) {
            JBIterable jBIterable2 = super.generationVariants(meta).append((Object)"User");
            jBIterable = jBIterable2;
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"super.generationVariants(meta).append(\"User\")");
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.OBJECT_TYPE)) {
            JBIterable jBIterable3 = JBIterable.of((Object[])new String[]{"Enum", "Domain", "Composite Type"});
            jBIterable = jBIterable3;
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable3, (String)"JBIterable.of(\"Enum\", \"Domain\", \"Composite Type\")");
        } else {
            JBIterable jBIterable4 = super.generationVariants(meta);
            jBIterable = jBIterable4;
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable4, (String)"super.generationVariants(meta)");
        }
        return jBIterable;
    }

    public void fillPropertiesWithExamples(@NotNull BasicModElement e, @NotNull String variant, @NotNull Map<String, String> vars) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
        Intrinsics.checkParameterIsNotNull(vars, (String)"vars");
        if (Intrinsics.areEqual((Object)variant, (Object)"User") && e instanceof PgGPlumBaseRole) {
            ((PgGPlumBaseRole)e).setCanLogin(true);
        }
        if (e instanceof PgGPlumBaseDefType) {
            switch (variant) {
                case "Enum": {
                    ((PgGPlumBaseDefType)e).setSubKind(PgDataTypeSubKind.ENUM);
                    ((PgGPlumBaseDefType)e).setLabels(CollectionsKt.listOf((Object)"label"));
                    vars.put("labels", "'label'");
                    break;
                }
                case "Domain": {
                    ((PgGPlumBaseDefType)e).setSubKind(PgDataTypeSubKind.DOMAIN);
                    break;
                }
                case "Composite Type": {
                    ((PgGPlumBaseDefType)e).setSubKind(PgDataTypeSubKind.COMPOSITE);
                    PgGPlumBaseDefTypeAttribute attr = (PgGPlumBaseDefTypeAttribute)((PgGPlumBaseDefType)e).getAttributes().createNewOne();
                    this.setTemplateName(attr, "attr");
                    PgGPlumBaseDefTypeAttribute pgGPlumBaseDefTypeAttribute = attr;
                    Intrinsics.checkExpressionValueIsNotNull((Object)pgGPlumBaseDefTypeAttribute, (String)"attr");
                    pgGPlumBaseDefTypeAttribute.setDataType(DataTypeFactory.of((String)"int"));
                    vars.put("attrs", "attr int");
                    break;
                }
            }
        }
        super.fillPropertiesWithExamples(e, variant, vars);
    }
}

