/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresgreenplumbase.model;

import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseAggregate;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDefType;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDefTypeCheck;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseExtension;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseModelHelper;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseOperator;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRole;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRoutine;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseSequence;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseTable;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseTableColumn;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseTrigger;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseUtil;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumDescriptionService;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.properties.PgAggregateKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u0006*\b\b\u0003\u0010\u0007*\u00020\b*\b\b\u0004\u0010\t*\u00020\n2\u00020\u000bB\u0005\u00a2\u0006\u0002\u0010\fJ\u001b\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00028\u0004H\u0014\u00a2\u0006\u0002\u0010\u0015J\u001b\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0017\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010\u0018J\u001b\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u001a\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0015\u0010!\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0004H\u0002\u00a2\u0006\u0002\u0010\"J\u0015\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020.H\u0002J\u0015\u0010/\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00100J\u0010\u00101\u001a\u00020\u00132\u0006\u00102\u001a\u000203H\u0014J\u0010\u00104\u001a\u00020\u00132\u0006\u00105\u001a\u000206H\u0004J\u0015\u00107\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00028\u0003H\u0002\u00a2\u0006\u0002\u00108J\u0010\u00109\u001a\u00020\u00132\u0006\u0010:\u001a\u00020;H\u0002J\u0018\u0010<\u001a\u00020\u00132\u0006\u0010=\u001a\u00020\u00062\u0006\u0010>\u001a\u00020?H\u0004J\u0015\u0010@\u001a\u00020\u00132\u0006\u0010$\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010%R\u0012\u0010\r\u001a\u00020\u000eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006A"}, d2={"Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumDescriptionService;", "R", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRoutine;", "DT", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseDefType;", "T", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseTrigger;", "RL", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRole;", "A", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseAggregate;", "Lcom/intellij/database/model/DescriptionService;", "()V", "helper", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "getHelper", "()Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "collectAggregateAttributes", "", "", "aggregate", "(Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseAggregate;)Ljava/util/List;", "collectRoleAttributes", "role", "(Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRole;)Ljava/util/List;", "collectRoutineAttributes", "routine", "(Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRoutine;)Ljava/util/List;", "content", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeAggregate", "(Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseAggregate;)Ljava/lang/String;", "describeDefType", "dt", "(Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseDefType;)Ljava/lang/String;", "describeDefTypeCheck", "check", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseDefTypeCheck;", "describeExtension", "extension", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseExtension;", "describeOperator", "op", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseOperator;", "describePgRoutine", "(Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRoutine;)Ljava/lang/String;", "describePgSequence", "seq", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseSequence;", "describePgTable", "table", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseTable;", "describeRole", "(Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRole;)Ljava/lang/String;", "describeTableColumn", "column", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseTableColumn;", "describeTrigger", "trig", "withSurrogates", "", "getTypeCategory", "intellij.database.dialects.postgresgreenplumbase"})
public abstract class PgGPlumDescriptionService<R extends PgGPlumBaseRoutine, DT extends PgGPlumBaseDefType, T extends PgGPlumBaseTrigger, RL extends PgGPlumBaseRole, A extends PgGPlumBaseAggregate>
extends DescriptionService {
    @NotNull
    protected abstract PgGPlumBaseModelHelper getHelper();

    @NotNull
    public String content(@NotNull BasicElement e, @NotNull DescriptionService.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BasicElement basicElement = e;
        return basicElement instanceof PgGPlumBaseSequence ? this.describePgSequence((PgGPlumBaseSequence)e) : (basicElement instanceof PgGPlumBaseRoutine ? this.describePgRoutine((PgGPlumBaseRoutine)e) : (basicElement instanceof PgGPlumBaseTable ? this.describePgTable((PgGPlumBaseTable)e) : (basicElement instanceof PgGPlumBaseTableColumn ? this.describeTableColumn((PgGPlumBaseTableColumn)e) : (basicElement instanceof PgGPlumBaseDefType ? this.describeDefType((PgGPlumBaseDefType)e) : (basicElement instanceof PgGPlumBaseOperator ? this.describeOperator((PgGPlumBaseOperator)e) : (basicElement instanceof PgGPlumBaseTrigger ? this.describeTrigger((PgGPlumBaseTrigger)e, context.getWithSurrogates()) : (basicElement instanceof PgGPlumBaseDefTypeCheck ? this.describeDefTypeCheck((PgGPlumBaseDefTypeCheck)e) : (basicElement instanceof PgGPlumBaseRole ? this.describeRole((PgGPlumBaseRole)e) : (basicElement instanceof PgGPlumBaseAggregate ? this.describeAggregate((PgGPlumBaseAggregate)e) : (basicElement instanceof PgGPlumBaseExtension ? this.describeExtension((PgGPlumBaseExtension)e) : super.content(e, context)))))))))));
    }

    @NotNull
    protected String describePgSequence(@NotNull PgGPlumBaseSequence seq) {
        Intrinsics.checkParameterIsNotNull((Object)seq, (String)"seq");
        String def = this.describeSequence((BasicSequence)seq);
        String category = seq.isBelongsToColumn() ? "private" : "shared";
        String dataType = !this.getHelper().hasDefaultType(seq) ? "data type: " + seq.getDataType() : "";
        String cacheSize = !PgGPlumBaseUtil.hasDefaultCacheSize(seq) ? "cache size: " + seq.getCacheSize() : "";
        String string = ' ' + dataType;
        StringBuilder stringBuilder = new StringBuilder().append(category).append(' ').append(def);
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string3 = ((Object)StringsKt.trimEnd((CharSequence)string2)).toString();
        string = ' ' + cacheSize;
        stringBuilder = stringBuilder.append(string3);
        bl = false;
        String string4 = string;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        string3 = ((Object)StringsKt.trimEnd((CharSequence)string4)).toString();
        return stringBuilder.append(string3).toString();
    }

    @NotNull
    protected final String describePgTable(@NotNull PgGPlumBaseTable table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        String d = this.describeTable((BasicTable)table);
        List<Long> list = table.getAncestorIds();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"table.ancestorIds");
        Collection collection = list;
        boolean bl = false;
        if (!collection.isEmpty()) {
            d = d + " (" + ModelFun.namesAsString((Collection)this.getHelper().getAncestors(table)) + ")";
        }
        Set<Long> set = table.getSuccessorIds();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"table.successorIds");
        collection = set;
        bl = false;
        if (!collection.isEmpty()) {
            d = d + " {" + ModelFun.namesAsString((Collection)this.getHelper().getSuccessors(table)) + "}";
        }
        return d;
    }

    private final String describePgRoutine(R routine) {
        String r = this.describeRoutine((BasicRoutine)routine);
        List<String> attributes2 = this.collectRoutineAttributes(routine);
        return r + (attributes2.isEmpty() ? "" : " attributes: " + CollectionsKt.joinToString$default((Iterable)attributes2, null, null, null, (int)0, null, (Function1)describePgRoutine.1.INSTANCE, (int)31, null));
    }

    @NotNull
    protected List<String> collectRoutineAttributes(@NotNull R routine) {
        Intrinsics.checkParameterIsNotNull(routine, (String)"routine");
        ArrayList<String> attributes2 = new ArrayList<String>();
        if (routine.isLeakproof()) {
            attributes2.add("leakproof");
        }
        if (routine.isStrict()) {
            attributes2.add("strict");
        }
        if (routine.isSecurityDefiner()) {
            attributes2.add("security definer");
        }
        if (PgGPlumBaseUtil.isCostDefined(routine)) {
            attributes2.add("cost " + PgGPlumBaseUtil.costAsString(routine));
        }
        attributes2.addAll((Collection)routine.getConfigurationParameters());
        return attributes2;
    }

    private final String describeTableColumn(PgGPlumBaseTableColumn column2) {
        String d = this.describeColumn((BasicLikeColumn)column2);
        if (column2.isInherited()) {
            d = "inherited " + d;
        }
        return d;
    }

    private final String describeDefType(DT dt) {
        StringBuilder b = new StringBuilder();
        b.append(this.getTypeCategory(dt));
        if (dt.getDefinition() != null) {
            b.append(" of ").append(dt.getDefinition());
        }
        List<String> list = dt.getLabels();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"dt.labels");
        Collection collection = list;
        boolean bl = false;
        if (!collection.isEmpty()) {
            StringBuilder stringBuilder = b.append(" of {");
            List<String> list2 = dt.getLabels();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"dt.labels");
            stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)).append("}");
        }
        if (dt.getDefaultExpression() != null) {
            b.append(" default ").append(dt.getDefaultExpression());
        }
        if (dt.isNotNull()) {
            b.append(" NN");
        }
        String string = b.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
        return string;
    }

    @NotNull
    protected String getTypeCategory(@NotNull DT dt) {
        Intrinsics.checkParameterIsNotNull(dt, (String)"dt");
        String string = dt.getSubKind().human_readable_name();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dt.subKind.human_readable_name()");
        return string;
    }

    private final String describeOperator(PgGPlumBaseOperator op) {
        StringBuilder b = new StringBuilder(60);
        String string = op.getOperatorKind().name();
        StringBuilder stringBuilder = b;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String string4 = string3;
        stringBuilder.append(string4).append(" operator (");
        if (Intrinsics.areEqual((Object)op.getLeftType(), (Object)DataType.UNKNOWN) ^ true) {
            b.append(op.getLeftType());
        }
        if (Intrinsics.areEqual((Object)op.getLeftType(), (Object)DataType.UNKNOWN) ^ true && Intrinsics.areEqual((Object)op.getRightType(), (Object)DataType.UNKNOWN) ^ true) {
            b.append(", ");
        }
        if (Intrinsics.areEqual((Object)op.getRightType(), (Object)DataType.UNKNOWN) ^ true) {
            b.append(op.getRightType());
        }
        b.append(") -> ");
        b.append(op.getResultType());
        if (op.getCallRoutineName() != null) {
            b.append(" [bound to ").append(op.getCallRoutineName()).append(']');
        }
        String string5 = b.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"b.toString()");
        return string5;
    }

    @NotNull
    protected final String describeTrigger(@NotNull PgGPlumBaseTrigger trig, boolean withSurrogates) {
        Object rName;
        Intrinsics.checkParameterIsNotNull((Object)trig, (String)"trig");
        String d = this.describeTrigger((BasicTrigger)trig);
        PgGPlumBaseRoutine r = PgGPlumBaseUtil.getCallRoutine(trig);
        long rId = trig.getCallRoutineId();
        Object object = r;
        if (object == null || (object = ModelFun.nameInContextOfSchema((BasicSchemaObject)((BasicSchemaObject)object), (BasicSchema)((BasicSchema)trig.getSchema()))) == null) {
            object = rId != 0L ? "???" : null;
        }
        if ((rName = object) != null) {
            d = d + " -> " + (String)rName + "()";
            if (withSurrogates) {
                d = d + " [id=" + rId + ']';
            }
        }
        return d;
    }

    private final String describeDefTypeCheck(PgGPlumBaseDefTypeCheck check) {
        return "check " + check.getPredicate();
    }

    private final String describeRole(RL role) {
        return CollectionsKt.joinToString$default((Iterable)this.collectRoleAttributes(role), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    protected List<String> collectRoleAttributes(@NotNull RL role) {
        boolean bl;
        String string;
        Collection collection;
        Intrinsics.checkParameterIsNotNull(role, (String)"role");
        ArrayList attributes2 = new ArrayList();
        if (role.isSuperRole()) {
            collection = attributes2;
            string = "superuser";
            bl = false;
            collection.add(string);
        }
        if (role.isCreateDb()) {
            collection = attributes2;
            string = "createdb";
            bl = false;
            collection.add(string);
        }
        if (role.isCreateRole()) {
            collection = attributes2;
            string = "createrole";
            bl = false;
            collection.add(string);
        }
        if (!role.isInherit()) {
            collection = attributes2;
            string = "noinherit";
            bl = false;
            collection.add(string);
        }
        if (role.getConnectionLimit() >= 0L) {
            collection = attributes2;
            string = "connection limit " + role.getConnectionLimit();
            bl = false;
            collection.add(string);
        }
        if (role.getValidUntil() != null) {
            collection = attributes2;
            string = "valid until " + role.getValidUntil();
            bl = false;
            collection.add(string);
        }
        return attributes2;
    }

    private final String describeExtension(PgGPlumBaseExtension extension) {
        List attributes2 = new ArrayList();
        if (extension.getVersion() != null) {
            attributes2.add("version: " + extension.getVersion());
        }
        if (extension.getSchemaName() != null) {
            attributes2.add("schemaName: '" + extension.getSchemaName() + '\'');
        }
        attributes2.add("availableUpdates: " + extension.getAvailableUpdates());
        return "extension " + CollectionsKt.joinToString$default((Iterable)attributes2, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
    }

    private final String describeAggregate(A aggregate) {
        return CollectionsKt.joinToString$default((Iterable)this.collectAggregateAttributes(aggregate), null, null, null, (int)0, null, null, (int)63, null);
    }

    @NotNull
    protected List<String> collectAggregateAttributes(@NotNull A aggregate) {
        Intrinsics.checkParameterIsNotNull(aggregate, (String)"aggregate");
        List attributes2 = new ArrayList();
        Collection collection = attributes2;
        String string = "transition: " + aggregate.getTransition();
        boolean bl = false;
        collection.add(string);
        collection = attributes2;
        string = "transition type: " + aggregate.getTransitionDataType();
        bl = false;
        collection.add(string);
        if (aggregate.getFinal() != null) {
            collection = attributes2;
            string = "final function: " + aggregate.getFinal();
            bl = false;
            collection.add(string);
        }
        if (aggregate.getInitialValue() != null) {
            collection = attributes2;
            string = "initial value: " + aggregate.getInitialValue();
            bl = false;
            collection.add(string);
        }
        if (aggregate.getSortOperator() != null) {
            collection = attributes2;
            string = "sort operator: " + aggregate.getSortOperator();
            bl = false;
            collection.add(string);
        }
        if (aggregate.getAggregateKind() != PgAggregateKind.NORMAL) {
            collection = attributes2;
            string = "kind: " + aggregate.getAggregateKind().getName();
            bl = false;
            collection.add(string);
        }
        if (aggregate.getDirectArgs() != 0) {
            collection = attributes2;
            string = "direct arguments: " + aggregate.getDirectArgs();
            bl = false;
            collection.add(string);
        }
        return attributes2;
    }
}

