/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqliteDialect
extends AbstractDatabaseDialect {
    public SqliteDialect() {
        super(new TypeHelper.SQLiteTypeHelper(), Casing.create((Case)Case.MIXED, (Case)Case.MIXED));
    }

    @NotNull
    public String getDisplayName() {
        return "SQLite";
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.SQLITE;
        if (dbms == null) {
            SqliteDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection) {
        if (system == null) {
            SqliteDialect.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            SqliteDialect.$$$reportNull$$$0(2);
        }
        return SearchPath.of((ObjectPath)ObjectPath.create((String)"main", (ObjectKind)ObjectKind.SCHEMA));
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlTableDefinition(@NotNull DasObject element) {
        if (element == null) {
            SqliteDialect.$$$reportNull$$$0(3);
        }
        Pair pair = Pair.create((Object)("select GROUP_CONCAT(s, ';\n') from (select sql as s from sqlite_master where tbl_name = '" + StringUtil.toLowerCase((String)element.getName()).replace("'", "''") + "' and (type = 'table' or type = 'index') order by type desc)"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            SqliteDialect.$$$reportNull$$$0(4);
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection) throws Exception {
        if (table == null) {
            SqliteDialect.$$$reportNull$$$0(5);
        }
        if (connection == null) {
            SqliteDialect.$$$reportNull$$$0(6);
        }
        Pair<String, DbImplUtil.ConcatenationProps> pair = this.sqlTableDefinition((DasObject)table);
        String string = DbImplUtil.concatStringResults((DatabaseConnection)connection, (Dbms)connection.getDbms(), (String)((String)pair.first), (int)1, (DbImplUtil.ConcatenationProps)((DbImplUtil.ConcatenationProps)pair.second));
        if (string == null) {
            SqliteDialect.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(8);
        }
        if (sequence == null) {
            SqliteDialect.$$$reportNull$$$0(9);
        }
        throw new UnsupportedOperationException(DatabaseBundle.message((String)"ddl.error.drop.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            SqliteDialect.$$$reportNull$$$0(10);
        }
        Pair pair = Pair.create((Object)("select sql as s from sqlite_master where tbl_name = '" + StringUtil.toLowerCase((String)element.getName()).replace("'", "''") + "' and type = 'view'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            SqliteDialect.$$$reportNull$$$0(11);
        }
        return pair;
    }

    public boolean supportsProcedureDefinition() {
        return false;
    }

    @Override
    public boolean supportsInsertDefaultValues() {
        return true;
    }

    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            SqliteDialect.$$$reportNull$$$0(12);
        }
        throw new UnsupportedOperationException(DatabaseBundle.message((String)"ddl.error.procedure.definition", (Object[])new Object[]{this.getDisplayName()}));
    }

    @NotNull
    public DdlBuilder qualifiedIdentifier(@NotNull DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(13);
        }
        if (identifier == null) {
            SqliteDialect.$$$reportNull$$$0(14);
        }
        if (qualifier == null) {
            SqliteDialect.$$$reportNull$$$0(15);
        }
        DdlBuilder ddlBuilder = builder.identifier(object, identifier);
        if (ddlBuilder == null) {
            SqliteDialect.$$$reportNull$$$0(16);
        }
        return ddlBuilder;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public boolean hasRowId(@Nullable DasDataSource system) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/sqlite/SqliteDialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/sqlite/SqliteDialect";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlTableDefinition";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlViewDefinition";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sqlTableDefinition";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

