/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite.model;

import com.intellij.database.dialects.sqlite.model.SqliteCheck;
import com.intellij.database.dialects.sqlite.model.SqliteIndex;
import com.intellij.database.dialects.sqlite.model.SqliteKey;
import com.intellij.database.dialects.sqlite.model.SqliteTable;
import com.intellij.database.dialects.sqlite.model.SqliteTableColumn;
import com.intellij.database.dialects.sqlite.model.SqliteVirtualTable;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001cH\u0002J*\u0010\u001d\u001a\u00020\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040 2\b\u0010!\u001a\u0004\u0018\u00010\u0004H\u0002\u00a8\u0006\""}, d2={"Lcom/intellij/database/dialects/sqlite/model/SqliteDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "()V", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeSqliteCheck", "chk", "Lcom/intellij/database/dialects/sqlite/model/SqliteCheck;", "describeSqliteColumn", "col", "Lcom/intellij/database/dialects/sqlite/model/SqliteTableColumn;", "describeSqliteIndex", "index", "Lcom/intellij/database/dialects/sqlite/model/SqliteIndex;", "describeSqliteIndexingItems", "describeSqliteKey", "key", "Lcom/intellij/database/dialects/sqlite/model/SqliteKey;", "withSurrogates", "", "describeSqliteTable", "table", "Lcom/intellij/database/dialects/sqlite/model/SqliteTable;", "describeSqliteVirtualTable", "Lcom/intellij/database/dialects/sqlite/model/SqliteVirtualTable;", "presentSqliteIndexColumn", "column", "descendants", "", "collation", "intellij.database.dialects.sqlite"})
public final class SqliteDescriptionService
extends DescriptionService {
    @NotNull
    public String content(@NotNull BasicElement e, @NotNull DescriptionService.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BasicElement basicElement = e;
        return basicElement instanceof SqliteVirtualTable ? this.describeSqliteVirtualTable((SqliteVirtualTable)e) : (basicElement instanceof SqliteTable ? this.describeSqliteTable((SqliteTable)e) : (basicElement instanceof SqliteTableColumn ? this.describeSqliteColumn((SqliteTableColumn)e) : (basicElement instanceof SqliteCheck ? this.describeSqliteCheck((SqliteCheck)e) : (basicElement instanceof SqliteKey ? this.describeSqliteKey((SqliteKey)e, context.getWithSurrogates()) : (basicElement instanceof SqliteIndex ? this.describeSqliteIndex((SqliteIndex)e) : super.content(e, context))))));
    }

    private final String describeSqliteVirtualTable(SqliteVirtualTable table) {
        String res2 = "virtual table ";
        if (table.isTemporary()) {
            res2 = "temp " + res2;
        }
        if (table.getModule() != null) {
            res2 = res2 + table.getModule();
        }
        res2 = res2 + "(" + StringUtil.join((Collection)table.getArguments(), (String)",") + ")";
        return res2;
    }

    private final String describeSqliteTable(SqliteTable table) {
        String res2 = this.describeTable((BasicTable)table);
        if (table.isWithoutRowId()) {
            res2 = res2 + " without rowid";
        }
        return res2;
    }

    private final String describeSqliteColumn(SqliteTableColumn col) {
        String res2 = this.describeColumn((BasicLikeColumn)col);
        if (col.getOnNullConflict() != null) {
            res2 = res2 + " on conflict " + col.getOnNullConflict();
        }
        if (col.getCollation() != null) {
            res2 = res2 + " collate " + col.getCollation();
        }
        return res2;
    }

    private final String describeSqliteCheck(SqliteCheck chk) {
        String res2 = this.describeCheck((BasicCheck)chk);
        if (chk.getOnConflict() != null) {
            res2 = res2 + " on conflict " + chk.getOnConflict();
        }
        return res2;
    }

    private final String describeSqliteKey(SqliteKey key2, boolean withSurrogates) {
        String res2 = this.describeKey((BasicKey)key2, withSurrogates);
        if (key2.getOnConflict() != null) {
            String string = String.valueOf(key2.getOnConflict());
            StringBuilder stringBuilder = new StringBuilder().append(res2).append(" on conflict ");
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            String string4 = string3;
            res2 = stringBuilder.append(string4).toString();
        }
        return res2;
    }

    private final String describeSqliteIndex(SqliteIndex index2) {
        String inner = this.describeSqliteIndexingItems(index2);
        String condition = index2.getCondition();
        String d = (index2.isUnique() ? "unique" : "index") + " (" + inner + ')';
        if (condition != null) {
            d = d + " when " + condition;
        }
        return d;
    }

    @NotNull
    public final String describeSqliteIndexingItems(@NotNull SqliteIndex index2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)index2, (String)"index");
        List<String> list = index2.getColNames();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"index.colNames");
        List<String> names = list;
        Set<String> set = index2.getReverseColNames();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"index.reverseColNames");
        Set<String> ds = set;
        List<String> list2 = index2.getColumnCollations();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"index.columnCollations");
        List<String> col = list2;
        Object object = names;
        boolean bl = false;
        if (!object.isEmpty()) {
            object = ", ";
            CharSequence charSequence = null;
            int n = 0;
            CharSequence charSequence2 = null;
            CharSequence charSequence3 = null;
            Function1 function1 = (Function1)new Function1<IndexedValue<? extends String>, String>(this, ds, col){
                final /* synthetic */ SqliteDescriptionService this$0;
                final /* synthetic */ Set $ds;
                final /* synthetic */ List $col;

                @NotNull
                public final String invoke(@NotNull IndexedValue<String> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    return SqliteDescriptionService.access$presentSqliteIndexColumn(this.this$0, (String)it.getValue(), this.$ds, (String)CollectionsKt.getOrNull((List)this.$col, (int)it.getIndex()));
                }
                {
                    this.this$0 = sqliteDescriptionService;
                    this.$ds = set;
                    this.$col = list;
                    super(1);
                }
            };
            string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.withIndex((Iterable)names), (CharSequence)object, charSequence3, charSequence2, (int)n, charSequence, (Function1)function1, (int)30, null);
        } else {
            string = "???";
        }
        String representation2 = string;
        return representation2;
    }

    private final String presentSqliteIndexColumn(String column2, Set<String> descendants, String collation) {
        String res2 = this.presentIndexColumn(column2, descendants);
        if (StringUtil.isNotEmpty((String)collation)) {
            res2 = res2 + " collate " + collation;
        }
        return res2;
    }

    public static final /* synthetic */ String access$presentSqliteIndexColumn(SqliteDescriptionService $this, String column2, Set descendants, String collation) {
        return $this.presentSqliteIndexColumn(column2, descendants, collation);
    }
}

