/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.db2;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.ObjectKind;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.dateTime.SqlDateTimeLanguageHelper;
import com.intellij.sql.dialects.db2.Db2DateTimeLanguageHelper;
import com.intellij.sql.dialects.db2.Db2ElementTypes;
import com.intellij.sql.dialects.db2.Db2LUWDialect;
import com.intellij.sql.dialects.db2.Db2OptionalKeywords;
import com.intellij.sql.dialects.db2.Db2Tokens;
import com.intellij.sql.dialects.db2.Db2Types;
import com.intellij.sql.dialects.db2.refactoring.Db2ExtractFunctionHelper;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlDeleteStatement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlMergeStatement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Db2DialectBase
extends SqlLanguageDialectEx {
    public Db2DialectBase(String id) {
        super(id);
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            Db2DialectBase.$$$reportNull$$$0(0);
        }
        return builtinFunctions;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            Db2DialectBase.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            Db2DialectBase.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            Db2DialectBase.$$$reportNull$$$0(3);
        }
        return set;
    }

    public boolean isResolveTargetAccepted(@Nullable PsiElement element, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            Db2DialectBase.$$$reportNull$$$0(4);
        }
        if (element instanceof SqlFileImpl.FakeDefinition && type == ObjectKind.OBJECT_TYPE && expectedTypes.contains(ObjectKind.ROUTINE)) {
            return true;
        }
        return super.isResolveTargetAccepted(element, type, expectedTypes, place, strict, isCompletion);
    }

    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    @NotNull
    public Collection<ObjectKind> getMajorChildKinds() {
        Collection collection = LazyData.MAJOR_CHILD_KINDS;
        if (collection == null) {
            Db2DialectBase.$$$reportNull$$$0(5);
        }
        return collection;
    }

    public boolean isTableAliasAllowedAt(@NotNull PsiElement element) {
        if (element == null) {
            Db2DialectBase.$$$reportNull$$$0(6);
        }
        return super.isTableAliasAllowedAt(element) || PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlDeleteStatement.class, SqlUpdateStatement.class, SqlMergeStatement.class}) != null;
    }

    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element == null) {
            Db2DialectBase.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            Db2DialectBase.$$$reportNull$$$0(8);
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue((String)name2, (String)LazyData.RE_PREVVAL.name, (boolean)resolve) && SqlImplUtil.getQualifierKind((PsiElement)element) == ObjectKind.SEQUENCE && !processor.executeTarget((DasObject)LazyData.RE_PREVVAL, element, this.getTypeSystem().integerType(), Boolean.valueOf(false), ResolveState.initial())) {
            return false;
        }
        return super.processReservedEntitiesWithType(name2, element, resolve, processor);
    }

    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        super.getParentDbTypes(result2, type);
        if (type == ObjectKind.ROUTINE || type == ObjectKind.METHOD) {
            result2.add((ObjectKind)ObjectKind.COLUMN);
        }
        return result2;
    }

    private static boolean isMethodReference(PsiElement element) {
        if (!(element instanceof SqlReferenceExpression)) {
            return false;
        }
        for (PsiElement child : element.getChildren()) {
            if (PsiUtilCore.getElementType((PsiElement)child) != Db2Types.DB2_DOUBLE_DOT) continue;
            return true;
        }
        return false;
    }

    public boolean isResolveTargetNotAccepted(@Nullable Object element, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            Db2DialectBase.$$$reportNull$$$0(9);
        }
        if (type == ObjectKind.ROUTINE && element instanceof DasRoutine && ((DasRoutine)element).getDasParent() instanceof DasUserDefinedType && !Db2DialectBase.isMethodReference(place)) {
            return true;
        }
        return super.isResolveTargetNotAccepted(element, type, expectedTypes, place, strict, isCompletion);
    }

    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return Db2ExtractFunctionHelper.INSTANCE;
    }

    @NotNull
    public SqlDateTimeLanguageHelper getDateTimeHelper() {
        Db2DateTimeLanguageHelper db2DateTimeLanguageHelper = Db2DateTimeLanguageHelper.INSTANCE;
        if (db2DateTimeLanguageHelper == null) {
            Db2DialectBase.$$$reportNull$$$0(10);
        }
        return db2DateTimeLanguageHelper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/db2/Db2DialectBase";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/db2/Db2DialectBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorChildKinds";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateTimeHelper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetNotAccepted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        static final Db2DialectBase INSTANCE = Db2LUWDialect.INSTANCE;
        static final ReservedEntity RE_PREVVAL = new ReservedEntity("prevval", ObjectKind.COLUMN);
        static final TokenClasses ourClasses = new TokenClasses(Db2Tokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = new SqlLanguageDialectEx.BuiltinFunctionsMap(SqlFunctionsUtil.loadFunctionDefinition((SqlLanguageDialectEx)INSTANCE));
        static final Set<String> ourSystemVars;
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;
        static final Set<IElementType> ourSupportedOperators;
        private static final EnterHandlerDelegate ENTER_HANDLER;
        private static final Collection<ObjectKind> MAJOR_CHILD_KINDS;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars((SqlLanguageDialect)INSTANCE));
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.all);
            ourReservedKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.reserved);
            ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlElementTypes.SQL_OP_PLUS, SqlElementTypes.SQL_OP_MINUS, SqlElementTypes.SQL_OP_MUL, SqlElementTypes.SQL_OP_DIV, SqlElementTypes.SQL_OP_NEQ, SqlElementTypes.SQL_OP_LE, SqlElementTypes.SQL_OP_LT, SqlElementTypes.SQL_OP_GE, SqlElementTypes.SQL_OP_EQ, SqlElementTypes.SQL_OP_GT, SqlElementTypes.SQL_OP_CONCAT, SqlElementTypes.SQL_AND, SqlElementTypes.SQL_NOT, SqlElementTypes.SQL_OR, SqlElementTypes.SQL_IS, SqlElementTypes.SQL_LIKE, SqlElementTypes.SQL_COLLATE, SqlElementTypes.SQL_IN, SqlElementTypes.SQL_OP_LOGICAL_AND, SqlElementTypes.SQL_OP_BITWISE_AND, SqlElementTypes.SQL_OP_BITWISE_NOT, SqlElementTypes.SQL_OP_BITWISE_OR, SqlElementTypes.SQL_OP_LOGICAL_OR, SqlElementTypes.SQL_OP_BITWISE_XOR, SqlElementTypes.SQL_OP_MODULO, SqlElementTypes.SQL_OP_NEQ2, SqlElementTypes.SQL_OP_NOT_LT, SqlElementTypes.SQL_OP_NOT_GT, SqlElementTypes.SQL_OP_NEQ2, SqlElementTypes.SQL_OP_PLUS_EQ, SqlElementTypes.SQL_OP_MINUS_EQ, SqlElementTypes.SQL_OP_MUL_EQ, SqlElementTypes.SQL_OP_DIV_EQ, SqlElementTypes.SQL_OP_MODULO_EQ, SqlElementTypes.SQL_OP_BITWISE_AND_EQ, SqlElementTypes.SQL_OP_BITWISE_OR_EQ, SqlElementTypes.SQL_OP_BITWISE_XOR_EQ, Db2OptionalKeywords.DB2_CONCAT, SqlElementTypes.SQL_LEFT_BRACKET});
            ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessor[]{new SqlCloseBlockProcessorImpl(new SqlCloseBlockProcessorImpl.SubstitutionDescriptor[]{new SubstitutionDescriptorImpl(new IElementType[]{Db2Types.DB2_DO, SqlElementTypes.SQL_FOR_LOOP_STATEMENT}, "", "end for;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_FOR, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON}).mask(new boolean[]{true, true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_BEGIN, SqlElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON}).mask(new boolean[]{true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{Db2Types.DB2_ATOMIC, SqlElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON}).mask(new boolean[]{true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{Db2Types.DB2_STATIC, Db2Types.DB2_SQL_EMBEDDED_STATEMENT}, "", "end compound;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlElementTypes.SQL_END, Db2Types.DB2_COMPOUND, SqlElementTypes.SQL_SEMICOLON}).mask(new boolean[]{true, true, false})}), new SubstitutionDescriptorImpl(new IElementType[]{Db2Types.DB2_STATEMENTS, Db2Types.DB2_SQL_EMBEDDED_STATEMENT}, "", "end compound;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlElementTypes.SQL_END, Db2Types.DB2_COMPOUND, SqlElementTypes.SQL_SEMICOLON}).mask(new boolean[]{true, true, false})}), new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_LOOP, SqlElementTypes.SQL_LOOP_STATEMENT}, "", "end loop;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_LOOP, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON}).mask(new boolean[]{true, true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_REPEAT, SqlElementTypes.SQL_REPEAT_LOOP_STATEMENT}, "", "until  end repeat;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_REPEAT, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON}).mask(new boolean[]{true, true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{Db2Types.DB2_DO, SqlElementTypes.SQL_WHILE_LOOP_STATEMENT}, "", "end while;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlElementTypes.SQL_END, Db2Types.DB2_WHILE, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON}).mask(new boolean[]{true, true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_THEN, SqlElementTypes.SQL_THEN_CLAUSE, SqlElementTypes.SQL_IF_STATEMENT}, "", "end if;", 2, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_IF, SqlElementTypes.SQL_SEMICOLON}).mask(new boolean[]{true, true, false})})})});
            MAJOR_CHILD_KINDS = Arrays.asList(ObjectKind.TRIGGER, ObjectKind.INDEX, Db2ElementTypes.Kinds.MASK, Db2ElementTypes.Kinds.PERMISSION);
        }
    }
}

