/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.mongo.js.ExpressionParser;
import com.intellij.sql.dialects.mongo.js.JSElementTypes;
import com.intellij.sql.dialects.mongo.js.JavaScriptParser;
import com.intellij.sql.dialects.mongo.js.JavaScriptParserBase;
import com.intellij.sql.dialects.mongo.js.StatementParser;
import gnu.trove.TIntStack;
import org.jetbrains.annotations.NotNull;

public class FunctionParser
extends JavaScriptParserBase {
    public static final Key<Boolean> ASYNC_METHOD_KEY = Key.create((String)"js.asyncMethod");
    public static final Key<String> methodsEmptinessKey = Key.create((String)"methodsEmptinessKey");
    public static final String METHODS_EMPTINESS_ALWAYS = "a";
    public static final String METHODS_EMPTINESS_POSSIBLY = "p";
    public static final Key<Boolean> IS_GENERATOR_FUNCTION_KEY = Key.create((String)"js.generator.Function");
    public static final Key<Boolean> HAD_GET_SET = Key.create((String)"js.getsetParser");
    private static final int B_PAREN = 1;
    private static final int B_BRACE = 2;
    private static final int B_BRACKET = 3;

    protected FunctionParser(JavaScriptParser parser) {
        super(parser);
    }

    public boolean parseFunctionExpression() {
        PsiBuilder.Marker mark2 = this.builder.mark();
        this.parseFunctionExpressionAttributeList();
        return this.parseFunctionNoMarker(Context.EXPRESSION, mark2);
    }

    public boolean isFunctionDeclarationStart() {
        return this.builder.getTokenType() == JSElementTypes.FUNCTION_KEYWORD;
    }

    public void parseFunctionDeclaration() {
        String prevMethodEmptiness = (String)this.builder.getUserData(methodsEmptinessKey);
        try {
            PsiBuilder.Marker mark2 = this.builder.mark();
            this.parseAttributesList();
            this.parseFunctionNoMarker(Context.SOURCE_ELEMENT, mark2);
        }
        finally {
            this.builder.putUserData(methodsEmptinessKey, (Object)prevMethodEmptiness);
        }
    }

    public void parseFunctionExpressionAttributeList() {
        this.parseAttributesList();
    }

    public boolean parseFunctionNoMarker(Context context, @NotNull PsiBuilder.Marker functionMarker) {
        if (functionMarker == null) {
            FunctionParser.$$$reportNull$$$0(0);
        }
        boolean functionKeywordWasOmitted = true;
        boolean parsedWithoutErrors = true;
        boolean isGeneratorContext = false;
        if (this.builder.getTokenType() == JSElementTypes.FUNCTION_KEYWORD && context != Context.PROPERTY) {
            this.builder.advanceLexer();
            functionKeywordWasOmitted = false;
            if (this.builder.getTokenType() == JSElementTypes.MULT) {
                this.builder.advanceLexer();
                isGeneratorContext = true;
            }
        }
        boolean wasGenerator = this.isGeneratorContext();
        this.setIsGenerator(isGeneratorContext);
        if (!this.parseFunctionName(functionKeywordWasOmitted, context)) {
            this.builder.error("function name expected");
            parsedWithoutErrors = false;
        }
        parsedWithoutErrors &= this.parseParameterList(context == Context.EXPRESSION || context == Context.PROPERTY);
        this.myJavaScriptParser.getTypeParser().tryParseFunctionReturnType();
        String methodEmptiness = (String)this.builder.getUserData(methodsEmptinessKey);
        if (methodEmptiness == null) {
            if (functionKeywordWasOmitted && JSElementTypes.ARROWS.contains(this.builder.getTokenType())) {
                this.builder.advanceLexer();
            }
            parsedWithoutErrors &= this.myJavaScriptParser.getStatementParser().parseFunctionBody();
        } else if (METHODS_EMPTINESS_ALWAYS.equals(methodEmptiness)) {
            if (this.builder.getTokenType() == JSElementTypes.SEMICOLON) {
                this.builder.advanceLexer();
            }
            if (this.builder.getTokenType() == JSElementTypes.LBRACE) {
                String message = this.builder.getUserData(StatementParser.withinInterfaceKey) == null ? "Ambient declaration should have no body" : "Interface functions declaration should have no body";
                parsedWithoutErrors = false;
                this.builder.error(message);
            }
        } else if (METHODS_EMPTINESS_POSSIBLY.equals(methodEmptiness)) {
            if (functionKeywordWasOmitted && JSElementTypes.ARROWS.contains(this.builder.getTokenType())) {
                this.builder.advanceLexer();
                parsedWithoutErrors &= this.myJavaScriptParser.getStatementParser().parseFunctionBody();
            } else if (this.builder.getTokenType() == JSElementTypes.SEMICOLON) {
                this.builder.advanceLexer();
            } else if (this.builder.getTokenType() == JSElementTypes.LBRACE) {
                parsedWithoutErrors &= this.myJavaScriptParser.getStatementParser().parseFunctionBody();
            }
        }
        functionMarker.done(context == Context.SOURCE_ELEMENT ? this.getFunctionDeclarationElementType() : this.getFunctionExpressionElementType());
        functionMarker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        this.setIsGenerator(wasGenerator);
        return parsedWithoutErrors;
    }

    public boolean parseFunctionName(boolean functionKeywordWasOmitted, Context context) {
        IElementType tokenType = this.builder.getTokenType();
        if (!(this.isIdentifierToken(tokenType) || functionKeywordWasOmitted && JSElementTypes.PROPERTY_NAMES.contains(tokenType))) {
            return context == Context.EXPRESSION;
        }
        this.parseFunctionIdentifier();
        return true;
    }

    public void parseFunctionIdentifier() {
        IElementType tokenType = this.builder.getTokenType();
        if (JSElementTypes.PROPERTY_NAMES.contains(tokenType)) {
            this.myJavaScriptParser.getExpressionParser().advancePropertyName(tokenType);
        } else {
            this.builder.advanceLexer();
        }
    }

    public IElementType getFunctionDeclarationElementType() {
        return JSElementTypes.FUNCTION_DECLARATION;
    }

    public boolean parseAttributesList() {
        PsiBuilder.Marker mark2 = this.builder.mark();
        IElementType type = this.builder.getTokenType();
        if (type == JSElementTypes.EXPORT_KEYWORD || type == JSElementTypes.GET_KEYWORD || type == JSElementTypes.SET_KEYWORD) {
            this.builder.advanceLexer();
        }
        mark2.done(this.getAttributeListElementType());
        return true;
    }

    public IElementType getAttributeListElementType() {
        return JSElementTypes.ATTRIBUTE_LIST;
    }

    public void parseES7Decorators() {
        StatementParser.LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.AT);
        while (this.builder.getTokenType() == JSElementTypes.AT) {
            PsiBuilder.Marker attribute = this.builder.mark();
            this.builder.advanceLexer();
            ExpressionParser expressionParser = this.myJavaScriptParser.getExpressionParser();
            expressionParser.parseLeftHandSideExpression(false, false);
            attribute.done((IElementType)JSElementTypes.ES6_DECORATOR);
        }
    }

    public boolean tryParseES7Decorators() {
        boolean hadAnnotation;
        boolean bl = hadAnnotation = this.builder.getTokenType() == JSElementTypes.AT;
        if (hadAnnotation && this.hasSupportDecorators()) {
            this.parseES7Decorators();
        }
        return hadAnnotation;
    }

    public boolean hasSupportDecorators() {
        return false;
    }

    public boolean parseParameterList(boolean funExpr) {
        if (this.builder.getTokenType() != JSElementTypes.LPAR) {
            this.builder.error("( expected");
            if (!funExpr) {
                PsiBuilder.Marker parameterList = this.builder.mark();
                parameterList.done(this.getParameterListElementType());
            }
            return false;
        }
        PsiBuilder.Marker parameterList = this.builder.mark();
        this.builder.advanceLexer();
        boolean hasErrors = false;
        boolean first2 = true;
        while (this.builder.getTokenType() != JSElementTypes.RPAR) {
            if (first2) {
                first2 = false;
            } else if (this.builder.getTokenType() == JSElementTypes.COMMA) {
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSElementTypes.RPAR && this.allowLastCommaInParameterAndArgumentList()) {
                    break;
                }
            } else {
                this.builder.error(", or ) expected");
                hasErrors = true;
                break;
            }
            PsiBuilder.Marker parameter = this.builder.mark();
            if (this.builder.getTokenType() == JSElementTypes.DOT_DOT_DOT) {
                this.builder.advanceLexer();
            }
            hasErrors |= !this.parseSingleParameter(parameter);
        }
        if (this.builder.getTokenType() == JSElementTypes.RPAR) {
            this.builder.advanceLexer();
        }
        parameterList.done(this.getParameterListElementType());
        if (first2) {
            return true;
        }
        return !hasErrors;
    }

    protected boolean parseSingleParameter(PsiBuilder.Marker parameter) {
        ParseResult result2 = this.doParseSingleParameter();
        if (result2.acceptResult) {
            parameter.done(result2.elementType);
        } else {
            parameter.drop();
        }
        return !result2.hasCriticalErrors;
    }

    protected ParseResult doParseSingleParameter() {
        boolean acceptResult;
        IElementType tokenType;
        boolean hasCriticalErrors = false;
        boolean hasOtherErrors = false;
        IElementType elementType = this.getParameterType();
        boolean allowPropertyNameAsIdentifier = this.parseParameterAttributeList();
        if (this.isParameterName(allowPropertyNameAsIdentifier, tokenType = this.builder.getTokenType())) {
            this.builder.advanceLexer();
            this.parseParameterOptionalMark();
            if (!this.tryParseArrowFunctionParameterType()) {
                hasOtherErrors = true;
            }
            if (this.builder.getTokenType() == JSElementTypes.EQ) {
                PsiBuilder.Marker m = null;
                if (!this.hasParameterInitializers()) {
                    m = this.builder.mark();
                }
                this.builder.advanceLexer();
                this.myJavaScriptParser.getExpressionParser().parseAssignmentExpression(true);
                if (m != null) {
                    m.error(", or ) expected");
                    hasCriticalErrors = true;
                }
            }
            acceptResult = true;
        } else if (this.willParseDestructuringAssignment()) {
            elementType = this.myJavaScriptParser.getExpressionParser().parseDestructuringElementNoMarker(this.getParameterType(), true, true);
            acceptResult = true;
        } else {
            this.builder.error("formal parameter name expected");
            hasCriticalErrors = true;
            if (this.hasParameterInitializers() && this.builder.getTokenType() == JSElementTypes.EQ) {
                this.builder.advanceLexer();
                this.myJavaScriptParser.getExpressionParser().parseAssignmentExpression(true);
            } else {
                this.myJavaScriptParser.getTypeParser().tryParseType();
            }
            acceptResult = false;
        }
        return new ParseResult(hasCriticalErrors, hasOtherErrors, acceptResult, elementType);
    }

    protected boolean isParameterName(boolean allowPropertyNameAsIdentifier, IElementType tokenType) {
        return this.isIdentifierToken(tokenType) || allowPropertyNameAsIdentifier && JSElementTypes.IDENTIFIER_NAMES.contains(tokenType);
    }

    protected boolean allowLastCommaInParameterAndArgumentList() {
        return false;
    }

    protected boolean tryParseArrowFunctionParameterType() {
        boolean looksLikeParameterList = this.builder.getTokenType() == JSElementTypes.COLON;
        this.myJavaScriptParser.getTypeParser().tryParseType();
        return looksLikeParameterList;
    }

    public IElementType getParameterType() {
        return JSElementTypes.FORMAL_PARAMETER;
    }

    public void parseParameterOptionalMark() {
    }

    public boolean willParseDestructuringAssignment() {
        return FunctionParser.willParseDestructuringAssignment(this.builder.getTokenType());
    }

    public static boolean willParseDestructuringAssignment(IElementType tokenType) {
        return tokenType == JSElementTypes.LBRACKET || tokenType == JSElementTypes.LBRACE;
    }

    protected boolean hasParameterInitializers() {
        return false;
    }

    protected boolean parseParameterAttributeList() {
        if (this.hasSupportDecorators() && this.builder.getTokenType() == JSElementTypes.AT) {
            PsiBuilder.Marker mark2 = this.builder.mark();
            this.tryParseES7Decorators();
            mark2.done(this.getAttributeListElementType());
        }
        return false;
    }

    public boolean parseArrowFunction() {
        return this.parseArrowFunctionWithoutModifiers(this.builder.mark());
    }

    protected boolean parseArrowFunctionWithoutModifiers(@NotNull PsiBuilder.Marker arrowFunction) {
        IElementType firstToken;
        if (arrowFunction == null) {
            FunctionParser.$$$reportNull$$$0(1);
        }
        if (this.isIdentifierToken(firstToken = this.builder.getTokenType()) && JSElementTypes.ARROWS.contains(this.builder.lookAhead(1))) {
            PsiBuilder.Marker parameterList = this.builder.mark();
            PsiBuilder.Marker parameter = this.builder.mark();
            this.builder.advanceLexer();
            parameter.done(this.getParameterType());
            parameterList.done(this.getParameterListElementType());
            parameterList.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        } else {
            if (!this.isArrowFunctionWithParentheses(false)) {
                arrowFunction.rollbackTo();
                return false;
            }
            this.parseParameterList(true);
            if (!this.tryParseArrowReturnType(arrowFunction)) {
                return false;
            }
        }
        IElementType arrow = this.builder.getTokenType();
        if (JSElementTypes.ARROWS.contains(arrow)) {
            this.builder.advanceLexer();
            this.myJavaScriptParser.getStatementParser().parseBlockOrFunctionBody(StatementParser.BlockType.ARROW_FUNCTION_BODY);
        } else {
            this.builder.error("expected =>");
        }
        arrowFunction.done(this.getFunctionExpressionElementType());
        arrowFunction.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return true;
    }

    private boolean tryParseArrowReturnType(@NotNull PsiBuilder.Marker arrowFunction) {
        IElementType type;
        if (arrowFunction == null) {
            FunctionParser.$$$reportNull$$$0(2);
        }
        if ((type = this.builder.getTokenType()) == JSElementTypes.COLON && !this.myJavaScriptParser.getTypeParser().tryParseArrowFunctionReturnType()) {
            arrowFunction.rollbackTo();
            return false;
        }
        return true;
    }

    public boolean isArrowFunctionWithParentheses(boolean expectOnlyDestructuring) {
        PsiBuilder.Marker marker = this.builder.mark();
        if (this.builder.getTokenType() == JSElementTypes.LT) {
            this.builder.advanceLexer();
            int balance = 1;
            while (!this.builder.eof()) {
                IElementType tokenType = this.builder.getTokenType();
                if (tokenType == JSElementTypes.LT) {
                    ++balance;
                } else if (tokenType == JSElementTypes.GT) {
                    --balance;
                }
                this.builder.advanceLexer();
                if (balance != 0) continue;
                break;
            }
        }
        if (this.builder.getTokenType() != JSElementTypes.LPAR) {
            marker.rollbackTo();
            return false;
        }
        IElementType next = this.builder.lookAhead(1);
        if (!this.isValidFirstParameterStart(next)) {
            marker.rollbackTo();
            return false;
        }
        TIntStack braceBalance = new TIntStack();
        boolean seenQuestion = false;
        boolean isEmpty = false;
        boolean seenColonCast = false;
        while (!this.builder.eof()) {
            IElementType tokenType = this.builder.getTokenType();
            if (tokenType == JSElementTypes.LPAR) {
                if (braceBalance.size() == 0 && this.builder.lookAhead(1) == JSElementTypes.RPAR) {
                    isEmpty = true;
                }
                braceBalance.push(1);
            } else if (tokenType == JSElementTypes.RPAR) {
                if (braceBalance.size() == 0 || braceBalance.pop() != 1) {
                    marker.rollbackTo();
                    return false;
                }
                if (braceBalance.size() == 0) {
                    this.builder.advanceLexer();
                    if (!seenColonCast || this.builder.getTokenType() != JSElementTypes.COLON || !this.shouldBreakCast()) break;
                    marker.rollbackTo();
                    return true;
                }
                seenColonCast = false;
            } else if (tokenType == JSElementTypes.LBRACE) {
                braceBalance.push(2);
            } else if (tokenType == JSElementTypes.RBRACE) {
                if (braceBalance.size() == 0 || braceBalance.pop() != 2) {
                    marker.rollbackTo();
                    return false;
                }
            } else if (tokenType == JSElementTypes.LBRACKET) {
                braceBalance.push(3);
            } else if (tokenType == JSElementTypes.RBRACKET) {
                if (braceBalance.size() == 0 || braceBalance.pop() != 3) {
                    marker.rollbackTo();
                    return false;
                }
            } else if (tokenType == JSElementTypes.QUEST) {
                if (braceBalance.size() == 1 && braceBalance.peek() == 1) {
                    if (this.builder.lookAhead(1) == JSElementTypes.COLON) {
                        marker.rollbackTo();
                        return true;
                    }
                    seenQuestion = true;
                }
            } else if (tokenType == JSElementTypes.COLON) {
                if (braceBalance.size() == 1 && braceBalance.peek() == 1) {
                    if (seenQuestion) {
                        marker.rollbackTo();
                        return false;
                    }
                    if (!this.supportsColonTypeCast()) {
                        marker.rollbackTo();
                        return true;
                    }
                    seenColonCast = true;
                }
            } else if (tokenType == JSElementTypes.COMMA && braceBalance.size() == 1 && braceBalance.peek() == 1) {
                if (this.builder.lookAhead(1) == JSElementTypes.EQ) {
                    marker.rollbackTo();
                    return true;
                }
                seenQuestion = false;
            }
            if (expectOnlyDestructuring && (tokenType == JSElementTypes.OR || tokenType == JSElementTypes.AND) && (braceBalance.size() == 1 && braceBalance.peek() == 1 || braceBalance.peek() == 2)) {
                marker.rollbackTo();
                return false;
            }
            this.builder.advanceLexer();
        }
        if (isEmpty && this.builder.getTokenType() == JSElementTypes.COLON) {
            marker.rollbackTo();
            return true;
        }
        if (!this.tryParseArrowReturnType(marker)) {
            return false;
        }
        boolean result2 = JSElementTypes.ARROWS.contains(this.builder.getTokenType());
        marker.rollbackTo();
        return result2;
    }

    protected boolean shouldBreakCast() {
        return false;
    }

    protected boolean isValidFirstParameterStart(IElementType next) {
        if (next == JSElementTypes.RPAR || next == JSElementTypes.DOT_DOT_DOT || FunctionParser.willParseDestructuringAssignment(next)) {
            return true;
        }
        boolean isParameterName = this.isParameterName(true, next);
        if (!isParameterName) {
            return false;
        }
        int lookaheadSteps = 2;
        if (next == JSElementTypes.CLASS_KEYWORD || next == JSElementTypes.FUNCTION_KEYWORD || next == JSElementTypes.ASYNC_KEYWORD && (next = this.builder.lookAhead(lookaheadSteps++)) == JSElementTypes.FUNCTION_KEYWORD) {
            IElementType lookAhead = this.builder.lookAhead(lookaheadSteps);
            if (this.isIdentifierToken(lookAhead)) {
                return false;
            }
            if (next == JSElementTypes.FUNCTION_KEYWORD) {
                return lookAhead != JSElementTypes.LPAR && lookAhead != JSElementTypes.MULT;
            }
            return lookAhead != JSElementTypes.LBRACE;
        }
        return true;
    }

    protected boolean supportsColonTypeCast() {
        return false;
    }

    public IElementType getParameterListElementType() {
        return JSElementTypes.PARAMETER_LIST;
    }

    protected IElementType getFunctionExpressionElementType() {
        return JSElementTypes.FUNCTION_EXPRESSION;
    }

    public boolean isAsyncContext() {
        return Boolean.TRUE.equals(this.builder.getUserData(ASYNC_METHOD_KEY));
    }

    public void setIsGenerator(boolean isGenerator) {
        if (!this.myJavaScriptParser.getExpressionParser().hasGeneratorsSupport()) {
            return;
        }
        this.builder.putUserData(IS_GENERATOR_FUNCTION_KEY, (Object)isGenerator);
    }

    public boolean isGeneratorContext() {
        if (this.myJavaScriptParser.getExpressionParser().hasGeneratorsSupport()) {
            return Boolean.TRUE.equals(this.builder.getUserData(IS_GENERATOR_FUNCTION_KEY));
        }
        return false;
    }

    protected boolean parseParameterListAndBody(PsiBuilder.Marker marker, IElementType elementType) {
        boolean lexerAdvanced = this.myJavaScriptParser.getFunctionParser().parseParameterList(false);
        lexerAdvanced |= this.myJavaScriptParser.getTypeParser().tryParseFunctionReturnType();
        marker.done(elementType);
        marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return lexerAdvanced |= this.myJavaScriptParser.getStatementParser().parseFunctionBody();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionMarker";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrowFunction";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/dialects/mongo/js/FunctionParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseFunctionNoMarker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parseArrowFunctionWithoutModifiers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "tryParseArrowReturnType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class ParseResult {
        public final boolean hasCriticalErrors;
        public final boolean hasOtherErrors;
        public final boolean acceptResult;
        public final IElementType elementType;

        public ParseResult(boolean hasCriticalErrors, boolean hasOtherErrors, boolean acceptResult, IElementType elementType) {
            this.hasCriticalErrors = hasCriticalErrors;
            this.acceptResult = acceptResult;
            this.elementType = elementType;
            this.hasOtherErrors = hasOtherErrors;
        }
    }

    public static enum Context {
        EXPRESSION,
        SOURCE_ELEMENT,
        PROPERTY;

    }
}

