/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dataFlow.SqlErrorSpecHelper;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.dateTime.SqlDateTimeLanguageHelper;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.mysql.MysqlDateTimeLanguageHelper;
import com.intellij.sql.dialects.mysql.MysqlDialect;
import com.intellij.sql.dialects.mysql.MysqlElementTypes;
import com.intellij.sql.dialects.mysql.MysqlOptionalKeywords;
import com.intellij.sql.dialects.mysql.MysqlReservedKeywords;
import com.intellij.sql.dialects.mysql.MysqlTypeSystem;
import com.intellij.sql.dialects.mysql.MysqlTypes;
import com.intellij.sql.dialects.mysql.dataFlow.MysqlErrorSpecHelper;
import com.intellij.sql.dialects.mysql.psi.MysqlDelimiterStatementImpl;
import com.intellij.sql.dialects.mysql.psi.MysqlShowStatementImpl;
import com.intellij.sql.dialects.mysql.refactoring.MysqlExtractFunctionHelper;
import com.intellij.sql.dialects.mysql.refactoring.MysqlExtractVariableHelper;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MysqlDialectBase
extends SqlLanguageDialectEx {
    public MysqlDialectBase(String id) {
        super(id);
    }

    protected void addTypes(Map<String, SqlFunctionDefinition.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"Geometry", (String)"geometry", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"JSON", (String)"json", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"Point", (String)"point", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"Curve", (String)"curve", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"LineString", (String)"linestring", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"Line", (String)"line", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"LinearRing", (String)"linearring", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"Surface", (String)"surface", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"Polygon", (String)"polygon", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"GeometryCollection", (String)"geometrycollection", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"MultiPoint", (String)"multipoint", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"MultiCurve", (String)"multicurve", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"MultiLineString", (String)"Multilinestring", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"MultiSurface", (String)"multisurface", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"MultiPolygon", (String)"multipolygon", (SqlLanguageDialectEx)this);
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            MysqlDialectBase.$$$reportNull$$$0(0);
        }
        return set;
    }

    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        MysqlShowStatementImpl showStatement;
        Pair<IElementType, IElementType> type;
        ReservedEntity.Typed[] cols2;
        if (element == null) {
            MysqlDialectBase.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            MysqlDialectBase.$$$reportNull$$$0(2);
        }
        if (!MysqlDialectBase.processReservedEntitiesWithTypeDual((String)name2, (PsiElement)element, (boolean)resolve, (SqlScopeProcessor)processor)) {
            return false;
        }
        SqlStatement stmt = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class);
        if (stmt instanceof MysqlShowStatementImpl && (cols2 = LazyData.RE_SHOW_COLUMNS_BY_TYPE.get(type = (showStatement = (MysqlShowStatementImpl)stmt).getShowType())) != null) {
            for (ReservedEntity.Typed col : cols2) {
                if (MysqlDialectBase.processReservedEntitiesWithTypeSimple((DasObject)col, (SqlType)col.type, (String)name2, (PsiElement)element, (boolean)resolve, (SqlScopeProcessor)processor, (boolean)true, (Boolean)false)) continue;
                return false;
            }
        }
        return super.processReservedEntitiesWithType(name2, element, resolve, processor);
    }

    public int getMaxIdentifierLength(@NotNull SqlIdentifier identifier, Version version) {
        ObjectKind kind;
        if (identifier == null) {
            MysqlDialectBase.$$$reportNull$$$0(3);
        }
        return (kind = SqlImplUtil.getIdentifierKind((SqlIdentifier)identifier)) == null ? Integer.MAX_VALUE : (kind == SqlDbElementType.LOCAL_ALIAS ? 256 : (kind == ObjectKind.USER || kind == ObjectKind.ROLE ? 32 : 64));
    }

    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        DasNamespace namespace = MysqlDialectBase.getDefaultNamespace((DbDataSource)dataSource, null);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern((ObjectName[])dsNames, (DasObject)namespace, (TreePatternNode.Group[])new TreePatternNode.Group[0]);
            if (treePattern == null) {
                MysqlDialectBase.$$$reportNull$$$0(4);
            }
            return treePattern;
        }
        TreePattern treePattern = this.getSchemaBaseImports(dataSource, dsNames, false);
        if (treePattern == null) {
            MysqlDialectBase.$$$reportNull$$$0(5);
        }
        return treePattern;
    }

    public boolean isVariablePrefix(@Nullable String prefix) {
        return "@".equals(prefix) || "@@".equals(prefix);
    }

    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    public boolean isAutoIncrementColumn(@NotNull DasColumn column2) {
        if (column2 == null) {
            MysqlDialectBase.$$$reportNull$$$0(6);
        }
        if (super.isAutoIncrementColumn(column2)) {
            return true;
        }
        String type = column2.getDataType().getSpecification();
        return StringUtil.equalsIgnoreCase((CharSequence)type, (CharSequence)"serial");
    }

    @NotNull
    public String getDelimiterAt(@NotNull SqlFile file, int offset) {
        if (file == null) {
            MysqlDialectBase.$$$reportNull$$$0(7);
        }
        String result2 = null;
        if (offset > 0) {
            for (MysqlDelimiterStatementImpl delimiter : SqlImplUtil.iterateStatementsBackward((PsiFile)file, (int)offset).filter(MysqlDelimiterStatementImpl.class)) {
                if (delimiter.getDelimiter() == null) continue;
                result2 = delimiter.getDelimiter();
                break;
            }
        }
        if (result2 == null) {
            String string = super.getDelimiterAt(file, offset);
            if (string == null) {
                MysqlDialectBase.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = result2;
        if (string == null) {
            MysqlDialectBase.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return new MysqlExtractVariableHelper();
    }

    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return MysqlExtractFunctionHelper.INSTANCE;
    }

    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref) {
        if (ref == null) {
            MysqlDialectBase.$$$reportNull$$$0(10);
        }
        return !this.getKeywords().contains(ref);
    }

    public boolean supportsSql92CharSetSpecFor(@NotNull IElementType element) {
        if (element == null) {
            MysqlDialectBase.$$$reportNull$$$0(11);
        }
        return element == SqlCompositeElementTypes.SQL_STRING_LITERAL || element == SqlCompositeElementTypes.SQL_NUMERIC_LITERAL || element == SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE;
    }

    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    @NotNull
    public Collection<ObjectKind> getMajorChildKinds() {
        Collection collection = LazyData.MAJOR_CHILD_KINDS;
        if (collection == null) {
            MysqlDialectBase.$$$reportNull$$$0(12);
        }
        return collection;
    }

    public boolean processUnqualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state2, @NotNull PsiReference ref) {
        if (processor == null) {
            MysqlDialectBase.$$$reportNull$$$0(13);
        }
        if (state2 == null) {
            MysqlDialectBase.$$$reportNull$$$0(14);
        }
        if (ref == null) {
            MysqlDialectBase.$$$reportNull$$$0(15);
        }
        if (processor.isExpected(MysqlElementTypes.Extra.USER_VARIABLE)) {
            SqlFileImpl sqlFile;
            PsiFile file = ref.getElement().getContainingFile();
            if (file != null) {
                file = (PsiFile)ObjectUtils.chooseNotNull((Object)file.getOriginalFile(), (Object)file);
            }
            if ((sqlFile = (SqlFileImpl)ObjectUtils.tryCast((Object)file, SqlFileImpl.class)) != null) {
                for (SqlReferenceExpression expression : MysqlDialectBase.getGlobalVariables((SqlFile)sqlFile)) {
                    if (processor.execute((PsiElement)expression, state2)) continue;
                    return false;
                }
            }
            if (processor.referenceName != null && !processor.isExpected(SqlDbElementType.ANY)) {
                return false;
            }
        }
        return super.processUnqualifiedResolve(processor, state2, ref);
    }

    @NotNull
    public SqlErrorSpecHelper getErrorSpecHelper() {
        MysqlErrorSpecHelper mysqlErrorSpecHelper = MysqlErrorSpecHelper.INSTANCE;
        if (mysqlErrorSpecHelper == null) {
            MysqlDialectBase.$$$reportNull$$$0(16);
        }
        return mysqlErrorSpecHelper;
    }

    public boolean supportsJoinUsing() {
        return true;
    }

    public boolean supportsNaturalJoin() {
        return true;
    }

    @NotNull
    public SqlDateTimeLanguageHelper getDateTimeHelper() {
        MysqlDateTimeLanguageHelper mysqlDateTimeLanguageHelper = MysqlDateTimeLanguageHelper.INSTANCE;
        if (mysqlDateTimeLanguageHelper == null) {
            MysqlDialectBase.$$$reportNull$$$0(17);
        }
        return mysqlDateTimeLanguageHelper;
    }

    @NotNull
    public static List<SqlReferenceExpression> getGlobalVariables(@NotNull SqlFile file) {
        if (file == null) {
            MysqlDialectBase.$$$reportNull$$$0(18);
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create(MysqlDialectBase.calcGlobalVariables((SqlFileImpl)file), (Object[])new Object[]{file}));
        if (list == null) {
            MysqlDialectBase.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    private static List<SqlReferenceExpression> calcGlobalVariables(SqlFileImpl file) {
        SqlLanguageDialectEx language = file.getSqlLanguage();
        if (!language.getDbms().isMysql() || file.getStub() != null) {
            List<SqlReferenceExpression> list = Collections.emptyList();
            if (list == null) {
                MysqlDialectBase.$$$reportNull$$$0(20);
            }
            return list;
        }
        HashMap<String, Pair> gradedVariables = new HashMap<String, Pair>();
        for (SqlReferenceExpression ref : SqlImplUtil.sqlTraverser((PsiElement)file).filter(SqlReferenceExpression.class)) {
            String prefix;
            if (ref.getReferenceElementType() != MysqlElementTypes.Extra.MYSQL_USER_VARIABLE_REFERENCE) continue;
            SqlIdentifier identifier = ref.getIdentifier();
            String string = prefix = identifier == null ? null : identifier.getNamePrefix();
            if (!language.isVariablePrefix(prefix)) continue;
            int grade = MysqlDialectBase.getVariableReferenceGrade(ref);
            String name2 = ref.getName();
            Pair old = (Pair)gradedVariables.get(name2);
            if (old != null && grade >= (Integer)old.second) continue;
            gradedVariables.put(name2, Pair.create((Object)ref, (Object)grade));
        }
        List list = ContainerUtil.map2List(gradedVariables.values(), val -> (SqlReferenceExpression)val.first);
        if (list == null) {
            MysqlDialectBase.$$$reportNull$$$0(21);
        }
        return list;
    }

    private static int getVariableReferenceGrade(@NotNull SqlReferenceExpression ref) {
        if (ref == null) {
            MysqlDialectBase.$$$reportNull$$$0(22);
        }
        int grade = 0;
        boolean insideRoutine = PsiTreeUtil.getParentOfType((PsiElement)ref, SqlCreateProcedureStatement.class) != null;
        SqlSetAssignment assignment = (SqlSetAssignment)PsiTreeUtil.getParentOfType((PsiElement)ref, SqlSetAssignment.class);
        if (assignment != null && assignment.getLValue() == ref) {
            return insideRoutine ? grade + 1 : grade;
        }
        grade += 2;
        SqlBinaryExpression expr = (SqlBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)ref, SqlBinaryExpression.class);
        if (expr != null && expr.getLOperand() == ref && (expr.getOpSign() == SqlCommonTokens.SQL_OP_ASSIGN || expr.getOpSign() == SqlCommonTokens.SQL_OP_EQ)) {
            return insideRoutine ? grade + 1 : grade;
        }
        return insideRoutine ? grade + 1 : (grade += 2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/mysql/MysqlDialectBase";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/mysql/MysqlDialectBase";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelimiterAt";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorChildKinds";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorSpecHelper";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateTimeHelper";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalVariables";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "calcGlobalVariables";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMaxIdentifierLength";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAutoIncrementColumn";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDelimiterAt";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shouldQuotedTypeReferenceBeChecked";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "supportsSql92CharSetSpecFor";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolve";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getGlobalVariables";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getVariableReferenceGrade";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        static final MysqlDialectBase INSTANCE = MysqlDialect.INSTANCE;
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars((SqlLanguageDialect)INSTANCE));
        static final TokenSet ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlCommonTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{SqlTokens.MYSQL_DELIMITER_TOKEN})});
        static final Set<IElementType> ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlCommonTokens.SQL_OP_PLUS, SqlCommonTokens.SQL_OP_MINUS, SqlCommonTokens.SQL_OP_MUL, SqlCommonTokens.SQL_OP_DIV, SqlCommonTokens.SQL_OP_NEQ, SqlCommonTokens.SQL_OP_LE, SqlCommonTokens.SQL_OP_LT, SqlCommonTokens.SQL_OP_GE, SqlCommonTokens.SQL_OP_EQ, SqlCommonTokens.SQL_OP_GT, SqlCommonTokens.SQL_OP_CONCAT, SqlCommonKeywords.SQL_AND, SqlCommonKeywords.SQL_NOT, SqlCommonKeywords.SQL_OR, SqlCommonKeywords.SQL_IS, SqlCommonKeywords.SQL_LIKE, SqlCommonKeywords.SQL_COLLATE, SqlCommonKeywords.SQL_IN, SqlCommonTokens.SQL_OP_LOGICAL_AND, SqlCommonTokens.SQL_OP_BITWISE_AND, SqlCommonTokens.SQL_OP_INVERT, SqlCommonTokens.SQL_OP_BITWISE_OR, SqlCommonTokens.SQL_OP_LOGICAL_OR, SqlCommonTokens.SQL_OP_BITWISE_XOR, SqlCommonTokens.SQL_OP_NULLSAFE_EQ, SqlCommonTokens.SQL_OP_LEFT_SHIFT, SqlCommonTokens.SQL_OP_RIGHT_SHIFT, SqlCommonTokens.SQL_OP_MODULO, SqlCommonTokens.SQL_OP_NEQ2, SqlCommonTokens.SQL_OP_NOT2, SqlCommonTokens.SQL_OP_ASSIGN, MysqlReservedKeywords.MYSQL_REGEXP, MysqlReservedKeywords.MYSQL_RLIKE, MysqlOptionalKeywords.MYSQL_SOUNDS, MysqlReservedKeywords.MYSQL_DIV, MysqlReservedKeywords.MYSQL_MOD, MysqlReservedKeywords.MYSQL_XOR, MysqlReservedKeywords.MYSQL_BINARY});
        static final Map<Pair<IElementType, IElementType>, ReservedEntity.Typed[]> RE_SHOW_COLUMNS_BY_TYPE = ContainerUtil.immutableMapBuilder().put(LazyData.type((IElementType)MysqlReservedKeywords.MYSQL_CHARACTER, null), (Object)LazyData.cols(LazyData.col("Charset", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Description", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Default collation", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Maxlen", MysqlTypeSystem.INSTANCE.integerType()))).put(LazyData.type((IElementType)SqlCommonKeywords.SQL_COLLATION, null), (Object)LazyData.cols(LazyData.col("Collation", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Charset", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Id", MysqlTypeSystem.INSTANCE.integerType()), LazyData.col("Default", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Compiled", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Sortlen", MysqlTypeSystem.INSTANCE.integerType()))).put(LazyData.type(MysqlTypes.MYSQL_COLUMNS, null), (Object)LazyData.cols(LazyData.col("Field", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Type", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Null", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Default", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Extra", MysqlTypeSystem.INSTANCE.stringType()))).put(LazyData.type(MysqlTypes.MYSQL_FULL, MysqlTypes.MYSQL_COLUMNS), (Object)LazyData.cols(LazyData.col("Field", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Type", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Collation", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Null", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Key", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Default", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Extra", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Privileges", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Comment", MysqlTypeSystem.INSTANCE.stringType()))).put(LazyData.type((IElementType)MysqlReservedKeywords.MYSQL_DATABASES, null), (Object)LazyData.cols(LazyData.col("database", MysqlTypeSystem.INSTANCE.stringType()))).put(LazyData.type(MysqlTypes.MYSQL_EVENTS, null), (Object)LazyData.cols(LazyData.col("Db", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Name", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Definer", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Time Zone", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Type", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Execute At", MysqlTypeSystem.INSTANCE.dateTimeType()), LazyData.col("Interval Value", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Interval Field", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Starts", MysqlTypeSystem.INSTANCE.dateTimeType()), LazyData.col("Ends", MysqlTypeSystem.INSTANCE.dateTimeType()), LazyData.col("Status", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Originator", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("character_set_client", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("collation_connection", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Database Collation", MysqlTypeSystem.INSTANCE.stringType()))).put(LazyData.type(MysqlTypes.MYSQL_FUNCTION, MysqlTypes.MYSQL_STATUS), (Object)LazyData.cols(LazyData.col("Db", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Name", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Type", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Definer", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Modified", MysqlTypeSystem.INSTANCE.dateTimeType()), LazyData.col("Created", MysqlTypeSystem.INSTANCE.dateTimeType()), LazyData.col("Security_type", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Comment", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("character_set_client", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("collation_connection", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Database Collation", MysqlTypeSystem.INSTANCE.stringType()))).put(LazyData.type((IElementType)MysqlReservedKeywords.MYSQL_INDEX, null), (Object)LazyData.cols(LazyData.col("Table", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Non_unique", MysqlTypeSystem.INSTANCE.integerType()), LazyData.col("Key_name", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Seq_in_index", MysqlTypeSystem.INSTANCE.integerType()), LazyData.col("Column_name", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Collation", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Cardinality", MysqlTypeSystem.INSTANCE.integerType()), LazyData.col("Sub_part", MysqlTypeSystem.INSTANCE.integerType()), LazyData.col("Packed", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Null", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Index_type", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Comment", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Index_comment", MysqlTypeSystem.INSTANCE.stringType()))).put(LazyData.type(MysqlTypes.MYSQL_OPEN, MysqlTypes.MYSQL_TABLES), (Object)LazyData.cols(LazyData.col("Database", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Table", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("In_use", MysqlTypeSystem.INSTANCE.integerType()), LazyData.col("Name_locked", MysqlTypeSystem.INSTANCE.integerType()))).put(LazyData.type((IElementType)MysqlReservedKeywords.MYSQL_PROCEDURE, MysqlTypes.MYSQL_STATUS), (Object)LazyData.cols(LazyData.col("Db", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Name", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Type", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Definer", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Modified", MysqlTypeSystem.INSTANCE.dateTimeType()), LazyData.col("Created", MysqlTypeSystem.INSTANCE.dateTimeType()), LazyData.col("Security_type", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Comment", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("character_set_client", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("collation_connection", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Database Collation", MysqlTypeSystem.INSTANCE.stringType()))).put(LazyData.type(MysqlTypes.MYSQL_STATUS, null), (Object)LazyData.cols(LazyData.col("Variable_name", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Value", MysqlTypeSystem.INSTANCE.integerType()))).put(LazyData.type((IElementType)MysqlReservedKeywords.MYSQL_TABLE, null), (Object)LazyData.cols(LazyData.col("Name", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Engine", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Version", MysqlTypeSystem.INSTANCE.integerType()), LazyData.col("Row_format", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Rows", MysqlTypeSystem.INSTANCE.integerType()), LazyData.col("Avg_row_length", MysqlTypeSystem.INSTANCE.integerType()), LazyData.col("Data_length", MysqlTypeSystem.INSTANCE.integerType()), LazyData.col("Max_data_length", MysqlTypeSystem.INSTANCE.integerType()), LazyData.col("Index_length", MysqlTypeSystem.INSTANCE.integerType()), LazyData.col("Data_free", MysqlTypeSystem.INSTANCE.integerType()), LazyData.col("Auto_increment", MysqlTypeSystem.INSTANCE.integerType()), LazyData.col("Create_time", MysqlTypeSystem.INSTANCE.dateTimeType()), LazyData.col("Update_time", MysqlTypeSystem.INSTANCE.dateTimeType()), LazyData.col("Check_time", MysqlTypeSystem.INSTANCE.dateTimeType()), LazyData.col("Collation", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Checksum", MysqlTypeSystem.INSTANCE.integerType()), LazyData.col("Create_options", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Comment", MysqlTypeSystem.INSTANCE.stringType()))).put(LazyData.type(MysqlTypes.MYSQL_TRIGGERS, null), (Object)LazyData.cols(LazyData.col("Trigger", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Event", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Table", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Statement", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Timing", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Created", MysqlTypeSystem.INSTANCE.dateTimeType()), LazyData.col("sql_mode", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Definer", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("character_set_client", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("collation_connection", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Database Collation", MysqlTypeSystem.INSTANCE.stringType()))).put(LazyData.type(MysqlTypes.MYSQL_VARIABLES, null), (Object)LazyData.cols(LazyData.col("Variable_name", MysqlTypeSystem.INSTANCE.stringType()), LazyData.col("Value", MysqlTypeSystem.INSTANCE.stringType()))).build();
        private static final EnterHandlerDelegate ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessor[]{new SqlCloseBlockProcessorImpl(new SqlCloseBlockProcessorImpl.SubstitutionDescriptor[]{new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{SqlCommonKeywords.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlCommonKeywords.SQL_END}).opt(new IElementType[]{SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlCommonTokens.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()}), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LOOP_STATEMENT}, "", "end loop", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlCommonKeywords.SQL_END}).man(new IElementType[]{SqlCommonKeywords.SQL_LOOP}).opt(new IElementType[]{SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlCommonTokens.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()}), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{SqlCommonKeywords.SQL_THEN, SqlCompositeElementTypes.SQL_THEN_CLAUSE, SqlCompositeElementTypes.SQL_IF_STATEMENT}, "", "end if", 2, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlCommonKeywords.SQL_END}).man(new IElementType[]{SqlCommonKeywords.SQL_IF}).opt(new IElementType[]{SqlCommonTokens.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()}), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{MysqlTypes.MYSQL_DO, SqlCompositeElementTypes.SQL_WHILE_LOOP_STATEMENT}, "", "end while", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlCommonKeywords.SQL_END}).man(new IElementType[]{MysqlReservedKeywords.MYSQL_WHILE}).opt(new IElementType[]{SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlCommonTokens.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()}), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{MysqlReservedKeywords.MYSQL_REPEAT, SqlCompositeElementTypes.SQL_REPEAT_LOOP_STATEMENT}, "", "until  end repeat", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlCommonKeywords.SQL_END}).man(new IElementType[]{MysqlReservedKeywords.MYSQL_REPEAT}).opt(new IElementType[]{SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlCommonTokens.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()})})});
        private static final Collection<ObjectKind> MAJOR_CHILD_KINDS = Collections.singletonList(ObjectKind.TRIGGER);

        LazyData() {
        }

        private static ReservedEntity.Typed[] cols(ReservedEntity.Typed ... entities) {
            return entities;
        }

        private static ReservedEntity.Typed col(@NotNull String name2, @NotNull SqlType type) {
            if (name2 == null) {
                LazyData.$$$reportNull$$$0(0);
            }
            if (type == null) {
                LazyData.$$$reportNull$$$0(1);
            }
            return new ReservedEntity.Typed(name2, ObjectKind.COLUMN, type);
        }

        private static Pair<IElementType, IElementType> type(IElementType f, IElementType s) {
            return Pair.create((Object)f, (Object)s);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/dialects/mysql/MysqlDialectBase$LazyData";
            objectArray[2] = "col";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

