/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.impl.GenericNotifierImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.ConnectionDiagnoseRefresher;
import org.jetbrains.idea.perforce.application.P4ConfigConnectionDiagnoseDialog;
import org.jetbrains.idea.perforce.application.P4RootsInformation;
import org.jetbrains.idea.perforce.application.PerforceBaseInfoWorker;
import org.jetbrains.idea.perforce.application.PerforceClientRootsChecker;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;
import org.jetbrains.idea.perforce.perforce.connections.PerforceMultipleConnections;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginManager;

@Service
public final class PerforceConnectionProblemsNotifier
extends GenericNotifierImpl<Object, Object> {
    public static final String PERFORCE_CONNECTION_PROBLEMS = "Perforce connection problems";
    private boolean myConnectionProblems = false;
    private boolean myParametersProblems = false;
    private final PerforceSettings mySettings = PerforceSettings.getSettings(this.myProject);

    public PerforceConnectionProblemsNotifier(Project project) {
        super(project, "Perforce", PERFORCE_CONNECTION_PROBLEMS, NotificationType.ERROR);
    }

    protected boolean ask(Object obj, String description) {
        if ("inspect".equals(description)) {
            PerforceConnectionProblemsNotifier.showConnectionState(this.myProject, false);
            return false;
        }
        if ("offline".equals(description)) {
            this.mySettings.disable(true);
            return true;
        }
        if ("retry".equals(description)) {
            return PerforceLoginManager.getInstance(this.myProject).checkAndRepairAll();
        }
        return false;
    }

    public static void showConnectionState(Project project, boolean refreshBefore) {
        PerforceSettings settings = PerforceSettings.getSettings(project);
        final PerforceBaseInfoWorker perforceBaseInfoWorker = (PerforceBaseInfoWorker)ServiceManager.getService((Project)project, PerforceBaseInfoWorker.class);
        final PerforceConnectionManagerI connectionManager = PerforceConnectionManager.getInstance(project);
        if (settings.useP4CONFIG) {
            ConnectionDiagnoseRefresher refresher = new ConnectionDiagnoseRefresher(){

                @Override
                public void refresh() {
                    connectionManager.updateConnections();
                    PerforceMultipleConnections object = connectionManager.getMultipleConnectionObject();
                    Map<VirtualFile, P4Connection> allConnections = object.getAllConnections();
                    PerforceConnectionProblemsNotifier.refreshChecker(allConnections, perforceBaseInfoWorker);
                }

                @Override
                public PerforceMultipleConnections getMultipleConnections() {
                    return connectionManager.getMultipleConnectionObject();
                }

                @Override
                public P4RootsInformation getP4RootsInformation() {
                    return perforceBaseInfoWorker.getCheckerResults();
                }
            };
            Runnable showDialog = () -> {
                P4ConfigConnectionDiagnoseDialog dialog = new P4ConfigConnectionDiagnoseDialog(project, refresher);
                dialog.show();
            };
            if (refreshBefore) {
                PerforceConnectionProblemsNotifier.underProgress(project, () -> refresher.refresh(), showDialog);
            } else {
                showDialog.run();
            }
        } else {
            Runnable showResults = () -> {
                P4RootsInformation checkerResults = perforceBaseInfoWorker.getCheckerResults();
                PerforceConnectionProblemsNotifier.showSingleConnectionState(project, checkerResults);
            };
            if (refreshBefore) {
                PerforceConnectionProblemsNotifier.underProgress(project, () -> PerforceConnectionProblemsNotifier.refreshChecker(connectionManager.getAllConnections(), perforceBaseInfoWorker), showResults);
            } else {
                showResults.run();
            }
        }
    }

    private static void refreshChecker(Map<VirtualFile, P4Connection> allConnections, PerforceBaseInfoWorker perforceBaseInfoWorker) {
        perforceBaseInfoWorker.scheduleRefresh();
        if (!allConnections.isEmpty()) {
            P4Connection connection = allConnections.values().iterator().next();
            try {
                perforceBaseInfoWorker.getInfo(connection);
            }
            catch (VcsException vcsException) {
                // empty catch block
            }
        }
    }

    private static void underProgress(Project project, final Runnable runnable, final Runnable onSuccess) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Perforce: refresh connection state", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                runnable.run();
            }

            public void onSuccess() {
                onSuccess.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/perforce/perforce/connections/PerforceConnectionProblemsNotifier$2", "run"));
            }
        });
    }

    public static void showSingleConnectionState(Project project, P4RootsInformation checkerResults) {
        if (!checkerResults.hasAnyErrors() && !checkerResults.hasNotAuthorized()) {
            Messages.showMessageDialog((Project)project, (String)"Connection successful", (String)"Perforce Connection State", (Icon)Messages.getInformationIcon());
        } else {
            StringBuilder sb = new StringBuilder("Connection problems:\n");
            MultiMap<P4Connection, VcsException> errors = checkerResults.getErrors();
            for (VcsException exception : errors.values()) {
                sb.append(exception.getMessage()).append('\n');
            }
            if (checkerResults.hasNotAuthorized()) {
                sb.append("\nNot logged to Perforce.");
            }
            Map<P4Connection, PerforceClientRootsChecker.WrongRoots> map = checkerResults.getMap();
            for (PerforceClientRootsChecker.WrongRoots wrongRoots : map.values()) {
                sb.append("\n").append("Wrong client specification:").append('\n').append("Client roots: ").append('\n');
                for (String string : wrongRoots.getActualInClientSpec()) {
                    sb.append(string).append('\n');
                }
                sb.append("Actual root: ").append('\n');
                for (VirtualFile virtualFile : wrongRoots.getWrong()) {
                    sb.append(virtualFile.getPath()).append('\n');
                }
            }
            Messages.showMessageDialog((String)sb.toString(), (String)PERFORCE_CONNECTION_PROBLEMS, (Icon)Messages.getErrorIcon());
        }
    }

    private void recalculateState() {
        if (this.mySettings.ENABLED && (this.myConnectionProblems || this.myParametersProblems)) {
            if (this.mySettings.myCanGoOffline && !ApplicationManager.getApplication().isUnitTestMode()) {
                ApplicationManager.getApplication().invokeLater(() -> this.mySettings.disable(), ModalityState.NON_MODAL);
            }
            this.ensureNotify((Object)this);
        } else {
            this.clear();
        }
    }

    public void setProblems(boolean connectionProblems, boolean parametersProblems) {
        this.myConnectionProblems = connectionProblems;
        this.myParametersProblems = parametersProblems;
        this.recalculateState();
    }

    @NotNull
    protected Object getKey(Object obj) {
        Object object = obj;
        if (object == null) {
            PerforceConnectionProblemsNotifier.$$$reportNull$$$0(0);
        }
        return object;
    }

    @NotNull
    protected String getNotificationContent(Object obj) {
        if (this.myConnectionProblems) {
            return "Server is not available. <a href=\"inspect\">Inspect</a>  <a href=\"retry\">Retry</a>  <a href=\"offline\">Go offline</a>";
        }
        return "Configuration problem. <a href=\"inspect\">Inspect</a>";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/perforce/connections/PerforceConnectionProblemsNotifier", "getKey"));
    }
}

