/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.widget;

import com.intellij.json.JsonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.JsonSchemaCatalogProjectConfiguration;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import com.jetbrains.jsonSchema.extension.JsonSchemaInfo;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.widget.JsonSchemaInfoPopupStep;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class JsonSchemaStatusPopup {
    static final JsonSchemaInfo ADD_MAPPING = new JsonSchemaInfo(""){

        @Override
        @NotNull
        public String getDescription() {
            String string = JsonBundle.message("schema.widget.add.mapping", new Object[0]);
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/widget/JsonSchemaStatusPopup$1", "getDescription"));
        }
    };
    static final JsonSchemaInfo EDIT_MAPPINGS = new JsonSchemaInfo(""){

        @Override
        @NotNull
        public String getDescription() {
            String string = JsonBundle.message("schema.widget.edit.mappings", new Object[0]);
            if (string == null) {
                2.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/widget/JsonSchemaStatusPopup$2", "getDescription"));
        }
    };
    public static final JsonSchemaInfo LOAD_REMOTE = new JsonSchemaInfo(""){

        @Override
        @NotNull
        public String getDescription() {
            String string = JsonBundle.message("schema.widget.load.mappings", new Object[0]);
            if (string == null) {
                3.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/widget/JsonSchemaStatusPopup$3", "getDescription"));
        }
    };

    static ListPopup createPopup(@NotNull JsonSchemaService service, @NotNull Project project, @NotNull VirtualFile virtualFile, boolean showOnlyEdit) {
        if (service == null) {
            JsonSchemaStatusPopup.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JsonSchemaStatusPopup.$$$reportNull$$$0(1);
        }
        if (virtualFile == null) {
            JsonSchemaStatusPopup.$$$reportNull$$$0(2);
        }
        JsonSchemaInfoPopupStep step = JsonSchemaStatusPopup.createPopupStep(service, project, virtualFile, showOnlyEdit);
        return JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
    }

    @NotNull
    static JsonSchemaInfoPopupStep createPopupStep(@NotNull JsonSchemaService service, @NotNull Project project, @NotNull VirtualFile virtualFile, boolean showOnlyEdit) {
        List allSchemas;
        if (service == null) {
            JsonSchemaStatusPopup.$$$reportNull$$$0(3);
        }
        if (project == null) {
            JsonSchemaStatusPopup.$$$reportNull$$$0(4);
        }
        if (virtualFile == null) {
            JsonSchemaStatusPopup.$$$reportNull$$$0(5);
        }
        JsonSchemaMappingsProjectConfiguration configuration = JsonSchemaMappingsProjectConfiguration.getInstance(project);
        UserDefinedJsonSchemaConfiguration mapping = configuration.findMappingForFile(virtualFile);
        if (!showOnlyEdit || mapping == null) {
            List<JsonSchemaInfo> infos = service.getAllUserVisibleSchemas();
            Comparator<JsonSchemaInfo> comparator = Comparator.comparing(JsonSchemaInfo::getDescription, String::compareTo);
            Stream<JsonSchemaInfo> registered = infos.stream().filter(i -> i.getProvider() != null).sorted(comparator);
            List otherList = ContainerUtil.emptyList();
            if (JsonSchemaCatalogProjectConfiguration.getInstance(project).isRemoteActivityEnabled() && (otherList = infos.stream().filter(i -> i.getProvider() == null).sorted(comparator).collect(Collectors.toList())).size() == 0) {
                otherList = ContainerUtil.createMaybeSingletonList((Object)LOAD_REMOTE);
            }
            allSchemas = Stream.concat(registered, otherList.stream()).collect(Collectors.toList());
            allSchemas.add(0, mapping == null ? ADD_MAPPING : EDIT_MAPPINGS);
        } else {
            allSchemas = ContainerUtil.createMaybeSingletonList((Object)EDIT_MAPPINGS);
        }
        return new JsonSchemaInfoPopupStep(allSchemas, project, virtualFile, service, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/widget/JsonSchemaStatusPopup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createPopup";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createPopupStep";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

