/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.http.request.debug.HttpRequestDebuggerUtils;
import com.intellij.ws.http.request.environment.HttpRequestEnvironment;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.run.HttpRequestExecutorExtension;
import com.intellij.ws.http.request.run.HttpRequestExecutorExtensionFactory;
import com.intellij.ws.http.request.run.RunHttpRequestAction;
import com.intellij.ws.http.request.run.config.HttpSingleRequestExecutionConfig;
import com.intellij.ws.rest.client.RestClientBundle;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestActionsProvider {
    @NotNull
    public static HttpRequestActionsProviderStrategy getActionsProvider() {
        if (HttpRequestDebuggerUtils.isDebugEnabled()) {
            return new ShowGroupedRunAndDebugActionsStrategy();
        }
        return new ShowFlattenRunActionsStrategy();
    }

    @NotNull
    private static List<AnAction> createActions(@NotNull HttpRequest request, @NotNull Collection<String> envs, @NotNull HttpRequestExecutorExtension extension) {
        if (request == null) {
            HttpRequestActionsProvider.$$$reportNull$$$0(0);
        }
        if (envs == null) {
            HttpRequestActionsProvider.$$$reportNull$$$0(1);
        }
        if (extension == null) {
            HttpRequestActionsProvider.$$$reportNull$$$0(2);
        }
        HttpSingleRequestExecutionConfig config = new HttpSingleRequestExecutionConfig(request);
        ArrayList actions = ContainerUtil.newArrayList((Object[])new AnAction[]{new RunHttpRequestAction.RunRequestWithDefaultEnvAction(config, extension)});
        for (String env : envs) {
            actions.add(new RunHttpRequestAction.RunRequestWithEnvAction(config, env, extension));
        }
        actions.add(new RunHttpRequestAction.RunRequestWithoutEnvAction(config, extension));
        ArrayList arrayList = actions;
        if (arrayList == null) {
            HttpRequestActionsProvider.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/run/HttpRequestActionsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/run/HttpRequestActionsProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createActions";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ShowGroupedRunAndDebugActionsStrategy
    implements HttpRequestActionsProviderStrategy {
        private ShowGroupedRunAndDebugActionsStrategy() {
        }

        @Override
        @NotNull
        public List<AnAction> provideActions(@NotNull HttpRequest request, @NotNull Collection<String> environments) {
            if (request == null) {
                ShowGroupedRunAndDebugActionsStrategy.$$$reportNull$$$0(0);
            }
            if (environments == null) {
                ShowGroupedRunAndDebugActionsStrategy.$$$reportNull$$$0(1);
            }
            HttpRequestExecutorExtension runExtension = HttpRequestExecutorExtensionFactory.getRunExtension();
            ArrayList actions = ContainerUtil.newArrayList((Object[])new AnAction[]{ShowGroupedRunAndDebugActionsStrategy.newDefaultRunAction(request, environments, runExtension)});
            List extensions = ContainerUtil.map(HttpRequestDebuggerUtils.getAvailableDebuggerExtension(), extension -> HttpRequestExecutorExtensionFactory.getDebugExtension(extension));
            extensions.forEach(extension -> actions.add(ShowGroupedRunAndDebugActionsStrategy.newDefaultRunAction(request, environments, extension)));
            if (!environments.isEmpty()) {
                actions.add(new RunHttpRequestActionsGroup(request, environments, runExtension));
                extensions.forEach(extension -> actions.add(new RunHttpRequestActionsGroup(request, environments, (HttpRequestExecutorExtension)extension)));
            }
            ArrayList arrayList = actions;
            if (arrayList == null) {
                ShowGroupedRunAndDebugActionsStrategy.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        @NotNull
        private static AnAction newDefaultRunAction(@NotNull HttpRequest request, @NotNull Collection<String> environments, @Nullable HttpRequestExecutorExtension extension) {
            String envName;
            if (request == null) {
                ShowGroupedRunAndDebugActionsStrategy.$$$reportNull$$$0(3);
            }
            if (environments == null) {
                ShowGroupedRunAndDebugActionsStrategy.$$$reportNull$$$0(4);
            }
            if (StringUtil.isEmpty((String)(envName = HttpRequestEnvironment.getDefaultEnvName(request.getProject()))) || environments.isEmpty()) {
                return new RunHttpRequestAction.RunRequestWithoutEnvAction(new HttpSingleRequestExecutionConfig(request), extension);
            }
            return new RunHttpRequestAction.RunRequestWithDefaultEnvAction(new HttpSingleRequestExecutionConfig(request), extension);
        }

        @Override
        @NotNull
        public String getTooltip() {
            String string = RestClientBundle.message("rest.client.request.run.debug.request.tooltip", new Object[0]);
            if (string == null) {
                ShowGroupedRunAndDebugActionsStrategy.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environments";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/http/request/run/HttpRequestActionsProvider$ShowGroupedRunAndDebugActionsStrategy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/http/request/run/HttpRequestActionsProvider$ShowGroupedRunAndDebugActionsStrategy";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "provideActions";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTooltip";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "provideActions";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "newDefaultRunAction";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class RunHttpRequestActionsGroup
        extends AnAction {
            private final HttpRequestExecutorExtension myExtension;
            private final HttpRequest myRequest;
            private final Collection<String> myEnvironments;

            private RunHttpRequestActionsGroup(@NotNull HttpRequest request, @NotNull Collection<String> environments, @NotNull HttpRequestExecutorExtension extension) {
                if (request == null) {
                    RunHttpRequestActionsGroup.$$$reportNull$$$0(0);
                }
                if (environments == null) {
                    RunHttpRequestActionsGroup.$$$reportNull$$$0(1);
                }
                if (extension == null) {
                    RunHttpRequestActionsGroup.$$$reportNull$$$0(2);
                }
                this.myRequest = request;
                this.myEnvironments = environments;
                this.myExtension = extension;
                Presentation presentation = this.getTemplatePresentation();
                presentation.setText(RestClientBundle.message("rest.client.request.execute.with.text", this.myExtension.getActionName()));
                presentation.setIcon(this.myExtension.getIcon());
            }

            public void actionPerformed(final @NotNull AnActionEvent e) {
                if (e == null) {
                    RunHttpRequestActionsGroup.$$$reportNull$$$0(3);
                }
                Project project = e.getProject();
                List allActions = HttpRequestActionsProvider.createActions(this.myRequest, this.myEnvironments, this.myExtension);
                final HashMap<String, AnAction> grouped = new HashMap<String, AnAction>();
                ArrayList<String> actionNames = new ArrayList<String>();
                for (AnAction action : allActions) {
                    String text = action instanceof RunHttpRequestAction ? ((RunHttpRequestAction)action).getPresentationText(project) : action.getTemplateText();
                    if (!StringUtil.isNotEmpty((String)text)) continue;
                    grouped.put(text, action);
                    actionNames.add(text);
                }
                String title = RestClientBundle.message("rest.client.request.execute.environment.popup.header", new Object[0]);
                BaseListPopupStep<String> popupStep = new BaseListPopupStep<String>(title, actionNames){

                    @Nullable
                    public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                        return this.doFinalStep(() -> ((AnAction)grouped.get(selectedValue)).actionPerformed(e));
                    }
                };
                ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)popupStep);
                InputEvent inputEvent = e.getInputEvent();
                if (inputEvent instanceof MouseEvent) {
                    popup.show(new RelativePoint((MouseEvent)inputEvent));
                } else {
                    popup.showInBestPositionFor(e.getDataContext());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "request";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "environments";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ws/http/request/run/HttpRequestActionsProvider$ShowGroupedRunAndDebugActionsStrategy$RunHttpRequestActionsGroup";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class ShowFlattenRunActionsStrategy
    implements HttpRequestActionsProviderStrategy {
        private ShowFlattenRunActionsStrategy() {
        }

        @Override
        @NotNull
        public List<AnAction> provideActions(@NotNull HttpRequest request, @NotNull Collection<String> environments) {
            if (request == null) {
                ShowFlattenRunActionsStrategy.$$$reportNull$$$0(0);
            }
            if (environments == null) {
                ShowFlattenRunActionsStrategy.$$$reportNull$$$0(1);
            }
            List list = HttpRequestActionsProvider.createActions(request, environments, HttpRequestExecutorExtensionFactory.getRunExtension());
            if (list == null) {
                ShowFlattenRunActionsStrategy.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Override
        @NotNull
        public String getTooltip() {
            String string = RestClientBundle.message("rest.client.request.run.request.tooltip", new Object[0]);
            if (string == null) {
                ShowFlattenRunActionsStrategy.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environments";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/http/request/run/HttpRequestActionsProvider$ShowFlattenRunActionsStrategy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/http/request/run/HttpRequestActionsProvider$ShowFlattenRunActionsStrategy";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "provideActions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTooltip";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "provideActions";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface HttpRequestActionsProviderStrategy {
        @NotNull
        public String getTooltip();

        @NotNull
        public List<AnAction> provideActions(@NotNull HttpRequest var1, @NotNull Collection<String> var2);
    }
}

