/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config.unified;

import a.g.lb;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.PresentableId;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.ui.unified.SshConfigConfigurable;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.UUID;
import kotlin.Pair;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="sshConfig")
public class SshConfig
implements Cloneable {
    public static final int DEFAULT_PORT = 22;
    @NonNls
    public static final String DEFAULT_KEY_PATH = "/.ssh/id_rsa";
    private static final int f = -1;
    @NotNull
    private String k;
    private boolean a;
    @NotNull
    private String d = "";
    @NotNull
    private String m = "";
    private int h = -1;
    @NotNull
    private String b = "";
    private int e = -1;
    @NotNull
    private String g = "";
    @NotNull
    private AuthType i = AuthType.KEY_PAIR;
    @NotNull
    private String j = "";
    @NotNull
    private NameFormat l;
    @Nullable
    private String c;
    private static final long n = lb.a(-5439418248053831916L, 3594798047651172374L, MethodHandles.lookup().lookupClass()).a(100799890433802L);

    @Attribute(value="id")
    @NotNull
    public String getId() {
        String string = this.k;
        if (string == null) {
            SshConfig.a(0);
        }
        return string;
    }

    public void setId(@NotNull String id2) {
        if (id2 == null) {
            SshConfig.a(1);
        }
        this.k = id2;
    }

    @Transient
    public boolean isProjectLevel() {
        return this.a;
    }

    public void setProjectLevel(boolean projectLevel) {
        this.a = projectLevel;
    }

    @Attribute(value="host")
    @NotNull
    public String getHost() {
        String string = this.d;
        if (string == null) {
            SshConfig.a(2);
        }
        return string;
    }

    public void setHost(@Nullable String host) {
        this.d = StringUtil.notNullize((String)host);
    }

    @Transient
    public int getPort() {
        return this.h;
    }

    public void setPort(int port2) {
        this.h = Math.max(port2, -1);
        this.m = String.valueOf(this.h);
    }

    @Attribute(value="port")
    @NotNull
    public String getLiteralPort() {
        String string = this.m;
        if (string == null) {
            SshConfig.a(3);
        }
        return string;
    }

    public void setLiteralPort(@Nullable String literalPort) {
        this.m = StringUtil.notNullize((String)literalPort);
        this.h = Math.max(StringUtil.parseInt((String)literalPort, (int)-1), -1);
    }

    @Attribute(value="localPort")
    @NotNull
    public String getLiteralLocalPort() {
        String string = this.b;
        if (string == null) {
            SshConfig.a(4);
        }
        return string;
    }

    public void setLiteralLocalPort(@Nullable String literalLocalPort) {
        this.b = StringUtil.notNullize((String)literalLocalPort);
        this.e = Math.max(StringUtil.parseInt((String)literalLocalPort, (int)-1), -1);
    }

    @Transient
    public int getLocalPort() {
        return this.e;
    }

    public void setLocalPort(int localPort) {
        this.e = Math.max(localPort, -1);
        this.b = String.valueOf(this.e);
    }

    @Attribute(value="username")
    @NotNull
    public String getUsername() {
        String string = this.g;
        if (string == null) {
            SshConfig.a(5);
        }
        return string;
    }

    public void setUsername(@Nullable String username) {
        this.g = StringUtil.notNullize((String)username);
    }

    @Attribute(value="authType")
    @NotNull
    public AuthType getAuthType() {
        AuthType authType = this.i;
        if (authType == null) {
            SshConfig.a(6);
        }
        return authType;
    }

    public void setAuthType(@NotNull AuthType authType) {
        if (authType == null) {
            SshConfig.a(7);
        }
        this.i = authType;
    }

    @Attribute(value="keyPath")
    @NotNull
    public String getKeyPath() {
        String string = this.j;
        if (string == null) {
            SshConfig.a(8);
        }
        return string;
    }

    public void setKeyPath(@Nullable String keyPath) {
        this.j = StringUtil.notNullize((String)keyPath);
    }

    public void mergeKeyPath(@Nullable String keyPath) {
        if (!StringUtil.isEmpty((String)this.j)) {
            return;
        }
        if (StringUtil.isEmpty((String)keyPath)) {
            return;
        }
        this.j = keyPath;
    }

    @Transient
    @NotNull
    public String getName() {
        String string = this.l.getName(this);
        if (string == null) {
            SshConfig.a(9);
        }
        return string;
    }

    @Deprecated
    @Attribute(value="nameFormat")
    @NotNull
    public NameFormat getSerializedNameFormat() {
        NameFormat nameFormat = this.l;
        if (nameFormat == null) {
            SshConfig.a(10);
        }
        return nameFormat;
    }

    @Deprecated
    public void setSerializedNameFormat(@Nullable NameFormat nameFormat) {
        this.l = nameFormat == null ? NameFormat.INITIAL : nameFormat;
    }

    @Deprecated
    @Attribute(value="customName")
    @Nullable
    public String getSerializedCustomName() {
        return this.c;
    }

    @Deprecated
    public void setSerializedCustomName(@Nullable String customName) {
        this.c = StringUtil.nullize((String)customName, (boolean)true);
    }

    public void setCustomName(@Nullable String customName) {
        if ((customName = StringUtil.nullize((String)customName, (boolean)true)) == null) {
            this.c = null;
            if (this.l == NameFormat.CUSTOM) {
                this.l = NameFormat.DESCRIPTIVE;
            }
            return;
        }
        this.a(customName);
    }

    public void mergeCustomName(@Nullable String customName) {
        if (this.c != null && this.l == NameFormat.CUSTOM) {
            return;
        }
        if ((customName = StringUtil.nullize((String)customName, (boolean)true)) == null) {
            return;
        }
        this.a(customName);
    }

    private void a(@NotNull String string) {
        if (string == null) {
            SshConfig.a(11);
        }
        if (string.equals(NameFormat.DESCRIPTIVE.getName(this))) {
            this.c = null;
            this.l = NameFormat.DESCRIPTIVE;
        } else {
            this.c = string;
            this.l = NameFormat.CUSTOM;
        }
    }

    @Nls
    @NotNull
    public String getPresentableShortName() {
        String string = this.l.getPresentableShortName(this);
        if (string == null) {
            SshConfig.a(12);
        }
        return string;
    }

    @Nls
    @Nullable
    public String getPresentableAddition() {
        return this.l.getPresentableAddition(this);
    }

    @Nls
    @NotNull
    public String getPresentableFullName() {
        String string = this.getPresentableShortName();
        if (string == null) {
            SshConfig.a(13);
        }
        return string;
    }

    @NotNull
    public AuthData getAuthDataFromForPasswordSafe() {
        AuthData authData = new AuthData();
        switch (this.i) {
            case PASSWORD: 
            case OPEN_SSH: {
                Pair<Credentials, Boolean> pair = this.getPasswordCredentialsFromPasswordSafe();
                authData.setPasswordAuth((Credentials)pair.getFirst(), (Boolean)pair.getSecond());
                break;
            }
            case KEY_PAIR: {
                Pair<Credentials, Boolean> pair = this.getPassphraseCredentialsFromPasswordSafe();
                authData.setKeyAuth((Credentials)pair.getFirst(), (Boolean)pair.getSecond());
            }
        }
        AuthData authData2 = authData;
        if (authData2 == null) {
            SshConfig.a(14);
        }
        return authData2;
    }

    @Nullable
    public Credentials getCredentials() {
        switch (this.i) {
            case PASSWORD: {
                return (Credentials)this.getPasswordCredentialsFromPasswordSafe().getFirst();
            }
            case KEY_PAIR: {
                return (Credentials)this.getPassphraseCredentialsFromPasswordSafe().getFirst();
            }
        }
        return null;
    }

    public boolean hasEqualData(SshConfig config, boolean nullsSameAsEmptyString) {
        if (this == config) {
            return true;
        }
        return this.isProjectLevel() == config.isProjectLevel() && this.getPort() == config.getPort() && SshConfig.a(nullsSameAsEmptyString, this.getHost(), config.getHost()) && SshConfig.a(nullsSameAsEmptyString, this.getLiteralPort(), config.getLiteralPort()) && SshConfig.a(nullsSameAsEmptyString, this.getLiteralLocalPort(), config.getLiteralLocalPort()) && SshConfig.a(nullsSameAsEmptyString, this.getKeyPath(), config.getKeyPath()) && SshConfig.a(nullsSameAsEmptyString, this.getUsername(), config.getUsername()) && this.getAuthType() == config.getAuthType();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        SshConfig sshConfig = (SshConfig)o2;
        return this.a == sshConfig.a && this.k.equals(sshConfig.k) && this.d.equals(sshConfig.d) && this.m.equals(sshConfig.m) && this.b.equals(sshConfig.b) && this.g.equals(sshConfig.g) && this.i == sshConfig.i && this.j.equals(sshConfig.j) && Objects.equals(this.c, sshConfig.c);
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.isProjectLevel(), this.getHost(), this.getLiteralPort(), this.getLiteralLocalPort(), this.getAuthType(), this.getKeyPath(), this.getUsername(), this.c);
    }

    @NotNull
    public RemoteCredentials copyToCredentials() {
        RemoteCredentials remoteCredentials = this.copyToCredentials(this.getAuthDataFromForPasswordSafe());
        if (remoteCredentials == null) {
            SshConfig.a(15);
        }
        return remoteCredentials;
    }

    @NotNull
    public RemoteCredentials copyToCredentials(@NotNull AuthData data) {
        if (data == null) {
            SshConfig.a(16);
        }
        RemoteCredentialsHolder remoteCredentialsHolder = new RemoteCredentialsHolder();
        remoteCredentialsHolder.setHost(this.getHost());
        remoteCredentialsHolder.setLiteralPort(this.getLiteralPort());
        remoteCredentialsHolder.setAuthType(this.getAuthType());
        remoteCredentialsHolder.setUserName(this.getUsername());
        remoteCredentialsHolder.setPassword(data.getPassword());
        remoteCredentialsHolder.setPassphrase(data.getPassphrase());
        remoteCredentialsHolder.setStorePassword(data.isSavePassword());
        remoteCredentialsHolder.setStorePassphrase(data.isSavePassphrase());
        remoteCredentialsHolder.setPrivateKeyFile(this.getKeyPath());
        RemoteCredentialsHolder remoteCredentialsHolder2 = remoteCredentialsHolder;
        if (remoteCredentialsHolder2 == null) {
            SshConfig.a(17);
        }
        return remoteCredentialsHolder2;
    }

    public boolean isNameConfigured() {
        return !this.d.isEmpty() && this.h != 0 && !StringUtil.isEmpty((String)this.g);
    }

    @NotNull
    public static SshConfig create(boolean projectLevel, String host, int port2, String username, AuthType authType, @Nullable String keyPath) {
        SshConfig sshConfig = new SshConfig(true);
        sshConfig.setProjectLevel(projectLevel);
        sshConfig.setHost(host);
        sshConfig.setPort(port2);
        sshConfig.setUsername(username);
        sshConfig.setAuthType(authType);
        sshConfig.setKeyPath(keyPath);
        SshConfig sshConfig2 = sshConfig;
        if (sshConfig2 == null) {
            SshConfig.a(18);
        }
        return sshConfig2;
    }

    @Deprecated
    public SshConfig() {
        this(false);
    }

    public SshConfig(boolean latestFormat) {
        this.k = UUID.randomUUID().toString();
        this.l = latestFormat ? NameFormat.DESCRIPTIVE : NameFormat.INITIAL;
    }

    @NotNull
    protected Pair<Credentials, Boolean> getPasswordCredentialsFromPasswordSafe() {
        return SshConfig.a(this, AuthType.PASSWORD);
    }

    @NotNull
    protected Pair<Credentials, Boolean> getPassphraseCredentialsFromPasswordSafe() {
        return SshConfig.a(this, AuthType.KEY_PAIR);
    }

    public void eraseAuthDataFromPasswordSafe() {
        for (AuthType authType : AuthType.values()) {
            if (authType == AuthType.OPEN_SSH) continue;
            PasswordSafe.getInstance().set(SshConfig.a(this, false, authType), null, false);
        }
    }

    public void saveAuthDataToPasswordSafe(@NotNull AuthData data) {
        if (data == null) {
            SshConfig.a(19);
        }
        Credentials credentials = null;
        boolean bl2 = false;
        Credentials credentials2 = null;
        boolean bl3 = false;
        switch (this.getAuthType()) {
            case PASSWORD: {
                String string = data.getPassword();
                bl2 = !data.isSavePassword();
                credentials = string == null ? null : new Credentials(null, string);
                break;
            }
            case KEY_PAIR: {
                String string = data.getPassphrase();
                bl3 = !data.isSavePassphrase();
                credentials2 = string == null ? null : new Credentials(null, string);
                break;
            }
            default: {
                return;
            }
        }
        PasswordSafe.getInstance().set(SshConfig.a(this, bl2, AuthType.PASSWORD), credentials, bl2);
        PasswordSafe.getInstance().set(SshConfig.a(this, bl3, AuthType.KEY_PAIR), credentials2, bl3);
    }

    @NotNull
    public PresentableId createPresentableId() {
        PresentableId presentableId = Objects.requireNonNull(PresentableId.createId((String)this.getId(), (String)this.getName()));
        if (presentableId == null) {
            SshConfig.a(20);
        }
        return presentableId;
    }

    public SshConfigConfigurable.Visibility getVisibility() {
        return this.a ? SshConfigConfigurable.Visibility.Project : SshConfigConfigurable.Visibility.App;
    }

    public SshConfig clone() {
        SshConfig sshConfig;
        try {
            sshConfig = (SshConfig)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
        return sshConfig;
    }

    public String toString() {
        long l2 = n ^ 0x663FFE4A1C4FL;
        return "SshConfig{myId='" + this.k + '\'' + ", isProjectLevel=" + this.a + ", myHost='" + this.d + '\'' + ", myLiteralPort='" + this.m + '\'' + ", myPort=" + this.h + ", myLiteralLocalPort='" + this.b + '\'' + ", myLocalPort=" + this.e + ", myUsername='" + this.g + '\'' + ", myAuthType=" + this.i + ", myKeyPath='" + this.j + '\'' + ", myNameFormat=" + (Object)((Object)this.l) + '}';
    }

    @NotNull
    private static Pair<Credentials, Boolean> a(SshConfig sshConfig, @NotNull AuthType authType) {
        long l2 = n ^ 0xD91BFEF2DA8L;
        if (authType == null) {
            SshConfig.a(21);
        }
        if (authType == AuthType.OPEN_SSH) {
            throw new IllegalStateException("Unexpected AuthType " + authType);
        }
        CredentialAttributes credentialAttributes = SshConfig.a(sshConfig, false, authType);
        Credentials credentials = PasswordSafe.getInstance().get(credentialAttributes);
        boolean bl2 = credentials == null ? true : PasswordSafe.getInstance().isPasswordStoredOnlyInMemory(credentialAttributes, credentials);
        return new Pair((Object)credentials, (Object)bl2);
    }

    private static CredentialAttributes a(SshConfig sshConfig, Boolean bl2, @NotNull AuthType authType) {
        String string;
        long l2 = n ^ 0x4FB9C3C3DBF9L;
        if (authType == null) {
            SshConfig.a(22);
        }
        switch (authType) {
            case PASSWORD: {
                string = "Password";
                break;
            }
            case KEY_PAIR: {
                string = "Passphrase";
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected AuthType " + authType);
            }
        }
        return new CredentialAttributes(CredentialAttributesKt.generateServiceName((String)("SshConfig" + string), (String)(SshConfig.a(sshConfig.getHost(), "<host>") + ":" + SshConfig.a(sshConfig.getLiteralPort(), "<port>") + " " + sshConfig.getId())), null, null, bl2.booleanValue());
    }

    @NotNull
    private static String a(@Nullable String string, @NotNull String string2) {
        if (string2 == null) {
            SshConfig.a(23);
        }
        if (StringUtil.isEmpty((String)string)) {
            String string3 = string2;
            if (string3 == null) {
                SshConfig.a(24);
            }
            return string3;
        }
        String string4 = string;
        if (string4 == null) {
            SshConfig.a(25);
        }
        return string4;
    }

    private static boolean a(boolean bl2, String string, String string2) {
        return bl2 ? Comparing.strEqual((String)string, (String)string2) : Objects.equals(string, string2);
    }

    public static void parseContent(@NotNull String name, @NotNull SshConfig config) {
        Pair<String, String> pair;
        long l2 = n ^ 0x60D3AFFE607L;
        if (name == null) {
            SshConfig.a(26);
        }
        if (config == null) {
            SshConfig.a(27);
        }
        if ((pair = SshConfig.a(name, '@', "<username>")) == null) {
            return;
        }
        name = (String)pair.getFirst();
        config.setUsername((String)pair.getSecond());
        pair = SshConfig.a(name, ':', "<host>");
        if (pair == null) {
            return;
        }
        name = (String)pair.getFirst();
        config.setHost((String)pair.getSecond());
        boolean bl2 = false;
        Pair<String, String> pair2 = SshConfig.a(name, ':', "<port>");
        if (pair2 != null) {
            bl2 = true;
            name = (String)pair2.getFirst();
            config.setLiteralPort((String)pair2.getSecond());
        }
        if ((pair2 = SshConfig.a(name, ' ', "<port>")) == null) {
            return;
        }
        name = (String)pair2.getFirst();
        if (bl2) {
            config.setLiteralLocalPort((String)pair2.getSecond());
        } else {
            config.setLiteralPort((String)pair2.getSecond());
            config.setLiteralLocalPort("");
        }
        if ("(p)".equals(name) || "password".equals(name)) {
            config.setAuthType(AuthType.PASSWORD);
        } else if ("(k)".equals(name) || "key".equals(name)) {
            config.setAuthType(AuthType.KEY_PAIR);
        } else if ("(o)".equals(name) || "agent".equals(name)) {
            config.setAuthType(AuthType.OPEN_SSH);
        }
    }

    @Nullable
    private static @Nullable Pair<@NotNull String, @Nullable String> a(@NotNull String string, char c10, @Nullable String string2) {
        int n2;
        if (string == null) {
            SshConfig.a(28);
        }
        if ((n2 = string.indexOf(c10)) < 0) {
            return null;
        }
        String string3 = string.substring(0, n2);
        if (string2 != null && string2.equals(string3)) {
            string3 = null;
        }
        return new Pair((Object)string.substring(n2 + 1), (Object)string3);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = n ^ 0x4791551C891BL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 7: 
            case 11: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 7: 
            case 11: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/config/unified/SshConfig";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 7: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customName";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: 
            case 7: 
            case 11: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/config/unified/SshConfig";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHost";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralPort";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralLocalPort";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsername";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializedNameFormat";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableShortName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableFullName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthDataFromForPasswordSafe";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "copyToCredentials";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createPresentableId";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "makeNotEmpty";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setId";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setAuthType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setNonemptyCustomName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "copyToCredentials";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "saveAuthDataToPasswordSafe";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getCredentialsAndMemoryOnlyStatus";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createAttributes";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "makeNotEmpty";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "parseContent";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "cutPiece";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 11: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class AuthData
    implements Cloneable {
        private String d;
        private boolean b;
        private String a;
        private boolean c;
        private static final long e = lb.a(-457091313111084111L, 761779210451388942L, MethodHandles.lookup().lookupClass()).a(114478235159052L);

        @Contract(value="!null, null->fail")
        public void setPasswordAuth(@Nullable Credentials credentials, Boolean memoryOnly) {
            this.a();
            if (credentials != null) {
                this.setPassword(credentials.getPasswordAsString());
                this.setSavePassword(memoryOnly == false);
            }
        }

        @Contract(value="!null, null->fail")
        public void setKeyAuth(@Nullable Credentials credentials, Boolean memoryOnly) {
            this.a();
            if (credentials != null) {
                this.setPassphrase(credentials.getPasswordAsString());
                this.setSavePassphrase(memoryOnly == false);
            }
        }

        private void a() {
            this.d = null;
            this.b = false;
            this.a = null;
            this.c = false;
        }

        public boolean equals(Object o2) {
            if (!(o2 instanceof AuthData)) {
                return false;
            }
            return this.hasEqualData((AuthData)o2, false);
        }

        public boolean hasEqualData(@Nullable AuthData data, boolean nullsSameAsEmptyString) {
            if (this == data) {
                return true;
            }
            if (data == null) {
                return false;
            }
            return this.isSavePassword() == data.isSavePassword() && this.isSavePassphrase() == data.isSavePassphrase() && SshConfig.a(nullsSameAsEmptyString, this.getPassword(), data.getPassword()) && SshConfig.a(nullsSameAsEmptyString, this.getPassphrase(), data.getPassphrase());
        }

        public int hashCode() {
            return Objects.hash(this.getPassword(), this.isSavePassword(), this.getPassphrase(), this.isSavePassphrase());
        }

        public String getPassword() {
            return this.d;
        }

        public void setPassword(String password) {
            this.d = password;
        }

        public boolean isSavePassword() {
            return this.b;
        }

        public void setSavePassword(boolean savePassword) {
            this.b = savePassword;
        }

        public String getPassphrase() {
            return this.a;
        }

        public void setPassphrase(String passphrase) {
            this.a = passphrase;
        }

        public boolean isSavePassphrase() {
            return this.c;
        }

        public void setSavePassphrase(boolean savePassphrase) {
            this.c = savePassphrase;
        }

        public AuthData clone() {
            try {
                return (AuthData)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        public boolean hasNoCredentials(@NotNull AuthType authType) {
            if (authType == null) {
                AuthData.a(0);
            }
            switch (authType) {
                case OPEN_SSH: {
                    return false;
                }
                case PASSWORD: {
                    return this.d == null;
                }
                case KEY_PAIR: {
                    return this.a == null;
                }
            }
            return false;
        }

        @NotNull
        public static AuthData create(@Nullable String password, @Nullable String passphrase, boolean savePassword, boolean savePassphrase) {
            AuthData authData = new AuthData();
            authData.setPassword(password);
            authData.setSavePassword(savePassword);
            authData.setPassphrase(passphrase);
            authData.setSavePassphrase(savePassphrase);
            AuthData authData2 = authData;
            if (authData2 == null) {
                AuthData.a(1);
            }
            return authData2;
        }

        @NotNull
        public static AuthData create(@NotNull RemoteCredentials credentials) {
            if (credentials == null) {
                AuthData.a(2);
            }
            return AuthData.create(credentials.getPassword(), credentials.getPassphrase(), credentials.isStorePassword(), credentials.isStorePassphrase());
        }

        @NotNull
        public static AuthData create(@NotNull AuthType authType, @Nullable Credentials credentials, boolean saveCredentialsInPermanentStore) {
            if (authType == null) {
                AuthData.a(3);
            }
            AuthData authData = new AuthData();
            switch (authType) {
                case OPEN_SSH: {
                    AuthData authData2 = authData;
                    if (authData2 == null) {
                        AuthData.a(4);
                    }
                    return authData2;
                }
                case PASSWORD: {
                    authData.setPassword(credentials == null ? null : credentials.getPasswordAsString());
                    authData.setSavePassword(saveCredentialsInPermanentStore);
                    AuthData authData3 = authData;
                    if (authData3 == null) {
                        AuthData.a(5);
                    }
                    return authData3;
                }
                case KEY_PAIR: {
                    authData.setPassphrase(credentials == null ? null : credentials.getPasswordAsString());
                    authData.setSavePassphrase(saveCredentialsInPermanentStore);
                    AuthData authData4 = authData;
                    if (authData4 == null) {
                        AuthData.a(6);
                    }
                    return authData4;
                }
            }
            AuthData authData5 = authData;
            if (authData5 == null) {
                AuthData.a(7);
            }
            return authData5;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = e ^ 0x16CE88B1272BL;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "authType";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ssh/config/unified/SshConfig$AuthData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "credentials";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ssh/config/unified/SshConfig$AuthData";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "hasNoCredentials";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class NameFormat
    extends Enum<NameFormat> {
        public static final /* enum */ NameFormat INITIAL;
        public static final /* enum */ NameFormat DESCRIPTIVE;
        public static final /* enum */ NameFormat CUSTOM;
        private static final /* synthetic */ NameFormat[] a;
        private static final long b;

        public static NameFormat[] values() {
            return (NameFormat[])a.clone();
        }

        public static NameFormat valueOf(String name) {
            return Enum.valueOf(NameFormat.class, name);
        }

        @NotNull
        public abstract String getName(@NotNull SshConfig var1);

        @Nls
        @NotNull
        public abstract String getPresentableShortName(@NotNull SshConfig var1);

        @Nls
        @Nullable
        public abstract String getPresentableAddition(@NotNull SshConfig var1);

        @NotNull
        private static String a(@NotNull SshConfig sshConfig, String string, String string2, String string3) {
            if (sshConfig == null) {
                NameFormat.a(0);
            }
            String string4 = SshConfig.a(sshConfig.getUsername(), "<" + string + ">") + "@" + SshConfig.a(sshConfig.getHost(), "<" + string2 + ">") + ":" + SshConfig.a(sshConfig.getLiteralPort(), "<" + string3 + ">") + (sshConfig.getLocalPort() == -1 ? "" : ":" + sshConfig.getLocalPort());
            if (string4 == null) {
                NameFormat.a(1);
            }
            return string4;
        }

        static {
            b = lb.a(8346095919442783818L, -6798157553619103576L, MethodHandles.lookup().lookupClass()).a(280723065880673L);
            long l2 = b ^ 0x31CED0726BB6L;
            INITIAL = new NameFormat(){
                private static final long c = lb.a(-4278010070940081869L, 8508120234285112998L, MethodHandles.lookup().lookupClass()).a(87021373618863L);

                @Override
                @NotNull
                public String getName(@NotNull SshConfig config) {
                    String string;
                    long l2 = c ^ 0x2BC4AC9FF185L;
                    if (config == null) {
                        1.b(0);
                    }
                    switch (config.getAuthType()) {
                        case PASSWORD: {
                            string = "p";
                            break;
                        }
                        case KEY_PAIR: {
                            string = "k";
                            break;
                        }
                        case OPEN_SSH: {
                            string = "o";
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected AuthType " + config.getAuthType());
                        }
                    }
                    String string2 = NameFormat.a(config, "username", "host", "port") + " (" + string + ")";
                    if (string2 == null) {
                        1.b(1);
                    }
                    return string2;
                }

                @Override
                @Nls
                @NotNull
                public String getPresentableShortName(@NotNull SshConfig config) {
                    if (config == null) {
                        1.b(2);
                    }
                    String string = DESCRIPTIVE.getPresentableShortName(config);
                    if (string == null) {
                        1.b(3);
                    }
                    return string;
                }

                @Override
                @Nls
                @NotNull
                public String getPresentableAddition(@NotNull SshConfig config) {
                    if (config == null) {
                        1.b(4);
                    }
                    String string = DESCRIPTIVE.getPresentableAddition(config);
                    if (string == null) {
                        1.b(5);
                    }
                    return string;
                }

                private static /* synthetic */ void b(int n2) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n3;
                    String string;
                    long l2 = c ^ 0x41EA1E7D5A40L;
                    switch (n2) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 5: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            n3 = 3;
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 5: {
                            n3 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "config";
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ssh/config/unified/SshConfig$NameFormat$1";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ssh/config/unified/SshConfig$NameFormat$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getName";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getPresentableShortName";
                            break;
                        }
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getPresentableAddition";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getName";
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 5: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "getPresentableShortName";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray;
                            objectArray[2] = "getPresentableAddition";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n2) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 5: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            DESCRIPTIVE = new NameFormat(){
                private static final long c = lb.a(691564406746900014L, -5099772941514706030L, MethodHandles.lookup().lookupClass()).a(215195495441087L);

                @Override
                @NotNull
                public String getName(@NotNull SshConfig config) {
                    String string;
                    long l2 = c ^ 0x5DAC4414FA23L;
                    if (config == null) {
                        2.b(0);
                    }
                    switch (config.getAuthType()) {
                        case PASSWORD: {
                            string = "password";
                            break;
                        }
                        case KEY_PAIR: {
                            string = "key";
                            break;
                        }
                        case OPEN_SSH: {
                            string = "agent";
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected AuthType " + config.getAuthType());
                        }
                    }
                    String string2 = NameFormat.a(config, "username", "host", "port") + " " + string;
                    if (string2 == null) {
                        2.b(1);
                    }
                    return string2;
                }

                @Override
                @Nls
                @NotNull
                public String getPresentableShortName(@NotNull SshConfig config) {
                    long l2 = c ^ 0x2DFF01864F03L;
                    if (config == null) {
                        2.b(2);
                    }
                    String string = NameFormat.a(config, SshBundle.message("ssh.config.name.presentation.placeholder.username", new Object[0]), SshBundle.message("ssh.config.name.presentation.placeholder.host", new Object[0]), SshBundle.message("ssh.config.name.presentation.placeholder.port", new Object[0]));
                    if (string == null) {
                        2.b(3);
                    }
                    return string;
                }

                @Override
                @Nls
                @NotNull
                public String getPresentableAddition(@NotNull SshConfig config) {
                    long l2 = c ^ 0x31AF9A760C9FL;
                    if (config == null) {
                        2.b(4);
                    }
                    switch (config.getAuthType()) {
                        case PASSWORD: {
                            String string = SshBundle.message("ssh.config.name.presentation.auth.password", new Object[0]);
                            if (string == null) {
                                2.b(5);
                            }
                            return string;
                        }
                        case KEY_PAIR: {
                            String string = SshBundle.message("ssh.config.name.presentation.auth.key", new Object[0]);
                            if (string == null) {
                                2.b(6);
                            }
                            return string;
                        }
                        case OPEN_SSH: {
                            String string = SshBundle.message("ssh.config.name.presentation.auth.openssh.agent", new Object[0]);
                            if (string == null) {
                                2.b(7);
                            }
                            return string;
                        }
                    }
                    throw new IllegalStateException("Unexpected AuthType " + config.getAuthType());
                }

                private static /* synthetic */ void b(int n2) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n3;
                    String string;
                    long l2 = c ^ 0x4C632C6330D3L;
                    switch (n2) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 5: 
                        case 6: 
                        case 7: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            n3 = 3;
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 5: 
                        case 6: 
                        case 7: {
                            n3 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "config";
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 5: 
                        case 6: 
                        case 7: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ssh/config/unified/SshConfig$NameFormat$2";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ssh/config/unified/SshConfig$NameFormat$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getName";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getPresentableShortName";
                            break;
                        }
                        case 5: 
                        case 6: 
                        case 7: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getPresentableAddition";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getName";
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 5: 
                        case 6: 
                        case 7: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "getPresentableShortName";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray;
                            objectArray[2] = "getPresentableAddition";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n2) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 5: 
                        case 6: 
                        case 7: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            CUSTOM = new NameFormat(){
                private static final long c = lb.a(7228281382355602331L, 7262339648969521264L, MethodHandles.lookup().lookupClass()).a(149208900404049L);

                @Override
                @NotNull
                public String getName(@NotNull SshConfig config) {
                    if (config == null) {
                        3.b(0);
                    }
                    if (config.c != null) {
                        String string = config.c;
                        if (string == null) {
                            3.b(1);
                        }
                        return string;
                    }
                    String string = DESCRIPTIVE.getName(config);
                    if (string == null) {
                        3.b(2);
                    }
                    return string;
                }

                @Override
                @Nls
                @NotNull
                public String getPresentableShortName(@NotNull SshConfig config) {
                    if (config == null) {
                        3.b(3);
                    }
                    String string = this.getName(config);
                    if (string == null) {
                        3.b(4);
                    }
                    return string;
                }

                @Override
                @Nls
                @Nullable
                public String getPresentableAddition(@NotNull SshConfig config) {
                    if (config == null) {
                        3.b(5);
                    }
                    if (config.c != null) {
                        return null;
                    }
                    return DESCRIPTIVE.getName(config);
                }

                private static /* synthetic */ void b(int n2) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n3;
                    String string;
                    long l2 = c ^ 0x5C4CD9572832L;
                    switch (n2) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 4: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            n3 = 3;
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 4: {
                            n3 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "config";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ssh/config/unified/SshConfig$NameFormat$3";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ssh/config/unified/SshConfig$NameFormat$3";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getName";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getPresentableShortName";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getName";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 4: {
                            break;
                        }
                        case 3: {
                            objectArray = objectArray;
                            objectArray[2] = "getPresentableShortName";
                            break;
                        }
                        case 5: {
                            objectArray = objectArray;
                            objectArray[2] = "getPresentableAddition";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n2) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 4: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            a = new NameFormat[]{INITIAL, DESCRIPTIVE, CUSTOM};
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = b ^ 0x2BCA5D2FA6DBL;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ssh/config/unified/SshConfig$NameFormat";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ssh/config/unified/SshConfig$NameFormat";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBasicDescription";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getBasicDescription";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

