/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import a.g.lb;
import com.intellij.dupLocator.iterators.ArrayBackedNodeIterator;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchResultSink;
import com.intellij.structuralsearch.MatchingProcess;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.a;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.SingleNodeIterator;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.util.CollectingMatchResultSink;
import com.intellij.structuralsearch.plugin.util.DuplicateFilteringResultSink;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.FileBasedIndex;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class Matcher {
    static final Logger LOG;
    private static final ThreadLocal<Set<String>> a;
    final Project project;
    final MatchContext matchContext;
    private boolean b;
    private final GlobalMatchingVisitor c;
    private final TaskScheduler d;
    int totalFilesToScan;
    int scannedFilesCount;
    private static final long e;

    public Matcher(@NotNull Project project, @NotNull MatchOptions matchOptions) {
        if (project == null) {
            Matcher.a(0);
        }
        if (matchOptions == null) {
            Matcher.a(1);
        }
        this.c = new GlobalMatchingVisitor();
        this.d = new TaskScheduler();
        this.project = project;
        this.matchContext = new MatchContext();
        this.matchContext.setMatcher(this.c);
        this.c.setMatchContext(this.matchContext);
        this.matchContext.setOptions(matchOptions);
        this.matchContext.setPattern(PatternCompiler.compilePattern(project, matchOptions, false, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Matcher buildMatcher(Project project, LanguageFileType fileType, String constraint) {
        long l2 = e ^ 0x1F18C85A137L;
        if (StringUtil.isQuotedString((String)constraint)) {
            MatchOptions matchOptions = new MatchOptions();
            matchOptions.setFileType(fileType);
            matchOptions.fillSearchCriteria(StringUtil.unquoteString((String)constraint));
            return new Matcher(project, matchOptions);
        }
        Set<String> set = a.get();
        if (!set.add(constraint)) {
            throw new MalformedPatternException("Pattern recursively references itself");
        }
        try {
            Configuration configuration = ConfigurationManager.getInstance(project).findConfigurationByName(constraint);
            if (configuration == null) {
                throw new MalformedPatternException("Configuration '" + constraint + "' not found");
            }
            Matcher matcher = new Matcher(project, configuration.getMatchOptions());
            return matcher;
        }
        finally {
            set.remove(constraint);
            if (set.isEmpty()) {
                a.remove();
            }
        }
    }

    public static void validate(Project project, MatchOptions options) {
        PatternCompiler.compilePattern(project, options, true, true);
    }

    public boolean checkIfShouldAttemptToMatch(NodeIterator matchedNodes) {
        CompiledPattern compiledPattern = this.matchContext.getPattern();
        NodeIterator nodeIterator = compiledPattern.getNodes();
        try {
            while (true) {
                PsiElement psiElement;
                if ((psiElement = nodeIterator.current()) == null) {
                    boolean bl2 = true;
                    return bl2;
                }
                PsiElement psiElement2 = matchedNodes.current();
                if (psiElement2 == null) {
                    boolean bl3 = false;
                    return bl3;
                }
                MatchingHandler matchingHandler = compiledPattern.getHandler(psiElement);
                if (!matchingHandler.canMatch(psiElement, psiElement2, this.matchContext)) {
                    boolean bl4 = false;
                    return bl4;
                }
                matchedNodes.advance();
                nodeIterator.advance();
            }
        }
        finally {
            nodeIterator.reset();
            matchedNodes.reset();
        }
    }

    public void processMatchesInElement(NodeIterator matchedNodes) {
        try {
            this.c.matchContext(matchedNodes);
        }
        finally {
            matchedNodes.reset();
        }
    }

    public boolean matchNode(@NotNull PsiElement element) {
        if (element == null) {
            Matcher.a(2);
        }
        this.matchContext.clear();
        CollectingMatchResultSink collectingMatchResultSink = new CollectingMatchResultSink();
        this.matchContext.setSink(new DuplicateFilteringResultSink(collectingMatchResultSink));
        CompiledPattern compiledPattern = this.matchContext.getPattern();
        if (compiledPattern == null) {
            return false;
        }
        this.matchContext.setShouldRecursivelyMatch(false);
        this.c.matchContext(SingleNodeIterator.newSingleNodeIterator(element));
        return !collectingMatchResultSink.getMatches().isEmpty();
    }

    public void findMatches(MatchResultSink sink) throws MalformedPatternException, UnsupportedPatternException {
        this.matchContext.clear();
        this.matchContext.setSink(new DuplicateFilteringResultSink(sink));
        CompiledPattern compiledPattern = this.matchContext.getPattern();
        if (compiledPattern == null) {
            return;
        }
        this.matchContext.getSink().setMatchingProcess(this.d);
        this.d.init();
        if (this.b) {
            LocalSearchScope localSearchScope = (LocalSearchScope)this.matchContext.getOptions().getScope();
            assert (localSearchScope != null);
            PsiElement[] psiElementArray = localSearchScope.getScope();
            PsiElement psiElement = psiElementArray[0].getParent();
            if (this.matchContext.getPattern().getStrategy().continueMatching(psiElement != null ? psiElement : psiElementArray[0])) {
                this.c.matchContext(new SsrFilteringNodeIterator(new ArrayBackedNodeIterator(psiElementArray)));
            } else {
                LanguageFileType languageFileType = this.matchContext.getOptions().getFileType();
                Language language = languageFileType.getLanguage();
                for (PsiElement psiElement2 : psiElementArray) {
                    this.match(psiElement2, language);
                }
            }
            this.matchContext.getSink().matchingFinished();
            return;
        }
        this.c();
        if (this.d.getTaskQueueEndAction() == null) {
            this.d.setTaskQueueEndAction(() -> this.matchContext.getSink().matchingFinished());
        }
        this.d.executeNext();
    }

    private void c() {
        boolean bl2;
        MatchOptions matchOptions = this.matchContext.getOptions();
        CompiledPattern compiledPattern = this.matchContext.getPattern();
        SearchScope searchScope = compiledPattern.getScope();
        boolean bl3 = bl2 = searchScope != null;
        if (!bl2) {
            searchScope = matchOptions.getScope();
        }
        if (searchScope instanceof GlobalSearchScope) {
            GlobalSearchScope globalSearchScope = (GlobalSearchScope)searchScope;
            ContentIterator contentIterator = virtualFile -> {
                if (!virtualFile.isDirectory() && globalSearchScope.contains(virtualFile) && virtualFile.getFileType() != FileTypes.UNKNOWN) {
                    ++this.totalFilesToScan;
                    this.d.addOneTask(new MatchOneVirtualFile(virtualFile));
                }
                return true;
            };
            ProgressIndicator progressIndicator = this.matchContext.getSink().getProgressIndicator();
            ReadAction.run(() -> FileBasedIndex.getInstance().iterateIndexableFiles(contentIterator, this.project, progressIndicator));
            if (progressIndicator != null) {
                progressIndicator.setText2("");
            }
        } else {
            LocalSearchScope localSearchScope = (LocalSearchScope)searchScope;
            assert (localSearchScope != null);
            PsiElement[] psiElementArray = localSearchScope.getScope();
            this.totalFilesToScan = psiElementArray.length;
            for (int i10 = 0; i10 < psiElementArray.length; ++i10) {
                PsiElement psiElement = psiElementArray[i10];
                if (psiElement == null) continue;
                this.d.addOneTask(new MatchOnePsiFile(psiElement));
                if (!bl2) continue;
                psiElementArray[i10] = null;
            }
        }
    }

    public MatchContext getMatchContext() {
        return this.matchContext;
    }

    public Project getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MatchResult> testFindMatches(String source, boolean fileContext, LanguageFileType sourceFileType, boolean physicalSourceFile) throws MalformedPatternException, UnsupportedPatternException {
        CollectingMatchResultSink collectingMatchResultSink = new CollectingMatchResultSink();
        MatchOptions matchOptions = this.matchContext.getOptions();
        try {
            if (matchOptions.getScope() == null) {
                PsiElement[] psiElementArray = MatcherImplUtil.createSourceTreeFromText(source, fileContext ? PatternTreeContext.File : PatternTreeContext.Block, sourceFileType, this.project, physicalSourceFile);
                matchOptions.setScope((SearchScope)new LocalSearchScope(psiElementArray));
            }
            this.testFindMatches(collectingMatchResultSink);
        }
        finally {
            matchOptions.setScope(null);
        }
        return collectingMatchResultSink.getMatches();
    }

    public void testFindMatches(MatchResultSink sink) throws MalformedPatternException, UnsupportedPatternException {
        this.b = true;
        try {
            this.findMatches(sink);
        }
        finally {
            this.b = false;
        }
    }

    void match(@NotNull PsiElement element, Language language) {
        MatchingStrategy matchingStrategy;
        if (element == null) {
            Matcher.a(3);
        }
        if ((matchingStrategy = this.matchContext.getPattern().getStrategy()).continueMatching(element) && element.getLanguage().isKindOf(language)) {
            this.c.matchContext(SingleNodeIterator.newSingleNodeIterator(element));
            return;
        }
        for (PsiElement psiElement = element.getFirstChild(); psiElement != null; psiElement = psiElement.getNextSibling()) {
            this.match(psiElement, language);
        }
        if (element instanceof PsiLanguageInjectionHost) {
            InjectedLanguageManager.getInstance((Project)this.project).enumerateEx(element, element.getContainingFile(), false, (psiFile, list2) -> this.match((PsiElement)psiFile, language));
        }
    }

    @NotNull
    public List<MatchResult> matchByDownUp(PsiElement element) throws MalformedPatternException, UnsupportedPatternException {
        long l2 = e ^ 0x7AD9D0CCF818L;
        this.matchContext.clear();
        CollectingMatchResultSink collectingMatchResultSink = new CollectingMatchResultSink();
        this.matchContext.setSink(new DuplicateFilteringResultSink(collectingMatchResultSink));
        CompiledPattern compiledPattern = this.matchContext.getPattern();
        this.matchContext.setShouldRecursivelyMatch(false);
        PsiElement psiElement = compiledPattern.getTargetNode();
        PsiElement psiElement2 = null;
        if (psiElement == null) {
            psiElement = compiledPattern.getNodes().current();
            if (psiElement != null) {
                compiledPattern.getNodes().advance();
                assert (!compiledPattern.getNodes().hasNext());
                compiledPattern.getNodes().rewind();
                element = element.getParent();
                if (element == null) {
                    List<MatchResult> list2 = Collections.emptyList();
                    if (list2 == null) {
                        Matcher.a(4);
                    }
                    return list2;
                }
                while (element.getClass() != psiElement.getClass()) {
                    if ((element = element.getParent()) != null) continue;
                    List<MatchResult> list3 = Collections.emptyList();
                    if (list3 == null) {
                        Matcher.a(5);
                    }
                    return list3;
                }
                psiElement2 = element;
            }
        } else {
            StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByPsiElement(element);
            if (structuralSearchProfile == null) {
                List<MatchResult> list4 = Collections.emptyList();
                if (list4 == null) {
                    Matcher.a(6);
                }
                return list4;
            }
            psiElement = structuralSearchProfile.extendMatchedByDownUp(psiElement);
            MatchOptions matchOptions = this.matchContext.getOptions();
            MatchingHandler matchingHandler = null;
            while (element.getClass() == psiElement.getClass() || compiledPattern.isTypedVar(psiElement) && compiledPattern.getHandler(psiElement).canMatch(psiElement, element, this.matchContext)) {
                matchingHandler = compiledPattern.getHandler(psiElement);
                matchingHandler.setPinnedElement(element);
                psiElement2 = element;
                if (matchingHandler instanceof TopLevelMatchingHandler) break;
                element = element.getParent();
                psiElement = psiElement.getParent();
                if (!matchOptions.isLooseMatching()) continue;
                element = structuralSearchProfile.updateCurrentNode(element);
                psiElement = structuralSearchProfile.updateCurrentNode(psiElement);
            }
            if (!(matchingHandler instanceof TopLevelMatchingHandler)) {
                List<MatchResult> list5 = Collections.emptyList();
                if (list5 == null) {
                    Matcher.a(7);
                }
                return list5;
            }
        }
        assert (psiElement != null) : "Could not match down up when no target node";
        this.c.matchContext(SingleNodeIterator.newSingleNodeIterator(psiElement2));
        this.matchContext.getSink().matchingFinished();
        List<MatchResult> list6 = collectingMatchResultSink.getMatches();
        if (list6 == null) {
            Matcher.a(8);
        }
        return list6;
    }

    static {
        e = lb.a(-2140992724548126899L, 6808110577567451869L, MethodHandles.lookup().lookupClass()).a(132925962993132L);
        LOG = Logger.getInstance(Matcher.class);
        a = ThreadLocal.withInitial(() -> new HashSet());
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = e ^ 0x6D3E3F07E45CL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchOptions";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/Matcher";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/Matcher";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "matchByDownUp";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "matchNode";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private abstract class MatchOneFile
    implements Runnable {
        private MatchOneFile() {
        }

        @Override
        public void run() {
            List<PsiElement> list2 = this.getPsiElementsToProcess();
            ProgressIndicator progressIndicator = Matcher.this.matchContext.getSink().getProgressIndicator();
            if (progressIndicator != null) {
                progressIndicator.setFraction((double)Matcher.this.scannedFilesCount / (double)Matcher.this.totalFilesToScan);
            }
            ++Matcher.this.scannedFilesCount;
            if (list2.isEmpty()) {
                return;
            }
            LanguageFileType languageFileType = Matcher.this.matchContext.getOptions().getFileType();
            Language language = languageFileType.getLanguage();
            for (PsiElement psiElement : list2) {
                if (psiElement instanceof PsiFile) {
                    Matcher.this.matchContext.getSink().processFile((PsiFile)psiElement);
                }
                ReadAction.nonBlocking(() -> {
                    if (!psiElement.isValid()) {
                        return;
                    }
                    StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByLanguage(psiElement.getLanguage());
                    if (structuralSearchProfile == null) {
                        return;
                    }
                    Matcher.this.match(structuralSearchProfile.extendMatchOnePsiFile(psiElement), language);
                }).inSmartMode(Matcher.this.project).executeSynchronously();
            }
        }

        @NotNull
        protected abstract List<PsiElement> getPsiElementsToProcess();

        /* synthetic */ MatchOneFile(a x1) {
            this();
        }
    }

    private class MatchOneVirtualFile
    extends MatchOneFile {
        private final VirtualFile a;
        private static final long b = lb.a(6857518957770686686L, -6477637126193091336L, MethodHandles.lookup().lookupClass()).a(46420663535642L);

        MatchOneVirtualFile(VirtualFile file) {
            super(null);
            this.a = file;
        }

        @Override
        @NotNull
        protected List<PsiElement> getPsiElementsToProcess() {
            List list2 = (List)ReadAction.compute(() -> {
                if (!this.a.isValid()) {
                    return Collections.emptyList();
                }
                PsiFile psiFile = PsiManager.getInstance((Project)Matcher.this.project).findFile(this.a);
                if (psiFile == null) {
                    return Collections.emptyList();
                }
                FileViewProvider fileViewProvider = psiFile.getViewProvider();
                SmartList smartList = new SmartList();
                for (Language language : fileViewProvider.getLanguages()) {
                    smartList.add(fileViewProvider.getPsi(language));
                }
                return smartList;
            });
            if (list2 == null) {
                MatchOneVirtualFile.a(0);
            }
            return list2;
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x6294BFF92596L;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/Matcher$MatchOneVirtualFile", "getPsiElementsToProcess"));
        }
    }

    private class MatchOnePsiFile
    extends MatchOneFile {
        private PsiElement a;

        MatchOnePsiFile(PsiElement file) {
            super(null);
            this.a = file;
        }

        @Override
        @NotNull
        protected List<PsiElement> getPsiElementsToProcess() {
            PsiElement psiElement = this.a;
            this.a = null;
            return new SmartList((Object)psiElement);
        }
    }

    class TaskScheduler
    implements MatchingProcess {
        private List<Runnable> b = new SmartList();
        private boolean a;
        private Runnable c;
        private boolean d;

        TaskScheduler() {
        }

        @Override
        public void stop() {
            this.a = true;
        }

        @Override
        public void pause() {
            this.d = true;
        }

        @Override
        public void resume() {
            if (!this.d) {
                return;
            }
            this.d = false;
            this.executeNext();
        }

        @Override
        public boolean isSuspended() {
            return this.d;
        }

        @Override
        public boolean isEnded() {
            return this.a;
        }

        void setTaskQueueEndAction(Runnable taskQueueEndAction) {
            this.c = taskQueueEndAction;
        }

        Runnable getTaskQueueEndAction() {
            return this.c;
        }

        void addOneTask(Runnable runnable) {
            this.b.add(runnable);
        }

        void executeNext() {
            while (!this.d && !this.a) {
                if (this.b.isEmpty()) {
                    this.a = true;
                    break;
                }
                Runnable runnable = this.b.remove(this.b.size() - 1);
                try {
                    runnable.run();
                }
                catch (ProcessCanceledException | StructuralSearchException throwable) {
                    this.a = true;
                    this.a();
                    throw throwable;
                }
                catch (Throwable throwable) {
                    LOG.error(throwable);
                }
            }
            if (this.a) {
                this.a();
            }
        }

        void init() {
            this.a = false;
            this.d = false;
            PsiManager.getInstance((Project)Matcher.this.project).startBatchFilesProcessingMode();
        }

        private void a() {
            if (this.b != null) {
                this.c.run();
                if (!Matcher.this.project.isDisposed()) {
                    PsiManager.getInstance((Project)Matcher.this.project).finishBatchFilesProcessingMode();
                }
                this.b = null;
            }
        }
    }
}

