/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import a.g.lb;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.filters.CompositeNodeFilter;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.LiteralWithSubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.util.SmartList;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class GlobalCompilingVisitor {
    @NonNls
    private static final String a = "\\b(__\\$_\\w+)\\b";
    private static final Pattern f;
    private static final NodeFilter d;
    private CompileContext c;
    private final List<PsiElement> e = new SmartList();
    private int b;
    private static final long g;

    public static NodeFilter getFilter() {
        return d;
    }

    public void setHandler(PsiElement element, MatchingHandler handler) {
        MatchingHandler matchingHandler = this.c.getPattern().getHandlerSimple(element);
        if (matchingHandler instanceof SubstitutionHandler) {
            ((SubstitutionHandler)matchingHandler).setMatchHandler(handler);
        } else {
            this.c.getPattern().setHandler(element, handler);
        }
    }

    public final void handle(PsiElement element) {
        if ((!d.accepts(element) || StructuralSearchUtil.isIdentifier(element)) && this.c.getPattern().isRealTypedVar(element) && this.c.getPattern().getHandlerSimple(element) == null) {
            String string = this.c.getPattern().getTypedVarString(element);
            SubstitutionHandler substitutionHandler = (SubstitutionHandler)this.c.getPattern().getHandler(string);
            if (substitutionHandler == null) {
                return;
            }
            this.c.getPattern().setHandler(element, substitutionHandler);
            if (this.c.getOptions().getVariableConstraint(substitutionHandler.getName()).isPartOfSearchResults()) {
                substitutionHandler.setTarget(true);
                this.c.getPattern().setTargetNode(element);
            }
        }
    }

    public CompileContext getContext() {
        return this.c;
    }

    public int getCodeBlockLevel() {
        return this.b;
    }

    public void setCodeBlockLevel(int codeBlockLevel) {
        this.b = codeBlockLevel;
    }

    public static void setFilter(MatchingHandler handler, NodeFilter filter) {
        if (handler.getFilter() != null && handler.getFilter().getClass() != filter.getClass()) {
            handler.setFilter(new CompositeNodeFilter(filter, handler.getFilter()));
        } else {
            handler.setFilter(filter);
        }
    }

    public void setFilterSimple(PsiElement element, NodeFilter filter) {
        this.c.getPattern().getHandler(element).setFilter(filter);
    }

    public List<PsiElement> getLexicalNodes() {
        return this.e;
    }

    public void addLexicalNode(PsiElement node) {
        this.e.add(node);
    }

    void compile(PsiElement[] elements, CompileContext context) {
        if (elements.length == 0) {
            throw new MalformedPatternException();
        }
        this.b = 0;
        this.c = context;
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType(context.getOptions().getFileType());
        assert (structuralSearchProfile != null);
        structuralSearchProfile.compile(elements, this);
        assert (context.getPattern().getStrategy() != null);
    }

    public boolean hasFragments(String pattern) {
        return f.matcher(pattern).find();
    }

    @Nullable
    public MatchingHandler processPatternStringWithFragments(String pattern, OccurenceKind kind) {
        return this.processPatternStringWithFragments(pattern, kind, f);
    }

    @Nullable
    public MatchingHandler processPatternStringWithFragments(String pattern, OccurenceKind kind, Pattern substitutionPattern) {
        String string;
        String string2;
        long l2 = g ^ 0xEF0DCA82A57L;
        if (kind == OccurenceKind.LITERAL) {
            string2 = pattern.substring(1, pattern.length() - 1);
        } else if (kind == OccurenceKind.COMMENT) {
            string2 = pattern;
        } else {
            assert (false);
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        Matcher matcher = substitutionPattern.matcher(string2);
        SmartList smartList = new SmartList();
        int n2 = 0;
        boolean bl2 = false;
        MatchingHandler matchingHandler = null;
        while (matcher.find()) {
            string = string2.substring(n2, matcher.start());
            if (!string.isEmpty()) {
                stringBuilder.append(StructuralSearchUtil.shieldRegExpMetaChars(string));
                bl2 = true;
                this.processTokenizedName(string, false, kind);
            }
            if ((matchingHandler = (SubstitutionHandler)this.getContext().getPattern().getHandler(matcher.group(1))) == null) {
                throw new MalformedPatternException();
            }
            smartList.add(matchingHandler);
            RegExpPredicate regExpPredicate = ((SubstitutionHandler)matchingHandler).findRegExpPredicate();
            if (regExpPredicate == null || !regExpPredicate.isWholeWords()) {
                stringBuilder.append("(.*?)");
            } else {
                stringBuilder.append(".*?\\b(").append(regExpPredicate.getRegExp()).append(")\\b.*?");
            }
            if (GlobalCompilingVisitor.isSuitablePredicate(regExpPredicate, (SubstitutionHandler)matchingHandler)) {
                this.processTokenizedName(regExpPredicate.getRegExp(), false, kind);
            }
            n2 = matcher.end();
        }
        string = string2.substring(n2);
        if (!string.isEmpty()) {
            bl2 = true;
            stringBuilder.append(StructuralSearchUtil.shieldRegExpMetaChars(string));
            this.processTokenizedName(string, false, kind);
        }
        if (bl2 && kind == OccurenceKind.LITERAL) {
            stringBuilder.insert(0, "[\"']");
            stringBuilder.append("[\"']");
        }
        if (!smartList.isEmpty()) {
            return bl2 ? new LiteralWithSubstitutionHandler(stringBuilder.toString(), (List<? extends SubstitutionHandler>)smartList, this.c.getOptions().isCaseSensitiveMatch()) : matchingHandler;
        }
        return null;
    }

    @Contract(value="null,_ -> false")
    public static boolean isSuitablePredicate(RegExpPredicate predicate, SubstitutionHandler handler) {
        return predicate != null && handler.getMinOccurs() != 0 && predicate.couldBeOptimized();
    }

    public static void addFilesToSearchForGivenWord(String word, boolean endTransaction, OccurenceKind kind, CompileContext compileContext) {
        if (!compileContext.getSearchHelper().doOptimizing()) {
            return;
        }
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType(compileContext.getOptions().getFileType());
        assert (structuralSearchProfile != null);
        if (structuralSearchProfile.getReservedWords().contains(word)) {
            return;
        }
        if (kind == OccurenceKind.CODE) {
            compileContext.getSearchHelper().addWordToSearchInCode(word);
        } else if (kind == OccurenceKind.COMMENT) {
            compileContext.getSearchHelper().addWordToSearchInComments(word);
        } else if (kind == OccurenceKind.LITERAL) {
            compileContext.getSearchHelper().addWordToSearchInLiterals(word);
        } else if (kind == OccurenceKind.TEXT) {
            compileContext.getSearchHelper().addWordToSearchInText(word);
        }
        if (endTransaction) {
            compileContext.getSearchHelper().endTransaction();
        }
    }

    public void processTokenizedName(String name, boolean skipComments, OccurenceKind kind) {
        if (kind == OccurenceKind.LITERAL) {
            name = StringUtil.unescapeStringCharacters((String)name);
        }
        for (String string : StringUtil.getWordsInStringLongestFirst((String)name)) {
            GlobalCompilingVisitor.addFilesToSearchForGivenWord(string, true, kind, this.getContext());
        }
    }

    static {
        g = lb.a(7005566115783779278L, 575248173043075358L, MethodHandles.lookup().lookupClass()).a(112786636007623L);
        long l2 = g ^ 0x39E5BB5F82A5L;
        f = Pattern.compile(a);
        d = LexicalNodesFilter.getInstance();
    }

    public static final class OccurenceKind
    extends Enum<OccurenceKind> {
        public static final /* enum */ OccurenceKind LITERAL;
        public static final /* enum */ OccurenceKind COMMENT;
        public static final /* enum */ OccurenceKind CODE;
        public static final /* enum */ OccurenceKind TEXT;
        private static final /* synthetic */ OccurenceKind[] a;

        public static OccurenceKind[] values() {
            return (OccurenceKind[])a.clone();
        }

        public static OccurenceKind valueOf(String name) {
            return Enum.valueOf(OccurenceKind.class, name);
        }

        static {
            long l2 = lb.a(3869582702533905230L, -4183787331987824088L, MethodHandles.lookup().lookupClass()).a(69547456258771L) ^ 0x77494B7AD882L;
            LITERAL = new OccurenceKind();
            COMMENT = new OccurenceKind();
            CODE = new OccurenceKind();
            TEXT = new OccurenceKind();
            a = new OccurenceKind[]{LITERAL, COMMENT, CODE, TEXT};
        }
    }
}

