/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant.actions;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.jetbrains.plugins.vagrant.VagrantBundle;
import com.jetbrains.plugins.vagrant.VagrantManager;
import com.jetbrains.plugins.vagrant.actions.VagrantTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VagrantActionBase
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            VagrantActionBase.$$$reportNull$$$0(0);
        }
        e.getPresentation().setVisible(true);
        e.getPresentation().setIcon(this.getIcon());
        Project project = VagrantActionBase.getProject(e);
        if (project == null) {
            e.getPresentation().setEnabled(false);
        } else {
            e.getPresentation().setEnabled(this.isEnabled(project));
        }
    }

    protected boolean isEnabled(Project project) {
        return VagrantManager.getInstance(project).haveInstance();
    }

    protected static Project getProject(AnActionEvent e) {
        return (Project)e.getData(CommonDataKeys.PROJECT);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            VagrantActionBase.$$$reportNull$$$0(1);
        }
        if ((project = VagrantActionBase.getProject(e)) == null) {
            Messages.showErrorDialog((Project)project, (String)VagrantBundle.message("vagrant.error.project.is.null", new Object[0]), (String)VagrantBundle.message("vagrant.error.title", new Object[0]));
            return;
        }
        this.createVagrantTask(project, (Consumer<VagrantTask>)((Consumer)task -> this.performTask(project, (VagrantTask)task)));
    }

    protected void performTask(@NotNull Project project, @Nullable VagrantTask task) {
        if (project == null) {
            VagrantActionBase.$$$reportNull$$$0(2);
        }
        if (task != null) {
            try {
                task.run();
            }
            catch (ExecutionException e1) {
                Messages.showErrorDialog((Project)project, (String)e1.getMessage(), (String)VagrantBundle.message("vagrant.error.title", new Object[0]));
            }
        }
    }

    protected void createVagrantTask(Project project, Consumer<VagrantTask> taskRunner) {
        ArrayList list = Lists.newArrayList((Object[])new String[]{this.commandName()});
        list.addAll(this.arguments(project));
        VagrantTask task = VagrantTask.createFromSettings(project, ArrayUtilRt.toStringArray((Collection)list));
        if (task != null) {
            task.withTty(this.withTty());
        }
        taskRunner.consume((Object)task);
    }

    protected abstract String commandName();

    protected List<String> arguments(Project project) {
        return Lists.newArrayList();
    }

    protected boolean withTty() {
        return true;
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/vagrant/actions/VagrantActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "performTask";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

