/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.DynamicBundle;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.TitledSeparator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileFilterPanel {
    private JCheckBox myUseFileMask;
    private JComboBox myFileMask;
    private JPanel myPanel;

    FileFilterPanel() {
        this.$$$setupUI$$$();
    }

    void init(AnalysisUIOptions options) {
        FindInProjectUtil.initFileFilter(this.myFileMask, this.myUseFileMask);
        this.myUseFileMask.setSelected(StringUtil.isNotEmpty((String)options.FILE_MASK));
        this.myFileMask.setEnabled(StringUtil.isNotEmpty((String)options.FILE_MASK));
        this.myFileMask.setSelectedItem(options.FILE_MASK);
        ActionListener listener2 = __ -> {
            options.FILE_MASK = this.myUseFileMask.isSelected() ? (String)this.myFileMask.getSelectedItem() : null;
        };
        this.myUseFileMask.addActionListener(listener2);
        this.myFileMask.addActionListener(listener2);
    }

    @Nullable
    GlobalSearchScope getSearchScope() {
        if (!this.myUseFileMask.isSelected()) {
            return null;
        }
        String text2 = (String)this.myFileMask.getSelectedItem();
        if (text2 == null) {
            return null;
        }
        final Condition<CharSequence> patternCondition = FindInProjectUtil.createFileMaskCondition(text2);
        return new GlobalSearchScope(){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return patternCondition.value((Object)file2.getNameSequence());
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    1.$$$reportNull$$$0(1);
                }
                return true;
            }

            public boolean isSearchInLibraries() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aModule";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/actions/FileFilterPanel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contains";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSearchInModuleContent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    JPanel getPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myUseFileMask = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/FindBundle", FileFilterPanel.class).getString("find.filter.file.mask.checkbox"));
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myFileMask = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 7, 0, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(DynamicBundle.getBundle((String)"messages/FindBundle", FileFilterPanel.class).getString("find.filter.file.name.group"));
        jPanel.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

