/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UnifiedEditorRangeHighlighter {
    @NotNull
    private final List<SyntaxElement> mySyntax;
    @NotNull
    private final List<MarkupElement> myMarkup;

    UnifiedEditorRangeHighlighter(@Nullable Project project, @NotNull DocumentContent content1, @NotNull DocumentContent content2, @NotNull List<HighlightRange> ranges) {
        if (content1 == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(0);
        }
        if (content2 == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(1);
        }
        if (ranges == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(2);
        }
        this.mySyntax = new ArrayList<SyntaxElement>();
        this.myMarkup = new ArrayList<MarkupElement>();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.initSyntax(project, Side.LEFT, content1, ranges);
        this.initSyntax(project, Side.RIGHT, content2, ranges);
        this.initMarkup(project, Side.LEFT, content1, ranges);
        this.initMarkup(project, Side.RIGHT, content2, ranges);
    }

    private void initSyntax(@Nullable Project project, @NotNull Side side, @NotNull DocumentContent content2, @NotNull List<HighlightRange> ranges) {
        EditorHighlighter highlighter;
        if (side == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(3);
        }
        if (content2 == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(4);
        }
        if (ranges == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(5);
        }
        if ((highlighter = DiffUtil.initEditorHighlighter(project, content2, content2.getDocument().getImmutableCharSequence())) == null) {
            return;
        }
        for (HighlightRange range2 : ranges) {
            if (range2.getSide() != side) continue;
            this.processSyntaxRange(highlighter, range2);
        }
    }

    private void initMarkup(@Nullable Project project, @NotNull Side side, @NotNull DocumentContent content2, @NotNull List<HighlightRange> ranges) {
        MarkupModelEx model;
        if (side == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(6);
        }
        if (content2 == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(7);
        }
        if (ranges == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(8);
        }
        if ((model = (MarkupModelEx)DocumentMarkupModel.forDocument(content2.getDocument(), project, false)) == null) {
            return;
        }
        for (HighlightRange range2 : ranges) {
            if (range2.getSide() != side) continue;
            this.processMarkupRange(model, range2);
        }
    }

    private void processSyntaxRange(@NotNull EditorHighlighter highlighter, @NotNull HighlightRange range2) {
        if (highlighter == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(9);
        }
        if (range2 == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(10);
        }
        TextRange changed2 = range2.getChanged();
        HighlighterIterator iterator2 = highlighter.createIterator(changed2.getStartOffset());
        while (!iterator2.atEnd() && iterator2.getStart() < changed2.getEndOffset()) {
            TextRange newRange = UnifiedEditorRangeHighlighter.getNewRange(range2, iterator2.getStart(), iterator2.getEnd());
            if (newRange != null) {
                this.mySyntax.add(new SyntaxElement(iterator2.getTextAttributes(), newRange.getStartOffset(), newRange.getEndOffset()));
            }
            iterator2.advance();
        }
    }

    private void processMarkupRange(@NotNull MarkupModelEx model, @NotNull HighlightRange range2) {
        if (model == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(11);
        }
        if (range2 == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(12);
        }
        TextRange changed2 = range2.getChanged();
        model.processRangeHighlightersOverlappingWith(changed2.getStartOffset(), changed2.getEndOffset(), (Processor<? super RangeHighlighterEx>)((Processor)marker -> {
            TextRange newRange = UnifiedEditorRangeHighlighter.getNewRange(range2, marker.getStartOffset(), marker.getEndOffset());
            if (newRange != null) {
                this.myMarkup.add(new MarkupElement((RangeHighlighterEx)marker, newRange.getStartOffset(), newRange.getEndOffset()));
            }
            return true;
        }));
    }

    @Nullable
    private static TextRange getNewRange(@NotNull HighlightRange range2, int startOffset, int endOffset) {
        if (range2 == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(13);
        }
        TextRange base = range2.getBase();
        TextRange changed2 = range2.getChanged();
        int changedLength = changed2.getEndOffset() - changed2.getStartOffset();
        int relativeStart = Math.max(startOffset - changed2.getStartOffset(), 0);
        int relativeEnd = Math.min(endOffset - changed2.getStartOffset(), changedLength);
        int newStart = base.getStartOffset() + relativeStart;
        int newEnd = base.getStartOffset() + relativeEnd;
        if (newEnd - newStart <= 0) {
            return null;
        }
        return new TextRange(newStart, newEnd);
    }

    public static void erase(@Nullable Project project, @NotNull Document document) {
        if (document == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(14);
        }
        MarkupModel model = DocumentMarkupModel.forDocument(document, project, true);
        model.removeAllHighlighters();
    }

    public void apply(@Nullable Project project, @NotNull Document document) {
        if (document == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(15);
        }
        MarkupModel model = DocumentMarkupModel.forDocument(document, project, true);
        for (SyntaxElement syntaxElement : this.mySyntax) {
            RangeHighlighter highlighter = model.addRangeHighlighter(syntaxElement.getStart(), syntaxElement.getEnd(), 1001, syntaxElement.getAttributes(), HighlighterTargetArea.EXACT_RANGE);
            highlighter.setGreedyToRight(true);
        }
        for (MarkupElement markupElement : this.myMarkup) {
            RangeHighlighterEx delegate = markupElement.getDelegate();
            if (!delegate.isValid()) continue;
            RangeHighlighter highlighter = model.addRangeHighlighter(markupElement.getStart(), markupElement.getEnd(), delegate.getLayer(), delegate.getTextAttributes(), delegate.getTargetArea());
            highlighter.setEditorFilter(delegate.getEditorFilter());
            highlighter.setCustomRenderer(delegate.getCustomRenderer());
            highlighter.setErrorStripeMarkColor(delegate.getErrorStripeMarkColor());
            highlighter.setErrorStripeTooltip(delegate.getErrorStripeTooltip());
            highlighter.setGutterIconRenderer(delegate.getGutterIconRenderer());
            highlighter.setLineMarkerRenderer(delegate.getLineMarkerRenderer());
            highlighter.setLineSeparatorColor(delegate.getLineSeparatorColor());
            highlighter.setThinErrorStripeMark(delegate.isThinErrorStripeMark());
            highlighter.setLineSeparatorPlacement(delegate.getLineSeparatorPlacement());
            highlighter.setLineSeparatorRenderer(delegate.getLineSeparatorRenderer());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content2";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedEditorRangeHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "initSyntax";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "initMarkup";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "processSyntaxRange";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "processMarkupRange";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getNewRange";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "erase";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SyntaxElement {
        @NotNull
        private final TextAttributes myAttributes;
        private final int myStart;
        private final int myEnd;

        SyntaxElement(@NotNull TextAttributes attributes, int start2, int end) {
            if (attributes == null) {
                SyntaxElement.$$$reportNull$$$0(0);
            }
            this.myAttributes = attributes;
            this.myStart = start2;
            this.myEnd = end;
        }

        @NotNull
        private TextAttributes getAttributes() {
            TextAttributes textAttributes = this.myAttributes;
            if (textAttributes == null) {
                SyntaxElement.$$$reportNull$$$0(1);
            }
            return textAttributes;
        }

        private int getStart() {
            return this.myStart;
        }

        private int getEnd() {
            return this.myEnd;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedEditorRangeHighlighter$SyntaxElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedEditorRangeHighlighter$SyntaxElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MarkupElement {
        @NotNull
        private final RangeHighlighterEx myDelegate;
        private final int myStart;
        private final int myEnd;

        MarkupElement(@NotNull RangeHighlighterEx delegate, int start2, int end) {
            if (delegate == null) {
                MarkupElement.$$$reportNull$$$0(0);
            }
            this.myDelegate = delegate;
            this.myStart = start2;
            this.myEnd = end;
        }

        @NotNull
        public RangeHighlighterEx getDelegate() {
            RangeHighlighterEx rangeHighlighterEx = this.myDelegate;
            if (rangeHighlighterEx == null) {
                MarkupElement.$$$reportNull$$$0(1);
            }
            return rangeHighlighterEx;
        }

        public int getStart() {
            return this.myStart;
        }

        public int getEnd() {
            return this.myEnd;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedEditorRangeHighlighter$MarkupElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedEditorRangeHighlighter$MarkupElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

