/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.CommonBundle;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExecutableValidator {
    public static final int TIMEOUT_MS = Registry.intValue((String)"vcs.executable.validator.timeout.sec", (int)60) * 1000;
    private static final Logger LOG = Logger.getInstance(ExecutableValidator.class);
    private static final NotificationGroup ourNotificationGroup = new NotificationGroup("External Executable Critical Failures", NotificationDisplayType.STICKY_BALLOON, true);
    @NotNull
    protected final Project myProject;
    @NotNull
    private final String myNotificationErrorTitle;
    @NotNull
    private final String myNotificationErrorDescription;

    public ExecutableValidator(@NotNull Project project, @NotNull String notificationErrorTitle, @NotNull String notificationErrorDescription) {
        if (project == null) {
            ExecutableValidator.$$$reportNull$$$0(0);
        }
        if (notificationErrorTitle == null) {
            ExecutableValidator.$$$reportNull$$$0(1);
        }
        if (notificationErrorDescription == null) {
            ExecutableValidator.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myNotificationErrorTitle = notificationErrorTitle;
        this.myNotificationErrorDescription = notificationErrorDescription;
    }

    protected abstract String getCurrentExecutable();

    @NotNull
    protected abstract String getConfigurableDisplayName();

    @Nullable
    protected Notification validate(@NotNull String executable) {
        if (executable == null) {
            ExecutableValidator.$$$reportNull$$$0(3);
        }
        return !this.isExecutableValid(executable) ? this.createDefaultNotification() : null;
    }

    @NotNull
    protected ExecutableNotValidNotification createDefaultNotification() {
        return new ExecutableNotValidNotification(this);
    }

    protected boolean isExecutableValid(@NotNull String executable) {
        if (executable == null) {
            ExecutableValidator.$$$reportNull$$$0(4);
        }
        return ExecutableValidator.doCheckExecutable(executable, Collections.emptyList(), Collections.emptyMap());
    }

    protected static boolean doCheckExecutable(@NotNull String executable, @NotNull List<String> processParameters, @NotNull Map<String, String> envVariables) {
        if (executable == null) {
            ExecutableValidator.$$$reportNull$$$0(5);
        }
        if (processParameters == null) {
            ExecutableValidator.$$$reportNull$$$0(6);
        }
        if (envVariables == null) {
            ExecutableValidator.$$$reportNull$$$0(7);
        }
        try {
            GeneralCommandLine commandLine = new GeneralCommandLine();
            commandLine.setExePath(executable);
            commandLine.addParameters(processParameters);
            commandLine.setCharset(CharsetToolkit.getDefaultSystemCharset());
            commandLine.withEnvironment(envVariables);
            CapturingProcessHandler handler2 = new CapturingProcessHandler(commandLine);
            ProcessOutput result2 = handler2.runProcess(TIMEOUT_MS);
            boolean timeout = result2.isTimeout();
            int exitCode = result2.getExitCode();
            String stderr = result2.getStderr();
            if (timeout) {
                LOG.warn("Validation of " + executable + " failed with a timeout");
            }
            if (exitCode != 0) {
                LOG.warn("Validation of " + executable + " failed with a non-zero exit code: " + exitCode);
            }
            if (!stderr.isEmpty()) {
                LOG.warn("Validation of " + executable + " failed with a non-empty error output: " + stderr);
            }
            return !timeout && exitCode == 0 && stderr.isEmpty();
        }
        catch (Throwable t) {
            LOG.warn(t);
            return false;
        }
    }

    private void showExecutableNotConfiguredNotification(@NotNull Notification notification) {
        if (notification == null) {
            ExecutableValidator.$$$reportNull$$$0(8);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        LOG.info("Executable is not valid: " + this.getCurrentExecutable());
        if (NotificationsManager.getNotificationsManager().getNotificationsOfType(notification.getClass(), this.myProject).length == 0) {
            notification.notify(this.myProject.isDefault() ? null : this.myProject);
        }
    }

    @NotNull
    protected String prepareDescription(@NotNull String description, boolean appendFixIt) {
        if (description == null) {
            ExecutableValidator.$$$reportNull$$$0(9);
        }
        StringBuilder result2 = new StringBuilder();
        String executable = this.getCurrentExecutable();
        if (executable.isEmpty()) {
            result2.append(String.format("<b>%s</b>%s", this.myNotificationErrorTitle, description));
        } else {
            result2.append(String.format("<b>%s:</b> <b>%s</b><br/>%s", this.myNotificationErrorTitle, executable, description));
        }
        if (appendFixIt) {
            result2.append(" <a href=''>Fix it.</a>");
        }
        String string = result2.toString();
        if (string == null) {
            ExecutableValidator.$$$reportNull$$$0(10);
        }
        return string;
    }

    protected void showSettingsAndExpireIfFixed(@NotNull Notification notification) {
        if (notification == null) {
            ExecutableValidator.$$$reportNull$$$0(11);
        }
        this.showSettings();
        if (this.validate(this.getCurrentExecutable()) == null) {
            notification.expire();
        }
    }

    protected void showSettings() {
        ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, this.getConfigurableDisplayName());
    }

    public boolean checkExecutableAndNotifyIfNeeded() {
        if (this.myProject.isDisposed()) {
            return false;
        }
        Notification notification = this.validate(this.getCurrentExecutable());
        return this.notify(notification);
    }

    protected boolean notify(@Nullable Notification notification) {
        if (notification != null) {
            this.showExecutableNotConfiguredNotification(notification);
            return false;
        }
        return true;
    }

    public boolean checkExecutableAndShowMessageIfNeeded(@Nullable Component parentComponent) {
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (!this.isExecutableValid(this.getCurrentExecutable())) {
            if (0 == this.showMessage(parentComponent)) {
                ApplicationManager.getApplication().invokeLater(() -> this.showSettings());
            }
            return false;
        }
        return true;
    }

    private int showMessage(@Nullable Component parentComponent) {
        String okText = "Fix it";
        String cancelText = CommonBundle.getCancelButtonText();
        Icon icon2 = Messages.getErrorIcon();
        String title = this.myNotificationErrorTitle;
        String description = this.myNotificationErrorDescription;
        return parentComponent != null ? Messages.showOkCancelDialog((Component)parentComponent, (String)description, (String)title, (String)okText, (String)cancelText, (Icon)icon2) : Messages.showOkCancelDialog((Project)this.myProject, (String)description, (String)title, (String)okText, (String)cancelText, (Icon)icon2);
    }

    public boolean isExecutableValid() {
        return this.isExecutableValid(this.getCurrentExecutable());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationErrorTitle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationErrorDescription";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processParameters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envVariables";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ExecutableValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ExecutableValidator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isExecutableValid";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doCheckExecutable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showExecutableNotConfiguredNotification";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "prepareDescription";
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showSettingsAndExpireIfFixed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class ExecutableNotValidNotification
    extends Notification {
        final /* synthetic */ ExecutableValidator this$0;

        public ExecutableNotValidNotification(ExecutableValidator this$0) {
            this(this$0, this$0.myNotificationErrorDescription);
        }

        public ExecutableNotValidNotification(@NotNull ExecutableValidator this$0, String description) {
            if (description == null) {
                ExecutableNotValidNotification.$$$reportNull$$$0(0);
            }
            this(this$0, this$0.prepareDescription(description, true), NotificationType.ERROR);
        }

        public ExecutableNotValidNotification(@NotNull ExecutableValidator this$0, @NotNull String preparedDescription, NotificationType type) {
            if (preparedDescription == null) {
                ExecutableNotValidNotification.$$$reportNull$$$0(1);
            }
            if (type == null) {
                ExecutableNotValidNotification.$$$reportNull$$$0(2);
            }
            this.this$0 = this$0;
            super(ourNotificationGroup.getDisplayId(), "", preparedDescription, type, (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    ExecutableValidator.this.showSettingsAndExpireIfFixed(notification);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/execution/ExecutableValidator$ExecutableNotValidNotification$1";
                    objectArray[2] = "hyperlinkActivated";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "description";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "preparedDescription";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/ExecutableValidator$ExecutableNotValidNotification";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

